/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.serviceHelper.ExpressionServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.formplugin.workingpaper.model.AbstractColumn;
import kd.fi.bcm.spread.formula.EncoderService;

public class WpFormulaUtil {
    public static Pair<String, List<IFormula>> getFormulaPair(String formula) {
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        try {
            Pair pair = parser.parse(formula, coder);
            return pair;
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"WpFormulaUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public static <T extends AbstractColumn> String transFormula2Chinese(String formula, List<T> columnList) {
        StringBuilder chinese = new StringBuilder();
        Pair<String, List<IFormula>> pair = WpFormulaUtil.getFormulaPair(formula);
        int flag = 0;
        for (int i = 0; i < ((String)pair.p1).length(); ++i) {
            if (((String)pair.p1).charAt(i) >= 'A' && ((String)pair.p1).charAt(i) <= 'Z') {
                if (!ExpressionServiceHelper.checkFactorComplete((int)i, (String)((String)pair.p1))) continue;
                chinese.append(WpFormulaUtil.transToChinese((IFormula)((List)pair.p2).get(flag), columnList));
                ++flag;
                continue;
            }
            chinese.append(((String)pair.p1).charAt(i));
        }
        return chinese.toString();
    }

    private static <T extends AbstractColumn> String transToChinese(IFormula f, List<T> columnList) {
        String number = ((ParamItem)f.getParamList().get(0)).toString();
        return WpFormulaUtil.getNameByNumber(number, columnList);
    }

    public static <T extends AbstractColumn> String getNameByNumber(String number, List<T> columnList) {
        for (AbstractColumn column : columnList) {
            if (!column.getNumber().equals(number)) continue;
            return column.getHeaderName();
        }
        return null;
    }

    public static String transFormula2Coordinate(int x, String formula, LinkedHashMap<String, Pair<Integer, Boolean>> number_index) {
        Pair<String, List<IFormula>> pair = WpFormulaUtil.getFormulaPair(formula);
        StringBuilder result = new StringBuilder();
        int flag = 0;
        for (int i = 0; i < ((String)pair.p1).length(); ++i) {
            if (((String)pair.p1).charAt(i) >= 'A' && ((String)pair.p1).charAt(i) <= 'Z') {
                if (!ExpressionServiceHelper.checkFactorComplete((int)i, (String)((String)pair.p1))) continue;
                String number = ((ParamItem)((IFormula)((List)pair.p2).get(flag)).getParamList().get(0)).toString();
                result.append(WpFormulaUtil.transToXY(x, number, number_index));
                ++flag;
                continue;
            }
            result.append(((String)pair.p1).charAt(i));
        }
        return result.toString();
    }

    private static String transToXY(int row, String number, LinkedHashMap<String, Pair<Integer, Boolean>> number_index) {
        Pair<Integer, Boolean> index_displayChild = number_index.get(number);
        if (index_displayChild == null) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        int col = (Integer)index_displayChild.p1;
        if (((Boolean)index_displayChild.p2).booleanValue()) {
            int nextCol = 0;
            Iterator<Map.Entry<String, Pair<Integer, Boolean>>> pairs = number_index.entrySet().iterator();
            for (int i = 0; pairs.hasNext() && i < number_index.entrySet().size(); ++i) {
                Map.Entry<String, Pair<Integer, Boolean>> pair = pairs.next();
                if (!pair.getValue().equals(index_displayChild) || !pairs.hasNext()) continue;
                nextCol = (Integer)pairs.next().getValue().p1;
                break;
            }
            if (nextCol != 0) {
                sb.append('(');
                for (int c = col; c < nextCol; ++c) {
                    sb.append(ExcelUtils.xy2Pos((int)c, (int)row));
                    sb.append('+');
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append(')');
            } else {
                sb.append(ExcelUtils.xy2Pos((int)col, (int)row));
            }
        } else {
            sb.append(ExcelUtils.xy2Pos((int)col, (int)row));
        }
        return sb.toString();
    }
}

