/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.websocket;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.AbstractFormView;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.bcm.business.websocket.BcmWebSocketCommand;
import kd.fi.bcm.business.websocket.BcmWebSocketManger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class WebsocketCustomEventPlugin
extends AbstractBaseFormPlugin {
    private final Log logger = LogFactory.getLog(WebsocketCustomEventPlugin.class);

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getCustomControl().setData(this.getCustomParmMap());
    }

    public void customEvent(CustomEventArgs e) {
        try {
            BcmWebSocketCommand webSocketOrder = BcmWebSocketCommand.deSerializedBytes((String)e.getEventArgs());
            if (webSocketOrder == null) {
                this.logger.error("\u53c2\u6570\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u4e3ajson\u683c\u5f0f,\u6570\u636e\u4e3a:");
                return;
            }
            this.consumerBcmWebSocketCommand(webSocketOrder);
        }
        catch (Throwable t) {
            this.logger.error("bcm--ws\u94fe\u63a5\u6d88\u8d39\u5931\u8d25\uff0c\u539f\u56e0\u4e3a \uff1a ", t);
        }
    }

    public void consumerBcmWebSocketCommand(BcmWebSocketCommand webSocketOrder) {
        webSocketOrder.setWsView(this.getView());
        List<Object> actionList = "onClose".equalsIgnoreCase(webSocketOrder.getWsMsgType()) ? this.onClose(webSocketOrder) : ("onConnect".equalsIgnoreCase(webSocketOrder.getWsMsgType()) ? this.onConnect(webSocketOrder) : this.onMessage(webSocketOrder));
        if (!CollectionUtil.isEmpty(actionList)) {
            ((AbstractFormView)this.getView()).getClientProxy().addAction("sendDynamicFormAction", (Object)MapInitHelper.ofMap((Object)"pageId", (Object)webSocketOrder.getWsView().getPageId(), (Object)"actions", actionList));
        }
    }

    protected Map<String, Object> getCustomParmMap() {
        String accountId = RequestContext.getOrCreate().getAccountId();
        String tenantId = RequestContext.getOrCreate().getTenantId();
        String userId = RequestContext.getOrCreate().getUserId();
        return MapInitHelper.ofMap((Object)"identifytype", (Object)BcmWebSocketManger.buildWSIdentifytype((String)this.getApplyWSMsgType(), (String)accountId, (String)tenantId, (String)userId, (String)this.getUserSpceKey()), (Object)"tenantId", (Object)RequestContext.getOrCreate().getTenantId());
    }

    protected String getUserSpceKey() {
        return "";
    }

    protected String getApplyWSMsgType() {
        return "CONSOLE";
    }

    private List<Object> onConnect(BcmWebSocketCommand webSocketOrder) {
        return null;
    }

    private List<Object> onMessage(BcmWebSocketCommand webSocketOrder) {
        return (List)DispatchServiceHelper.invokeBizService((String)webSocketOrder.getConsumer().getCloudId(), (String)webSocketOrder.getConsumer().getAppid(), (String)webSocketOrder.getConsumer().getServiceName(), (String)webSocketOrder.getConsumer().getMethod(), (Object[])new Object[]{webSocketOrder.toByteSerialized()});
    }

    private List<Object> onClose(BcmWebSocketCommand webSocketOrder) {
        return null;
    }

    public CustomControl getCustomControl() {
        return (CustomControl)this.getControl("bcmapphomewebsocket");
    }
}

