/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.workingpaper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.WorkPaperEnum;
import kd.fi.bcm.common.enums.WorkPaperTypeEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.util.WorkPaperUtil;
import kd.fi.bcm.formplugin.util.WpFormulaUtil;
import kd.fi.bcm.formplugin.workingpaper.model.Column4Cache;

public class ColMemberEditPlugin
extends AbstractBaseFormPlugin {
    private static final String COLPREFIX = "col_";
    private static final String DEFINED = "defined_";
    private static final String PRE = "pre_";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String PROCESS = "process";
    private static final String AUDIT_TRAIL = "audittrail";
    private static final String CURRENCY = "currency";
    private static final String DISPLAY_CHILD = "displaychild";
    private static final String LOAN_SHOW = "loanshow";
    private static final String IS_FORMULA = "isformula";
    private static final String CHINESE_FORMULA = "chineseformula";
    private static final String COL_NAME = "colname";
    private static final String USE_DEFAULT = "usedefault";
    private static final String DEFAULT_COL = "defaultcol";
    private static final String FORMULA = "formula";
    private static final String COL_LIST = "collist";
    private static final String NUMBER = "number";
    private static final String INSERT_COMPONENT = "insertComponent";
    private static final String INSERT_FORMULA_COL = "InsertFormulaCol";
    private static final String BREAK_PROCESS = "breakprocess";
    private static final String ORIGINAL_HEADNAME = "originalHeadName";
    private static final List<String> colnumbers = Arrays.asList("process", "audittrail", "currency");
    private static final List<String> defaultcolnumbers = Arrays.asList("audittrail", "currency");
    private Set<String> headNames = new HashSet<String>(16);
    private List<Column4Cache> columnList = new ArrayList<Column4Cache>(16);

    @Override
    public void initialize() {
        super.initialize();
        HashMap parammap = new HashMap(16);
        this.asMapF7toType(colnumbers, SingleF7TypeEnum.ROOT, parammap);
        this.initSingleMemberF7(parammap);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("confirm", CHINESE_FORMULA);
        colnumbers.forEach(m -> {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl((String)m);
            if (basedataEdit != null) {
                basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setCanEdit();
        this.setBox();
        this.setDefaultValue();
    }

    @Override
    public void afterBindData(EventObject e) {
        DynamicObject process;
        this.setCSLSchemeF7Visiable(e);
        if (this.getModelId() != 0L) {
            this.hideATAndCT(this.getView(), "bcm_audittrialmembertree", this.getAuditTrailFormulaFlag());
            this.hideATAndCT(this.getView(), "bcm_changetypemembertree", this.isExistChangeTypeDimension());
        }
        if ((process = (DynamicObject)this.getValue(PROCESS)) != null) {
            String datasource = process.getString("datasource");
            if ("2".equals(datasource)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{LOAN_SHOW});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{LOAN_SHOW});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LOAN_SHOW});
        }
    }

    private Boolean getAuditTrailFormulaFlag() {
        Column4Cache column;
        if (this.isExistAuditTrailDimension() && (column = this.getOrignCol()) != null && StringUtils.isNotEmpty((String)column.getFormula())) {
            return false;
        }
        return this.isExistAuditTrailDimension();
    }

    private void setCanEdit() {
        String sign = (String)this.getView().getFormShowParameter().getCustomParam("sign");
        String insertComponent = (String)this.getView().getFormShowParameter().getCustomParam(INSERT_COMPONENT);
        String insertFormulaCol = (String)this.getView().getFormShowParameter().getCustomParam(INSERT_FORMULA_COL);
        if (INSERT_COMPONENT.equals(insertComponent)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{PROCESS, DISPLAY_CHILD, AUDIT_TRAIL, CURRENCY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{IS_FORMULA, COL_NAME, CHINESE_FORMULA});
            this.getModel().setValue(USE_DEFAULT, (Object)true);
        } else if (sign.contains(PRE)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{PROCESS, AUDIT_TRAIL, CURRENCY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{USE_DEFAULT, DEFAULT_COL, IS_FORMULA, CHINESE_FORMULA});
        } else if (INSERT_FORMULA_COL.equalsIgnoreCase(insertFormulaCol)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{IS_FORMULA});
            this.getModel().setValue(IS_FORMULA, (Object)true);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{USE_DEFAULT, DEFAULT_COL, PROCESS, DISPLAY_CHILD, AUDIT_TRAIL, CURRENCY});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CHINESE_FORMULA, DEFAULT_COL});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{DISPLAY_CHILD});
        }
    }

    private void setDefaultValue() {
        Boolean isAddCol = (Boolean)this.getView().getFormShowParameter().getCustomParam("isAddCol");
        if (isAddCol != null && isAddCol.booleanValue()) {
            return;
        }
        Column4Cache column = this.getOrignCol();
        if (column != null) {
            String headerName = column.getHeaderName();
            this.getPageCache().put(ORIGINAL_HEADNAME, headerName);
            if (StringUtils.isEmpty((String)column.getFormula())) {
                IDNumberTreeNode treeNode;
                String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
                long modelid = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
                WorkPaperTypeEnum typeEnum = WorkPaperUtil.getWorkPaperTypeEnum(column);
                this.getModel().setValue(COL_NAME, (Object)headerName);
                if (typeEnum == null) {
                    this.getModel().setValue(USE_DEFAULT, (Object)false);
                } else {
                    this.getModel().setValue(USE_DEFAULT, (Object)true);
                    if (type.equals(WorkPaperEnum.USERDEFINED.getNumber())) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{USE_DEFAULT, IS_FORMULA});
                    }
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{PROCESS, AUDIT_TRAIL, CURRENCY, DISPLAY_CHILD});
                }
                String processNum = column.getProcess();
                String modelNumber = MemberReader.findModelNumberById((Object)modelid);
                if (!StringUtils.isEmpty((String)processNum)) {
                    treeNode = MemberReader.findMemberByNumber((String)modelNumber, (String)DimEntityNumEnum.PROCESS.getNumber(), (String)processNum);
                    this.getModel().setValue(PROCESS, (Object)treeNode.getId());
                    if (OrgRelaProcessMembPool.isRelaProcess((String)processNum) && typeEnum == null) {
                        this.getView().setEnable(Boolean.valueOf(true), new String[]{DISPLAY_CHILD});
                    }
                }
                this.getModel().setValue(DISPLAY_CHILD, (Object)column.getDisplayChild());
                this.getModel().setValue(LOAN_SHOW, (Object)column.getLoanShow());
                treeNode = MemberReader.findMemberByNumber((String)modelNumber, (String)DimEntityNumEnum.AUDITTRIAL.getNumber(), (String)column.getAuditTrial());
                this.getModel().setValue(AUDIT_TRAIL, (Object)treeNode.getId());
                treeNode = MemberReader.findMemberByNumber((String)modelNumber, (String)DimEntityNumEnum.CURRENCY.getNumber(), (String)column.getCurrency());
                this.getModel().setValue(CURRENCY, (Object)treeNode.getId());
            } else {
                this.getModel().setValue(IS_FORMULA, (Object)true);
                this.getModel().setValue(COL_NAME, (Object)headerName);
                this.getModel().setValue(FORMULA, (Object)column.getFormula());
                List<Column4Cache> columnList = this.getColumnList();
                this.getModel().setValue(CHINESE_FORMULA, (Object)WpFormulaUtil.transFormula2Chinese(column.getFormula(), columnList));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{USE_DEFAULT, DEFAULT_COL, PROCESS, DISPLAY_CHILD, AUDIT_TRAIL, CURRENCY});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{CHINESE_FORMULA});
            }
        }
    }

    private void setBox() {
        ArrayList<ComboItem> cols;
        ComboEdit defaultCols = (ComboEdit)this.getControl(DEFAULT_COL);
        boolean isInsertComponent = INSERT_COMPONENT.equals(this.getView().getFormShowParameter().getCustomParam(INSERT_COMPONENT));
        boolean isInsertFormulaCol = INSERT_FORMULA_COL.equals(this.getView().getFormShowParameter().getCustomParam(INSERT_FORMULA_COL));
        if (isInsertFormulaCol) {
            List<Column4Cache> columnList = this.getColumnList();
            cols = new ArrayList<ComboItem>(columnList.size());
            columnList.forEach(col -> cols.add(new ComboItem(new LocaleString(col.getHeaderName()), col.getNumber())));
        } else {
            List<Object> elements = new ArrayList(16);
            elements = isInsertComponent ? (List)ObjectSerialUtil.deSerializedBytes((String)((String)this.getView().getFormShowParameter().getCustomParam("cloumn_elements"))) : WorkPaperUtil.filterPreWorkEnum(this.getColumnList());
            cols = new ArrayList(elements.size());
            for (WorkPaperTypeEnum workPaperTypeEnum : elements) {
                cols.add(new ComboItem(new LocaleString(workPaperTypeEnum.getHeaderName()), workPaperTypeEnum.getNumber()));
            }
        }
        defaultCols.setComboItems(cols);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName().toLowerCase(Locale.ENGLISH);
        Object newValue = this.getModel().getValue(key);
        IFormView view = this.getView();
        if (newValue == null) {
            return;
        }
        switch (key) {
            case "isformula": {
                if (newValue.equals(true)) {
                    view.setVisible(Boolean.valueOf(false), new String[]{USE_DEFAULT, DEFAULT_COL, PROCESS, DISPLAY_CHILD, AUDIT_TRAIL, CURRENCY});
                    view.setVisible(Boolean.valueOf(true), new String[]{CHINESE_FORMULA, COL_NAME});
                } else {
                    view.setVisible(Boolean.valueOf(true), new String[]{USE_DEFAULT, PROCESS, DISPLAY_CHILD, CURRENCY});
                    if (this.isExistAuditTrailDimension()) {
                        view.setVisible(Boolean.valueOf(true), new String[]{AUDIT_TRAIL});
                    }
                    view.setVisible(Boolean.valueOf(false), new String[]{CHINESE_FORMULA, DEFAULT_COL});
                }
                this.getModel().setValue(USE_DEFAULT, (Object)false);
                this.setNull(Arrays.asList(PROCESS, AUDIT_TRAIL, CURRENCY, COL_NAME, DEFAULT_COL));
                break;
            }
            case "usedefault": {
                if (newValue.equals(true)) {
                    view.setVisible(Boolean.valueOf(true), new String[]{DEFAULT_COL});
                    view.setVisible(Boolean.valueOf(false), new String[]{COL_NAME});
                    view.setEnable(Boolean.valueOf(false), new String[]{PROCESS, AUDIT_TRAIL, CURRENCY, DISPLAY_CHILD});
                } else {
                    view.setVisible(Boolean.valueOf(false), new String[]{DEFAULT_COL});
                    view.setVisible(Boolean.valueOf(true), new String[]{COL_NAME});
                    view.setEnable(Boolean.valueOf(true), new String[]{PROCESS, AUDIT_TRAIL, CURRENCY, DISPLAY_CHILD});
                }
                this.setNull(Arrays.asList(PROCESS, AUDIT_TRAIL, CURRENCY, COL_NAME, DEFAULT_COL));
                this.getModel().setValue(DISPLAY_CHILD, (Object)false);
                break;
            }
            case "process": {
                if (this.getPageCache().get(BREAK_PROCESS) == null) {
                    String processNum = ((DynamicObject)newValue).getString(NUMBER);
                    if (OrgRelaProcessMembPool.isRelaProcess((String)processNum)) {
                        view.setEnable(Boolean.valueOf(true), new String[]{DISPLAY_CHILD});
                        this.getModel().setValue(DISPLAY_CHILD, (Object)true);
                    } else {
                        view.setEnable(Boolean.valueOf(false), new String[]{DISPLAY_CHILD});
                        this.getModel().setValue(DISPLAY_CHILD, (Object)false);
                    }
                    String datasource = ((DynamicObject)newValue).getString("datasource");
                    if ("2".equals(datasource)) {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{LOAN_SHOW});
                    } else {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{LOAN_SHOW});
                    }
                }
                this.getPageCache().remove(BREAK_PROCESS);
                break;
            }
            case "defaultcol": {
                IDNumberTreeNode treeNode;
                WorkPaperTypeEnum typeEnum = WorkPaperTypeEnum.getEnumByNumber((String)((String)newValue));
                long modelid = Long.parseLong((String)view.getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
                this.getModel().setValue(COL_NAME, (Object)typeEnum.getHeaderName());
                String modelNumber = MemberReader.findModelNumberById((Object)modelid);
                String processNum = typeEnum.getProcessNum();
                if (!StringUtils.isEmpty((String)processNum)) {
                    QFilter qFilter = new QFilter("model", "=", (Object)modelid);
                    qFilter.and(NUMBER, "=", (Object)processNum);
                    qFilter.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
                    DynamicObject process = BusinessDataServiceHelper.loadSingle((String)"bcm_processmembertree", (String)"id,datasource", (QFilter[])qFilter.toArray());
                    this.getPageCache().put(BREAK_PROCESS, "true");
                    this.getModel().setValue(PROCESS, (Object)process.getLong("id"));
                    if ("2".equals(process.getString("datasource"))) {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{LOAN_SHOW});
                    } else {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{LOAN_SHOW});
                    }
                } else {
                    this.getModel().setValue(PROCESS, null);
                }
                this.getModel().setValue(DISPLAY_CHILD, (Object)WorkPaperTypeEnum.isDisplayChild((WorkPaperTypeEnum)typeEnum));
                if (this.isExistAuditTrailDimension()) {
                    treeNode = MemberReader.findMemberByNumber((String)modelNumber, (String)DimEntityNumEnum.AUDITTRIAL.getNumber(), (String)typeEnum.getAuditTrailNum());
                    this.getModel().setValue(AUDIT_TRAIL, (Object)treeNode.getId());
                }
                treeNode = MemberReader.findMemberByNumber((String)modelNumber, (String)DimEntityNumEnum.CURRENCY.getNumber(), (String)typeEnum.getCurrencyNum());
                this.getModel().setValue(CURRENCY, (Object)treeNode.getId());
                break;
            }
        }
    }

    private Set<String> getPreHeadNname() {
        HashSet<String> exitHeaderNames = new HashSet<String>(16);
        Column4Cache sourceColumn = this.getOrignCol();
        WorkPaperTypeEnum typeEnum = null;
        if (sourceColumn != null) {
            typeEnum = WorkPaperUtil.getWorkPaperTypeEnum(sourceColumn);
        }
        for (WorkPaperTypeEnum workPaperTypeEnum : WorkPaperUtil.filterPreWorkEnum(new ArrayList<Column4Cache>(16))) {
            if (typeEnum != null && typeEnum == workPaperTypeEnum) continue;
            exitHeaderNames.add(workPaperTypeEnum.getHeaderName());
        }
        return exitHeaderNames;
    }

    private Set<String> getExitHeadName() {
        if (this.headNames.isEmpty()) {
            List<Column4Cache> columnList = this.getColumnList();
            columnList.forEach(column4Cache -> this.headNames.add(column4Cache.getHeaderName()));
        }
        return this.headNames;
    }

    private List<Column4Cache> getColumnList() {
        if (this.columnList.isEmpty()) {
            String colList = (String)this.getView().getFormShowParameter().getCustomParam(COL_LIST);
            this.columnList = (List)ObjectSerialUtil.deSerializedBytes((String)colList);
        }
        return this.columnList;
    }

    private void setNull(List<String> keys) {
        IDataModel model = this.getModel();
        keys.forEach(e -> model.setValue(e, null));
    }

    private boolean checkHeadNameForSysAssembly(String headerName) {
        Set<String> exitHeadNname = this.getExitHeadName();
        String originalName = this.getPageCache().get(ORIGINAL_HEADNAME);
        if (StringUtils.isEmpty((String)headerName)) {
            return false;
        }
        if (originalName != null && headerName.equals(originalName)) {
            return true;
        }
        if (exitHeadNname.contains(headerName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u4ef6\u540d\u79f0\u4e0e\u5df2\u6dfb\u52a0\u7ec4\u4ef6\u5217\u540d\u79f0\u91cd\u590d\u3002", (String)"ColMemberEditPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (this.getPreHeadNname().contains(headerName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u4ef6\u540d\u79f0\u4e0e\u9884\u7f6e\u7ec4\u4ef6\u540d\u79f0\u91cd\u590d\u3002", (String)"ColMemberEditPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        return true;
    }

    private Column4Cache getOrignCol() {
        Object customParam = this.getFormCustomParam("column");
        return customParam != null && StringUtils.isNotEmpty((String)customParam.toString()) ? (Column4Cache)ObjectSerialUtil.deSerializedBytes((String)customParam.toString()) : null;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm".equals(key)) {
            String sign = (String)this.getView().getFormShowParameter().getCustomParam("sign");
            boolean loanShow = (Boolean)this.getModel().getValue(LOAN_SHOW);
            Column4Cache sourceColumn = this.getOrignCol();
            if (sign.contains(PRE)) {
                String headerName = (String)this.getModel().getValue(COL_NAME);
                if (this.checkHeadNameForSysAssembly(headerName)) {
                    boolean displayChild = (Boolean)this.getModel().getValue(DISPLAY_CHILD);
                    if (sourceColumn != null) {
                        sourceColumn.setHeaderName(headerName);
                        sourceColumn.setDisplayChild(Boolean.valueOf(displayChild));
                        sourceColumn.setUseDefault(Boolean.valueOf(true));
                        sourceColumn.setLoanShow(Boolean.valueOf(loanShow));
                        this.returnDataToParent(Pair.onePair((Object)sign, (Object)sourceColumn));
                        this.getView().close();
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u586b\u5199\u3002", (String)"ColMemberEditPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
            } else {
                String headerName = (String)this.getModel().getValue(COL_NAME);
                boolean isFormula = (Boolean)this.getModel().getValue(IS_FORMULA);
                boolean isSys = (Boolean)this.getModel().getValue(USE_DEFAULT);
                Integer colIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("colIndex");
                if (this.checkCanComfirm(headerName, isFormula, isSys)) {
                    Column4Cache column;
                    String colNumber = sign;
                    if (sourceColumn != null) {
                        colIndex = sourceColumn.getColIndex();
                        colNumber = sourceColumn.getNumber();
                    }
                    if (isFormula) {
                        String formula = (String)this.getModel().getValue(FORMULA);
                        column = new Column4Cache(colNumber, headerName, colIndex.intValue(), false, "", "", "", "", formula, false);
                        column.setUseDefault(Boolean.valueOf(false));
                    } else {
                        boolean displayChild = (Boolean)this.getModel().getValue(DISPLAY_CHILD);
                        String process = this.getModel().getValue(PROCESS) == null ? "" : ((DynamicObject)this.getModel().getValue(PROCESS)).getString(NUMBER);
                        String auditTrail = null;
                        if (this.isExistAuditTrailDimension()) {
                            auditTrail = ((DynamicObject)this.getModel().getValue(AUDIT_TRAIL)).getString(NUMBER);
                        }
                        String currency = ((DynamicObject)this.getModel().getValue(CURRENCY)).getString(NUMBER);
                        column = new Column4Cache(colNumber, headerName, colIndex.intValue(), displayChild, "", process, auditTrail, currency, "", loanShow);
                        column.setUseDefault(Boolean.valueOf(isSys));
                    }
                    this.returnDataToParent(Pair.onePair((Object)sign, (Object)column));
                    this.getView().close();
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u586b\u5199\u3002", (String)"ColMemberEditPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
            }
        } else if (CHINESE_FORMULA.equals(key)) {
            String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
            String colList = (String)this.getView().getFormShowParameter().getCustomParam(COL_LIST);
            this.openFormPage("bcm_paper_formulaedit", "formulaedit", type, colList);
        }
    }

    private void openFormPage(String formId, String callBackId, String type, String colList) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("type", (Object)type);
        formShowParameter.setCustomParam(COL_LIST, (Object)colList);
        formShowParameter.setCustomParam(FORMULA, this.getModel().getValue(FORMULA));
        if (StringUtils.isNotEmpty((String)callBackId)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, callBackId);
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("formulaedit") && (returnData = closedCallBackEvent.getReturnData()) != null) {
            Pair result = (Pair)ObjectSerialUtil.deSerializedBytes((String)((String)returnData));
            this.getModel().setValue(FORMULA, result.p1);
            this.getModel().setValue(CHINESE_FORMULA, result.p2);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        beforeF7SelectEvent.addCustomQFilter(new QFilter("model", "=", (Object)this.getModelId()));
    }

    private boolean checkCanComfirm(String headerName, boolean isFormula, boolean isSys) {
        IDataModel model;
        boolean isAddCol = false;
        if (this.getView().getFormShowParameter().getCustomParam("isAddCol") != null) {
            isAddCol = (Boolean)this.getView().getFormShowParameter().getCustomParam("isAddCol");
        }
        if (isSys && StringUtils.isNotEmpty((String)headerName)) {
            if (isAddCol) {
                return true;
            }
            Column4Cache orignCol = this.getOrignCol();
            if (orignCol != null && !orignCol.isUseDefault()) {
                return true;
            }
            return this.checkHeadNameForSysAssembly(headerName);
        }
        if (StringUtils.isEmpty((String)headerName)) {
            return false;
        }
        List<Column4Cache> columnList = this.getColumnList();
        String originalName = this.getPageCache().get(ORIGINAL_HEADNAME);
        if (columnList != null && !columnList.isEmpty()) {
            for (int i = 0; i < columnList.size(); ++i) {
                if (!headerName.equals(columnList.get(i).getHeaderName()) || !isAddCol && headerName.equals(originalName)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u4ef6\u540d\u79f0\u4e0e\u5df2\u6dfb\u52a0\u7ec4\u4ef6\u5217\u540d\u79f0\u91cd\u590d\u3002", (String)"ColMemberEditPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
        if (((Boolean)(model = this.getModel()).getValue(USE_DEFAULT)).booleanValue()) {
            for (String key : defaultcolnumbers) {
                if (model.getValue(key) != null) continue;
                return false;
            }
        } else {
            if (WorkPaperTypeEnum.getEnumByName((String)headerName) != null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u4ef6\u540d\u79f0\u4e0e\u9884\u7f6e\u7ec4\u4ef6\u540d\u79f0\u91cd\u590d\u3002", (String)"ColMemberEditPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (isFormula) {
                return !StringUtils.isEmpty((String)((String)model.getValue(CHINESE_FORMULA)));
            }
            for (String key : colnumbers) {
                if (this.getModel().getValue(key) != null) continue;
                return false;
            }
        }
        return true;
    }
}

