/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.workingpaper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.LabelElement;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.ColDimensionEntryExt;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.MembSettingBaseDetail;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.RowDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.common.AnalyticsSolutionDataConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.WorkPaperEnum;
import kd.fi.bcm.common.enums.WorkPaperTypeEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.util.TemplateDimSettingUtil;
import kd.fi.bcm.formplugin.util.WorkPaperUtil;
import kd.fi.bcm.formplugin.util.WpFormulaUtil;
import kd.fi.bcm.formplugin.workingpaper.WorkPaperTemplatePlugin;
import kd.fi.bcm.formplugin.workingpaper.model.AbstractColumn;
import kd.fi.bcm.formplugin.workingpaper.model.Column;
import kd.fi.bcm.formplugin.workingpaper.model.Column4Cache;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;

public class TemplatePageSettingPlugin
extends AbstractTemplateBasePlugin
implements DynamicPage {
    private static final String DIMS = "dims";
    private static final String GENERAL = "general";
    private static final String ROW = "row";
    private static final String COL = "col";
    private static final String PANEL = "panel";
    private static final String ALL = "allPoint";
    private static final String ALL_NAME = "map";
    private static final String ALL_SEQ = "seq";
    private static final String ROWCACHE = "rowcache";
    private static final String ROWNUM = "rownum";
    private static final String COLNUM = "colnum";
    private static final String COLADDNUM = "coladdnum";
    private static final String COLSAVEDNUM = "colsavednum";
    private static final String COLPREFIX = "col_";
    private static final String DEFINED = "defined_";
    private static final String PRE = "pre_";
    private static final Set<String> colnumbers = Sets.newHashSet((Object[])new String[]{"entity", "process", "audittrail", "currency"});
    private static final String COL_CACHE_KEY = "col_cache_key";
    private static final String TYPE = "type";
    private static final String SAVEDTYPE = "savedtype";
    private static final String CODEMAPPINGCONTROL = "codemappingcontrol";
    private static final String ROWNAME = "rowname";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String NUMBER = "number";
    private static final String MODEL = "model";
    private static final String ROW_PANEL = "rowpanel";
    private static final String SCOPE = "scope";
    private static final String GENERAL_PANEL = "generalpanel";

    @Override
    public void initialize() {
        super.initialize();
        if (this.getPage(this.getView()) != null) {
            this.getPage(this.getView()).bindCtrlMapping(this.getView());
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_confirm", "btnaddf7", "btndelf7", "btnaddcol", "btndelcol", "btnresetcol");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String type = (String)this.getView().getFormShowParameter().getCustomParam(TYPE);
        this.getPageCache().put(SAVEDTYPE, type);
        Page page = this.getPage(this.getView());
        page = page == null ? new Page() : page;
        TemplateModel template = this.getTemplateModel();
        page.addArea(this.initPageViewPanel(GENERAL, template, type));
        page.addArea(this.initPageViewPanel(ROW, template, type));
        page.addArea(this.initPageViewPanel(COL, template, type));
        this.resetElementStyle(page.getAreaList());
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        this.setDefaultValue(type);
        this.setDraggable();
    }

    private void resetCol() {
        Page page = this.getPage(this.getView());
        Area colPanel = page.findAreaBySign("colpanel");
        colPanel.getElementListList().clear();
        IPageCache pageCache = this.getPageCache();
        String savedType = pageCache.get(SAVEDTYPE);
        String type = pageCache.get(TYPE);
        this.addElement2Col(null, type, savedType, colPanel, 0);
        this.getPageCache().put(COLSAVEDNUM, String.valueOf(0));
        Map<String, Map<String, Map<String, Object>>> dimInfo = this.getDimInfo();
        this.resetElementStyle(page.getAreaList());
        this.setPage(this.getView(), page, true);
        page.updatePage(this.getView());
        this.setDraggable();
        List enums = WorkPaperTypeEnum.getList((String)type);
        int colnum = 0;
        ArrayList<Column4Cache> columnList = new ArrayList<Column4Cache>(enums.size());
        for (WorkPaperTypeEnum a : enums) {
            Column4Cache column = new Column4Cache(a.getNumber(), a.getHeaderName(), colnum, a.isDisplayChild(), "", a.getProcessNum(), a.getAuditTrailNum(), a.getCurrencyNum(), "", a.isLoanShow());
            column.setUseDefault(Boolean.valueOf(true));
            this.initDefaultValue4Col(type, "col_pre_" + colnum, column, dimInfo);
            ++colnum;
            columnList.add(column);
        }
        this.cachLastColIndex(colnum);
        pageCache.put(COL_CACHE_KEY + type, ObjectSerialUtil.toByteSerialized(columnList));
    }

    @Override
    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnaddf7": {
                this.addF7();
                return;
            }
            case "btndelf7": {
                this.deleteF7();
                return;
            }
            case "btnaddcol": {
                this.addCol();
                return;
            }
            case "btndelcol": {
                this.deleteColElement();
                return;
            }
            case "btnresetcol": {
                this.resetCol();
                return;
            }
            case "btn_confirm": {
                String type = (String)this.getModel().getValue(TYPE);
                String colCache = this.getPageCache().get(COL_CACHE_KEY + type);
                List cols4Cache = (List)ObjectSerialUtil.deSerializedBytes((String)colCache);
                if (cols4Cache == null || cols4Cache.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u7ef4\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\uff0c\u8bf7\u5148\u65b0\u589e\u5217\u7ef4\uff0c\u518d\u70b9\u51fb\u786e\u8ba4\u3002", (String)"TemplatePageSettingPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                this.actionConfirm();
                return;
            }
        }
        List<String> dims = this.getDims();
        String dim = this.checkAndGetKey(dims, key);
        if (dim != null) {
            this.getPageCache().put("bcm_workingpaper", "true");
            this.openMultiF7(key, dim);
        } else if (key.startsWith(COLPREFIX)) {
            this.getPageCache().put("bcm_workingpaper", "true");
            this.openColEdit(key, false, null);
        }
    }

    @Override
    public String getModelNumber() {
        return MemberReader.findModelNumberById((Object)this.getModelId());
    }

    private void openMultiF7(String key, String dim) {
        FormShowParameter para = new FormShowParameter();
        HashMap<String, Object> params = new HashMap<String, Object>();
        int paramvalue = 0;
        List<Map<String, String>> list = this.getPointEntry();
        for (Map<String, String> map : list) {
            if (!dim.equalsIgnoreCase(map.get(NUMBER))) continue;
            paramvalue = Integer.parseInt(map.get(ALL_SEQ));
            break;
        }
        if (this.getValue(key) == null || StringUtils.isEmpty((String)this.getValue(key).toString())) {
            this.setValue(key, null);
            this.getPageCache().remove(key);
        }
        params.put("dimension", paramvalue + "");
        params.put("sign", key);
        params.put("isUpDownBtn", true);
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        params.put("KEY_MODEL_ID", modelId);
        para.setCustomParams(params);
        if ("InternalCompany".equalsIgnoreCase(dim)) {
            para.setFormId("bcm_mulmemberf7_tem_ic");
        } else {
            para.setFormId("bcm_mulmemberf7base_tem");
        }
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"TemplatePageSettingPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), QueryDimensionServiceHelper.getDimByDseq((int)paramvalue, (String)modelId).getString("name")));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private LabelElement addLabelElement(int number) {
        return new LabelElement(this.getRowSuffix("label", number), "\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014", new LocaleString("15px"));
    }

    private TextEditElement addTextEditElementForRow(Map<String, String> map, int number) {
        return new TextEditElement(map.get("name"), this.getRowSuffix(map.get("sign"), number), map.get("entity"));
    }

    private void addF7() {
        int number = Integer.parseInt(this.getPageCache().get(ROWNUM)) + 1;
        Page page = this.getPage(this.getView());
        Area area = page.findAreaBySign(ROW_PANEL);
        Map<String, Object> valueMap = this.getValueMap(area.getElementListList(), this.getPageCache());
        area.addElement((Element)this.addLabelElement(number));
        List row = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(ROW));
        for (Map<String, String> map : this.getPointEntry()) {
            if (!row.contains(map.get("sign"))) continue;
            area.addElement((Element)this.addTextEditElementForRow(map, number));
        }
        this.getPageCache().put(ROWNUM, String.valueOf(number));
        List areas = page.getAreaList();
        this.resetElementStyle(areas);
        this.getModel().getDataEntity(true);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        this.setDraggable();
        for (int i = 0; i <= number; ++i) {
            for (String dim : row) {
                String rowSuffix = this.getRowSuffix(dim, i);
                this.setValue(rowSuffix, valueMap.get(rowSuffix));
            }
        }
        this.getView().updateView(ROW_PANEL);
    }

    private void deleteF7() {
        int number = Integer.parseInt(this.getPageCache().get(ROWNUM));
        if (number == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u5b58\u5728\u4e00\u4e2a\u884c\u7ef4\u7ec4\u5408\u3002", (String)"TemplatePageSettingPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        Page page = this.getPage(this.getView());
        Area rowArea = page.findAreaBySign(ROW_PANEL);
        ArrayList<String> needDel = new ArrayList<String>();
        for (Object element : rowArea.getElementListList()) {
            String[] split = element.getSign().split("!");
            if (split.length != 2 || !split[1].equals(number + "")) continue;
            needDel.add(element.getSign());
        }
        needDel.forEach(sign -> rowArea.removeElememt(sign));
        List row = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(ROW));
        for (String dim : row) {
            String rowSuffix = this.getRowSuffix(dim, number);
            this.getPageCache().remove(rowSuffix);
            this.setValue(rowSuffix, null);
        }
        this.getPageCache().put(ROWNUM, String.valueOf(number - 1));
        List areas = page.getAreaList();
        this.resetElementStyle(areas);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private void addCol() {
        int colnum = this.getLastColIndex();
        String key = this.getAddColKey(colnum);
        this.openColEdit(key, true, colnum);
    }

    private String getAddColKey(int colnum) {
        String key = "col_defined_" + colnum;
        List<Tuple<String, String, String>> colCodeMapping = this.getColCodeMapping();
        if (colCodeMapping.stream().anyMatch(pair -> ((String)pair.p1).equals(key) || ((String)pair.p3).equals(key))) {
            return this.getAddColKey(++colnum);
        }
        return key;
    }

    public void deleteColElement() {
        int colAddNum;
        IPageCache pageCache = this.getPageCache();
        int colnum = this.getLastColIndex();
        String type = pageCache.get(TYPE);
        if (colnum <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e0d\u5b58\u5728\u53ef\u5220\u9664\u7684\u5217\u7ef4\u6210\u5458\u3002", (String)"TemplatePageSettingPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        List columnList = (List)ObjectSerialUtil.deSerializedBytes((String)pageCache.get(COL_CACHE_KEY + type));
        List<Tuple<String, String, String>> colCodeMapping = this.getColCodeMapping();
        Tuple<String, String, String> tuple = colCodeMapping.remove(columnList.size() - 1);
        this.cacheColCodeMapping(colCodeMapping);
        columnList.remove(columnList.size() - 1);
        pageCache.put(COL_CACHE_KEY + type, ObjectSerialUtil.toByteSerialized((Object)columnList));
        --colnum;
        String sign = (String)tuple.p1;
        Page page = this.getPage(this.getView());
        Area area = page.findAreaBySign("colpanel");
        area.removeElememt(sign);
        pageCache.remove(sign);
        int n = colAddNum = pageCache.get(COLADDNUM + type) == null ? 0 : Integer.parseInt(pageCache.get(COLADDNUM + type));
        if (colAddNum != 0) {
            pageCache.put(COLADDNUM + type, String.valueOf(--colAddNum));
        }
        this.cachLastColIndex(colnum);
        List areas = page.getAreaList();
        this.resetElementStyle(areas);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        this.setDraggable();
    }

    private void openColEdit(String key, boolean isAddCol, Integer colIndex) {
        FormShowParameter parameter = new FormShowParameter();
        String type = this.getPageCache().get(TYPE);
        parameter.setCustomParam(TYPE, (Object)type);
        parameter.setCustomParam("isAddCol", (Object)isAddCol);
        parameter.setCustomParam("column", (Object)(isAddCol ? "" : this.getPageCache().get(key)));
        parameter.setCustomParam("collist", (Object)this.getPageCache().get(COL_CACHE_KEY + type));
        parameter.setCustomParam("sign", (Object)key);
        if (colIndex != null) {
            parameter.setCustomParam("colIndex", (Object)colIndex);
        }
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        parameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        parameter.setFormId("bcm_coldimension");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private String checkAndGetKey(List<String> dims, String key) {
        for (String dim : dims) {
            if (!key.equals(dim = dim.toLowerCase(Locale.ENGLISH)) && !key.startsWith(dim + '!')) continue;
            return dim;
        }
        return null;
    }

    private void actionConfirm() {
        if (this.fillBack2TemplateModel(this, this.getTemplateModel())) {
            TemplateModel template = this.getTemplateModel();
            SpreadManager spread = new SpreadManager(null, null);
            String type = (String)this.getModel().getValue(TYPE);
            String colCache = this.getPageCache().get(COL_CACHE_KEY + type);
            List<String> areas = this.calculateAreas(colCache);
            template.getAreaRangeEntries().clear();
            for (int i = 0; i < areas.size(); ++i) {
                this.handleAreaSettingEvent(areas.get(i), areas.get(i).split(":")[0], template, spread);
                this.fillBack2RankMember(i, template);
            }
            List cols4Cache = (List)ObjectSerialUtil.deSerializedBytes((String)colCache);
            AreaRangeEntry firstArea = (AreaRangeEntry)template.getAreaRangeEntries().get(0);
            ArrayList<Column> columnList = new ArrayList<Column>(10);
            int startColIdx = ExcelUtils.pos2XY((String)firstArea.getStartPosition())[0];
            int i = 0;
            for (Column4Cache col4Cache : cols4Cache) {
                String header = col4Cache.getHeaderName();
                String number = col4Cache.getNumber();
                String formula = col4Cache.getFormula();
                ColDimensionEntryExt colDimensionEntryExt = WorkPaperUtil.getColDimensionEntryExt(this.getModelId(), firstArea, (AbstractColumn)col4Cache, startColIdx + i);
                Column column = new Column(number, header, startColIdx + i, col4Cache.getDisplayChild().booleanValue(), formula, col4Cache.getLoanShow().booleanValue());
                column.setUseDefault(Boolean.valueOf(col4Cache.isUseDefault()));
                Iterator iterator = colDimensionEntryExt.getDimMembers().iterator();
                column.setOrg((Pair)iterator.next());
                column.setProcess((Pair)iterator.next());
                if (this.isExistAuditTrailDimension()) {
                    column.setAuditTrial((Pair)iterator.next());
                }
                column.setCurrency((Pair)iterator.next());
                columnList.add(column);
                ++i;
            }
            WorkPaperUtil.saveColumnList(spread, columnList);
            template.getViewPointDimensionEntries().clear();
            Tuple result = Tuple.create((Object)template, (Object)JsonSerializerUtil.toJson((SpreadManager)spread), (Object)((String)this.getModel().getValue(TYPE)));
            this.returnDataToParent(result);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObjectCollection doc;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        List<String> dims = this.getDims();
        if (actionId.startsWith("col_defined_") || actionId.startsWith("col_pre_")) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                Pair pair = (Pair)ObjectSerialUtil.deSerializedBytes((String)returnData.toString());
                String elementSign = (String)pair.p1;
                Column4Cache newCol = (Column4Cache)pair.p2;
                if (newCol != null && elementSign != null) {
                    boolean isAdd = true;
                    String type = (String)this.getModel().getValue(TYPE);
                    List columnList = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(COL_CACHE_KEY + type));
                    for (Column4Cache column : columnList) {
                        if (!column.getNumber().equals(newCol.getNumber())) continue;
                        isAdd = false;
                        break;
                    }
                    if (actionId.startsWith("col_pre_")) {
                        isAdd = false;
                    }
                    Page page = this.getPage(this.getView());
                    Area colArea = page.findAreaBySign("colpanel");
                    List<Tuple<String, String, String>> colCodeMapping = this.getColCodeMapping();
                    if (isAdd) {
                        TextEditElement f7 = new TextEditElement(newCol.getHeaderName(), newCol.getNumber(), null);
                        colArea.addElement((Element)f7);
                        colCodeMapping.add((Tuple<String, String, String>)Tuple.create((Object)newCol.getNumber(), (Object)newCol.getHeaderName(), (Object)newCol.getNumber()));
                        this.cacheColCodeMapping(colCodeMapping);
                        int colnum = this.getLastColIndex();
                        this.cachLastColIndex(++colnum);
                        this.refreshPage(page);
                        this.resetColValue(type, newCol, null, elementSign);
                        this.setDraggable();
                    } else {
                        TextEditElement f7 = (TextEditElement)page.findElementBySign(elementSign);
                        f7.setName(newCol.getHeaderName());
                        Integer index = null;
                        for (Tuple<String, String, String> colSign : colCodeMapping) {
                            if (!((String)colSign.p1).equalsIgnoreCase(elementSign)) continue;
                            index = colCodeMapping.indexOf(colSign);
                        }
                        if (index != null) {
                            colCodeMapping.remove(index);
                            colCodeMapping.add(index, (Tuple<String, String, String>)Tuple.create((Object)elementSign, (Object)newCol.getHeaderName(), (Object)newCol.getNumber()));
                            this.cacheColCodeMapping(colCodeMapping);
                        }
                        this.refreshPage(page);
                        this.resetColValue(type, null, newCol, elementSign);
                    }
                }
            }
        } else if (this.checkAndGetKey(dims, actionId) != null && (doc = (DynamicObjectCollection)closedCallBackEvent.getReturnData()) != null) {
            StringBuilder sb = new StringBuilder();
            ArrayList list = new ArrayList(10);
            for (DynamicObject dot : doc) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", dot.get(4).toString());
                map.put(SCOPE, dot.get(5).toString());
                map.put(NUMBER, dot.get(2).toString());
                map.put("name", dot.get(3).toString());
                this.buildPageViewShowName(sb, dot.get(3).toString(), dot.getInt(5));
                list.add(map);
            }
            if (StringUtils.isEmpty((String)sb.toString())) {
                this.setValue(actionId, sb.toString());
                this.getPageCache().remove(actionId);
            } else {
                this.setValue(actionId, sb.substring(0, sb.length() - 1));
                this.getPageCache().put(actionId, SerializationUtils.toJsonString(list));
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName().toLowerCase(Locale.ENGLISH);
        String newValue = (String)this.getModel().getValue(key);
        List<String> dims = this.getDims();
        String dim = this.checkAndGetKey(dims, key);
        if (dim != null) {
            String sign;
            Page page;
            if (StringUtils.isEmpty((String)newValue)) {
                this.getPageCache().remove(key);
            }
            if (key.equalsIgnoreCase(DimEntityNumEnum.SCENARIO.getNumber()) && (page = this.getPage(this.getView())) != null && page.findElementBySign(sign = DimTypesEnum.PERIOD.getNumber().toLowerCase(Locale.ENGLISH)) != null) {
                this.getModel().setValue(sign, null);
                this.getPageCache().put(sign, null);
                this.getView().updateView(sign);
            }
        } else if (key.startsWith(COLPREFIX)) {
            if ("".equals(newValue)) {
                HashMap<String, List<String>> dimNumAndFiels = new HashMap<String, List<String>>();
                dimNumAndFiels.put(DimTypesEnum.PROCESS.getNumber(), Arrays.asList(NUMBER, "name"));
                if (MemberReader.isExistAuditTrailDimension((String)this.getCurModelNumber())) {
                    dimNumAndFiels.put(DimTypesEnum.AUDITTRIAL.getNumber(), Arrays.asList(NUMBER, "name"));
                }
                dimNumAndFiels.put(DimTypesEnum.CURRENCY.getNumber(), Arrays.asList(NUMBER, "name"));
                Map dimInfo = QueryDimensionServiceHelper.getDimMemberInfoMap((long)this.template.getModelId(), dimNumAndFiels, (boolean)false);
                Column4Cache column = (Column4Cache)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(key));
                String type = this.getPageCache().get(TYPE);
                String colValue = this.getColChineseValue(type, column, dimInfo);
                this.setValue(key, colValue);
                this.getView().updateView(key);
            }
        } else if (TYPE.equals(key)) {
            this.typeChanged(newValue);
        }
    }

    private void typeChanged(String newValue) {
        Page page = this.getPage(this.getView());
        Area colPanel = page.findAreaBySign("colpanel");
        colPanel.getElementListList().clear();
        List areaEntry = this.getTemplateModel().getAreaRangeEntries();
        String savedType = this.getPageCache().get(SAVEDTYPE);
        this.addElement2Col(areaEntry, newValue, savedType, colPanel, 0);
        this.getPageCache().put(COLSAVEDNUM, String.valueOf(0));
        this.resetElementStyle(page.getAreaList());
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        this.getPageCache().put(COL_CACHE_KEY + newValue, null);
        this.resetColValue(newValue, null, null, null);
        this.getPageCache().put(TYPE, newValue);
    }

    private void buildPageViewShowName(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.VALUE_10) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"TemplatePageSettingPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(",");
        }
    }

    private String getRowSuffix(String dimNum, int i) {
        return dimNum + '!' + i + "";
    }

    private Area initPageViewPanel(String item, TemplateModel template, String type) {
        Area area = new Area(item + PANEL);
        area.setShowLabel(true);
        List<String> dims = this.getDims();
        List areas = template.getAreaRangeEntries();
        LocaleString width = new LocaleString("35%");
        switch (item) {
            case "general": {
                TextEditElement f7;
                Dimension dim;
                List dimensions = template.getPageDimensionEntries();
                for (PageDimensionEntry entry : dimensions) {
                    dim = entry.getDimension();
                    f7 = new TextEditElement(dim.getName(), dim.getNumber().toLowerCase(Locale.ENGLISH), dim.getDataEntityNumber());
                    f7.setLabelWidth(width);
                    area.addElement((Element)f7);
                    dims.add(dim.getNumber().toLowerCase(Locale.ENGLISH));
                }
                for (PageDimensionEntry entry : template.getViewPointDimensionEntries()) {
                    dim = entry.getDimension();
                    if (dims.contains(dim.getNumber().toLowerCase(Locale.ENGLISH))) continue;
                    f7 = new TextEditElement(dim.getName(), dim.getNumber().toLowerCase(Locale.ENGLISH), dim.getDataEntityNumber());
                    f7.setLabelWidth(width);
                    area.addElement((Element)f7);
                    dims.add(dim.getNumber().toLowerCase(Locale.ENGLISH));
                }
                break;
            }
            case "row": {
                int areasize = areas.isEmpty() ? 1 : areas.size();
                HashMap rowName = Maps.newHashMap();
                for (int i = 0; i < areasize; ++i) {
                    if (i != 0) {
                        area.addElement((Element)this.addLabelElement(i));
                    }
                    for (Map<String, String> map : this.getPointEntry()) {
                        if (i == 0) {
                            rowName.put(map.get("sign"), Pair.onePair((Object)map.get("name"), (Object)map.get("entity")));
                        }
                        if (!ROW.equals(map.get(PANEL))) continue;
                        TextEditElement f7 = this.addTextEditElementForRow(map, i);
                        f7.setLabelWidth(width);
                        area.addElement((Element)f7);
                        dims.add(map.get(NUMBER).toLowerCase(Locale.ENGLISH));
                    }
                }
                this.getPageCache().put(ROWNAME, ObjectSerialUtil.toByteSerialized((Object)rowName));
                break;
            }
            case "col": {
                this.addElement2Col(areas, type, type, area, 0);
            }
        }
        this.getPageCache().put(DIMS, ObjectSerialUtil.toByteSerialized(dims));
        return area;
    }

    private void addElement2Col(List<AreaRangeEntry> areas, String type, String savedType, Area colPanel, int colNum) {
        ArrayList<Tuple<String, String, String>> tuples = new ArrayList<Tuple<String, String, String>>(16);
        if (areas == null || areas.size() == 0 || !type.equals(savedType)) {
            List enums = WorkPaperTypeEnum.getList((String)type);
            for (WorkPaperTypeEnum a : enums) {
                String sign = "col_pre_" + colNum;
                TextEditElement f7 = new TextEditElement(a.getHeaderName(), sign, null);
                tuples.add((Tuple<String, String, String>)Tuple.create((Object)sign, (Object)a.getHeaderName(), (Object)a.getNumber()));
                colPanel.addElement((Element)f7);
                ++colNum;
            }
        } else {
            String customParam = (String)this.getView().getFormShowParameter().getCustomParam("columns");
            List cols = areas.get(0).getColDimEntriesExt();
            if (customParam != null) {
                WorkPaperUtil.syncSmColumnToAreaRangeEntry(areas.get(0), (List)ObjectSerialUtil.deSerializedBytes((String)customParam), this.getModelId());
            }
            ColDimensionEntryExt.sortCols((List)cols);
            for (ColDimensionEntryExt col : cols) {
                String sign = this.getPrefix(type, col.isUseDefault()) + colNum;
                TextEditElement f7 = new TextEditElement(col.getHeader(), sign, null);
                tuples.add((Tuple<String, String, String>)Tuple.create((Object)sign, (Object)col.getHeader(), (Object)col.getNumber()));
                colPanel.addElement((Element)f7);
                ++colNum;
            }
        }
        this.cacheColCodeMapping(tuples);
    }

    private String getPrefix(String type, boolean isUseDefault) {
        String pre = type.equals(WorkPaperEnum.USERDEFINED.getNumber()) ? "col_defined_" : (isUseDefault ? "col_pre_" : "col_defined_");
        return pre;
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String ctrlKey = e.getKey();
        if (this.getPage(this.getView()) != null) {
            Element c = this.getPage(this.getView()).findElementBySign(ctrlKey);
            if (c != null && TextEditElement.class.isAssignableFrom(c.getClass())) {
                if (ctrlKey.equals(DimTypesEnum.PROCESS.getNumber())) {
                    TextEdit edit = new TextEdit();
                    edit.setKey(ctrlKey);
                    edit.setModel(this.getModel());
                    edit.setView(this.getView());
                    e.setControl((Control)edit);
                } else {
                    TextEdit edit = new TextEdit();
                    edit.setKey(ctrlKey);
                    edit.setModel(this.getModel());
                    edit.setView(this.getView());
                    edit.addClickListener((ClickListener)this);
                    e.setControl((Control)edit);
                    this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getTemplateModel().getModelId()));
                }
            } else if (c != null) {
                e.setControl(c.getControl(this.getView()));
            }
        }
    }

    private List<Map<String, String>> getPointEntry() {
        return WorkPaperTemplatePlugin.getPointEntry(this, this.getTemplateModel());
    }

    private void setDefaultValue(String type) {
        List members;
        Dimension dim;
        TemplateModel template = this.getTemplateModel();
        List dimensions = template.getPageDimensionEntries();
        ArrayList<String> dims = new ArrayList<String>(dimensions.size());
        for (PageDimensionEntry entry : dimensions) {
            dim = entry.getDimension();
            dims.add(dim.getNumber());
            members = entry.getMembers();
            this.initDefaultValue(dim.getNumber().toLowerCase(Locale.ENGLISH), this.getCurrectDimEntity(DimensionUtil.getDimMembEntityNumByDimNum(dim.getNumber())), members);
        }
        for (PageDimensionEntry entry : template.getViewPointDimensionEntries()) {
            dim = entry.getDimension();
            if (dims.contains(dim.getNumber())) continue;
            members = Lists.newArrayList((Object[])new Member[]{entry.getMember()});
            this.initDefaultValue(dim.getNumber().toLowerCase(Locale.ENGLISH), this.getCurrectDimEntity(DimensionUtil.getDimMembEntityNumByDimNum(dim.getNumber())), members);
        }
        List entries = template.getAreaRangeEntries();
        int num = entries.isEmpty() ? 0 : entries.size();
        for (int i = 0; i < num; ++i) {
            List temp = ((AreaRangeEntry)entries.get(i)).getRowDimEntries();
            for (RowDimensionEntry entry : temp) {
                Dimension dim2 = entry.getDimension();
                List members2 = entry.getMembers();
                this.initDefaultValue(this.getRowSuffix(dim2.getNumber().toLowerCase(Locale.ENGLISH), i), this.getCurrectDimEntity(DimensionUtil.getDimMembEntityNumByDimNum(dim2.getNumber())), members2);
            }
        }
        this.resetColValue(type, null, null, null);
        this.setValue(TYPE, type);
        IPageCache pageCache = this.getPageCache();
        pageCache.put(TYPE, type);
        pageCache.put(ROWNUM, entries.isEmpty() ? "0" : String.valueOf(num - 1));
    }

    private void initDefaultValue(String sign, String entity, List<Member> members) {
        StringBuilder sb = new StringBuilder();
        if (members.isEmpty()) {
            return;
        }
        ArrayList li = new ArrayList(members.size());
        ArrayList<String> numbers = new ArrayList<String>(members.size());
        for (int i = 0; i < members.size(); ++i) {
            numbers.add(members.get(i).getNumber());
        }
        Map dimMembers = QueryDimensionServiceHelper.getMemberMapByNumber((long)this.getTemplateModel().getModelId(), numbers, (String)entity);
        if (dimMembers.isEmpty()) {
            return;
        }
        for (int i = 0; i < members.size(); ++i) {
            DynamicObject obj = (DynamicObject)dimMembers.get(members.get(i).getNumber());
            long id = obj.getLong("id");
            String name = obj.getString("name");
            this.buildPageViewShowName(sb, name, members.get(i).getScope());
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("id", String.valueOf(id));
            m.put(SCOPE, String.valueOf(members.get(i).getScope()));
            m.put(NUMBER, obj.getString(NUMBER));
            m.put("name", obj.getString("name"));
            li.add(m);
        }
        Object[] ids = new Object[]{sb.substring(0, sb.length() - 1)};
        this.setValue(sign, ids);
        this.getPageCache().put(sign, SerializationUtils.toJsonString(li));
    }

    private void initDefaultValue4Col(String type, String sign, Column4Cache column, Map<String, Map<String, Map<String, Object>>> dimInfo) {
        String colValue = this.getColChineseValue(type, column, dimInfo);
        this.setValue(sign, colValue);
        this.getPageCache().put(sign, ObjectSerialUtil.toByteSerialized((Object)column));
    }

    private String getColChineseValue(String type, Column4Cache column, Map<String, Map<String, Map<String, Object>>> dimInfo) {
        Map<String, Object> map;
        Map<String, Map<String, Object>> stringMapMap;
        boolean existAuditTrailDimension;
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((String)column.getFormula())) {
            List<Column4Cache> columnList = new ArrayList();
            if (this.getPageCache().get(COL_CACHE_KEY + type) != null) {
                columnList = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(COL_CACHE_KEY + type));
            } else {
                List colDims = ((AreaRangeEntry)this.getTemplateModel().getAreaRangeEntries().get(0)).getColDimEntriesExt();
                int i = 0;
                for (ColDimensionEntryExt colDim : colDims) {
                    Column4Cache column4Cache = new Column4Cache(colDim.getNumber(), colDim.getHeader(), i, colDim.getDisplayChild().booleanValue(), "", "", "", "", colDim.getFormula(), colDim.getLoanShow().booleanValue());
                    columnList.add(column4Cache);
                    ++i;
                }
            }
            return WpFormulaUtil.transFormula2Chinese(column.getFormula(), columnList);
        }
        if (!StringUtils.isEmpty((String)column.getProcess())) {
            sb.append(dimInfo.get(DimTypesEnum.PROCESS.getNumber()).get(column.getProcess()).get("name")).append(',');
        }
        if ((existAuditTrailDimension = MemberReader.isExistAuditTrailDimension((long)this.getModelId())) && !StringUtils.isEmpty((String)column.getAuditTrial()) && (stringMapMap = dimInfo.get(DimTypesEnum.AUDITTRIAL.getNumber())) != null && (map = dimInfo.get(DimTypesEnum.AUDITTRIAL.getNumber()).get(column.getAuditTrial())) != null) {
            sb.append(dimInfo.get(DimTypesEnum.AUDITTRIAL.getNumber()).get(column.getAuditTrial()).get("name")).append(',');
        }
        if (!StringUtils.isEmpty((String)column.getCurrency()) && (stringMapMap = dimInfo.get(DimTypesEnum.CURRENCY.getNumber())) != null && (map = dimInfo.get(DimTypesEnum.CURRENCY.getNumber()).get(column.getCurrency())) != null) {
            sb.append(dimInfo.get(DimTypesEnum.CURRENCY.getNumber()).get(column.getCurrency()).get("name"));
        }
        return sb.toString();
    }

    private void resetColValue(String type, Column4Cache newCol, Column4Cache modifyCol, String elementSign) {
        Map<String, Map<String, Map<String, Object>>> dimInfo = this.getDimInfo();
        Tuple<Map<Long, String>, Map<Long, String>, Map<Long, String>> dimMaps = this.getDimMap();
        IPageCache pageCache = this.getPageCache();
        List<Object> columnList = new ArrayList<Column4Cache>();
        int colnum = 0;
        if (pageCache.get(COL_CACHE_KEY + type) == null) {
            List areas;
            if (type.equals(this.getPageCache().get(SAVEDTYPE))) {
                this.addColInTemplateToList(type, dimMaps, columnList);
                for (Column4Cache column4Cache : columnList) {
                    String prefix = this.getPrefix(type, column4Cache.isUseDefault());
                    this.initDefaultValue4Col(type, (String)prefix + colnum, column4Cache, dimInfo);
                    ++colnum;
                }
            }
            if (!(!columnList.isEmpty() || !(areas = this.template.getAreaRangeEntries()).isEmpty() && ((AreaRangeEntry)areas.get(0)).getColDimEntriesExt().isEmpty() && type.equals(this.getPageCache().get(SAVEDTYPE)) || type.equals(WorkPaperEnum.USERDEFINED.getNumber()))) {
                List list = WorkPaperTypeEnum.getList((String)type);
                for (WorkPaperTypeEnum a : list) {
                    Column4Cache column = new Column4Cache(a.getNumber(), a.getHeaderName(), colnum, a.isDisplayChild(), "", a.getProcessNum(), a.getAuditTrailNum(), a.getCurrencyNum(), "", a.isLoanShow());
                    column.setUseDefault(Boolean.valueOf(true));
                    this.initDefaultValue4Col(type, "col_pre_" + colnum, column, dimInfo);
                    ++colnum;
                    columnList.add(column);
                }
            }
        } else {
            columnList = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(COL_CACHE_KEY + type));
            colnum = columnList.size();
            int savedColnum = Integer.parseInt(pageCache.get(COLSAVEDNUM));
            if (newCol != null) {
                this.initDefaultValue4Col(type, newCol.getNumber(), newCol, dimInfo);
                ++colnum;
                columnList.add(newCol);
            }
            ArrayList<Column4Cache> arrayList = new ArrayList<Column4Cache>();
            if (modifyCol != null && elementSign != null) {
                WorkPaperTypeEnum typeEnum = WorkPaperUtil.getWorkPaperTypeEnum(modifyCol);
                String modifyNumer = typeEnum != null ? typeEnum.getNumber() : modifyCol.getNumber();
                for (Column4Cache column4Cache : columnList) {
                    if (Arrays.asList(modifyNumer, modifyCol.getNumber()).contains(column4Cache.getNumber())) {
                        this.initDefaultValue4Col(type, elementSign, modifyCol, dimInfo);
                        arrayList.add(modifyCol);
                        continue;
                    }
                    arrayList.add(column4Cache);
                }
                columnList = arrayList;
            }
            pageCache.put(COLADDNUM + type, String.valueOf(colnum - savedColnum));
        }
        this.cachLastColIndex(colnum);
        pageCache.put(COL_CACHE_KEY + type, ObjectSerialUtil.toByteSerialized(columnList));
    }

    private int getLastColIndex() {
        int colIndex = 0;
        if (this.getPageCache().get(COLNUM) != null) {
            colIndex = Integer.parseInt(this.getPageCache().get(COLNUM));
        }
        return colIndex;
    }

    private void cachLastColIndex(int colIndex) {
        this.getPageCache().remove(COLNUM);
        this.getPageCache().put(COLNUM, Integer.toString(colIndex));
    }

    private void setDraggable() {
        this.getControl(GENERAL_PANEL).setDroppable(true);
        this.getControl(ROW_PANEL).setDroppable(true);
        List row = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(ROW));
        int number = Integer.parseInt(this.getPageCache().get(ROWNUM));
        for (int i = 0; i <= number; ++i) {
            for (String f7key : row) {
                String rowSuffix = this.getRowSuffix(f7key, i);
                this.getControl(rowSuffix).setDraggable(true);
                this.getControl(rowSuffix).setDroppable(true);
            }
        }
        List<String> dims = this.getDims();
        dims.forEach(e -> {
            if (!row.contains(e) && !colnumbers.contains(e)) {
                this.getControl((String)e).setDraggable(true);
                this.getControl((String)e).setDroppable(true);
            }
        });
        List tuples = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(CODEMAPPINGCONTROL));
        tuples.forEach(tuple -> {
            this.getControl((String)tuple.p1).setDraggable(true);
            this.getControl((String)tuple.p1).setDroppable(true);
        });
    }

    private String getPanelForSign(String sign) {
        if (GENERAL_PANEL.equals(sign) || ROW_PANEL.equals(sign) || "colpanel".equals(sign)) {
            return sign;
        }
        Element element = this.getPage(this.getView()).findElementBySign(sign);
        if (element != null && element.getArea() != null) {
            return element.getArea().getSign();
        }
        return sign;
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String name = e.getEventName();
        if ("drop".equals(name)) {
            String[] msg = this.translateMessage(e.getEventArgs());
            String source = msg[1];
            String target = msg[0];
            if (source.contains(COLPREFIX)) {
                this.dragColElement(target, source);
            } else {
                if (target.startsWith(COLPREFIX)) {
                    return;
                }
                if (this.checkIsRowpanel(msg)) {
                    this.dragRowElement(target, source);
                } else {
                    int i;
                    List<String> dims = this.getDims();
                    String targetPanel = this.getPanelForSign(target);
                    String sourcepanel = this.getPanelForSign(source);
                    source = this.checkAndGetKey(dims, msg[1]);
                    ArrayList<String> row = new ArrayList<String>((Collection)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(ROW)));
                    if (targetPanel.equals(sourcepanel)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u7528\u7ef4\u4e0d\u652f\u6301\u5185\u90e8\u62d6\u62fd\u3002", (String)"TemplatePageSettingPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                        return;
                    }
                    if (targetPanel.startsWith(GENERAL)) {
                        if (row.size() == 1) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u7ef4\u81f3\u5c11\u4fdd\u7559\u4e00\u4e2a\u7ef4\u5ea6\u3002", (String)"TemplatePageSettingPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                            return;
                        }
                        row.remove(source);
                    }
                    this.getPageCache().put(ROW, ObjectSerialUtil.toByteSerialized(row));
                    this.getPageCache().remove(ALL);
                    Page page = this.getPage(this.getView());
                    Area sourceArea = page.findAreaBySign(sourcepanel);
                    ArrayList<Element> needMove = new ArrayList<Element>();
                    for (Element element : sourceArea.getElementListList()) {
                        if (!element.getSign().equals(msg[1])) continue;
                        needMove.add(element);
                    }
                    int number = Integer.parseInt(this.getPageCache().get(ROWNUM));
                    if (sourcepanel.equals(ROW_PANEL)) {
                        for (int i2 = 0; i2 <= number; ++i2) {
                            sourceArea.removeElememt(this.getRowSuffix(source, i2));
                        }
                    } else {
                        sourceArea.removeElememt(msg[1]);
                    }
                    Area targetarea = page.findAreaBySign(targetPanel);
                    Map<String, Object> valueMap = this.getValueMap(targetarea.getElementListList(), this.getPageCache());
                    TextEditElement element = (TextEditElement)needMove.get(0);
                    String addSign = null;
                    ArrayList<String> newitems = new ArrayList<String>();
                    if (targetPanel.equals(GENERAL_PANEL)) {
                        String temp = this.checkAndGetKey(this.getDims(), element.getSign());
                        TextEditElement f7 = new TextEditElement(element.getName(), temp, element.getEntity());
                        targetarea.addElement((Element)f7);
                        addSign = f7.getSign();
                        for (i = number; i >= 0; --i) {
                            String rowSuffix = this.getRowSuffix(source, i);
                            this.getPageCache().remove(rowSuffix);
                            this.setValue(rowSuffix, null);
                        }
                        this.getPageCache().remove(source);
                    } else {
                        int targetIndex = -1;
                        for (int i3 = 0; i3 < row.size(); ++i3) {
                            if (!target.startsWith((String)row.get(i3))) continue;
                            targetIndex = i3;
                        }
                        if (targetIndex >= 0) {
                            row.add(targetIndex, source);
                        } else {
                            row.add(source);
                        }
                        this.getPageCache().put(ROW, ObjectSerialUtil.toByteSerialized(row));
                        this.getPageCache().remove(ALL);
                        Map rowName = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(ROWNAME));
                        targetarea.getElementListList().clear();
                        for (i = 0; i <= number; ++i) {
                            if (i != 0) {
                                LabelElement label = this.addLabelElement(i);
                                targetarea.addElement((Element)label);
                                newitems.add(this.getRowSuffix("label", i));
                            }
                            for (String rowNumber : row) {
                                String rowSuffix = this.getRowSuffix(rowNumber, i);
                                TextEditElement ele = new TextEditElement((String)((Pair)rowName.get((Object)rowNumber)).p1, rowSuffix, (String)((Pair)rowName.get((Object)rowNumber)).p2);
                                ele.setValue(this.getPageCache(), valueMap.get(rowSuffix));
                                targetarea.addElement((Element)ele);
                                newitems.add(rowSuffix);
                            }
                        }
                        this.getPageCache().remove(element.getSign());
                    }
                    this.resetElementStyle(page.getAreaList());
                    this.setPage(this.getView(), page, true);
                    page.updatePage(this.getView());
                    for (String s : newitems) {
                        if (s.startsWith("label!")) continue;
                        this.setValue(s, valueMap.get(s));
                        this.getView().updateView(s);
                    }
                    this.setDraggable();
                    if (StringUtils.isNotEmpty((String)addSign)) {
                        this.getView().updateView(addSign);
                    }
                }
            }
        }
    }

    private boolean checkIsRowpanel(String[] msg) {
        String source = msg[1];
        String target = msg[0];
        List row = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(ROW));
        if (row == null || row.isEmpty()) {
            return false;
        }
        boolean b = row.stream().anyMatch(item -> source.startsWith(item + '!'));
        boolean a = row.stream().anyMatch(item -> target.startsWith(item + '!'));
        return b && a || b && ROW_PANEL.equals(target) || a && ROW_PANEL.equals(source);
    }

    private void dragColElement(String target, String source) {
        if (!target.startsWith(COLPREFIX)) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        String type = this.getModel().getValue(TYPE).toString();
        List<Tuple<String, String, String>> colSigns = this.getColCodeMapping();
        ArrayList<Column4Cache> columnList = new ArrayList<Column4Cache>((Collection)ObjectSerialUtil.deSerializedBytes((String)pageCache.get(COL_CACHE_KEY + type)));
        int targetIndex = -1;
        int sourceIndex = -1;
        Tuple<String, String, String> sourceTemp = null;
        for (int i = 0; i < colSigns.size(); ++i) {
            if (((String)colSigns.get((int)i).p1).equals(source)) {
                sourceTemp = colSigns.get(i);
                sourceIndex = i;
            }
            if (!((String)colSigns.get((int)i).p1).equals(target)) continue;
            targetIndex = i;
        }
        Column4Cache columnTemp = (Column4Cache)columnList.get(sourceIndex);
        colSigns.remove(sourceTemp);
        columnList.remove(columnTemp);
        if (sourceIndex <= targetIndex) {
            colSigns.add(targetIndex - 1, sourceTemp);
            columnList.add(targetIndex - 1, columnTemp);
        } else {
            colSigns.add(targetIndex, sourceTemp);
            columnList.add(targetIndex, columnTemp);
        }
        ((Column4Cache)columnList.get(targetIndex)).setColIndex(targetIndex);
        ((Column4Cache)columnList.get(sourceIndex)).setColIndex(sourceIndex);
        Page page = this.getPage(this.getView());
        Area colArea = page.findAreaBySign("colpanel");
        colArea.getElementListList().clear();
        for (Tuple<String, String, String> sign : colSigns) {
            colArea.addElement((Element)new TextEditElement((String)sign.p2, (String)sign.p1, null));
        }
        this.cacheColCodeMapping(colSigns);
        pageCache.put(COL_CACHE_KEY + type, ObjectSerialUtil.toByteSerialized(columnList));
        this.resetElementStyle(page.getAreaList());
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        this.setDraggable();
    }

    private boolean isSameGroup(String target, String source) {
        String[] split1 = target.split("!");
        String[] split2 = source.split("!");
        return split1.length == 2 && split2.length == 2 && split1[1].equals(split2[1]);
    }

    private void dragRowElement(String target, String source) {
        if (!this.isSameGroup(target, source)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u7ef4\u6210\u5458\u987a\u5e8f\u53ea\u80fd\u5728\u540c\u7ec4\u5185\u62d6\u62fd\u4fee\u6539\u3002", (String)"TemplatePageSettingPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        IPageCache pageCache = this.getPageCache();
        ArrayList<String> row = new ArrayList<String>((Collection)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(ROW)));
        int targetIndex = -1;
        String sourceTemp = null;
        for (int i = 0; i < row.size(); ++i) {
            if (source.startsWith((String)row.get(i) + '!')) {
                sourceTemp = (String)row.get(i);
            }
            if (!target.startsWith((String)row.get(i) + '!')) continue;
            targetIndex = i;
        }
        row.remove(sourceTemp);
        row.add(targetIndex, sourceTemp);
        Page page = this.getPage(this.getView());
        Area rowArea = page.findAreaBySign(ROW_PANEL);
        Map<String, Object> valueMap = this.getValueMap(rowArea.getElementListList(), pageCache);
        rowArea.getElementListList().clear();
        Map rowName = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(ROWNAME));
        int number = Integer.parseInt(this.getPageCache().get(ROWNUM));
        for (int i = 0; i <= number; ++i) {
            if (i != 0) {
                rowArea.addElement((Element)this.addLabelElement(i));
            }
            for (String rowNumber : row) {
                String rowSuffix = this.getRowSuffix(rowNumber, i);
                TextEditElement ele = new TextEditElement((String)((Pair)rowName.get((Object)rowNumber)).p1, rowSuffix, (String)((Pair)rowName.get((Object)rowNumber)).p2);
                ele.setValue(pageCache, valueMap.get(rowSuffix));
                rowArea.addElement((Element)ele);
            }
        }
        pageCache.put(ROW, ObjectSerialUtil.toByteSerialized(row));
        this.resetElementStyle(page.getAreaList());
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private Map<String, Object> getValueMap(List<Element> elementListList, IPageCache pageCache) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)elementListList.size());
        for (Element element : elementListList) {
            result.put(element.getSign(), element.getValue(pageCache));
        }
        return result;
    }

    private void resetElementStyle(List<Area> areas) {
        for (Area area : areas) {
            if (area.getSign().startsWith(ROW)) {
                for (Element element : area.getElementListList()) {
                    this.setRowDefaultStyle(element);
                }
                continue;
            }
            for (Element element : area.getElementListList()) {
                this.setDefaultStyle(element);
            }
        }
    }

    private void setDefaultStyle(Element element) {
        Style style = new Style();
        Margin margin = new Margin();
        Padding padding = new Padding();
        padding.setRight("10px");
        padding.setLeft("14px");
        padding.setTop("10px");
        margin.setBottom("10px");
        style.setMargin(margin);
        style.setPadding(padding);
        element.setStyle(style);
    }

    private void setRowDefaultStyle(Element element) {
        Style style = new Style();
        Margin margin = new Margin();
        Padding padding = new Padding();
        padding.setRight("1px");
        padding.setLeft("1px");
        padding.setTop("1px");
        margin.setLeft("1px");
        margin.setRight("1px");
        margin.setTop("1px");
        margin.setBottom("1px");
        style.setMargin(margin);
        style.setPadding(padding);
        element.setStyle(style);
    }

    private String[] translateMessage(String text) {
        text = text.substring(1, text.length() - 1);
        String[] msg = text.split(",");
        for (int i = 0; i < msg.length; ++i) {
            msg[i] = msg[i].substring(1, msg[i].length() - 1);
        }
        return msg;
    }

    private void fillBack2RankMember(int i, TemplateModel template) {
        List row = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(ROW));
        AreaRangeEntry area = (AreaRangeEntry)template.getAreaRangeEntries().get(template.getAreaRangeEntries().size() - 1);
        for (MembSettingBaseDetail cd : area.getRowDimEntries()) {
            for (String dim : row) {
                if (!dim.equalsIgnoreCase(cd.getDimension().getNumber())) continue;
                List list = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.getRowSuffix(dim, i)), List.class);
                for (Map map : list) {
                    String entityNumber = this.getCurrectDimEntity(DimensionUtil.getDimMembEntityNumByDimNum(dim));
                    IDNumberTreeNode memberById = MemberReader.findMemberById((long)this.getModelId(), (String)entityNumber, (Long)Long.valueOf((String)map.get("id")));
                    if (memberById == null) {
                        entityNumber = "bcm_definedpropertyvalue";
                        memberById = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_definedpropertyvalue", (Long)Long.valueOf((String)map.get("id")));
                    }
                    Member member = TemplateDimSettingUtil.convertMemberTree2Member(memberById, entityNumber);
                    member.setScope(Integer.parseInt((String)map.get(SCOPE)));
                    cd.getMembers().add(member);
                }
            }
        }
    }

    private boolean fillBack2TemplateModel(AbstractTemplateBasePlugin pageview, TemplateModel template) {
        ArrayList<Map<String, String>> general = new ArrayList<Map<String, String>>();
        List<Map<String, String>> allponit = this.getPointEntry();
        IPageCache pageCache = pageview.getPageCache();
        for (Map<String, String> map : allponit) {
            if (GENERAL.equals(map.get(PANEL))) {
                if (pageCache.get(map.get("sign")) == null) {
                    pageview.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u901a\u7528\u7ef4\u5ea6\u6210\u5458\u3002", (String)"TemplatePageSettingPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return false;
                }
                general.add(map);
                continue;
            }
            if (!ROW.equals(map.get(PANEL))) continue;
            int number = Integer.parseInt(this.getPageCache().get(ROWNUM));
            for (int i = 0; i <= number; ++i) {
                String suffix = this.getRowSuffix(map.get("sign"), i);
                if (pageview.getPageCache().get(suffix) != null && !ObjectUtils.isEmpty((Object)this.getValue(suffix))) continue;
                pageview.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u7ef4\u6210\u5458\u3002", (String)"TemplatePageSettingPlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return false;
            }
        }
        TemplateDimSettingUtil.handlePageEntryFilltoTemplateModel(template, general, pageview);
        return true;
    }

    private List<String> calculateAreas(String colCache) {
        List cols4Cache = (List)ObjectSerialUtil.deSerializedBytes((String)colCache);
        int columnSize = cols4Cache.size();
        for (Column4Cache column4Cache : cols4Cache) {
            if (!column4Cache.getLoanShow().booleanValue()) continue;
            ++columnSize;
        }
        int allRow = 0;
        List row = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(ROW));
        int rowSize = row.size();
        int number = Integer.parseInt(this.getPageCache().get(ROWNUM));
        ArrayList<String> result = new ArrayList<String>(number);
        for (int i = 0; i <= number; ++i) {
            int rowsize = 1;
            for (String dim : row) {
                String suffix = this.getRowSuffix(dim, i);
                List list = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(suffix), List.class);
                rowsize *= this.getNewDimensionSize(list, dim);
            }
            allRow += rowsize;
            result.add(this.calculateArea(rowsize, result, row.size(), columnSize));
        }
        int current = (rowSize + columnSize) * (allRow + 1);
        if (current > 300000) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e95\u7a3f\u6a21\u677f\u9875\u9762\u5e03\u5c40\u6700\u5927\u53ea\u652f\u630130\u4e07\u6709\u6548\u5355\u5143\u683c\u8bbe\u7f6e\uff0c\u5f53\u524d%s\u5355\u5143\u683c\uff0c\u8bf7\u51cf\u5c11\u884c\u7ef4\u6210\u5458\u4e2a\u6570\u540e\u64cd\u4f5c\u3002", (String)"TemplatePageSettingPlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), current));
        }
        return result;
    }

    private int getNewDimensionSize(List<Map<String, String>> list, String dimNum) {
        AtomicInteger size = new AtomicInteger();
        String entityName = DimensionUtil.getDimMembEntityNumByDimNum(dimNum);
        for (Map<String, String> map : list) {
            MembRangeItem item = new MembRangeItem(entityName, Long.valueOf(map.get("id")), String.valueOf(map.get(NUMBER)), Integer.parseInt(map.get(SCOPE)), false, (Object)this.getModelId());
            item.matchItems(c -> {
                if (("bcm_fymembertree".equals(entityName) || "bcm_periodmembertree".equals(entityName)) && AnalyticsSolutionDataConstant.SPECIFIC_PE_OR_FY.contains(c.getNumber())) {
                    return;
                }
                size.getAndIncrement();
            });
        }
        return size.get();
    }

    private String calculateArea(int rowsize, List<String> areas, int rowDimSize, int colSize) {
        int[] rangeExy;
        int[] rangeSxy;
        String before;
        String string = before = areas.isEmpty() ? null : areas.get(areas.size() - 1);
        if (null != before) {
            rangeSxy = ExcelUtils.pos2XY((String)before.split(":")[0]);
            rangeExy = ExcelUtils.pos2XY((String)before.split(":")[1]);
        } else {
            int startrow = Integer.parseInt(this.getView().getFormShowParameter().getCustomParam("startrow") + "");
            int startcol = Integer.parseInt(this.getView().getFormShowParameter().getCustomParam("startcol") + "");
            rangeSxy = new int[]{startcol + rowDimSize, 0};
            rangeExy = new int[]{startcol + rowDimSize + colSize - 1, startrow};
        }
        int sr = rangeSxy[0];
        int sc = rangeExy[1] + 1;
        int er = rangeExy[0];
        int ec = rangeExy[1] + rowsize;
        return ExcelUtils.xy2Pos((int)sr, (int)sc) + ":" + ExcelUtils.xy2Pos((int)er, (int)ec);
    }

    private void handleAreaSettingEvent(String areainfo, String startpoint, TemplateModel template, SpreadManager spread) {
        AreaRangeEntry areaEntry = new AreaRangeEntry(this.getTemplateModel());
        areaEntry.setAreaRange(areainfo);
        areaEntry.setStartPosition(startpoint);
        template.getAreaRangeEntries().add(areaEntry);
        PositionInfo newps = new PositionInfo(areaEntry.getStartPosition(), areaEntry.getAreaRange());
        newps.setSplit(true);
        spread.getAreaManager().addArea(newps, null, null);
        areaEntry.getRowDimEntries().clear();
        areaEntry.getColDimEntriesExt().clear();
        List<String> rowEntry = this.sortRowEntry(this.getRowEntry());
        for (String row : rowEntry) {
            DynamicObject temp = this.getDimByDseq(Integer.parseInt(this.getSeqMap().get(row)), String.valueOf(template.getModelId()));
            Dimension dim = this.convertDynaObj2Dimension(temp);
            RowDimensionEntry rowDimEntry = new RowDimensionEntry(areaEntry);
            rowDimEntry.setDimension(dim);
            rowDimEntry.setSeq(Integer.parseInt(this.getSeqMap().get(row)));
            areaEntry.addRowDimEntry(rowDimEntry);
        }
    }

    public DynamicObject getDimByDseq(int seq, String modelId) {
        Map objectMap = MemberReader.getDimDyoByModelId((long)LongUtil.toLong((Object)modelId));
        DynamicObject dyo = null;
        for (Map.Entry entry : objectMap.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            if (value.getInt("dseq") != seq) continue;
            dyo = value;
            break;
        }
        return dyo;
    }

    private List<String> sortRowEntry(List<String> rowEntry) {
        if (this.getPageCache().get(ROW) != null) {
            List row = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(ROW));
            ArrayList result = Lists.newArrayList();
            for (String s : row) {
                for (String s1 : rowEntry) {
                    if (!s1.equalsIgnoreCase("bcm_" + s)) continue;
                    result.add(s1);
                }
            }
            if (result.size() == rowEntry.size()) {
                return result;
            }
        }
        return rowEntry;
    }

    private Map<String, String> getSeqMap() {
        HashMap<String, String> map;
        if (this.getPageCache().get(ALL_SEQ) == null) {
            map = new HashMap();
            this.getPageCache().put(ALL_SEQ, SerializationUtils.toJsonString(map));
        }
        map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(ALL_SEQ), Map.class);
        return map;
    }

    private Map<String, String> getNameMap() {
        HashMap<String, String> map;
        if (this.getPageCache().get(ALL_NAME) == null) {
            map = new HashMap();
            this.getPageCache().put(ALL_NAME, SerializationUtils.toJsonString(map));
        }
        map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(ALL_NAME), Map.class);
        return map;
    }

    private List<String> getRowEntry() {
        if (this.getPageCache().get(ROWCACHE) == null) {
            Map<String, String> map = this.getNameMap();
            Map<String, String> seq = this.getSeqMap();
            ArrayList<String> list = new ArrayList<String>();
            List<DynamicObject> rank = this.getRankDim();
            for (DynamicObject dot : rank) {
                if (colnumbers.contains(dot.getString(NUMBER).toLowerCase(Locale.ENGLISH))) continue;
                list.add("bcm_" + dot.getString(NUMBER).toLowerCase(Locale.ENGLISH));
                map.put("bcm_" + dot.getString(NUMBER).toLowerCase(Locale.ENGLISH), dot.getString("name"));
                seq.put("bcm_" + dot.getString(NUMBER).toLowerCase(Locale.ENGLISH), QueryDimensionServiceHelper.getMsgByNumber((long)this.getTemplateModel().getModelId(), (String)dot.getString(NUMBER)).getString("dseq"));
            }
            this.getPageCache().put(ROWCACHE, SerializationUtils.toJsonString(list));
            this.getPageCache().put(ALL_NAME, SerializationUtils.toJsonString(map));
            this.getPageCache().put(ALL_SEQ, SerializationUtils.toJsonString(seq));
        }
        List rp = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(ROWCACHE), List.class);
        return rp;
    }

    private List<DynamicObject> getRankDim() {
        ArrayList<String> numbers = new ArrayList<String>(10);
        for (PageDimensionEntry pe : this.getTemplateModel().getPageDimensionEntries()) {
            numbers.add(pe.getDimension().getNumber());
        }
        for (PageDimensionEntry pe : this.getTemplateModel().getPagePropEntries()) {
            numbers.add(pe.getDimension().getNumber());
        }
        for (ViewPointDimensionEntry ve : this.getTemplateModel().getViewPointDimensionEntries()) {
            numbers.add(ve.getDimension().getNumber());
        }
        List rank = QueryDimensionServiceHelper.getOthersDim(numbers, (Long)this.getTemplateModel().getModelId());
        for (DynamicObject obj : rank) {
            if (!DimTypesEnum.INTERCOMPANY.getNumber().equals(obj.getString(NUMBER)) || QueryDimensionServiceHelper.checkIcEnt((long)this.getTemplateModel().getModelId())) continue;
            rank.remove(obj);
            break;
        }
        return rank;
    }

    private List<String> getDims() {
        List<String> dims = new ArrayList<String>();
        if (this.getPageCache().get(DIMS) != null) {
            dims = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(DIMS));
        }
        return dims;
    }

    private Map<String, Map<String, Map<String, Object>>> getDimInfo() {
        TemplateModel template = this.getTemplateModel();
        HashMap<String, List<String>> dimNumAndFiels = new HashMap<String, List<String>>();
        dimNumAndFiels.put(DimTypesEnum.PROCESS.getNumber(), Arrays.asList(NUMBER, "name"));
        if (MemberReader.isExistAuditTrailDimension((long)this.getModelId())) {
            dimNumAndFiels.put(DimTypesEnum.AUDITTRIAL.getNumber(), Arrays.asList(NUMBER, "name"));
        }
        dimNumAndFiels.put(DimTypesEnum.CURRENCY.getNumber(), Arrays.asList(NUMBER, "name"));
        return QueryDimensionServiceHelper.getDimMemberInfoMap((long)template.getModelId(), dimNumAndFiels, (boolean)false);
    }

    private Tuple<Map<Long, String>, Map<Long, String>, Map<Long, String>> getDimMap() {
        QFilter filter = new QFilter(MODEL, "=", (Object)this.getModelId());
        DynamicObjectCollection processs = QueryServiceHelper.query((String)"bcm_processmembertree", (String)"id,number", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection auditTrails = QueryServiceHelper.query((String)"bcm_audittrialmembertree", (String)"id,number", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection currencys = QueryServiceHelper.query((String)"bcm_currencymembertree", (String)"id,number", (QFilter[])new QFilter[]{filter});
        HashMap<Long, String> processMap = new HashMap<Long, String>();
        HashMap<Long, String> auditTrailMap = new HashMap<Long, String>();
        HashMap<Long, String> currencyMap = new HashMap<Long, String>();
        for (DynamicObject dot : processs) {
            processMap.put(dot.getLong("id"), dot.getString(NUMBER));
        }
        for (DynamicObject dot : auditTrails) {
            auditTrailMap.put(dot.getLong("id"), dot.getString(NUMBER));
        }
        for (DynamicObject dot : currencys) {
            currencyMap.put(dot.getLong("id"), dot.getString(NUMBER));
        }
        return Tuple.create(processMap, auditTrailMap, currencyMap);
    }

    private void addColInTemplateToList(String type, Tuple<Map<Long, String>, Map<Long, String>, Map<Long, String>> dimMaps, List<Column4Cache> columnList) {
        IPageCache pageCache = this.getPageCache();
        List areas = this.template.getAreaRangeEntries();
        int colnum = 0;
        boolean existAuditTrailDimension = MemberReader.isExistAuditTrailDimension((long)this.getModelId());
        if (!areas.isEmpty()) {
            List colDims = ((AreaRangeEntry)areas.get(0)).getColDimEntriesExt();
            ColDimensionEntryExt.sortCols((List)colDims);
            for (ColDimensionEntryExt colDim : colDims) {
                String currency = "";
                String auditTrail = "";
                String process = "";
                for (Pair member : colDim.getDimMembers()) {
                    if (member.p2 == null) continue;
                    if (((Dimension)member.p1).getNumber().equals(DimTypesEnum.PROCESS.getNumber())) {
                        process = (String)((Map)dimMaps.p1).get(((Member)member.p2).getId());
                    }
                    if (existAuditTrailDimension && ((Dimension)member.p1).getNumber().equals(DimTypesEnum.AUDITTRIAL.getNumber())) {
                        auditTrail = (String)((Map)dimMaps.p2).get(((Member)member.p2).getId());
                    }
                    if (!((Dimension)member.p1).getNumber().equals(DimTypesEnum.CURRENCY.getNumber())) continue;
                    currency = (String)((Map)dimMaps.p3).get(((Member)member.p2).getId());
                }
                String headerName = colDim.getHeader();
                String number = colDim.getNumber();
                Column4Cache column = new Column4Cache(number, headerName, colnum, colDim.getDisplayChild().booleanValue(), "", process, auditTrail, currency, colDim.getFormula(), colDim.getLoanShow().booleanValue());
                column.setUseDefault(Boolean.valueOf(colDim.isUseDefault()));
                ++colnum;
                columnList.add(column);
            }
        } else {
            colnum = WorkPaperTypeEnum.getList((String)type).size();
        }
        pageCache.put(COLSAVEDNUM, String.valueOf(colnum));
    }

    private void refreshPage(Page page) {
        List areas = page.getAreaList();
        this.resetElementStyle(areas);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private String getCurrectDimEntity(String entity) {
        if (entity.equals("bcm_eb_versionmembertree") || entity.equals("eb_datetypemembertree")) {
            return "bcm_userdefinedmembertree";
        }
        return entity;
    }

    private List<Tuple<String, String, String>> getColCodeMapping() {
        List<Object> tuples = new ArrayList<Tuple<String, String, String>>(16);
        String s = this.getPageCache().get(CODEMAPPINGCONTROL);
        if (StringUtils.isNotEmpty((String)s)) {
            tuples = (List)ObjectSerialUtil.deSerializedBytes((String)s);
        }
        return tuples;
    }

    private void cacheColCodeMapping(List<Tuple<String, String, String>> tuples) {
        this.getPageCache().remove(CODEMAPPINGCONTROL);
        this.getPageCache().put(CODEMAPPINGCONTROL, ObjectSerialUtil.toByteSerialized(tuples));
    }
}

