/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.workingpaper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.fi.bcm.business.chkcheck.util.CheckedFormulaUtil;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.serviceHelper.ExpressionServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.util.WpFormulaUtil;
import kd.fi.bcm.formplugin.workingpaper.model.Column4Cache;
import kd.fi.bcm.spread.formula.EncoderService;
import org.apache.commons.lang.RandomStringUtils;

public class WorkPaperFormulaEditPlugin
extends AbstractBaseFormPlugin
implements DynamicPage {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(WorkPaperFormulaEditPlugin.class);
    private static final String WPFORMULACV = "cvtformulacb";
    private static final String COL_LIST = "collist";
    private static final String FORMULA_SETTING_TEXT = "formulasettingtext";

    @Override
    public void initialize() {
        super.initialize();
        if (this.getPage(this.getView()) != null) {
            this.getPage(this.getView()).bindCtrlMapping(this.getView());
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_del", "btn_+", "btn_-", "btn_*", "btn_/", "btn_(", "btn_)", "btn_v");
        this.addClickListeners("confirm");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setComboBox();
        this.buildEditPage();
    }

    private void setComboBox() {
        String colList = (String)this.getView().getFormShowParameter().getCustomParam(COL_LIST);
        List columnList = (List)ObjectSerialUtil.deSerializedBytes((String)colList);
        ComboEdit colfactor = (ComboEdit)this.getControl("colfactor");
        ArrayList<ComboItem> factors = new ArrayList<ComboItem>();
        for (Column4Cache column : columnList) {
            if (!StringUtils.isEmpty((CharSequence)column.getFormula())) continue;
            factors.add(new ComboItem(new LocaleString(column.getHeaderName()), column.getNumber()));
        }
        colfactor.setComboItems(factors);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = this.getModel().getValue(key);
        if (newValue == null) {
            return;
        }
        String number = String.valueOf(newValue);
        if (key.equals("colfactor")) {
            String colList = (String)this.getView().getFormShowParameter().getCustomParam(COL_LIST);
            List columnList = (List)ObjectSerialUtil.deSerializedBytes((String)colList);
            String name = "";
            for (Column4Cache column : columnList) {
                if (!column.getNumber().equals(number)) continue;
                name = column.getHeaderName();
                break;
            }
            this.addFactor(name, number);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("confirm")) {
            this.getPageCache().put("issave", "true");
            CustomControl custom = (CustomControl)this.getView().getControl(FORMULA_SETTING_TEXT);
            custom.setData(CheckedFormulaUtil.packGetText());
        }
    }

    private void addFactor(String value, String number) {
        CustomControl custom = (CustomControl)this.getView().getControl(FORMULA_SETTING_TEXT);
        String sign = this.getComboSign(WPFORMULACV);
        number = "CVT(\"" + number + "\")";
        this.getPageCache().put(sign, number);
        custom.setData(CheckedFormulaUtil.packAddTextNoEdit((String)sign, (String)value));
    }

    private String getComboSign(String type) {
        return type + RandomStringUtils.randomAlphanumeric((int)5).toLowerCase(Locale.ENGLISH);
    }

    public void customEvent(CustomEventArgs eventArgs) {
        switch (eventArgs.getEventName()) {
            case "f(x)": {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u51fd\u6570\u3002", (String)"WorkPaperFormulaEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "getText": {
                CheckedFormulaUtil.FormulaBuilder formulas;
                String text = eventArgs.getEventArgs();
                text = text.replaceAll("\n", "");
                text = text.replaceAll("\\p{C}", "");
                if (StringUtils.isEmpty((CharSequence)text)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u516c\u5f0f\u3002", (String)"WorkPaperFormulaEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                try {
                    formulas = CheckedFormulaUtil.transToFormulaOld((String)text, (IPageCache)this.getPageCache());
                }
                catch (Exception e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"WorkPaperFormulaEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                Pair<String, String> result = this.getFormula(formulas);
                this.returnDataToParent(result);
                this.getView().close();
            }
        }
    }

    private Pair<String, String> getFormula(CheckedFormulaUtil.FormulaBuilder formulas) {
        String formula = formulas.getLeftsb().toString() + formulas.getCompsb().toString() + formulas.getRigntsb().toString();
        return this.transFormula(formula);
    }

    private Pair<String, String> transFormula(String formula) {
        String colList = (String)this.getView().getFormShowParameter().getCustomParam(COL_LIST);
        List columnList = (List)ObjectSerialUtil.deSerializedBytes((String)colList);
        return Pair.onePair((Object)formula, (Object)WpFormulaUtil.transFormula2Chinese(formula, columnList));
    }

    private void buildEditPage() {
        String formula = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        CustomControl custom = (CustomControl)this.getView().getControl(FORMULA_SETTING_TEXT);
        custom.setData(this.packFormula(formula));
    }

    private Object packFormula(String formula) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)formula)) {
            String colList = (String)this.getView().getFormShowParameter().getCustomParam(COL_LIST);
            List columnList = (List)ObjectSerialUtil.deSerializedBytes((String)colList);
            ExpressParser parser = new ExpressParser();
            EncoderService encoder = new EncoderService();
            IPageCache pageCache = this.getPageCache();
            try {
                Pair pair = parser.parse(formula, encoder);
                int flag = 0;
                for (int i = 0; i < ((String)pair.p1).length(); ++i) {
                    if (((String)pair.p1).charAt(i) >= 'A' && ((String)pair.p1).charAt(i) <= 'Z') {
                        if (!ExpressionServiceHelper.checkFactorComplete((int)i, (String)((String)pair.p1))) continue;
                        IFormula iFormula = (IFormula)((List)pair.p2).get(flag);
                        sb.append("{\"");
                        StringBuffer chinaName = new StringBuffer();
                        if ("CVT".equals(iFormula.getName())) {
                            String sign = this.getComboSign(WPFORMULACV);
                            sb.append(sign);
                            String number = ((ParamItem)iFormula.getParamList().get(0)).toString();
                            chinaName.append(WpFormulaUtil.getNameByNumber(number, columnList));
                            pageCache.put(sign, iFormula.toString());
                        }
                        sb.append("\",\"");
                        sb.append(chinaName);
                        sb.append("\"}");
                        ++flag;
                        continue;
                    }
                    String oper = String.valueOf(((String)pair.p1).charAt(i));
                    sb.append(oper);
                }
            }
            catch (Exception e1) {
                log.error("error", (Throwable)e1);
            }
        }
        JSONObject data = new JSONObject();
        data.put("data", (Object)sb.toString());
        data.put("operate", (Object)"updateText");
        data.put("ishide", (Object)"1");
        return data;
    }
}

