/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.workingpaper;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.reportlist.cache.ReportRedisCache;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.business.util.dynamicobject.DynamicObjectCollectionUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.workpaper.DimensionMemberDisplayTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.cslscheme.CslSchemeUtils;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.report.IIncreaseReportTab;
import kd.fi.bcm.formplugin.report.postman.AbstractReportPostman;
import kd.fi.bcm.formplugin.report.postman.ReportPostmanFactory;
import kd.fi.bcm.formplugin.util.WorkPaperUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class WorkPaperListPlugin
extends AbstractBaseListPlugin
implements TreeNodeClickListener {
    private static final Set<String> dimKeys = Sets.newHashSet((Object[])new String[]{"scenario", "year", "period", "currency"});
    private static final String ROWLLIST = "llist";
    private static final String LFOCUS = "lfocus";
    private static final String TREEVIEW_ENTITY = "treeview_entity";
    private static final String CACHE_TREEORG = "cache_treeentity";
    private static final String SELECTORGS = "selectorgs";
    private static final String ENTITYSELECTED_NODE_ID = "entityselectedNodeId";
    private static final String STR_MODEL = "model";
    private static final String STR_SCENE = "scenario";
    private static final String STR_YEAR = "year";
    private static final String STR_PERIOD = "period";
    private static final String CURRENCY = "currency";
    private static final String MODEL_CACHE_KEY = "KEY_MODEL_ID";
    private static final String BILLLISTAP = "billlistap";
    private static final String SHOWORGTYPE_CACHE = "showorgtype";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_BATCHEXPORT = "btn_batchexport";
    private static final String MODEL_F7ID = "modelf7id";
    private static final String SCENE_F7ID = "scenariof7id";
    private static final String YEAR_F7ID = "yearf7id";
    private static final String PERIOD_F7ID = "periodf7id";
    private static final String CURRENCY_F7ID = "currencyf7id";
    private static final String PREFIX_ENT = "Prefix_Ent_";
    private static final Set<String> visableCol = Sets.newHashSet((Object[])new String[]{"fseq", "template.number", "template.name", "modifier.name", "modifytime"});
    private static final String CTL_CSLSCHEME = "cslscheme";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String NUMBER = "number";
    private static final String SEARCH_BEFORE = "searchbefore";
    private static final String SEARCH_NEXT = "searchnext";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WorkPaperListPlugin.class);
    private Map<Long, DynamicObject> currencyDynaObjmap = new HashMap<Long, DynamicObject>();

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.setBillFormId("bcm_reportlistentity");
        HashMap map = new HashMap();
        this.asMapF7toType(new ArrayList<String>(dimKeys), SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public boolean isSingleF7() {
        return true;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView orgTreeView = (TreeView)this.getControl(TREEVIEW_ENTITY);
        orgTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(SEARCH_BEFORE, SEARCH_NEXT);
        Search sl = (Search)this.getControl("entitysearchap");
        sl.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    WorkPaperListPlugin.this.searchMember(event.getText().toLowerCase(Locale.ENGLISH).trim(), true);
                } else {
                    WorkPaperListPlugin.this.getPageCache().put(WorkPaperListPlugin.ROWLLIST, null);
                    WorkPaperListPlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
        BasedataEdit edit = (BasedataEdit)this.getView().getControl(CTL_CSLSCHEME);
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        if (((BasedataEdit)e.getSource()).getKey().equals(CTL_CSLSCHEME)) {
            e.addCustomQFilter(new QFilter(NUMBER, "!=", (Object)"DefaultRateScheme"));
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columns = args.getListColumns();
        for (IListColumn listColumn : columns) {
            if (visableCol.contains(listColumn.toString())) {
                listColumn.setVisible(1);
                continue;
            }
            listColumn.setVisible(0);
        }
        args.setListColumns(columns);
    }

    private void initFromMergeControl() {
        FormShowParameter params = this.getView().getFormShowParameter();
        Map customParams = params.getCustomParams();
        this.getModel().beginInit();
        this.getModel().setValue(STR_MODEL, customParams.get(STR_MODEL));
        this.setCslschemeValue(customParams.get("selectedOrgid").toString());
        this.getModel().setValue(STR_SCENE, customParams.get(STR_SCENE));
        this.getModel().setValue(STR_YEAR, customParams.get(STR_YEAR));
        this.getModel().setValue(STR_PERIOD, customParams.get(STR_PERIOD));
        this.setCurrencyValue();
        ArrayList<String> selectnodes = new ArrayList<String>();
        selectnodes.add(customParams.get("selectedOrgid").toString());
        this.getPageCache().put(SELECTORGS, ObjectSerialUtil.toByteSerialized(selectnodes));
        this.getModel().endInit();
        this.refreshTree(null);
        this.refreshBillList(this.getF7id(null));
        this.checkGradeOrgScheme();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String showType = (String)this.getModel().getValue(SHOWORGTYPE_CACHE);
        this.getPageCache().put(SHOWORGTYPE_CACHE, showType != null ? showType : "4");
        Object modelIdStr = this.getFormCustomParam(MODEL_CACHE_KEY);
        if (modelIdStr != null) {
            this.initFromMergeControl();
            return;
        }
        this.refreshBillByUserSelect(new ArrayList<String>(dimKeys), false);
        String modelId = this.getPageCache().get(MODEL_CACHE_KEY);
        if (!StringUtils.isEmpty((CharSequence)modelId)) {
            this.initCslschemeValue(modelId, false);
            String selectOrgid = (String)this.getFormCustomParam("selectedOrgid");
            if (!StringUtil.isEmptyString((String)selectOrgid)) {
                this.setCslschemeValue(selectOrgid);
                if (!GuidePageUtils.isFromGuide(this.getView())) {
                    this.setCurrencyValue();
                }
                this.refreshTree(null);
            } else {
                this.refreshTree(Long.valueOf(modelId));
            }
        } else {
            this.setCslschemeValue(null);
            this.refreshTree(null);
        }
        this.refreshBillList(this.getF7id(null));
        this.checkGradeOrgScheme();
        WorkPaperUtil.updateOrgDisplay(this.getView(), WorkPaperUtil.getOrgDisplayFromUserSelect(ModelUtil.queryApp((IFormView)this.getView()), this.getModelId()));
    }

    private void setCurrencyValue() {
        DynamicObject ecCurrency = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_currencymembertree", (String)"id", (QFilter[])new QFilter[]{new QFilter(STR_MODEL, "=", this.getFormCustomParam(MODEL_CACHE_KEY)), new QFilter(NUMBER, "=", (Object)CurrencyEnum.EC)});
        this.getModel().setValue(CURRENCY, (Object)ecCurrency.getLong("id"));
    }

    private void setCslschemeValue(Object selectOrgid) {
        IDNumberTreeNode node;
        if (selectOrgid != null && (node = BcmThreadCache.findNodeById((String)this.getModelNumber(), (String)DimTypesEnum.ENTITY.getNumber(), (long)LongUtil.toLong((Object)selectOrgid))) != IDNumberTreeNode.NotFoundTreeNode) {
            this.getPageCache().put("selectedNodeId", selectOrgid.toString());
            UserSelectServiceHelper.setEntity((Long)this.getUserId(), (Long)this.getModelId(), (Object)selectOrgid);
            this.getModel().setValue(CTL_CSLSCHEME, node.getProperty("cslscheme.id"));
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        this.openMultTabReportProcessPage();
        args.setCancel(true);
        HashMap<String, ArrayList<Object>> map = null;
        try {
            map = this.getlogMessageMap();
            Iterator<Map.Entry<String, ArrayList<Object>>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                ArrayList<Object> value = iterator.next().getValue();
                String number = (String)value.get(1);
                String name = (String)value.get(2);
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u67e5\u770b", "WorkPaperListPlugin_1", FI_BCM_FORMPLUGIN, "check"), new OPDescMultiLangEnumBridge("%1$s %2$s\uff0c\u67e5\u770b\u6210\u529f", "WorkPaperListPlugin_2", FI_BCM_FORMPLUGIN, new String[]{number, name}));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private List<Long> getNoPermList() {
        boolean superUser = PermissionServiceHelper.isSuperUser((long)Long.parseLong(RequestContext.get().getUserId()));
        if (superUser || MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()))) {
            return new ArrayList<Long>();
        }
        ArrayListMultimap map = PermClassEntityHelper.getPermissionMap((String)"bcm_templateentity", (String)String.valueOf(this.getModelId()), (String)String.valueOf(this.getUserId()));
        List noPermIds = map.get((Object)"1");
        return noPermIds;
    }

    private HashMap<String, ArrayList<Object>> getlogMessageMap() {
        ArrayList<Object> selectIdList = new ArrayList<Object>();
        BillList billlistap = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection cos = billlistap.getSelectedRows();
        for (ListSelectedRow listSelectedRow : cos) {
            selectIdList.add(listSelectedRow.getPrimaryKeyValue());
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])selectIdList.toArray(), (DynamicObjectType)billlistap.getEntityType());
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>();
        for (DynamicObject dynamicObject : load) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(dynamicObject.getString("entity.name"));
            list.add(dynamicObject.getString("template.number"));
            list.add(dynamicObject.getString("template.name"));
            map.put(dynamicObject.getPkValue().toString(), list);
        }
        return map;
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        this.openMultTabReportProcessPage();
        evt.setCancel(true);
    }

    private void openMultTabReportProcessPage() {
        TreeMultimap<Long, DynamicObject> sortMap;
        DynamicObject[] templates = this.getSelectTemplates();
        if (templates == null) {
            return;
        }
        StringBuilder notificationMessage = new StringBuilder();
        ArrayList<DynamicObject> finList = new ArrayList<DynamicObject>();
        List<Long> noPermIds = this.getNoPermList();
        for (DynamicObject dyo : templates) {
            if (dyo != null && "0".equals(dyo.getString("template.status"))) {
                notificationMessage.append(dyo.getString("template.number")).append("\u3001");
            } else {
                finList.add(dyo);
            }
            if (dyo == null) {
                return;
            }
            if (noPermIds == null || !noPermIds.contains(dyo.getLong("template.id"))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5de5\u4f5c\u5e95\u7a3f\u6a21\u677f\u5df2\u8bbe\u7f6e\u65e0\u6743\u4e0d\u80fd\u6253\u5f00\uff0c\u8bf7\u70b9\u51fb\u5237\u65b0\u3002", (String)"WorkPaperListPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), dyo.getString("template.number")));
        }
        if (null != notificationMessage && notificationMessage.length() > 0) {
            this.refreshBillList(this.getF7id(null));
            notificationMessage = notificationMessage.deleteCharAt(notificationMessage.lastIndexOf("\u3001"));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5de5\u4f5c\u5e95\u7a3f\u6a21\u677f\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u6253\u5f00\u9875\u9762\uff0c\u5982\u9700\u6253\u5f00\u8bf7\u5c06\u8be5\u6a21\u677f\u72b6\u6001\u6539\u4e3a\u542f\u7528\u3002", (String)"WorkPaperListPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), notificationMessage));
        }
        if ((sortMap = this.sortTemplates(finList)) != null) {
            sortMap.keySet().forEach(e -> this.handleOpenFinTemplate(sortMap.get(e)));
        }
    }

    private void handleOpenFinTemplate(Collection<DynamicObject> templates) {
        AbstractReportPostman postman = null;
        for (DynamicObject template : templates) {
            if (postman == null) {
                postman = ReportPostmanFactory.getReportPostman(true, template);
            }
            if (postman.isSortByEntity()) {
                postman.addPair(template.get("template.id"), template.get("report.id"));
                continue;
            }
            postman.addPair(template.get("entity.id"), template.get("report.id"));
        }
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        if (postman != null) {
            String menuPageID = this.getMenuPageId(postman);
            if (mainPageView == null || mainPageView.getView(menuPageID) == null) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setPageId(menuPageID);
                formShowParameter.setFormId("bcm_workpaper");
                String moduleName = ResManager.loadKDString((String)"\u5de5\u4f5c\u5e95\u7a3f", (String)"WorkPaperListPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                String caption = this.getOpenFormCaption(postman);
                formShowParameter.setCaption(moduleName + " : " + caption);
                formShowParameter.setCustomParam("reportpostman", (Object)ObjectSerialUtil.toByteSerialized((Object)postman));
                formShowParameter.setCustomParam("listPageID", (Object)this.getView().getPageId());
                formShowParameter.setCustomParam("schemeId", (Object)((DynamicObject)this.getModel().getValue(CTL_CSLSCHEME)).getLong("id"));
                formShowParameter.setCustomParam("schemeNum", (Object)((DynamicObject)this.getModel().getValue(CTL_CSLSCHEME)).getString(NUMBER));
                formShowParameter.setCustomParam("yearId", (Object)((DynamicObject)this.getModel().getValue(STR_YEAR)).getLong("id"));
                formShowParameter.setCustomParam("periodId", (Object)((DynamicObject)this.getModel().getValue(STR_PERIOD)).getLong("id"));
                formShowParameter.setCustomParam("yearNum", ((DynamicObject)this.getModel().getValue(STR_YEAR)).get(NUMBER));
                formShowParameter.setCustomParam("periodNum", ((DynamicObject)this.getModel().getValue(STR_PERIOD)).get(NUMBER));
                formShowParameter.setCustomParam("scenarioId", (Object)((DynamicObject)this.getModel().getValue(STR_SCENE)).getLong("id"));
                formShowParameter.setCustomParam(STR_MODEL, (Object)((DynamicObject)this.getModel().getValue(STR_MODEL)).getLong("id"));
                DynamicObject[] templateArray = templates.toArray(new DynamicObject[0]);
                formShowParameter.setCustomParam("entityNumber", (Object)templateArray[0].getString("entity.number"));
                formShowParameter.setCustomParam("entityName", (Object)templateArray[0].getString("entity.name"));
                formShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
                formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
                if (parentView == null) {
                    this.getView().showForm(formShowParameter);
                } else {
                    formShowParameter.setParentPageId(parentView.getPageId());
                    formShowParameter.setParentFormId(parentView.getEntityId());
                    parentView.showForm(formShowParameter);
                    this.getView().sendFormAction(parentView);
                }
            } else {
                IFormView childFormView = mainPageView.getView(menuPageID);
                childFormView.activate();
                FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childFormView.getService(FormViewPluginProxy.class);
                AbstractReportPostman pm = postman;
                pluginProxy.getPlugIns().forEach(e -> {
                    if (IIncreaseReportTab.class.isAssignableFrom(e.getClass())) {
                        ((IIncreaseReportTab)IIncreaseReportTab.class.cast(e)).increaseReportTab(pm);
                    }
                });
                this.getView().sendFormAction(childFormView);
            }
        }
    }

    private String getOpenFormCaption(AbstractReportPostman pm) {
        DynamicObject entity = QueryServiceHelper.queryOne((String)pm.getTabSort().getEntityNumber(), (String)"name,id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", pm.getSortViewPK())});
        DynamicObject year = (DynamicObject)this.getModel().getValue(STR_YEAR);
        DynamicObject period = (DynamicObject)this.getModel().getValue(STR_PERIOD);
        DynamicObject scenario = (DynamicObject)this.getModel().getValue(STR_SCENE);
        DynamicObjectCollection dys = new DynamicObjectCollection();
        dys.add((Object)entity);
        FilterOrgStructParam param = new FilterOrgStructParam(this.getModelId(), scenario.getLong("id"), year.getString(NUMBER), period.getLong("id"));
        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, (List)dys);
        return entity.getString("name");
    }

    private String getMenuPageId(AbstractReportPostman pm) {
        return this.getMenuPagePrefix() + (pm.isSortByEntity() ? pm.getEntityPK(null) : pm.getTemplatePK(null)) + this.getView().getPageId() + this.isolationByPageFilterInfo(pm);
    }

    private String isolationByPageFilterInfo(AbstractReportPostman pm) {
        String modelNum = ((DynamicObject)this.getModel().getValue(STR_MODEL)).getString(NUMBER);
        ArrayList otherDim = Lists.newArrayList((Object[])new String[]{MemberReader.findScenaMemberById((String)modelNum, (Long)((Long)pm.getScenarioPK())).getNumber(), MemberReader.findFyMemberById((String)modelNum, (Long)((Long)pm.getYearPK())).getNumber(), MemberReader.findPeriodMemberById((String)modelNum, (Long)((Long)pm.getPeriodPK())).getNumber(), MemberReader.findCurrencyMemberById((String)modelNum, (Long)((Long)pm.getCurrencyPK())).getNumber()});
        return Joiner.on((char)'-').join((Iterable)otherDim);
    }

    private String getMenuPagePrefix() {
        return PREFIX_ENT;
    }

    private TreeMultimap<Long, DynamicObject> sortTemplates(List<DynamicObject> templates) {
        if (templates.isEmpty()) {
            return null;
        }
        Comparator cp = (d1, d2) -> d1.getString("template.number").compareTo(d2.getString("template.number"));
        TreeMultimap multiMap = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)cp);
        templates.forEach(e -> {
            if (e.getString("template.number") != null) {
                multiMap.put((Object)e.getLong("entity.id"), e);
            }
        });
        if (multiMap.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002", (String)"WorkPaperListPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return null;
        }
        return multiMap;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection coll = billList.getSelectedRows();
        Object[] PKS = new Object[coll.size()];
        for (int i = 0; i < coll.size(); ++i) {
            ListSelectedRow row = coll.get(i);
            PKS[i] = row.getPrimaryKeyValue();
        }
        this.getPageCache().put("PKS", ObjectSerialUtil.toByteSerialized((Object)PKS));
        switch (itemKey = evt.getItemKey()) {
            case "btn_refresh": {
                this.refreshTree(null);
                this.refreshBillList(this.getF7id(null));
                break;
            }
            case "btn_batchexport": {
                this.showMultiBatchExportView(itemKey);
                break;
            }
            case "btn_number": 
            case "btn_name": 
            case "btn_simple": 
            case "btn_numname": 
            case "btn_numsimple": {
                DimensionMemberDisplayTypeEnum displayTypeEnum = DimensionMemberDisplayTypeEnum.getEnumByItemKey((String)itemKey);
                WorkPaperUtil.saveUserSelect(this.getModelId(), displayTypeEnum, ModelUtil.queryApp((IFormView)this.getView()));
                WorkPaperUtil.updateOrgDisplay(this.getView(), displayTypeEnum);
                this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.ORGDISPLAY.getMultiLangEnumBridge(), (String)"Org Display Format"), new OPDescMultiLangEnumBridge("%s\uff0c\u8bbe\u7f6e\u6210\u529f", "WorkPaperListPlugin_16", FI_BCM_FORMPLUGIN, new String[]{displayTypeEnum.getText()}));
                break;
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        Object[] PKS = evt.getListSelectedRowCollection().getPrimaryKeyValues();
        this.getPageCache().put("PKS", ObjectSerialUtil.toByteSerialized((Object)PKS));
    }

    public void showMultiBatchExportView(String key) {
        DynamicObject sceneDy = (DynamicObject)this.getModel().getValue(STR_SCENE);
        DynamicObject yearDy = (DynamicObject)this.getModel().getValue(STR_YEAR);
        DynamicObject periodDy = (DynamicObject)this.getModel().getValue(STR_PERIOD);
        DynamicObject cyDy = (DynamicObject)this.getModel().getValue(CURRENCY);
        DynamicObject cslSchemDy = (DynamicObject)this.getModel().getValue(CTL_CSLSCHEME);
        if (sceneDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f", (String)"WorkPaperListPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        FormShowParameter fm = new FormShowParameter();
        fm.setParentFormId(this.getView().getFormShowParameter().getFormId());
        if ("btn_batchprint".equals(key)) {
            fm.setFormId("bcm_reportlistmultiprint");
        } else {
            fm.setFormId("bcm_reportlistmultiexport");
        }
        fm.setCustomParam(MODEL_CACHE_KEY, (Object)this.getModelId());
        fm.setCustomParam(STR_SCENE, (Object)sceneDy.getLong("id"));
        fm.setCustomParam(STR_YEAR, (Object)(yearDy == null ? 0L : yearDy.getLong("id")));
        fm.setCustomParam(STR_PERIOD, (Object)(periodDy == null ? 0L : periodDy.getLong("id")));
        fm.setCustomParam(CURRENCY, (Object)(cyDy == null ? 0L : cyDy.getLong("id")));
        fm.setCustomParam(CTL_CSLSCHEME, (Object)(cslSchemDy == null ? 0L : cslSchemDy.getLong("id")));
        DynamicObject orgDy = this.getSelectedEntity();
        DynamicObject[] temps = this.getSelectTemplates();
        if (temps == null) {
            fm.setCustomParam("selecttemplate", (Object)new Long[]{0L});
        } else {
            Long[] longArray;
            Object[] pks = (Object[])ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("PKS"));
            DynamicObject[] sortTemps = new DynamicObject[temps.length];
            Map<Long, DynamicObject> dyMaps = Arrays.stream(temps).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            for (int i = 0; i < pks.length; ++i) {
                sortTemps[i] = dyMaps.get(pks[i]);
            }
            Long[] ids = DynamicObjectCollectionUtil.getFieldPKArray((DynamicObject[])sortTemps, (String)"template.id");
            if (ids == null || ids.length == 0) {
                Long[] longArray2 = new Long[1];
                longArray = longArray2;
                longArray2[0] = 0L;
            } else {
                longArray = ids;
            }
            fm.setCustomParam("selecttemplate", (Object)longArray);
        }
        if (orgDy != null && orgDy.getString(NUMBER).equals("Entity") || orgDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7ec4\u7ec7\u3002", (String)"WorkPaperListPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        Long[] ids = new Long[]{orgDy.getLong("id")};
        fm.setCustomParam("org", (Object)ids);
        fm.setStatus(OperationStatus.EDIT);
        fm.setCustomParam("KEY_MODEL_NUMBER", (Object)this.getModelNumber());
        fm.setCustomParam("isFromWorkPaper", (Object)"1");
        fm.setParentPageId(this.getView().getPageId());
        fm.setCaption(ResManager.loadKDString((String)"\u5de5\u4f5c\u5e95\u7a3f-\u6279\u91cf\u5bfc\u51fa", (String)"WorkPaperListPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        fm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(fm);
    }

    private String getModelNumber() {
        return MemberReader.findModelNumberById((Object)this.getModelId());
    }

    private DynamicObject getSelectedEntity() {
        String orgId = this.getPageCache().get(ENTITYSELECTED_NODE_ID);
        return BusinessDataServiceHelper.loadSingleFromCache((Object)(kd.bos.util.StringUtils.isNotEmpty((String)orgId) ? Long.parseLong(orgId) : 0L), (String)"bcm_entitymembertree");
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
        String selectedNodeId = (String)arg0.getNodeId();
        if (selectedNodeId.isEmpty()) {
            this.doRefreshBillList(new QFilter("1", "=", (Object)0));
            return;
        }
        if (this.checkOrgMemberIsNoPerm(selectedNodeId)) {
            this.doRefreshBillList(new QFilter("1", "=", (Object)0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u64cd\u4f5c\u5bf9\u5e94\u7684\u6210\u5458\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"WorkPaperListPlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        List<String> selectnodes = new ArrayList<String>();
        if (this.getPageCache().get(SELECTORGS) != null) {
            selectnodes = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(SELECTORGS));
        }
        selectnodes.remove(selectedNodeId);
        selectnodes.add(selectedNodeId);
        this.getPageCache().put(SELECTORGS, ObjectSerialUtil.toByteSerialized(selectnodes));
        this.getPageCache().put(ENTITYSELECTED_NODE_ID, selectedNodeId);
        UserSelectServiceHelper.setEntity((Long)this.getUserId(), (Long)this.getModelId(), (Object)selectedNodeId);
        this.refreshBillList(this.getF7id(null));
    }

    private void refreshBillList(HashMap<String, Long> f7IdMap) {
        if (f7IdMap != null) {
            this.doDeleteReportList();
            this.doPrepareReportList(f7IdMap);
            this.doRefreshBillList(new QFilter("groupid", "=", (Object)this.gainGroupId()));
        } else {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            billList.clearData();
        }
    }

    private void doDeleteReportList() {
        QFilter filterPageId = new QFilter("groupid", "=", (Object)this.gainGroupId());
        try (TXHandle tx = TX.required();){
            try {
                BusinessDataWriter.delete((String)"bcm_reportlistentity", (QFilter[])new QFilter[]{filterPageId});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void doPrepareReportList(HashMap<String, Long> f7IdMap) {
        Long modelId = f7IdMap.get(MODEL_F7ID);
        QFilter modelFilter = new QFilter(STR_MODEL, "=", (Object)modelId);
        HashSet templateIdSet = new HashSet();
        String selectedNodeId = this.getPageCache().get(ENTITYSELECTED_NODE_ID);
        if (selectedNodeId == null) {
            return;
        }
        Long orgid = Long.parseLong(selectedNodeId);
        ArrayList<DynamicObject> reportList = new ArrayList<DynamicObject>();
        DynamicObject currencyF7model = (DynamicObject)this.getModel().getValue(CURRENCY);
        boolean isEcCurrency = CurrencyEnum.EC.number.equals(currencyF7model.getString(NUMBER));
        ArrayList dimensionPairList = Lists.newArrayList((Object[])new Pair[]{Pair.onePair((Object)STR_SCENE, (Object)"bcm_scenemembertree"), Pair.onePair((Object)STR_YEAR, (Object)"bcm_fymembertree"), Pair.onePair((Object)STR_PERIOD, (Object)"bcm_periodmembertree")});
        if (!isEcCurrency) {
            dimensionPairList.add(Pair.onePair((Object)CURRENCY, (Object)"bcm_currencymembertree"));
        }
        QFilter qFilter = new QFilter("templatetype", "in", (Object)TemplateTypeEnum.getWPTypes());
        qFilter.and("status", "=", (Object)TemplateModel.TplStatus.ENABLE.getStatuValue());
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{modelFilter, qFilter});
        col.forEach(e -> templateIdSet.add(e.getLong("id")));
        List templateModelList = ReportRedisCache.queryTemplateModelFromCache(templateIdSet, (long)this.getModelId(), (boolean)false);
        boolean isNewModel = QueryDimensionServiceHelper.checkInfoInModel((String)NUMBER, (String)NUMBER, (String)"CurrentYear", (String)"bcm_fymembertree", (String)String.valueOf(this.getModelId()));
        for (TemplateModel templateModel : templateModelList) {
            long templateId = templateModel.getId();
            boolean flag = this.handleTemplateViewPageDim(dimensionPairList, templateModel, isNewModel);
            if (flag) continue;
            HashMap<String, Boolean> iscurrencyinner = new HashMap<String, Boolean>(16);
            boolean istrue = true;
            if (isEcCurrency) {
                istrue = this.doByCurrency(f7IdMap, orgid, templateModel, iscurrencyinner);
            }
            if (!istrue) continue;
            this.getReportList(f7IdMap, orgid, templateId, reportList, isEcCurrency);
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_reportlistentity");
        if (!reportList.isEmpty()) {
            int orm_maxobjects;
            int fetchSize = orm_maxobjects = 100000;
            for (int pos = 0; pos <= reportList.size() && fetchSize > 0; pos += fetchSize) {
                fetchSize = orm_maxobjects;
                if (fetchSize > reportList.size() - pos) {
                    fetchSize = reportList.size() - pos;
                }
                if (fetchSize <= 0) continue;
                BusinessDataWriter.save((IDataEntityType)dynamicObject.getDynamicObjectType(), (Object[])reportList.subList(pos, pos + fetchSize).toArray(new DynamicObject[0]));
            }
        }
    }

    private void doRefreshBillList(QFilter filter) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.clearSelection();
        this.getPageCache().put("PKS", null);
        billList.setFilter(filter);
        billList.setOrderBy("entity.longnumber,template.number,template.templatecatalog.longnumber, template.createtime");
        billList.refresh();
    }

    private void refreshTree(Long modelid) {
        DynamicObject modelDynamicObject;
        if (modelid == null && (modelDynamicObject = (DynamicObject)this.getModel().getValue(STR_MODEL)) != null) {
            modelid = modelDynamicObject.getLong("id");
        }
        if (modelid != null && this.getModel().getValue(CTL_CSLSCHEME) != null) {
            String showType = this.getPageCache().get(SHOWORGTYPE_CACHE);
            OrgTreeNode root = this.initOrgTree(modelid, showType, false, true);
            if (root == null || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)root.getChildren())) {
                TreeView tree = (TreeView)this.getControl(TREEVIEW_ENTITY);
                tree.deleteAllNodes();
                this.getPageCache().remove(ENTITYSELECTED_NODE_ID);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u3002", (String)"WorkPaperListPlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            } else {
                TreeBuilder.setOpen((ITreeNode)((ITreeNode)root.getChildren().get(0)));
                this.initTree((AbstractTreeNode<Object>)root);
            }
        } else {
            TreeView tree = (TreeView)this.getControl(TREEVIEW_ENTITY);
            tree.deleteAllNodes();
            this.getPageCache().remove(ENTITYSELECTED_NODE_ID);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject newValue;
        super.propertyChanged(e);
        HashMap<String, Long> dimensionMap = new HashMap<String, Long>();
        ArrayList otherDim = Lists.newArrayList((Object[])new String[]{STR_MODEL, STR_SCENE, STR_YEAR, STR_PERIOD, CURRENCY});
        String propertyName = e.getProperty().getName();
        if (STR_MODEL.equals(propertyName)) {
            this.getPageCache().remove(SELECTORGS);
            this.getPageCache().remove(ENTITYSELECTED_NODE_ID);
            newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            this.propertyChangedModelUse(new ArrayList<String>(dimKeys));
            DimensionMemberDisplayTypeEnum displayTypeEnum = DimensionMemberDisplayTypeEnum.NUMBERANDNAME;
            if (newValue != null) {
                if (!this.isEPM()) {
                    CslSchemeUtils.setDefaultCslSchemeValue(newValue.getString("id"), true, this.getView());
                    this.getView().updateView(CTL_CSLSCHEME);
                }
                TreeView tree = (TreeView)this.getControl(TREEVIEW_ENTITY);
                tree.deleteAllNodes();
                this.refreshTree(newValue.getLong("id"));
                dimensionMap = this.getF7id(null);
                displayTypeEnum = WorkPaperUtil.getOrgDisplayFromUserSelect(ModelUtil.queryApp((IFormView)this.getView()), newValue.getLong("id"));
            } else {
                dimensionMap = null;
            }
            WorkPaperUtil.updateOrgDisplay(this.getView(), displayTypeEnum);
        } else if (dimKeys.contains(propertyName)) {
            newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            Boolean isSureReturn = this.propertyChangedDimUse(propertyName, newValue, false, true);
            if (!isSureReturn.booleanValue()) {
                return;
            }
            if (newValue == null) {
                dimensionMap = null;
            } else {
                otherDim.remove(otherDim.indexOf(propertyName));
                dimensionMap = this.doPrepareDimensionAndMemberId(propertyName, newValue, otherDim);
            }
            if ((STR_YEAR.equals(propertyName) || STR_PERIOD.equals(propertyName)) && this.getModel().getValue(STR_MODEL) != null && this.getModel().getValue(STR_YEAR) != null && this.getModel().getValue(STR_PERIOD) != null) {
                this.refreshTree(null);
                this.refreshBillList(dimensionMap);
            }
        } else if (CTL_CSLSCHEME.equals(propertyName)) {
            newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            this.saveUserChangedCslscheme(newValue);
            this.getPageCache().remove(SELECTORGS);
            this.getPageCache().remove(ENTITYSELECTED_NODE_ID);
            UserSelectServiceHelper.setEntity((Long)this.getUserId(), (Long)this.getModelId(), null);
            this.refreshTree(null);
            if (newValue != null) {
                dimensionMap = this.getF7id(null);
            }
        }
        if (dimensionMap != null && !dimensionMap.isEmpty()) {
            this.refreshBillList(dimensionMap);
        } else if (SHOWORGTYPE_CACHE.equals(propertyName)) {
            String showType = (String)this.getModel().getValue(SHOWORGTYPE_CACHE);
            this.getPageCache().put(SHOWORGTYPE_CACHE, showType);
            this.refreshTree(null);
        } else {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            billList.clearData();
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
            String key = ((ColumnDesc)e.getSource()).getKey();
            Map orgNode = ((TreeView)this.getControl(TREEVIEW_ENTITY)).getTreeState().getFocusNode();
            if ("entity.name".equals(key) && orgNode != null) {
                e.setFormatValue(orgNode.get("text"));
            }
        }
    }

    private HashMap<String, Long> doPrepareDimensionAndMemberId(String dataChangeDim, DynamicObject newValue, List<String> otherDim) {
        HashMap<String, Long> dimensionMap = new HashMap<String, Long>();
        dimensionMap.put(dataChangeDim + "f7id", newValue.getLong("id"));
        if (STR_YEAR.equals(dataChangeDim)) {
            dimensionMap.put("bcm_fymembertree", newValue.getLong("dimension.id"));
        } else {
            dimensionMap.put("bcm_" + dataChangeDim + "membertree", newValue.getLong("dimension.id"));
        }
        for (String key : otherDim) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(key);
            if (dynamicObject == null) {
                return null;
            }
            dimensionMap.put(key + "f7id", dynamicObject.getLong("id"));
            if (STR_YEAR.equals(key)) {
                dimensionMap.put("bcm_fymembertree", dynamicObject.getLong("dimension.id"));
                continue;
            }
            if (STR_MODEL.equals(key)) continue;
            dimensionMap.put("bcm_" + key + "membertree", dynamicObject.getLong("dimension.id"));
        }
        return dimensionMap;
    }

    private void initTree(AbstractTreeNode<Object> root) {
        TreeView tree = (TreeView)this.getControl(TREEVIEW_ENTITY);
        if (!this.isEPM()) {
            tree.setRootVisible(false);
        }
        if (root != null) {
            TreeModel treemodel = new TreeModel(root);
            treemodel.buildEntryTree(tree);
            if (CollectionUtils.isEmpty((Collection)root.getChildren())) {
                return;
            }
            TreeNode selectnode = this.findCacheNode(root, (TreeModel<AbstractTreeNode<Object>>)treemodel);
            tree.focusNode(selectnode);
            this.getPageCache().put(ENTITYSELECTED_NODE_ID, selectnode.getId());
            this.expandAllSelected((TreeModel<AbstractTreeNode<Object>>)treemodel, tree);
            treemodel.ache2page(this.getPageCache(), CACHE_TREEORG);
        }
    }

    private TreeNode findCacheNode(AbstractTreeNode<Object> root, TreeModel<AbstractTreeNode<Object>> treemodel) {
        String selectnode = null;
        selectnode = GuidePageUtils.getUserSelectOrg(this.getView(), this.getUserId(), this.getModelId(), false, false);
        if (this.getPageCache().get(SELECTORGS) != null) {
            List selects = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(SELECTORGS));
            selectnode = (String)selects.get(selects.size() - 1);
        } else {
            ArrayList<String> selectnodes = new ArrayList<String>();
            selectnodes.add(selectnode);
            this.getPageCache().put(SELECTORGS, ObjectSerialUtil.toByteSerialized(selectnodes));
        }
        if (selectnode == null || selectnode.equals(root.getId())) {
            if (!this.isEPM()) {
                return new TreeNode("0", ((ITreeNode)root.getChildren().get(0)).getId(), ((ITreeNode)root.getChildren().get(0)).getName());
            }
            return new TreeNode("0", root.getId(), root.getName());
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(root);
        while (!queue.isEmpty()) {
            ITreeNode node = (ITreeNode)queue.poll();
            if (node.getId().equals(selectnode)) {
                return new TreeNode(node.getParent().getId(), node.getId(), node.getName());
            }
            List children = node.getChildren();
            if (children.size() == 0) continue;
            for (ITreeNode child : children) {
                queue.add(child);
            }
        }
        if (!this.isEPM()) {
            return new TreeNode("0", ((ITreeNode)root.getChildren().get(0)).getId(), ((ITreeNode)root.getChildren().get(0)).getName());
        }
        return new TreeNode("0", root.getId(), root.getName());
    }

    private void expandAllSelected(TreeModel<AbstractTreeNode<Object>> treemodel, TreeView treeView) {
        if (this.getPageCache().get(SELECTORGS) != null) {
            List selects = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(SELECTORGS));
            OrgTreeNode root = (OrgTreeNode)treemodel.getRoot();
            for (String nodeid : selects) {
                OrgTreeNode node = (OrgTreeNode)treemodel.searchByNodeId(nodeid);
                if (node == null || node.getId().equals(root.getId())) continue;
                String parentid = node.getParent().getId();
                while (!parentid.equals(root.getId())) {
                    treeView.expand(parentid);
                    node = (OrgTreeNode)node.getParent();
                    parentid = node.getParent().getId();
                }
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (SEARCH_BEFORE.equals(key) || SEARCH_NEXT.equals(key)) {
            TreeView treeView = (TreeView)this.getControl(TREEVIEW_ENTITY);
            TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)CACHE_TREEORG);
            String rowcache = this.getPageCache().get(ROWLLIST);
            int rowCount = 0;
            String count = this.getPageCache().get(LFOCUS);
            if (count != null) {
                rowCount = Integer.parseInt(count);
            }
            if (rowcache == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"WorkPaperListPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            List rowList = (List)SerializationUtils.fromJsonString((String)rowcache, List.class);
            if (SEARCH_BEFORE.equals(key)) {
                if (0 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"WorkPaperListPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                --rowCount;
            } else if (SEARCH_NEXT.equals(key)) {
                if (rowList.size() - 1 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"WorkPaperListPlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                ++rowCount;
            }
            String focusnode = String.valueOf(rowList.get(rowCount));
            this.getPageCache().put(LFOCUS, String.valueOf(rowCount));
            ITreeNode parent = treeModel.searchByNodeId(focusnode).getParent();
            String parentId = parent == null ? null : parent.getId();
            treeView.focusNode(new TreeNode(parentId, focusnode, ""));
            treeView.treeNodeClick(parentId, focusnode);
            while (parentId != null) {
                String temp = parentId;
                treeView.expand(temp);
                if (treeModel.searchByNodeId(temp).getParent() == null) break;
                parentId = treeModel.searchByNodeId(temp).getParent().getId();
            }
        }
    }

    private HashMap<String, Long> getF7id(HashMap<String, Long> f7IdMap) {
        if (f7IdMap != null) {
            return f7IdMap;
        }
        DynamicObject modelDynamicObject = (DynamicObject)this.getModel().getValue(STR_MODEL);
        DynamicObject scenarioDynamicObject = (DynamicObject)this.getModel().getValue(STR_SCENE);
        DynamicObject fyearDynamicObject = (DynamicObject)this.getModel().getValue(STR_YEAR);
        DynamicObject periodDynamicObject = (DynamicObject)this.getModel().getValue(STR_PERIOD);
        DynamicObject currencyDynamicObject = (DynamicObject)this.getModel().getValue(CURRENCY);
        if (modelDynamicObject == null || scenarioDynamicObject == null || fyearDynamicObject == null || periodDynamicObject == null || currencyDynamicObject == null) {
            return null;
        }
        HashMap<String, Long> map = new HashMap<String, Long>(9);
        map.put(MODEL_F7ID, modelDynamicObject.getLong("id"));
        map.put(SCENE_F7ID, scenarioDynamicObject.getLong("id"));
        map.put("bcm_scenemembertree", scenarioDynamicObject.getLong("dimension.id"));
        map.put(YEAR_F7ID, fyearDynamicObject.getLong("id"));
        map.put("bcm_fymembertree", fyearDynamicObject.getLong("dimension.id"));
        map.put(PERIOD_F7ID, periodDynamicObject.getLong("id"));
        map.put("bcm_periodmembertree", periodDynamicObject.getLong("dimension.id"));
        map.put(CURRENCY_F7ID, currencyDynamicObject.getLong("id"));
        map.put("bcm_currencymembertree", currencyDynamicObject.getLong("dimension.id"));
        return map;
    }

    private void searchMember(String text, boolean isentity) {
        ArrayList<String> list = new ArrayList<String>(10);
        TreeView treeView = (TreeView)this.getControl(TREEVIEW_ENTITY);
        TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)CACHE_TREEORG);
        if (null == treeModel) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"WorkPaperListPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        ITreeNode root = treeModel.getRoot();
        List lists = treeModel.seekAllChildrenIf(root.getId(), p -> p.getName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH)));
        for (AbstractTreeNode node : lists) {
            list.add(node.getId());
        }
        if (list.size() > 0) {
            this.getPageCache().put(ROWLLIST, SerializationUtils.toJsonString(list));
            this.getPageCache().put(LFOCUS, "0");
            String focusnode = (String)list.get(0);
            ITreeNode parent = ((AbstractTreeNode)treeModel.searchByNodeId(focusnode)).getParent();
            String parentId = parent == null ? null : parent.getId();
            treeView.focusNode(new TreeNode(parentId, focusnode, ""));
            treeView.treeNodeClick(parentId, focusnode);
            while (parentId != null) {
                String temp = parentId;
                treeView.expand(temp);
                if (((AbstractTreeNode)treeModel.searchByNodeId(temp)).getParent() != null) {
                    parentId = ((AbstractTreeNode)treeModel.searchByNodeId(temp)).getParent().getId();
                    continue;
                }
                break;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"WorkPaperListPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private boolean handleTemplateViewPageDim(List<Pair<String, String>> dimensionPairList, TemplateModel templateModel, boolean isNewModel) {
        for (int i = 0; i < dimensionPairList.size(); ++i) {
            String f7Key = (String)dimensionPairList.get((int)i).p1;
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(f7Key);
            boolean isInnerRange = true;
            if (isNewModel && f7Key.equals(STR_YEAR)) {
                boolean isCurrentOrLastYear;
                boolean bl = isCurrentOrLastYear = TemplateRangeService.isInnerRange((String)((String)dimensionPairList.get((int)i).p2), (TemplateModel)templateModel, (Object)this.getIdByNumber((String)dimensionPairList.get((int)i).p2, "CurrentYear", templateModel.getModelId())) || TemplateRangeService.isInnerRange((String)((String)dimensionPairList.get((int)i).p2), (TemplateModel)templateModel, (Object)this.getIdByNumber((String)dimensionPairList.get((int)i).p2, "LastYear", templateModel.getModelId()));
                if (!isCurrentOrLastYear) {
                    isInnerRange = TemplateRangeService.isInnerRange((String)((String)dimensionPairList.get((int)i).p2), (TemplateModel)templateModel, (Object)dynamicObject.getLong("id"));
                }
            } else if (isNewModel && f7Key.equals(STR_PERIOD)) {
                boolean isCurrentOrLastPeriod;
                boolean bl = isCurrentOrLastPeriod = TemplateRangeService.isInnerRange((String)((String)dimensionPairList.get((int)i).p2), (TemplateModel)templateModel, (Object)this.getIdByNumber((String)dimensionPairList.get((int)i).p2, "CurrentPeriod", templateModel.getModelId())) || TemplateRangeService.isInnerRange((String)((String)dimensionPairList.get((int)i).p2), (TemplateModel)templateModel, (Object)this.getIdByNumber((String)dimensionPairList.get((int)i).p2, "LastPeriod", templateModel.getModelId()));
                if (!isCurrentOrLastPeriod) {
                    isInnerRange = TemplateRangeService.isInnerRange((String)((String)dimensionPairList.get((int)i).p2), (TemplateModel)templateModel, (Object)dynamicObject.getLong("id"));
                }
            } else {
                isInnerRange = TemplateRangeService.isInnerRange((String)((String)dimensionPairList.get((int)i).p2), (TemplateModel)templateModel, (Object)dynamicObject.getLong("id"));
            }
            if (isInnerRange) continue;
            return true;
        }
        return false;
    }

    private Object getIdByNumber(String entity, String number, Long modelId) {
        DynamicObject at = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)"id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)number), new QFilter(STR_MODEL, "=", (Object)modelId)});
        return at.getLong("id");
    }

    private void getReportList(HashMap<String, Long> F7idMap, Long entityId, Long templateid, List<DynamicObject> reportList, boolean isEcCurrency) {
        Boolean hasReport = false;
        DynamicObject reportListObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_reportlistentity");
        reportListObject.set("id", (Object)DBServiceHelper.genGlobalLongId());
        reportListObject.set("groupid", (Object)this.gainGroupId());
        reportListObject.set("template", (Object)templateid);
        F7idMap = this.getF7id(F7idMap);
        if (F7idMap != null) {
            reportListObject.set(STR_MODEL, (Object)F7idMap.get(MODEL_F7ID));
            reportListObject.set("scene", (Object)F7idMap.get(SCENE_F7ID));
            reportListObject.set("fyear", (Object)F7idMap.get(YEAR_F7ID));
            reportListObject.set(STR_PERIOD, (Object)F7idMap.get(PERIOD_F7ID));
            reportListObject.set(CURRENCY, (Object)F7idMap.get(CURRENCY_F7ID));
        }
        if (!hasReport.booleanValue()) {
            reportListObject.set("report", null);
            reportListObject.set("entity", (Object)entityId);
            reportListObject.set("reportstatus", (Object)ReportStatusEnum.UNWEAVE.status());
        }
        reportListObject.set("createtime", (Object)new Date());
        reportListObject.set("creator", (Object)this.getUserId());
        reportList.add(reportListObject);
    }

    private Boolean doByCurrency(HashMap<String, Long> F7idMap, Long entityId, TemplateModel templatemodel, Map<String, Boolean> iscurrencyinner) {
        DynamicObject currencyDynaObj = this.currencyDynaObjmap.get(entityId);
        if (currencyDynaObj == null) {
            DynamicObject orgDyn = OrgCurrencyServiceHelper.getOrgModelAndCurrency((Long)entityId, (Long)F7idMap.get(YEAR_F7ID), (Long)F7idMap.get(PERIOD_F7ID));
            QFilter filter3 = new QFilter(NUMBER, "=", (Object)orgDyn.getString("currency.number"));
            QFilter filter4 = new QFilter(STR_MODEL, "=", (Object)F7idMap.get(MODEL_F7ID));
            Map currencyDynaObj_temp = BusinessDataServiceHelper.loadFromCache((String)"bcm_currencymembertree", (String)"id,number", (QFilter[])new QFilter[]{filter3, filter4});
            for (Map.Entry entry : currencyDynaObj_temp.entrySet()) {
                currencyDynaObj = (DynamicObject)entry.getValue();
            }
            this.currencyDynaObjmap.put(entityId, currencyDynaObj);
        }
        if (currencyDynaObj == null) {
            return false;
        }
        String currencyNum = currencyDynaObj.getString(NUMBER);
        Boolean isCurrencyInTemplateInnerRange = iscurrencyinner.get(currencyNum);
        if (isCurrencyInTemplateInnerRange == null) {
            isCurrencyInTemplateInnerRange = TemplateRangeService.isInnerRange((String)"bcm_currencymembertree", (TemplateModel)templatemodel, (Object)currencyDynaObj.getLong("id"));
            iscurrencyinner.put(currencyNum, isCurrencyInTemplateInnerRange);
        }
        return isCurrencyInTemplateInnerRange;
    }

    private DynamicObject[] getSelectTemplates() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        Object[] PKS = billList.getSelectedRows().getPrimaryKeyValues();
        QFilter filter = new QFilter("id", "in", (Object)PKS);
        return (DynamicObject[])QueryServiceHelper.query((String)billList.getEntityType().getName(), (String)this.getSelector(), (QFilter[])new QFilter[]{filter}).toArray((Object[])new DynamicObject[0]);
    }

    private String getSelector() {
        return "id,template.id,template.number,template.name,report.id,report.template.number,model.number,model.id,reportstatus,entity.id,entity.name,entity.number,template.isfintemplate,scene.id,fyear.id,period.id,currency.id,template.templatecatalog.number,template.status";
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        args.setCustomQFilters(this.getFilters());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        args.setCustomQFilters(this.getFilters());
    }

    private List<QFilter> getFilters() {
        ArrayList<QFilter> result = new ArrayList<QFilter>();
        QFilter filter = new QFilter(STR_MODEL, "=", (Object)this.getModelId());
        filter.and("isleaf", "=", (Object)true);
        filter.and("catalogtype", "!=", (Object)Character.valueOf(TemplateCatalogTypeEnum.TEMPLATECATALOG.getType()));
        QFilter fhide = new QFilter(NUMBER, "not in", (Object)Lists.newArrayList((Object[])new String[]{TemplateCatalogEnum.ADJUST_WP.getNumber(), TemplateCatalogEnum.RULE_WP.getNumber()}));
        result.add(filter);
        result.add(fhide);
        return result;
    }

    public void setFilter(SetFilterEvent e) {
        QFilter filter;
        super.setFilter(e);
        QFilter qFilter = new QFilter("groupid", "=", (Object)this.gainGroupId());
        qFilter.and("template.status", "=", (Object)"1");
        e.getQFilters().add(qFilter);
        e.setOrderBy("entity.longnumber,template.sequence,template.number, template.templatecatalog.longnumber, template.createtime");
        if (!MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId())) && (filter = this.getPermClassFilter()) != null) {
            e.getQFilters().add(filter);
        }
    }

    private QFilter getPermClassFilter() {
        QFilter qFilter = null;
        ArrayListMultimap map = PermClassEntityHelper.getPermissionMap((String)"bcm_templateentity", (String)String.valueOf(this.getModelId()), (String)String.valueOf(this.getUserId()));
        List noPermIds = map.get((Object)"1");
        if (!CollectionUtils.isEmpty((Collection)noPermIds)) {
            qFilter = new QFilter("template", "not in", (Object)noPermIds);
        }
        return qFilter;
    }
}

