/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.workingpaper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.enums.workpaper.DimensionMemberDisplayTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.analytics.AnalyticsSolutionHelper;
import kd.fi.bcm.formplugin.analytics.MDQADataQueryHelper;
import kd.fi.bcm.formplugin.analytics.MDQueryAnalysisStyleHandle;
import kd.fi.bcm.formplugin.analytics.service.MultiDimQAStyleService;
import kd.fi.bcm.formplugin.datatrace.DataTraceHelper;
import kd.fi.bcm.formplugin.report.AbstractMultiReportPlugin;
import kd.fi.bcm.formplugin.report.floatreport.FloatLogicImpl;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.formplugin.report.multi.ReportModelTypeEnum;
import kd.fi.bcm.formplugin.report.multi.ReportTabInfo;
import kd.fi.bcm.formplugin.report.multi.ReportTabModel;
import kd.fi.bcm.formplugin.report.postman.AbstractReportPostman;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.multiview.validators.TemplateVerification;
import kd.fi.bcm.formplugin.util.CellDataTypeUtil;
import kd.fi.bcm.formplugin.util.WorkPaperUtil;
import kd.fi.bcm.formplugin.workingpaper.WorkPaperUpdataService;
import kd.fi.bcm.formplugin.workingpaper.model.Column;
import kd.fi.bcm.formplugin.workingpaper.util.WorkPaperQueryHelper;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.common.variant.Variant;
import kd.fi.bcm.spread.datacollect.FormulaCheckModel;
import kd.fi.bcm.spread.datacollect.ReportCalculateHelper;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Header;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.SpreadSelector;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.event.NotifyEvent;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.StatusBarModel;
import kd.fi.bcm.spread.util.ReportSourceUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class WorkPaperQueryAnalysisPlugin
extends AbstractMultiReportPlugin {
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String COLUMN_LIST = "column_list";
    private static final String CACHE_SHOWTYPE = "cache_showtype";
    private static final String CACHE_HIDECOL = "hidecol";
    private static final String CACHE_HIDEROW = "hiderow";
    private static final String CACHE_PLUSCELL = "pluscell";
    private static final Set<DataTypeEnum> unitDataTypeEnums = Sets.newHashSet((Object[])new DataTypeEnum[]{DataTypeEnum.DEFAULT, DataTypeEnum.CURRENCY});
    private boolean isModified;

    @Override
    protected void reportTabSelected(TabSelectEvent evt) {
        super.reportTabSelected(evt);
        this.calculateFormulas();
        this.refreshClientRptValue();
        this.restoreNoDataRowCol();
        this.hideNoDataRowCol();
        WorkPaperUtil.updateOrgDisplay(this.getView(), this.getOrgDisPlay());
    }

    @Override
    protected void calculateNewrptinfoFormulas() {
        this.calculateFormulas();
    }

    @Override
    protected void refreshClientRptValue() {
        this.changeDataUnitDisplay();
    }

    @Override
    protected void afterLoadReport4WorkPaper() {
        super.afterLoadReport4WorkPaper();
        this.cacheSpreadModel();
        this.getView().setVisible(Boolean.valueOf(this.isVisible("isShowMore", false)), new String[]{"show_less"});
        this.getView().setVisible(Boolean.valueOf(!this.isVisible("isShowMore", false)), new String[]{"show_more"});
        this.getView().setVisible(Boolean.valueOf(this.isVisible("isShowMore", false)), new String[]{"morefieldsetpanel"});
    }

    @Override
    protected void initReportTabInfoByPostman(AbstractReportPostman postman) {
        super.initReportTabInfoByPostman(postman);
        for (ReportTabInfo repTab : this.getReportTabInfoManager().getTabs()) {
            TemplateModel template = ModelDataProvider.getTemplateModel(repTab.getTemplateId());
            if (!template.isOldTemplate()) continue;
            WorkPaperUpdataService.updateWorkPaperTemplate(template);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        boolean isEffect;
        ThreadCache.put((Object)"needCheckPerm", (Object)true);
        DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getTemplateId(), (String)"bcm_templateentity");
        if (template == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5df2\u5220\u9664\u3002", (String)"WorkPaperQueryAnalysisPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (template.getInt("status") == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5df2\u7981\u7528\u3002", (String)"WorkPaperQueryAnalysisPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (e.getChangeSet()[0].getNewValue() == null) {
            DynamicObject member = (DynamicObject)e.getChangeSet()[0].getOldValue();
            this.getModel().getDataEntity().set(e.getProperty().getName(), (Object)member);
            this.changeSceneAndPeriod(member, e.getProperty().getName());
            return;
        }
        String propertyName = e.getProperty().getName();
        if (("bcm_periodmembertree".equals(propertyName) || "bcm_fymembertree".equals(propertyName)) && !(isEffect = this.checkEffivePeriod())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5728\u6240\u9009\u8d22\u5e74\u671f\u95f4\u672a\u751f\u6548\u3002", (String)"WorkPaperQueryAnalysisPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            DynamicObject member = (DynamicObject)e.getChangeSet()[0].getOldValue();
            this.getModel().beginInit();
            this.getModel().setDataChanged(false);
            this.getModel().getDataEntity().set(e.getProperty().getName(), (Object)member);
            this.getView().updateView(propertyName);
            this.getModel().endInit();
            return;
        }
        super.propertyChanged(e);
        this.deleteHideCache();
        this.loadReport();
        this.forcePushCache();
    }

    private void calculateFormulas() {
        String cacheKey = this.getCacheKey("calculateFormulas");
        if (ThreadCache.exists((Object)cacheKey)) {
            return;
        }
        ThreadCache.put((Object)cacheKey, (Object)true);
        Map<DimTypesEnum, Object> numbers = this.getCurrentReportCommonParam("number");
        String cur = numbers.get(DimTypesEnum.CURRENCY).toString();
        cur = this.getConcreteCY(cur);
        String orgnum = numbers.get(DimTypesEnum.ENTITY).toString();
        CalContext ctx = new CalContext(this.getModelNumber(), orgnum, numbers.get(DimTypesEnum.YEAR).toString(), numbers.get(DimTypesEnum.PERIOD).toString(), numbers.get(DimTypesEnum.SCENARIO).toString(), cur);
        FormulaCheckModel formulaCheckModel = new FormulaCheckModel();
        List cellAxis = ReportCalculateHelper.calculateSheet((Sheet)this.getEffectiveSheet(), (ICalContext)ctx, cell -> {
            if (cell.hasFormula() && (formulaCheckModel.isOnlyExcel(cell.getFormula()) || cell.getFormula().toLowerCase(Locale.ENGLISH).startsWith("newrptinfo"))) {
                return true;
            }
            return false;
        }, error -> {});
        if (!cellAxis.isEmpty()) {
            SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), "report");
            invoker.setBatch(true);
            cellAxis.forEach(axis -> {
                Point p = ExcelUtils.pos2Point((String)axis);
                Cell c = this.getEffectiveSheet().getCell(p.y, p.x);
                Object v = c.getValue();
                if (v instanceof Exception) {
                    c.setValue(null);
                } else if (c.getValue() != null) {
                    c.setChangeVal(false);
                    invoker.updataValue(c.getRow(), c.getCol(), c.getValue());
                }
            });
            invoker.startToInvoke();
        }
    }

    private void deleteHideCache() {
        this.getPageCache().remove(this.getCacheKey(CACHE_HIDECOL));
        this.getPageCache().remove(this.getCacheKey(CACHE_HIDEROW));
        this.getPageCache().remove(this.getCacheKey(CACHE_PLUSCELL));
        this.getPageCache().remove(this.getCacheKey("getAreaRangeModel"));
        this.getPageCache().remove(this.getCacheKey("getFormulaColIndexs"));
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "btn_refresh": {
                this.refreshReport();
                ThreadCache.put((Object)"needCheckPerm", (Object)true);
                this.updateClientSpreadValues();
                break;
            }
            case "btn_datatrace": {
                this.linkData();
                break;
            }
            case "btn_name": 
            case "btn_number": 
            case "btn_simple": 
            case "btn_numname": 
            case "btn_numsimple": {
                this.changeDimMemberDisplay(true, itemKey);
                break;
            }
            case "btn_clear": {
                this.hideNoDataRowCol();
                String opNameDes = OpItemEnum.CLEAR.getName() + OpItemEnum.NODATAROW.getName();
                this.writeClearRestoreLog(new OpNameMultiLangEnumBridge("\u9690\u85cf\u65e0\u6570\u636e\u884c\u5217\u3002", "WorkPaperQueryAnalysisPlugin_10", FI_BCM_FORMPLUGIN, "hide nodatarow"), opNameDes);
                break;
            }
            case "btn_restore": {
                this.restoreNoDataRowCol();
                this.writeClearRestoreLog(new OpNameMultiLangEnumBridge("\u8fd8\u539f\u65e0\u6570\u636e\u884c\u5217\u3002", "WorkPaperQueryAnalysisPlugin_11", FI_BCM_FORMPLUGIN, "restore nodatarow"), OpItemEnum.RESTORE.getName() + OpItemEnum.NODATAROW.getName());
                break;
            }
            case "btn_close": {
                this.getView().close();
                break;
            }
            case "btn_row_name": 
            case "btn_row_number": 
            case "btn_row_numname": {
                this.changeDimMemberDisplay(false, itemKey);
                break;
            }
            case "btn_unit0": 
            case "btn_unit3": 
            case "btn_unit4": 
            case "btn_unit6": 
            case "btn_unit7": 
            case "btn_unit8": {
                this.invokeUnitChangeClickEvent(itemKey);
                break;
            }
            case "query_export": {
                this.invokeExportEvent(this.getBizEntityNumber());
                break;
            }
        }
    }

    private void changeDimMemberDisplay(boolean isOrg, String itemKey) {
        DimensionMemberDisplayTypeEnum displayTypeEnum = DimensionMemberDisplayTypeEnum.getEnumByItemKey((String)itemKey);
        WorkPaperQueryHelper workPaperQueryHelper = new WorkPaperQueryHelper(this, "report", this.getTemplateModel(), this.getSpreadModel());
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), "report");
        invoker.setBatch(true);
        if (isOrg) {
            workPaperQueryHelper.setOrgDisplayType(displayTypeEnum);
            WorkPaperUtil.updateOrgDisplay(this.getView(), displayTypeEnum);
        } else {
            workPaperQueryHelper.setRowColDimensionDisplayType(displayTypeEnum);
        }
        this.cacheShowType(isOrg, displayTypeEnum);
        workPaperQueryHelper.dealDisplayType(displayTypeEnum, isOrg, invoker);
        invoker.startToInvoke();
        this.writeDisplayOpLog(isOrg ? OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.ORGDISPLAY.getMultiLangEnumBridge(), (String)"orgdisplay") : OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.DISPALYSTYLE.getMultiLangEnumBridge(), (String)"dispalystyle"), this.getOpItemEnum(itemKey).getName());
    }

    private void cacheShowType(boolean isOrg, DimensionMemberDisplayTypeEnum displayTypeEnum) {
        this.getPageCache().put(this.getCacheDisplayKey(isOrg), displayTypeEnum.getIndex() + "");
    }

    private String getCacheDisplayKey(boolean isOrg) {
        String tabid = this.getPageCache().get("tabkey_selected");
        String cacheKey = isOrg ? "orgdisplayforwp_" + tabid : CACHE_SHOWTYPE + tabid;
        return cacheKey;
    }

    @Override
    public long getModelId() {
        this.modelId = this.getFormCustomParam("model", 0L);
        return this.modelId;
    }

    @Override
    protected ReportModelTypeEnum getLoadReportModelType() {
        return ReportModelTypeEnum.TEMPLATE;
    }

    private DimensionMemberDisplayTypeEnum getDimMemberDisplayTypeEnum(boolean isOrg) {
        String s = this.getPageCache().get(this.getCacheDisplayKey(isOrg));
        DimensionMemberDisplayTypeEnum displayTypeEnum = null;
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            try {
                displayTypeEnum = DimensionMemberDisplayTypeEnum.getEnumByIndex((int)Integer.parseInt(s));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (displayTypeEnum == null) {
            Object wbShowType;
            displayTypeEnum = isOrg ? WorkPaperUtil.getOrgDisplayFromUserSelect(this.getApplicationType(), this.getModelId()) : ((wbShowType = this.getEffectiveSheet().getUserObject("wb_showType")) != null ? DimensionMemberDisplayTypeEnum.getEnumByItemKey((String)wbShowType.toString()) : DimensionMemberDisplayTypeEnum.NUMBERANDNAME);
        }
        return displayTypeEnum;
    }

    private void writeDisplayOpLog(OpNameMultiLangEnumBridge opName, String btnName) {
        TemplateModel templateModel = this.getCurrentTabModel().getTemplateModel();
        String templateNumber = templateModel.getNumber();
        String templateName = templateModel.getName();
        String orgName = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)this.getModelId()), (Long)((Long)this.getCurrentOrgInfo().p1)).getName();
        String logs = String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s,%4$s%5$s\u663e\u793a%6$s", (String)"WorkPaperQueryAnalysisPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), orgName, templateNumber, templateName, OpItemEnum.CHANGE.getName(), btnName, ResultStatusEnum.SUCCESS.getName());
        this.writeMultiLangLog(opName, OPDescMultiLangEnumBridge.genUnTransBridge((String)logs));
    }

    private OpItemEnum getOpItemEnum(String itemKey) {
        OpItemEnum opItemEnum;
        switch (itemKey) {
            case "btn_number": 
            case "btn_row_number": {
                opItemEnum = OpItemEnum.NUMBER;
                break;
            }
            case "btn_name": 
            case "btn_row_name": {
                opItemEnum = OpItemEnum.NAME;
                break;
            }
            case "btn_simple": {
                opItemEnum = OpItemEnum.SIMPLE;
                break;
            }
            case "btn_numsimple": {
                opItemEnum = OpItemEnum.NUMSIMPLE;
                break;
            }
            default: {
                opItemEnum = OpItemEnum.NUMNAME;
            }
        }
        return opItemEnum;
    }

    private void restoreNoDataRowCol() {
        String row = this.getPageCache().get(this.getCacheKey(CACHE_HIDEROW));
        if (row != null) {
            List hideRow = (List)SerializationUtils.fromJsonString((String)row, List.class);
            SpreadEasyInvoker.setRowsVisble(this.getClientViewProxy(), "report", hideRow.stream().mapToInt(Integer::intValue).toArray(), true);
        }
        String cacheKey = this.getCacheKey(CACHE_HIDECOL);
        String col = this.getPageCache().get(cacheKey);
        if (col != null) {
            List hideCol = (List)SerializationUtils.fromJsonString((String)col, List.class);
            SpreadEasyInvoker.setColumnVisble(this.getClientViewProxy(), "report", hideCol.stream().mapToInt(Integer::intValue).toArray(), true);
            this.changePlusCellSymbol4Restore();
            this.getPageCache().remove(cacheKey);
        }
    }

    private List<Pair<Integer, Integer>> getSpanInfo() {
        ArrayList<Pair<Integer, Integer>> spanInfo = new ArrayList<Pair<Integer, Integer>>();
        Stack<Column> stack = new Stack<Column>();
        for (Column column : this.getColumnListFromCache()) {
            if (stack.isEmpty() || column.getNumber().equals(((Column)stack.peek()).getNumber())) {
                stack.push(column);
            }
            if (column.getNumber().equals(((Column)stack.peek()).getNumber())) continue;
            if (stack.size() == 1) {
                stack.clear();
                stack.push(column);
                continue;
            }
            if (stack.size() < 2) continue;
            int colLenth = stack.size();
            for (int i = 0; i < colLenth - 1; ++i) {
                stack.pop();
            }
            Column start = (Column)stack.pop();
            int colStart = start.getColIndex();
            spanInfo.add((Pair<Integer, Integer>)Pair.onePair((Object)colStart, (Object)colLenth));
            stack.push(column);
        }
        if (stack.size() >= 2) {
            int colLenth = stack.size();
            for (int i = 0; i < colLenth - 1; ++i) {
                stack.pop();
            }
            Column start = (Column)stack.pop();
            int colStart = start.getColIndex();
            spanInfo.add((Pair<Integer, Integer>)Pair.onePair((Object)colStart, (Object)colLenth));
        }
        return spanInfo;
    }

    private void changePlusCellSymbol4Restore() {
        Object key;
        String cacheKey = this.getCacheKey(CACHE_PLUSCELL);
        if (null == this.getPageCache().get(cacheKey)) {
            return;
        }
        List plusCell = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(cacheKey), List.class);
        AreaRangeEntry firstArea = (AreaRangeEntry)this.getTemplateModel().getAreaRangeEntries().get(0);
        Point start = ExcelUtils.pos2Point((String)firstArea.getStartPosition());
        int row = start.y - 1;
        ArrayList<Map<String, Object>> plus = new ArrayList<Map<String, Object>>();
        ArrayList<HashMap> plusCell2 = new ArrayList<HashMap>();
        for (Map cell : plusCell) {
            for (Map.Entry entry : cell.entrySet()) {
                key = entry.getKey();
                String name = (String)entry.getValue();
                name = "-" + name.substring(1);
                int keyNum = Integer.parseInt((String)key);
                plus.add(SpreadEasyInvoker.packedUpdateCellMap(row, keyNum, name));
                HashMap map = Maps.newHashMap();
                map.put(key, name);
                plusCell2.add(map);
            }
        }
        List<Pair<Integer, Integer>> spanInfo = this.getSpanInfo();
        for (Pair<Integer, Integer> pair : spanInfo) {
            int[] array = new int[(Integer)pair.p2 - 1];
            for (int i = 1; i < (Integer)pair.p2; ++i) {
                array[i - 1] = (Integer)pair.p1 + i;
            }
            key = Arrays.toString(array);
            this.getPageCache().remove(key);
        }
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "report", plus);
        this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(plusCell2));
    }

    @Override
    protected void lockDataAreaRange(SpreadEasyInvoker invoker) {
        RangeModel dataRange = this.getAreaRangeModel();
        TemplateVerification.getHeaderRangeModel(this.getEffectiveSheet(), dataRange).forEach(rangeModel -> invoker.lockCell(rangeModel.getY_start(), rangeModel.getX_start(), rangeModel.getRowSize(), rangeModel.getColSize()));
        invoker.lockCell(dataRange.getY_start(), dataRange.getX_start(), dataRange.getRowSize(), dataRange.getColSize());
        this.getCanSetFormulDataArea(dataRange).forEach(row -> invoker.unlockCell((int)row, dataRange.getX_start(), 1, dataRange.getColSize()));
    }

    @Override
    protected void callBackChangeConfrim(boolean periodCanNotSave) {
        this.invokeExportEvent(this.getBizEntityNumber());
        this.getPageCache().remove("isClosePageConfirm");
    }

    @Override
    protected boolean needAutoSave() {
        return this.isModified();
    }

    @Override
    public boolean isCanSave() {
        return false;
    }

    @Override
    protected void showMessageBeoforeColose(BeforeClosedEvent e) {
        e.setCancel(true);
        this.cacheTrueOrFalseFlag("isClosePageConfirm", true);
        this.getPageCache().remove("is_modify");
        this.showConfirm(ResManager.loadKDString((String)"\u5de5\u4f5c\u5e95\u7a3f\u4e2d\u5b58\u5728\u8349\u7a3f\u6570\u636e\uff0c\u662f\u5426\u9700\u8981\u5bfc\u51fa\u5230\u672c\u5730\u6682\u5b58\uff1f", (String)"WorkPaperQueryAnalysisPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), "change_confirm");
    }

    private void writeClearRestoreLog(OpNameMultiLangEnumBridge opName, String opDes) {
        TemplateModel templateModel = this.getCurrentTabModel().getTemplateModel();
        String templateNumber = templateModel.getNumber();
        String templateName = templateModel.getName();
        String orgName = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)this.getModelId()), (Long)((Long)this.getCurrentOrgInfo().p1)).getName();
        String logs = String.format("%s %s %s%s%s", orgName, templateNumber, templateName, opDes, ResultStatusEnum.SUCCESS.getName());
        this.writeMultiLangLog(opName, OPDescMultiLangEnumBridge.genUnTransBridge((String)logs));
    }

    private Set<Integer> getCanSetFormulDataArea(RangeModel dataRange) {
        HashSet<Integer> rows = new HashSet<Integer>(16);
        Header rowHeader = this.getEffectiveSheet().getRowHeader();
        if (rowHeader != null) {
            List dimNums = rowHeader.getDimNums();
            rowHeader.iteratorObjects(dataRange.getY_start(), dataRange.getY_end(), h -> {
                if (MDQADataQueryHelper.isNotCompleteDimMem(h, dimNums, true)) {
                    rows.add(h.getIndex());
                }
            });
        }
        return rows;
    }

    private void hideNoDataRowCol() {
        Object col;
        HashSet<Integer> hideRow = new HashSet<Integer>(16);
        HashSet<Integer> hideCol = new HashSet<Integer>(16);
        MultiDimQAStyleService.collectNoDataRowOrCol(this.getEffectiveSheet(), this.getAreaRangeModel(), hideRow, hideCol, cell -> {
            if (cell.getValue() != null && StringUtils.isNotEmpty((CharSequence)cell.getValue().toString())) {
                return !(cell.getValue() instanceof BigDecimal) || ((BigDecimal)cell.getValue()).compareTo(BigDecimal.ZERO) != 0;
            }
            return false;
        }, false);
        if (!hideRow.isEmpty()) {
            this.getPageCache().put(this.getCacheKey(CACHE_HIDEROW), SerializationUtils.toJsonString(hideRow));
        }
        if (!hideCol.isEmpty()) {
            String cacheKey = this.getCacheKey(CACHE_HIDECOL);
            col = this.getPageCache().get(cacheKey);
            if (col != null) {
                List oldHideCol = (List)SerializationUtils.fromJsonString((String)col, List.class);
                hideCol.addAll(oldHideCol);
            }
            this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(hideCol));
        }
        int[] row = hideRow.stream().mapToInt(Integer::intValue).toArray();
        col = hideCol.stream().mapToInt(Integer::intValue).toArray();
        SpreadEasyInvoker.setRowsVisble(this.getClientViewProxy(), "report", row, false);
        SpreadEasyInvoker.setColumnVisble(this.getClientViewProxy(), "report", (int[])col, false);
    }

    private List<Column> getColumnListFromCache() {
        String cache = this.getPageCache().get(this.getCacheKey(COLUMN_LIST));
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            return (List)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        return new ArrayList<Column>();
    }

    @Override
    public void dealSpreadManagerForWp() {
        ReportTabModel reportTabModel = super.getCurrentTabModel();
        TemplateModel templateModel = reportTabModel.getTemplateModel();
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(templateModel.getModelId()));
        SpreadManager spreadManager = reportTabModel.getSpreadModel();
        spreadManager.getBook().getSheet(0).setUnCheckSize(true);
        WorkPaperQueryHelper workPaperQueryHelper = new WorkPaperQueryHelper(this, "report", templateModel, spreadManager);
        workPaperQueryHelper.setOrgDisplayType(this.getOrgDisPlay());
        workPaperQueryHelper.setRowColDimensionDisplayType(this.getDimMemberDisplayTypeEnum(false));
        workPaperQueryHelper.initSMForWp();
        templateModel = workPaperQueryHelper.getTemplate();
        spreadManager = workPaperQueryHelper.getSm();
        this.cacherReportTabManager();
    }

    @Override
    protected void refreshReport() {
        if (!this.checkFilterConditionIsAllFilled()) {
            return;
        }
        SpreadManager sm = this.getSpreadModel();
        this.initYear(sm);
        MDQADataQueryHelper.refreshData(sm, this.getModelNumber(), this.getOrgRelaMembSupplier());
        this.handleDebitCreditColum();
        this.calculateNewrptinfoFormulas();
        this.setModified(false);
    }

    private void initYear(SpreadManager sm) {
        Map<DimTypesEnum, Object> commonParam = this.getCurrentReportCommonParam("number");
        Object year = commonParam.get(DimTypesEnum.YEAR);
        if (year != null) {
            String yearNum = year.toString();
            sm.setCurrentYear(yearNum);
            sm.setLastYear(PeriodUtils.lastYear((String)this.getModelNumber(), (String)yearNum));
        }
    }

    private DimensionMemberDisplayTypeEnum getOrgDisPlay() {
        return this.getDimMemberDisplayTypeEnum(true);
    }

    @Override
    public void doubleClickLockedCell(int row, int col) {
        if (this.isInFoldArea(row, col)) {
            List<Pair<Integer, Integer>> spanInfo = this.getSpanInfo();
            for (Pair<Integer, Integer> pair : spanInfo) {
                List hideCol;
                if ((Integer)pair.p1 > col || (Integer)pair.p1 + (Integer)pair.p2 <= col) continue;
                int[] array = new int[(Integer)pair.p2 - 1];
                for (int i = 1; i < (Integer)pair.p2; ++i) {
                    array[i - 1] = (Integer)pair.p1 + i;
                }
                boolean isVisiable = this.getVisiable(array);
                String cacheHideColKey = this.getCacheKey(CACHE_HIDECOL);
                String hidecolStr = this.getPageCache().get(cacheHideColKey);
                List hidecol = Lists.newArrayList();
                if (StringUtils.isNotEmpty((CharSequence)hidecolStr)) {
                    hidecol = (List)SerializationUtils.fromJsonString((String)hidecolStr, List.class);
                }
                List arrayList = Arrays.stream(array).boxed().collect(Collectors.toList());
                if (!isVisiable) {
                    hidecol.addAll(arrayList);
                } else {
                    hidecol.removeAll(arrayList);
                }
                this.getPageCache().put(cacheHideColKey, SerializationUtils.toJsonString(hidecol));
                SpreadEasyInvoker.setColumnVisble(this.getClientViewProxy(), "report", array, isVisiable);
                this.cacheVisiable(array);
                this.changePlusCellSymbol(pair, isVisiable, row);
                String colstr = this.getPageCache().get(cacheHideColKey);
                if (!StringUtils.isNotEmpty((CharSequence)colstr) || !(hideCol = (List)SerializationUtils.fromJsonString((String)colstr, List.class)).contains(pair.p1)) continue;
                SpreadEasyInvoker.setColumnVisble(this.getClientViewProxy(), "report", new int[]{(Integer)pair.p1}, true);
            }
        }
    }

    private void cacheVisiable(int[] array) {
        String key = Arrays.toString(array);
        this.cacheTrueOrFalseFlag(key, !this.getVisiable(array));
    }

    private boolean getVisiable(int[] array) {
        String key = Arrays.toString(array);
        return this.isTrueFlagInCache(key);
    }

    private boolean isInFoldArea(int row, int col) {
        Point point = ExcelUtils.pos2Point((String)((AreaRangeEntry)this.getTemplateModel().getAreaRangeEntries().get(0)).getStartPosition());
        if (point.y - 1 == row) {
            List<Pair<Integer, Integer>> spanInfo = this.getSpanInfo();
            for (Pair<Integer, Integer> pair : spanInfo) {
                if ((Integer)pair.p1 > col || (Integer)pair.p1 + (Integer)pair.p2 <= col) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ThreadCache.put((Object)"needCheckPerm", (Object)true);
        if (this.isMockCreateNewData()) {
            return;
        }
        String postmanSerial = (String)this.getFormCustomParam("reportpostman");
        if (StringUtils.isEmpty((CharSequence)postmanSerial)) {
            throw new KDBizException("not found ReportPostman Info!");
        }
        AbstractReportPostman postman = (AbstractReportPostman)this.deSerializedBytes(postmanSerial);
        this.initReportTabEnv(postman);
        ArrayList<Map> MenuItems = new ArrayList<Map>(10);
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.copy, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.cut, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.clearContents, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), this.getSpreadKey(), MenuItems);
        WorkPaperUtil.updateOrgDisplay(this.getView(), this.getOrgDisPlay());
    }

    @Override
    protected boolean isView() {
        return true;
    }

    @Override
    protected boolean isReportStyleShow() {
        return true;
    }

    private void changePlusCellSymbol(Pair<Integer, Integer> pair, boolean isVisiable, int row) {
        List plusCell = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.getCacheKey(CACHE_PLUSCELL)), List.class);
        for (Map cell : plusCell) {
            String name = (String)cell.get(String.valueOf(pair.p1));
            if (name == null) continue;
            name = isVisiable ? "-" + name.substring(1) : "+" + name.substring(1);
            ArrayList<Map<String, Object>> plus = new ArrayList<Map<String, Object>>(16);
            plus.add(SpreadEasyInvoker.packedUpdateCellMap(row, (Integer)pair.p1, name));
            SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "report", plus);
            return;
        }
    }

    @Override
    protected void controlSpreadStyle(Map<String, Object> spreadStyle) {
        this.getPageCache().put("locksheet", "true");
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), "report");
        invoker.setBatch(true);
        this.lockDataAreaRange(invoker);
        invoker.startToInvoke();
    }

    @Override
    public void updateClientSpreadValues() {
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(16);
        RangeModel rangeModel = this.getAreaRangeModel();
        this.getEffectiveSheet().iteratorRangeCells(rangeModel, cell -> {
            if (cell != null && cell.isChangeVal()) {
                cell.setChangeVal(false);
                cellValues.add(SpreadEasyInvoker.packedUpdateCellMap(cell.getRow(), cell.getCol(), cell.getValue()));
            }
        });
        this.changeCellValueDisplayByUnit(cellValues);
        if (!cellValues.isEmpty()) {
            SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "report", cellValues);
        }
        SpreadClientInvoker.invokeHideZeroMethod(this.getClientViewProxy(), "report", false);
        if (ThreadCache.exists((Object)"needCheckPerm")) {
            this.noPermControl();
            ThreadCache.remove((Object)"needCheckPerm");
        }
        this.cacheSpreadModel();
    }

    private void noPermControl() {
        if (!MemberPermHelper.isModelManager((Long)this.getModelId())) {
            new MDQueryAnalysisStyleHandle(this.getView(), this.getSpreadKey(), this.getModelId(), this.getEffectiveSheet(), this.getPageViewMember()).unitDataControl();
        }
    }

    @Override
    public void changeCellValueDisplayByUnit(List<Map<String, Object>> cellsUpdate) {
        if (CollectionUtils.isEmpty(cellsUpdate)) {
            return;
        }
        Sheet sheet = this.getEffectiveSheet();
        int unitSize = this.getReportUnitInfo();
        if (unitSize == 0) {
            return;
        }
        BigDecimal unit = BigDecimal.TEN.pow(unitSize);
        this.dataTypeMap = FloatLogicImpl.getAllDataType(this.getPageCache(), this.getSpreadModel(), this.getTemplateModel());
        cellsUpdate.forEach(cellData -> {
            int col;
            int row;
            Cell cell;
            Object value = cellData.get(SpreadProperties.UpdataValueMethod.V.k());
            if (value != null && StringUtils.isNotEmpty((CharSequence)value.toString()) && new Variant((Object)value.toString()).isNumeric() && unitDataTypeEnums.contains(this.getCellDataType(cell = sheet.getCell(row = ((Integer)cellData.get(SpreadProperties.UpdataValueMethod.R.k())).intValue(), col = ((Integer)cellData.get(SpreadProperties.UpdataValueMethod.C.k())).intValue()), false))) {
                if (value instanceof String) {
                    cellData.put("v", new BigDecimal(value.toString()).divide(unit));
                } else {
                    cellData.put("v", ((BigDecimal)value).divide(unit));
                }
            }
        });
    }

    @Override
    public boolean isChangeUnitType(Cell cell) {
        return unitDataTypeEnums.contains(this.getCellDataType(cell, false));
    }

    @Override
    protected DataTypeEnum getCellDataType(Cell cell, boolean isDetail) {
        RangeModel rangeModel = this.getAreaRangeModel();
        Set<Integer> formulaColIndexs = this.getFormulaColIndexs();
        if (!rangeModel.checkIsInArea(cell) || formulaColIndexs.contains(cell.getCol())) {
            return DataTypeEnum.TXT;
        }
        DataTypeEnum dataType = CellDataTypeUtil.getCellDataType((long)this.getModelId(), (Cell)cell, (IPageCache)this.getPageCache(), (SpreadManager)this.getSpreadModel(), (HashMap)this.dataTypeMap, (boolean)isDetail, (boolean)true);
        if (DataTypeEnum.DEFAULT == dataType || DataTypeEnum.CURRENCY == dataType) {
            return DataTypeEnum.DEFAULT;
        }
        if (DataTypeEnum.TXT == dataType && cell.getValue() != null) {
            cell.setValue((Object)String.valueOf(cell.getValue()));
        }
        return dataType;
    }

    public String getCacheKey(String suffix) {
        String tabid = this.getPageCache().get("tabkey_selected");
        return String.join((CharSequence)"_", tabid, suffix);
    }

    private RangeModel getAreaRangeModel() {
        String cacheKey = this.getCacheKey("getAreaRangeModel");
        if (StringUtils.isNotEmpty((CharSequence)cacheKey) && this.getPageCache().get(cacheKey) != null) {
            return new RangeModel(this.getPageCache().get(cacheKey));
        }
        RangeModel rangeModel = AnalyticsSolutionHelper.getDataRangeModel(this.getSpreadModel());
        if (StringUtils.isNotEmpty((CharSequence)cacheKey)) {
            this.getPageCache().put(cacheKey, rangeModel.toString());
        }
        return rangeModel;
    }

    private Set<Integer> getFormulaColIndexs() {
        String cacheKey = this.getCacheKey("getFormulaColIndexs");
        if (StringUtils.isNotEmpty((CharSequence)cacheKey) && this.getPageCache().get(cacheKey) != null) {
            return (Set)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(cacheKey));
        }
        HashSet<Integer> formulaColIndex = new HashSet<Integer>(16);
        this.getColumnListFromCache().forEach(c -> {
            if (c.hasFormula()) {
                formulaColIndex.add(c.getColIndex());
            }
        });
        if (StringUtils.isNotEmpty((CharSequence)cacheKey)) {
            this.getPageCache().put(cacheKey, ObjectSerialUtil.toByteSerialized(formulaColIndex));
        }
        return formulaColIndex;
    }

    @Override
    public void updateClientValuesWhenUnitChange() {
        ArrayList cellValues = new ArrayList(16);
        int unit = this.getReportUnitInfo();
        this.dataTypeMap = FloatLogicImpl.getAllDataType(this.getPageCache(), this.getSpreadModel(), this.getTemplateModel());
        int scale = this.getCurrencyScale();
        Variant right = Variant.getTenPow((int)unit);
        Set<Integer> formulaCols = this.getFormulaColIndexs();
        this.getEffectiveSheet().iteratorRangeCells(this.getAreaRangeModel(), cell -> {
            if (!formulaCols.contains(cell.getCol()) && cell.getValue() != null) {
                Variant value = cell.getVariant();
                Object newVal = value.getValue();
                if (value != null && value.isNumeric() && this.isChangeUnitType((Cell)cell)) {
                    Variant newData = value.isNumber() ? new Variant(value).divide(right) : value;
                    newVal = newData.toBigDecimal().setScale(scale + unit, RoundingMode.HALF_UP);
                }
                cellValues.add(SpreadEasyInvoker.packedUpdateCellMap(cell.getRow(), cell.getCol(), newVal));
            }
        });
        if (!cellValues.isEmpty()) {
            SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "report", cellValues);
            this.noPermControl();
        }
        SpreadClientInvoker.invokeHideZeroMethod(this.getClientViewProxy(), "report", false);
    }

    @Override
    protected void afterRefreshData() {
    }

    @Override
    protected String getCorrectOrgName(IDimMember dimMember, long periodId, long yearId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model.id", "=", (Object)this.getModelId());
        qfBuilder.add("dimension.number", "=", (Object)"Entity");
        String memberNum = dimMember.getNumber();
        String par_SonNum = dimMember.getPar_SonNum();
        if (!StringUtil.isEmptyString((String)par_SonNum)) {
            String[] nums = par_SonNum.split("_");
            qfBuilder.add("parent.number", "=", (Object)nums[0]);
            qfBuilder.add("number", "=", (Object)nums[1]);
        } else if (dimMember.getNumber().contains("_")) {
            memberNum = memberNum.split("_")[1];
            qfBuilder.add("number", "=", (Object)memberNum);
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_entitymembertree", (String)"dimension.name,number,name", (QFilter[])qfBuilder.toArray());
        return EntityVersioningUtil.getEffOrgName((DynamicObject)dy, (long)this.getModelId(), (long)yearId, (long)periodId);
    }

    @Override
    protected DynamicObject queryReportRecord(Map<String, Long> filterMap, String select) {
        return null;
    }

    @Override
    protected boolean isCommonFilterInPV(String ctrlKey) {
        return true;
    }

    @Override
    protected void handleDebitCreditColum() {
        WorkPaperQueryHelper workPaperQueryHelper = new WorkPaperQueryHelper(this, "report", this.getTemplateModel(), this.getSpreadModel());
        workPaperQueryHelper.handleDebitCreditColum();
        this.cacheSpreadModel(workPaperQueryHelper.getSm());
    }

    @Override
    protected Map<String, String> getCellDimMemberMap(Cell cell, boolean isParSon) {
        Map<String, Object> cellInfo = MDQADataQueryHelper.getCellInfo(this.getModelId(), this.getEffectiveSheet().getRowHeader(), this.getEffectiveSheet().getColHeader(), cell.getRow(), cell.getCol(), WorkPaperUtil.getPageViewMember(this.getSpreadModel()), false, null, null, isParSon, false, this.getAreaRangeModel(), null);
        if (MapUtils.isNotEmpty(cellInfo)) {
            return (LinkedHashMap)cellInfo.get("dimNumber2MembNumber");
        }
        return new HashMap<String, String>(16);
    }

    @Override
    protected Map<String, Object> getCellInfo(boolean hideNotify, boolean supportExtInfo) {
        SpreadSelector selector = this.getSpreadSelector();
        int r = selector.getStartRow();
        int c = selector.getStartCol();
        Map<String, Pair<String, String>> specialYear = this.getSpecialYear();
        Map<String, Object> cellInfo = MDQADataQueryHelper.getCellInfo4wp(this.getModelId(), this.getEffectiveSheet(), r, c, WorkPaperUtil.getPageViewMember(this.getSpreadModel()), this.getAreaRangeModel(), specialYear);
        if (MapUtils.isEmpty(cellInfo)) {
            if (!hideNotify) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5355\u5143\u683c\u3002", (String)"AbstractMultiReportPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            return null;
        }
        return cellInfo;
    }

    private Map<String, DynamicObject> getDimMemDyoForLinkData() {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        HashSet dimSet = Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber()});
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        WorkPaperUtil.getPageViewMember(this.getSpreadModel()).forEach((k, v) -> {
            if (dimSet.contains(k)) {
                map.put((String)k, QueryServiceHelper.queryOne((String)DimEntityNumEnum.getEntieyNumByNumber((String)k), (String)"id,number,name", (QFilter[])new QFilter[]{qFilter, new QFilter("number", "=", v)}));
            }
        });
        return map;
    }

    @Override
    public void linkData() {
        OPDescMultiLangEnumBridge result = new OPDescMultiLangEnumBridge("\u8054\u67e5\u6210\u529f", "MultiDimQueryAnalysisPlugin_39", FI_BCM_FORMPLUGIN, null);
        if (!DataTraceHelper.openExtDataTrace(this.getModelId(), this.getEffectiveSheet(), this.getView(), this.getDimMemDyoForLinkData(), WorkPaperUtil.getPageViewMember(this.getSpreadModel()), this.getSpreadSelector(), ResManager.loadKDString((String)"\u5de5\u4f5c\u5e95\u7a3f\uff1a\u8054\u67e5\u62d3\u5c55\u6570\u636e", (String)"WorkPaperQueryAnalysisPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), this.getAreaRangeModel(), this.getSpecialYear()) && !DataTraceHelper.openDataTraceFromHeaderMode(this.getModelId(), this.getEffectiveSheet(), this.getView(), this.getDimMemDyoForLinkData(), WorkPaperUtil.getPageViewMember(this.getSpreadModel()), this.getSpreadSelector(), ResManager.loadKDString((String)"\u5de5\u4f5c\u5e95\u7a3f\uff1a\u6570\u636e\u8ffd\u6eaf", (String)"AbstractMultiReportPlugin_87", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), this.getAreaRangeModel(), this.getSpecialYear())) {
            result = new OPDescMultiLangEnumBridge("\u8054\u67e5\u5931\u8d25", "WorkPaperQueryAnalysisPlugin_8", FI_BCM_FORMPLUGIN, null);
        }
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u8054\u67e5", "MultiDimQueryAnalysisPlugin_29", FI_BCM_FORMPLUGIN, "linkdata"), result);
    }

    @Override
    public void linkDataSource() {
        DataTraceHelper.openLinkDataSource(this.getModelId(), this.getEffectiveSheet(), this.getView(), this.getDimMemDyoForLinkData(), WorkPaperUtil.getPageViewMember(this.getSpreadModel()), this.getSpreadSelector(), ResManager.loadKDString((String)"\u5de5\u4f5c\u5e95\u7a3f\uff1a\u8054\u67e5\u660e\u7ec6\u6765\u6e90", (String)"WorkPaperQueryAnalysisPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), this.getAreaRangeModel(), this.getSpecialYear());
    }

    @Override
    protected void setReportStausBar(NotifyEvent e) {
        StatusBarModel statusBarModel = new StatusBarModel();
        Map<String, Object> cellInfo = MDQADataQueryHelper.getCellInfo(this.getModelId(), this.getEffectiveSheet().getRowHeader(), this.getEffectiveSheet().getColHeader(), this.getSelectorStartRow(), this.getSelectorStartCol(), WorkPaperUtil.getPageViewMember(this.getSpreadModel()), true, "\uff1a", "\uff0c", false, true, this.getAreaRangeModel(), null);
        if (MapUtils.isNotEmpty(cellInfo)) {
            Map combo;
            if (cellInfo.get("infoText") != null) {
                statusBarModel.setCellNameStr(cellInfo.get("infoText").toString());
            }
            if (MapUtils.isNotEmpty((Map)(combo = (Map)MDQADataQueryHelper.getValue(cellInfo, "dimNumber2MembNumber", new HashMap())))) {
                statusBarModel.setSource(OlapSourceEnum.getName((Object)ReportSourceUtil.getSource((String)MemberReader.findModelNumberById((Object)this.getModelId()), (Map)combo)));
            }
        }
        this.invokeSetDisplayContentMethod(statusBarModel);
    }

    @Override
    public void afterSpreadEventHandle(EventConstant.ActionName actionName) {
        if (this.isModified) {
            this.setModified(true);
        }
    }

    @Override
    protected void invokeUpdateFormula(NotifyEvent e) {
        if (this.isModified) {
            return;
        }
        Cell cell = (Cell)e.getSource();
        if (cell.isChangeVal()) {
            this.isModified = true;
        }
    }

    @Override
    protected void beforeUpdateMultiValue(NotifyEvent e) {
    }

    @Override
    protected void beforeUpdateValue(NotifyEvent e) {
    }

    @Override
    protected void afterUpdateValue(NotifyEvent e) {
    }

    @Override
    protected void afterUpdateMultiValue(NotifyEvent e) {
        if (this.isModified) {
            return;
        }
        for (LinkedHashMap value : ((SpreadPostDataInfo)e.getSource()).getValues()) {
            Integer r = (Integer)value.get("r");
            Integer c = (Integer)value.get("c");
            if (!this.getEffectiveSheet().getCell(r.intValue(), c.intValue()).isChangeVal()) continue;
            this.isModified = true;
            break;
        }
    }

    @Override
    protected void invokeAddOrRemove(NotifyEvent e) {
    }

    @Override
    protected void invokeCellSelect(NotifyEvent e) {
        this.setReportStausBar(e);
    }
}

