/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.workingpaper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.util.FormShowParameterUtil;
import kd.fi.bcm.formplugin.util.ShowOperationMsgUtil;
import kd.fi.bcm.formplugin.util.TemplateUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class WorkPaperTemplateListPlugin
extends AbstractBaseListPlugin {
    private static final String BILLLISTAP = "billlistap";
    private static final String billlistap = "billlistap";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String NUMBER = "number";
    private static final String STR_MODEL = "model";
    private static final String FOCUS_NODE_ID = "focusnodeid";
    private static final String PROCESS_CLOSED_CALLLBACK = "processClosedCallBack";

    private static String getOperationDel() {
        return ResManager.loadKDString((String)"\u5220\u9664", (String)"WorkPaperTemplateListPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private static String getOperationCopy() {
        return ResManager.loadKDString((String)"\u590d\u5236", (String)"WorkPaperTemplateListPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private static String getOperationView() {
        return ResManager.loadKDString((String)"\u67e5\u770b", (String)"WorkPaperTemplateListPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private static String getOperationDisadle() {
        return ResManager.loadKDString((String)"\u7981\u7528", (String)"WorkPaperTemplateListPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private static String getOperationAdle() {
        return ResManager.loadKDString((String)"\u542f\u7528", (String)"WorkPaperTemplateListPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private static String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"WorkPaperTemplateListPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private static String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"WorkPaperTemplateListPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setBillFormId("bcm_templateentity");
        billList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                WorkPaperTemplateListPlugin.this.checkTmpAuth(evt);
            }
        });
    }

    private void checkTmpAuth(ListRowClickEvent evt) {
        ListSelectedRowCollection rows;
        boolean modelManager = MemberPermHelper.isModelManager((Long)this.getModelId());
        if (!modelManager && this.isReadOnly(rows = evt.getListSelectedRowCollection())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_delete", "btn_enable", "btn_disable"});
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_delete", "btn_enable", "btn_disable"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent p0) {
                BillList list = (BillList)p0.getSource();
                String readOnly = WorkPaperTemplateListPlugin.this.getPageCache().get("readOnly");
                if (null != readOnly) {
                    List onlyRead = (List)SerializationUtils.fromJsonString((String)WorkPaperTemplateListPlugin.this.getPageCache().get("readOnly"), List.class);
                    if (!StringUtils.isEmpty((String)WorkPaperTemplateListPlugin.this.getPageCache().get("read"))) {
                        WorkPaperTemplateListPlugin.this.getPageCache().remove("read");
                    }
                    if (onlyRead.contains(list.getFocusRowPkId())) {
                        WorkPaperTemplateListPlugin.this.getPageCache().put("read", "true");
                    }
                }
                DynamicObject dyna = list.getModel().loadReferenceData((DynamicObjectType)list.getEntityType(), list.getFocusRowPkId());
                WorkPaperTemplateListPlugin.this.handleOpenProcess(dyna);
            }
        });
    }

    private boolean isReadOnly(ListSelectedRowCollection dys) {
        String readOnly = this.getPageCache().get("readOnly");
        if (null != readOnly) {
            List onlyRead = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("readOnly"), List.class);
            for (ListSelectedRow dy : dys) {
                if (!onlyRead.contains(dy.getPrimaryKeyValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
        List<Long> noPermIds = this.getNoPermList();
        if (noPermIds != null && noPermIds.contains(currentRow.getPrimaryKeyValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5df2\u8bbe\u7f6e\u65e0\u6743\u4e0d\u80fd\u6253\u5f00\uff0c\u8bf7\u70b9\u51fb\u5237\u65b0", (String)"WorkPaperTemplateListPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        this.writeOperationLog(WorkPaperTemplateListPlugin.getOperationView(), currentRow.getNumber(), currentRow.getName(), WorkPaperTemplateListPlugin.getOperationStstusSuccess());
    }

    private List<Long> getNoPermList() {
        boolean superUser = PermissionServiceHelper.isSuperUser((long)Long.parseLong(RequestContext.get().getUserId()));
        if (superUser || MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()))) {
            return new ArrayList<Long>();
        }
        ArrayListMultimap map = PermClassEntityHelper.getPermissionMap((String)"bcm_templateentity", (String)String.valueOf(this.getModelId()), (String)String.valueOf(this.getUserId()));
        List noPermIds = map.get((Object)"1");
        return noPermIds;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "modelbd");
        if (StringUtils.isEmpty((String)modelId)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            FilterParameter fParameter = billList.getFilterParameter();
            fParameter.getQFilters().add(new QFilter("1", "!=", (Object)"1", true));
            billList.setFilterParameter(fParameter);
            this.getView().showTipNotification(MessageConstant.getMODEL_NOTEXISTS());
            return;
        }
        this.getModel().setValue(STR_MODEL, (Object)modelId);
        this.modelChange(modelId);
    }

    private void modelChange(String modelid) {
        this.getPageCache().put("KEY_MODEL_ID", modelid);
        this.refreshBill(Long.parseLong(modelid));
    }

    private void refreshBill(long modelid) {
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter(STR_MODEL, "=", (Object)modelid);
        filter.and("templatetype", "=", (Object)"2");
        fp.setFilter(filter);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setFilterParameter(fp);
        billList.setClearSelection(true);
        billList.refresh();
    }

    @Override
    protected boolean validator() {
        String modelid = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((String)modelid)) {
            this.getView().showTipNotification(MessageConstant.getMODEL_NOTEXISTS());
            return false;
        }
        return true;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        if (!this.validator()) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "model": {
                String modelId = UserSelectUtil.getF7SelectId(this.getView(), STR_MODEL);
                if (modelId == null) {
                    this.getModel().setValue(STR_MODEL, (Object)this.getPageCache().get("KEY_MODEL_ID"));
                    break;
                }
                if (modelId.equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
                this.modelChange(modelId);
                break;
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        if (!this.validator()) {
            return;
        }
        switch (key = evt.getItemKey()) {
            case "btn_add": {
                this.openFormPage();
                break;
            }
            case "btn_refresh": {
                this.refreshBill(this.getModelId());
                break;
            }
            case "btn_delete": {
                this.deleteTemplate();
                break;
            }
            case "btn_copy": {
                this.copyTemplate();
                break;
            }
            case "btn_enable": 
            case "btn_disable": {
                this.statusControl(key);
                break;
            }
            case "btn_template_order": {
                this.showTemplateOrderView();
            }
        }
    }

    private void showTemplateOrderView() {
        String rootPageId = null;
        if (this.getView().getParentView() != null) {
            rootPageId = this.getView().getParentView().getPageId();
        }
        this.getView().showForm(FormShowParameterUtil.getFormShowParameter("bcm_template_order_popup", ShowType.Modal, ResManager.loadKDString((String)"\u5de5\u4f5c\u5e95\u7a3f\u6a21\u677f\u987a\u5e8f\uff08\u652f\u6301\u62d6\u62fd\u79fb\u52a8\u6392\u5e8f\uff09", (String)"WorkPaperTemplateListPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), new CloseCallBack((IFormPlugin)this, "refresh"), rootPageId, this.getPageCache().get("KEY_MODEL_ID")));
    }

    private void statusControl(String key) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection dys = billList.getSelectedRows();
        if (dys == null || dys.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"WorkPaperTemplateListPlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        OperationResult operationResult = new OperationResult();
        operationResult.setBillCount(dys.size());
        TemplateModel.TplStatus enable = StringUtil.equals((String)"btn_enable", (String)key) ? TemplateModel.TplStatus.ENABLE : TemplateModel.TplStatus.DISABLE;
        Map<Long, DynamicObject> templateStatus = TemplateUtil.getTemplateStatus(dys.getPrimaryKeyValues());
        TemplateUtil.updateReportStatus(enable, templateStatus, operationResult, true, this.getModelId());
        if (!templateStatus.isEmpty()) {
            List successPkIds = operationResult.getSuccessPkIds();
            String operation = StringUtil.equals((String)"btn_enable", (String)key) ? WorkPaperTemplateListPlugin.getOperationAdle() : WorkPaperTemplateListPlugin.getOperationDisadle();
            templateStatus.forEach((k, v) -> this.writeOperationLog(operation, v.getString(NUMBER), v.getString("name"), successPkIds.contains(k) ? WorkPaperTemplateListPlugin.getOperationStstusSuccess() : WorkPaperTemplateListPlugin.getOperationStstusFail()));
        }
        ShowOperationMsgUtil.showOperationResultMulti(operationResult, this.getView());
        this.refreshBill(this.getModelId());
    }

    private void copyTemplate() {
        DynamicObject[] tempObjs = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u590d\u5236\u7684\u6a21\u677f\u8bb0\u5f55\u3002", (String)"WorkPaperTemplateListPlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        if (tempObjs != null && tempObjs.length > 0) {
            QFilter templatetypeFilter;
            ArrayList<Iterator> saveObj = new ArrayList<Iterator>(tempObjs.length);
            ArrayList<String> numberList = new ArrayList<String>(tempObjs.length);
            for (DynamicObject obj : tempObjs) {
                TemplateModel model = new TemplateModel();
                model.loadDynaObj2Model(obj);
                model.setName(model.getName().length() > 56 ? model.getName().substring(0, 56) + "copy" : model.getName() + "copy");
                model.setNumber(model.getNumber().length() > 56 ? model.getNumber().substring(0, 56) + "copy" : model.getNumber() + "copy");
                numberList.add(model.getNumber());
                model.setId(GlobalIdUtil.genGlobalLongId());
                model.getAreaRangeEntries().forEach(p -> p.setId(GlobalIdUtil.genGlobalLongId()));
                model.getPageDimensionEntries().forEach(p -> p.setId(GlobalIdUtil.genGlobalLongId()));
                model.getViewPointDimensionEntries().forEach(p -> p.setId(GlobalIdUtil.genGlobalLongId()));
                model.getPagePropEntries().forEach(p -> p.setId(GlobalIdUtil.genGlobalLongId()));
                Date time = new Date();
                model.setCreatorId(Long.parseLong(RequestContext.get().getUserId()));
                model.setCreateTime(time);
                model.setModifierId(Long.parseLong(RequestContext.get().getUserId()));
                model.setModifyTime(time);
                Iterator t = model.genDynamicObject();
                t.set("group", GlobalIdUtil.genGlobalLongId());
                saveObj.add(t);
            }
            boolean isLarge = numberList.stream().anyMatch(e -> e.length() > 50);
            if (isLarge) {
                throw new KDBizException(ResManager.loadKDString((String)"\u590d\u5236\u7684\u6570\u636e\u7f16\u7801\u4f4d\u6570\u8d85\u8fc7\u957f\u5ea6\uff08%1$s\uff09\uff0c\u8bf7\u5148\u4fee\u6539\u7f16\u7801\u3002", (String)"WorkPaperTemplateListPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            QFilter qfnumber = new QFilter(NUMBER, "in", numberList);
            QFilter qfmodel = new QFilter(STR_MODEL, "=", (Object)this.getModelId());
            DynamicObjectCollection numberCol = QueryServiceHelper.query((String)"bcm_templateentity", (String)NUMBER, (QFilter[])new QFilter[]{qfnumber, qfmodel, templatetypeFilter = new QFilter("templatetype", "in", (Object)TemplateTypeEnum.getWPTypes())});
            if (numberCol != null && numberCol.size() > 0) {
                ArrayList<String> tip = new ArrayList<String>();
                for (DynamicObject num : numberCol) {
                    tip.add(num.getString(NUMBER));
                }
                for (int i = 0; i < tempObjs.length; ++i) {
                    this.writeOperationLog(WorkPaperTemplateListPlugin.getOperationCopy(), tempObjs[i].getString(NUMBER), tempObjs[i].getString("name"), WorkPaperTemplateListPlugin.getOperationStstusFail());
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u590d\u5236\u65f6\u4f1a\u4ea7\u751f\u91cd\u590d\u7684\u7f16\u7801\uff1a\uff08%s\uff09\u8bf7\u5148\u4fee\u6539\u7f16\u7801", (String)"WorkPaperTemplateListPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), String.join((CharSequence)",", tip)));
            }
            BusinessDataWriter.save((IDataEntityType)((DynamicObject)saveObj.get(0)).getDataEntityType(), (Object[])saveObj.toArray());
            this.refreshBill(this.getModelId());
            for (int i = 0; i < tempObjs.length; ++i) {
                this.writeOperationLog(WorkPaperTemplateListPlugin.getOperationCopy(), tempObjs[i].getString(NUMBER), tempObjs[i].getString("name"), WorkPaperTemplateListPlugin.getOperationStstusSuccess());
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"WorkPaperTemplateListPlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private DynamicObject[] getSelectedTempDynaObjs(String noSelectedMsg) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (billList.getSelectedRows().size() == 0) {
            if (StringUtils.isNotEmpty((String)noSelectedMsg)) {
                this.getView().showTipNotification(noSelectedMsg);
            }
            return null;
        }
        return BusinessDataServiceHelper.load((Object[])billList.getSelectedRows().getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType());
    }

    private void deleteTemplate() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection dys = billList.getSelectedRows();
        if (dys == null || dys.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"WorkPaperTemplateListPlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (this.checkStatus(dys)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u72b6\u6001\u7684\u5de5\u4f5c\u5e95\u7a3f\u6a21\u677f\u4e0d\u5141\u8bb8\u88ab\u5220\u9664\uff0c\u53ea\u5141\u8bb8\u5220\u9664\u7981\u7528\u72b6\u6001\u7684\u5de5\u4f5c\u5e95\u7a3f\u3002", (String)"WorkPaperTemplateListPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\uff1f", (String)"WorkPaperTemplateListPlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deletetemplate", (IFormPlugin)this));
    }

    private boolean checkStatus(ListSelectedRowCollection dys) {
        Map<Long, DynamicObject> templateStatus = TemplateUtil.getTemplateStatus(dys.getPrimaryKeyValues());
        if (templateStatus == null) {
            return false;
        }
        for (Map.Entry<Long, DynamicObject> entry : templateStatus.entrySet()) {
            if (!"1".equals(entry.getValue().getString("status"))) continue;
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        long modelId = Long.parseLong(this.getPageCache().get("KEY_MODEL_ID"));
        if ("deletetemplate".equals(callBackId) && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            Object[] ids = billList.getSelectedRows().getPrimaryKeyValues();
            QFilter filter = new QFilter("id", "in", (Object)ids);
            DynamicObjectCollection tempCollection = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id, number,name", (QFilter[])new QFilter[]{filter});
            for (DynamicObject object : tempCollection) {
                super.writeOperationLog(WorkPaperTemplateListPlugin.getOperationDel(), object.getString(NUMBER), object.getString("name"), WorkPaperTemplateListPlugin.getOperationStstusSuccess());
            }
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_templateentity"), (Object[])ids);
            TemplateServiceHelper.removeTemplateModelCacheByIds((Object)modelId, (Object[])ids);
            this.refreshBill(modelId);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"WorkPaperTemplateListPlugin_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void openFormPage() {
        if (this.getModelId() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"WorkPaperTemplateListPlugin_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        JSONObject catalog = new JSONObject();
        catalog.put("id", (Object)this.getWpcatalogId());
        catalog.put("name", (Object)"");
        HashMap<String, String> customParams = new HashMap<String, String>(16);
        customParams.put("modelId", this.getPageCache().get("KEY_MODEL_ID"));
        customParams.put("KEY_MODEL_ID", this.getPageCache().get("KEY_MODEL_ID"));
        customParams.put("catalog", catalog.toJSONString());
        customParams.put("templatetype", TemplateCatalogEnum.MERGE_WP.getNumber());
        this.getView().showForm(FormShowParameterUtil.getFormShowParameter("bcm_templateentity", ShowType.Modal, ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"WorkPaperTemplateListPlugin_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), new CloseCallBack((IFormPlugin)this, "bcm_templateentity"), null, customParams));
    }

    private Long getWpcatalogId() {
        QFilter qFilter = new QFilter(STR_MODEL, "=", (Object)this.getModelId());
        qFilter.and("catalogtype", "=", (Object)Character.valueOf(TemplateCatalogTypeEnum.WPCATALOG.getType())).and(NUMBER, "=", (Object)TemplateCatalogEnum.MERGE_WP.getNumber());
        return BusinessDataServiceHelper.loadSingle((String)"bcm_templatecatalog", (String)"id", (QFilter[])qFilter.toArray()).getLong("id");
    }

    private void handleOpenProcess(DynamicObject dyna) {
        TemplateModel template = this.constructTemplateModel(dyna);
        this.openTemplateProcessPage(template);
    }

    private TemplateModel constructTemplateModel(DynamicObject dyna) {
        TemplateModel template = new TemplateModel();
        template.loadDynaObj2Model(dyna);
        return template;
    }

    private void openTemplateProcessPage(TemplateModel template) {
        IFormView mainPageView = this.getView().getMainView();
        String pageId = this.getView().getPageId() + template.getId();
        IFormView parentView = this.getView().getParentView();
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            HashMap customParams = Maps.newHashMap();
            customParams.put("KEY_MODEL_ID", this.getPageCache().get("KEY_MODEL_ID"));
            customParams.put("read", this.getPageCache().get("read"));
            customParams.put("List_entry", Boolean.TRUE);
            customParams.put("template_model", ObjectSerialUtil.toByteSerialized((Object)template));
            customParams.put("listPageID", this.getView().getPageId());
            FormShowParameter formShowParameter = FormShowParameterUtil.getFormShowParameter("bcm_papertmpl_process", ShowType.MainNewTabPage, String.format(ResManager.loadKDString((String)"\u7f16\u8f91\u5de5\u4f5c\u5e95\u7a3f\u6a21\u677f-%s", (String)"WorkPaperTemplateListPlugin_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), template.getName()), new CloseCallBack((IFormPlugin)this, PROCESS_CLOSED_CALLLBACK), null, customParams);
            formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
            formShowParameter.setPageId(pageId);
            if (parentView == null) {
                this.getView().showForm(formShowParameter);
            } else {
                formShowParameter.setParentPageId(parentView.getPageId());
                formShowParameter.setParentFormId(parentView.getEntityId());
                parentView.showForm(formShowParameter);
                this.getView().sendFormAction(parentView);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "bcm_templateentity": {
                if (evt.getReturnData() != null) {
                    String tempser = (String)evt.getReturnData();
                    TemplateModel template = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)tempser);
                    this.openTemplateProcessPage(template);
                }
            }
            case "processClosedCallBack": {
                this.refreshBill(this.getModelId());
                break;
            }
            case "refresh": {
                boolean isRefresh;
                if (returnData == null || !(isRefresh = ((Boolean)returnData).booleanValue())) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f", (String)"WorkPaperTemplateListPlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.refreshBill(this.getModelId());
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        QFilter filter;
        super.setFilter(e);
        e.setOrderBy("sequence,number,name,templatecatalog.longnumber,createtime");
        e.getQFilters().add(new QFilter(STR_MODEL, "=", (Object)this.getModelId()));
        e.getQFilters().add(new QFilter("templatetype", "=", (Object)String.valueOf(TemplateTypeEnum.MSN.getType())));
        boolean superUser = PermissionServiceHelper.isSuperUser((long)Long.parseLong(RequestContext.get().getUserId()));
        if (!superUser && !MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId())) && (filter = this.getPermClassFilter()) != null) {
            e.getQFilters().add(filter);
        }
    }

    private QFilter getPermClassFilter() {
        QFilter qFilter = null;
        ArrayListMultimap map = PermClassEntityHelper.getPermissionMap((String)"bcm_templateentity", (String)String.valueOf(this.getModelId()), (String)String.valueOf(this.getUserId()));
        List noPermIds = map.get((Object)"1");
        if (!CollectionUtils.isEmpty((Collection)noPermIds)) {
            qFilter = new QFilter("id", "not in", (Object)noPermIds);
        }
        if (map.get((Object)"2") != null) {
            this.getPageCache().put("readOnly", SerializationUtils.toJsonString((Object)map.get((Object)"2")));
        }
        return qFilter;
    }
}

