/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.workingpaper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.formula.register.FormulaConfig;
import kd.fi.bcm.business.log.DataPermLogHelper;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.ColDimensionEntryExt;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimPropEntry;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.RowDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateCatalog;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.business.util.UpgradeWorkPaperTemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.RowColExcuteEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.WorkPaperEnum;
import kd.fi.bcm.common.enums.WorkPaperTypeEnum;
import kd.fi.bcm.common.enums.log.DataPermLogMultiLangEnum;
import kd.fi.bcm.common.enums.template.DefaultDimSettingEnum;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.BCMStringUtil;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.formplugin.analytics.QueryAnalysisPermHelper;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.intergration.util.ShowFormulaUtil;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.spread.SpreadUtils;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.formplugin.template.multiview.TempFormulaUtil;
import kd.fi.bcm.formplugin.template.multiview.validators.TemplateVerification;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.formplugin.template.util.TemplateScanMemberService;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import kd.fi.bcm.formplugin.util.MarkSpecialCell;
import kd.fi.bcm.formplugin.util.ObjectConvertUtils;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.formplugin.util.TemplateDimSettingUtil;
import kd.fi.bcm.formplugin.util.TemplateUtil;
import kd.fi.bcm.formplugin.util.WorkPaperUtil;
import kd.fi.bcm.formplugin.workingpaper.WorkPaperUpdataService;
import kd.fi.bcm.formplugin.workingpaper.model.AbstractColumn;
import kd.fi.bcm.formplugin.workingpaper.model.Column;
import kd.fi.bcm.formplugin.workingpaper.model.Column4Cache;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.MultiAreaPositionsManager;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.SpreadSelector;
import kd.fi.bcm.spread.domain.view.builder.FreeStyleTemplateFinalBuilder;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.event.AdjustRangeEvent;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.event.NotifyEvent;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import org.apache.commons.collections.CollectionUtils;

public class WorkPaperTemplatePlugin
extends AbstractTemplateBasePlugin {
    private static final String ALL = "allPoint";
    private static final String GENERAL = "general";
    private static final String COL = "col";
    private static final String ROW = "row";
    private static final String btn_save = "btn_save";
    private static final String btn_dimsetting = "btn_dimsetting";
    private static final String type = "type";
    private static final String colBase64headNameMap = "colBase64headNameSet";
    private static final String INSERT_COMPONENT = "insertComponent";
    private static final String INSERT_FORMULA_COL = "insertFormulaCol";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String COL_HEADER = "colHeader";
    private static final String CACHE_UPDATE_VALUE_FAIL = "update_value_fail";
    private static final String CACHE_UPDATE_FORMULA_FAIL = "update_formula_fail";
    private static final String COL_DEFINED = "col_defined_";
    private static final String INSERT_COMPONENT_FORMULA_COL = "insertComponentFormulaCol";
    public static final String IS_MODIFY = "is_modify";
    private static final String sfr = "sfr";
    private static final String sfc = "sfc";
    private static final List<String> rownumbers = Arrays.asList("account", "changetype");
    private static final Set<String> colnumbers = Sets.newHashSet((Object[])new String[]{"entity", "process", "audittrail", "currency"});

    private static OpNameMultiLangEnumBridge getOperationSave() {
        return new OpNameMultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58", "WorkPaperTemplatePlugin_1", FI_BCM_FORMPLUGIN, "Add Save");
    }

    private static String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"WorkPaperTemplatePlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initSpreadListener();
    }

    protected void initSpreadListener() {
        this.registerBeforeEvent(EventConstant.ActionName.ADD_ROW, this::operationCheck);
        this.registerBeforeEvent(EventConstant.ActionName.REMOVE_ROW, this::operationCheck);
        this.registerBeforeEvent(EventConstant.ActionName.ADD_COL, this::operationCheck);
        this.registerBeforeEvent(EventConstant.ActionName.REMOVE_COL, this::operationCheck);
        this.registerAfterEvent(EventConstant.ActionName.ADD_ROW, this::invokeAddOrRemove);
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_ROW, this::invokeAddOrRemove);
        this.registerAfterEvent(EventConstant.ActionName.ADD_COL, this::invokeAddOrRemove);
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_COL, this::invokeAddOrRemove);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)this.getModelId());
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), "template_spread");
        invoker.setWorksheetOptions(SpreadProperties.SetWorkSheetOptions.CLIPBOARDOPTIONS.k(), 0);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        this.registerBeforeEvent(EventConstant.ActionName.UPDATE_VALUE, event -> {
            Cell cell = (Cell)event.getSource();
            String pos = ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow());
            if (SpreadAreaUtil.isInArea((String)pos, this.getMdDataDomain()) && !TemplateVerification.getCanSetFormulDataArea(this.getTemplateModel(), this.getSpreadModel()).contains(cell.getRow())) {
                cell.setValue(null);
                this.getPageCache().put(CACHE_UPDATE_VALUE_FAIL, "true");
                event.setCancel(true);
                SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "template_spread", Lists.newArrayList((Object[])new Map[]{this.packedUpdateCellMap(cell.getRow(), cell.getCol(), null)}));
            }
        });
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_VALUE, event -> {
            if (!event.isCancel()) {
                Cell cell = (Cell)event.getSource();
                this.handleUpdateValueEvent(cell);
                if (cell.hasFormula() && (cell.getValue() == null || StringUtils.isEmpty((String)cell.getValue().toString()))) {
                    cell.setFormula(null);
                }
            }
        });
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_MULVALUE, event -> {
            if (this.getPageCache().get(CACHE_UPDATE_VALUE_FAIL) != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df\u4e0d\u80fd\u5f55\u5165\u6570\u503c\u3002", (String)"WorkPaperTemplatePlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.getPageCache().remove(CACHE_UPDATE_VALUE_FAIL);
            }
        });
        this.registerBeforeEvent(EventConstant.ActionName.UPDATE_FORMULA, event -> {
            Cell cell = (Cell)event.getSource();
            String pos = ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow());
            if (SpreadAreaUtil.isInArea((String)pos, this.getMdDataDomain()) && !TemplateVerification.getCanSetFormulDataArea(this.getTemplateModel(), this.getSpreadModel()).contains(cell.getRow())) {
                event.setCancel(true);
                cell.setFormula(null);
                SpreadClientInvoker.invokeSetFormulaMethod(this.getClientViewProxy(), "template_spread", Lists.newArrayList((Object[])new Map[]{this.packedSetFormulaCellMap(cell.getRow(), cell.getCol(), null)}));
                this.getPageCache().put(CACHE_UPDATE_FORMULA_FAIL, "true");
            }
        });
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_MULFORMULA, event -> {
            if (this.getPageCache().get(CACHE_UPDATE_FORMULA_FAIL) != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e95\u7a3f\u6a21\u677f\u6709\u6548\u6570\u636e\u533a\u57df\u5185\u7684\u5355\u5143\u683c\u4e0d\u80fd\u5f55\u5165\u516c\u5f0f\u3002", (String)"WorkPaperTemplatePlugin_34", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.getPageCache().remove(CACHE_UPDATE_FORMULA_FAIL);
            }
        });
    }

    private List<String> getMdDataDomain() {
        Set infos = this.getSpreadModel().getAreaManager().getPostionInfoSet();
        ArrayList<String> areaRangs = new ArrayList<String>(infos.size());
        if (infos == null || infos.isEmpty()) {
            return areaRangs;
        }
        infos.forEach(e -> areaRangs.add(e.getAreaRange()));
        return areaRangs;
    }

    private void handleUpdateValueEvent(Cell cell) {
        String input = cell.getValue() == null ? "" : cell.getValue().toString();
        Pair<Boolean, String> f7AndDimInfo = this.isF7Cell(cell);
        if (!((Boolean)f7AndDimInfo.p1).booleanValue()) {
            return;
        }
        cell.clearMembersOfUserObject();
        String dimNum = (String)f7AndDimInfo.p2;
        String entity = DimEntityNumEnum.getEntieyNumByNumber((String)dimNum);
        boolean isValidate = this.buildDimMemberGroup(() -> new QFilter("number", "=", (Object)dimNum).and(this.getQFilterByModelID()), () -> new QFilter("name", "=", (Object)input).or(new QFilter("number", "=", (Object)input)).and(this.getQFilterByModelID()), entity, cell);
        if (!isValidate) {
            this.mergeInvokeUpdateValueCommands(Lists.newArrayList((Object[])new Map[]{this.packedUpdateCellMap(cell.getRow(), cell.getCol(), null)}));
            cell.setValue(null);
        } else {
            this.mergeInvokeUpdateValueCommands(Lists.newArrayList((Object[])new Map[]{this.packedUpdateCellMap(cell.getRow(), cell.getCol(), ((IDimMember)cell.getMemberFromUserObject().get(0)).getName())}));
        }
    }

    private Pair<Boolean, String> isF7Cell(Cell cell) {
        boolean isF7;
        Set infos = this.getSpreadModel().getAreaManager().getPostionInfoSet();
        Recorder startRow = new Recorder((Object)-1);
        Recorder endRow = new Recorder((Object)-1);
        Recorder startCol = new Recorder((Object)-1);
        infos.forEach(e -> {
            String area = e.getAreaRange();
            RangeModel range = new RangeModel(area);
            if ((Integer)startRow.getRecord() > range.getY_start() || (Integer)startRow.getRecord() < 0) {
                startRow.setRecord((Object)range.getY_start());
            }
            if ((Integer)endRow.getRecord() < range.getY_end()) {
                endRow.setRecord((Object)range.getY_end());
            }
            if ((Integer)startCol.getRecord() < 0) {
                startCol.setRecord((Object)range.getX_start());
            }
        });
        if ((Integer)startCol.getRecord() == -1) {
            return Pair.onePair((Object)false, null);
        }
        TemplateModel templateModel = this.getTemplateModel();
        int rowDimSize = ((AreaRangeEntry)templateModel.getAreaRangeEntries().get(0)).getRowDimEntries().size();
        int firstCol = (Integer)startCol.getRecord() - rowDimSize;
        boolean bl = isF7 = cell.getRow() <= (Integer)endRow.getRecord() && cell.getRow() >= (Integer)startRow.getRecord() && cell.getCol() < (Integer)startCol.getRecord() && cell.getCol() >= firstCol;
        if (!isF7) {
            return Pair.onePair((Object)false, null);
        }
        String dimNum = ((RowDimensionEntry)((AreaRangeEntry)templateModel.getAreaRangeEntries().get(0)).getRowDimEntries().get(cell.getCol() - firstCol)).getDimension().getNumber();
        return Pair.onePair((Object)true, (Object)dimNum);
    }

    private boolean buildDimMemberGroup(Supplier<QFilter> dimFilter, Supplier<QFilter> membFilter, String entityNum, Cell cell) {
        boolean isValidate = true;
        DynamicObject dimDyna = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)"id,number,name", (QFilter[])new QFilter[]{dimFilter.get()});
        DynamicObject[] membDyna = BusinessDataServiceHelper.load((String)entityNum, (String)"id,number,name", (QFilter[])new QFilter[]{membFilter.get().and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex())), new QFilter("dimension.id", "=", dimDyna.get("id"))});
        if (membDyna != null && membDyna.length == 1) {
            IDimension dim = ObjectConvertUtils.toIDimension(dimDyna);
            IDimMember memb = ObjectConvertUtils.toDimMember(membDyna[0], dim);
            cell.addDim2UserObject(memb);
        } else {
            isValidate = false;
            cell.clearMembersOfUserObject();
        }
        return isValidate;
    }

    @Override
    public TemplateModel getTemplateModel() {
        if (super.getTemplateModel().isOldTemplate()) {
            boolean isSuccess = WorkPaperUpdataService.updateWorkPaperTemplate(this.template);
            this.template = ModelDataProvider.getTemplateModel(this.template.getId());
            DynamicObject templateDy = BusinessDataServiceHelper.loadSingle((Object)this.template.getId(), (String)"bcm_templateentity");
            this.template = new TemplateModel();
            this.template.loadDynaObj2Model(templateDy);
            if (isSuccess) {
                if (StringUtils.isEmpty((String)this.template.getRptData())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u635f\u574f\u3002", (String)"WorkPaperTemplatePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
                SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)this.template.getRptData());
                this.cacheSpreadModel(spreadManager);
                this.cacheTemplateModel(this.template);
                SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), "template_spread", this.template.getSpreadJson());
                this.setSelectCell(0, 0, 1, 1);
                this.setF7TypeCellOnSpreadJS(spreadManager, this.template);
                this.setViewSpreadJs();
                this.getPageCache().put(type, (String)spreadManager.getBook().getSheet(0).getUserObject(type));
            }
        }
        return this.template;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TemplateModel template = this.getTemplateModel();
        SpreadManager spreadManager = this.getSpreadModel();
        List areas = template.getAreaRangeEntries();
        if (areas.isEmpty()) {
            Predicate<Object> p = t -> t == null;
            this.setCatalog2Model(p, template);
            this.initTemplate(template);
            this.cacheTemplateModel();
            this.getPageCache().put(type, WorkPaperEnum.EASY.getNumber());
            this.getPageCache().put("isnew", "true");
        } else {
            if (this.getFormCustomParam("read") != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53ea\u6709\u67e5\u8be2\u6743\u9650\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"WorkPaperTemplatePlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            Sheet sheet = spreadManager.getBook().getSheet(0);
            this.getTemplateModel().setDataUnit(sheet.getUserObject("dataunit").toString());
            this.getPageCache().put(type, (String)sheet.getUserObject(type));
            this.getPageCache().put("isnew", "false");
        }
        this.getModel().setValue("number", (Object)template.getNumber());
        this.getPageCache().put("savednum", template.getNumber());
        this.getModel().setValue("name", (Object)template.getName());
        this.getModel().setValue("permclass", template.getPermClass());
        this.getModel().setValue("dataunit", (Object)Integer.parseInt(template.getDataUnit()));
        this.getModel().setValue("description", (Object)template.getDescription());
        this.cacheTemplateModel();
        String json = template.getSpreadJson() != null ? template.getSpreadJson() : spreadManager.getBook().toJSon();
        try {
            this.registerFormula();
        }
        catch (Exception ex) {
            log.error("table template register formula error:" + ex.getMessage());
        }
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), "template_spread", json);
        this.buildRowData(template, spreadManager);
        this.cacheSpreadModel();
        this.dealLockSysHead(true);
        SpreadEasyInvoker spreadEasyInvoker = new SpreadEasyInvoker(this.getClientViewProxy(), "template_spread");
        spreadEasyInvoker.addContextMenuItem("moveForwards", ResManager.loadKDString((String)"\u5de6\u79fb", (String)"WorkPaperTemplatePlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), new String[]{COL_HEADER});
        spreadEasyInvoker.addContextMenuItem("moveBackwards", ResManager.loadKDString((String)"\u53f3\u79fb", (String)"WorkPaperTemplatePlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), new String[]{COL_HEADER});
        this.supportGroupRC(spreadEasyInvoker);
        if (!areas.isEmpty()) {
            this.setViewSpreadJs();
        }
        this.registSpreadShortcutKey();
    }

    @Override
    protected void registSpreadShortcutKey() {
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), "template_spread", "upgradeWpHistoryData", "U", true, true, true);
    }

    public void upgradeWpHistoryData() {
        UpgradeWorkPaperTemplateUtil.upgradeWpTemplate((Long)this.getModelId());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u5e95\u7a3f\u5386\u53f2\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"WorkPaperTemplatePlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
    }

    private void dealLockSysHead(boolean isLock) {
        MultiAreaPositionsManager areaManager = this.getSpreadModel().getAreaManager();
        List areaRangeEntries = this.getTemplateModel().getAreaRangeEntries();
        if (areaManager != null && areaManager.getPostionInfoSet() != null && areaRangeEntries != null && !areaRangeEntries.isEmpty()) {
            int rowDimSize = ((AreaRangeEntry)areaRangeEntries.get(0)).getRowDimEntries().size();
            Pair<Point, Point> pair = this.getAreaRange(areaManager.getPostionInfoSet());
            Point startPoint = (Point)pair.p1;
            Point endPoint = (Point)pair.p2;
            if (startPoint != null && endPoint != null) {
                SpreadEasyInvoker easyInvoker = new SpreadEasyInvoker(this.getClientViewProxy(), "template_spread");
                int c = startPoint.x - rowDimSize;
                if (isLock) {
                    easyInvoker.lockCell(startPoint.y - 1, c, 1, endPoint.x - c + 1);
                } else {
                    easyInvoker.unlockCell(startPoint.y - 1, c, 1, endPoint.x - c + 1);
                }
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (btn_save.equals(key)) {
            QueryAnalysisPermHelper.checkModelFunctionPerm(this.getModelId(), this.getBizAppId(), "bcm_paperlist", this.getFormCustomParam("read") != null);
            this.handleSaveEvent();
        } else if (btn_dimsetting.equals(key)) {
            this.openFormPage();
        } else if (key.matches("btn_name|btn_number|btn_numname")) {
            this.getModel().setValue("showtype", (Object)key);
            this.changeDisplay();
            this.cacheSpreadModel();
        } else if ("bar_info".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_templateentity");
            formShowParameter.setParentPageId(this.getView().getPageId());
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            TemplateModel templateModel = this.getTemplateModel();
            QFilter filter2 = new QFilter("id", "!=", (Object)templateModel.getId());
            QFilter filter = new QFilter("group", "=", (Object)templateModel.getGroup());
            QFilter[] filters = new QFilter[]{filter2, filter};
            boolean flag = QueryServiceHelper.exists((String)"bcm_templateentity", (QFilter[])filters);
            formShowParameter.setStatus(OperationStatus.EDIT);
            formShowParameter.setCustomParam("exist", (Object)(!flag ? 1 : 0));
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"WorkPaperTemplatePlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            formShowParameter.setCustomParam(this.KEY_TEMPLATE_MODEL, (Object)this.getTemplateModelSerial());
            formShowParameter.setCustomParam("templatetype", (Object)TemplateCatalogEnum.MERGE_WP.getNumber());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "callBack4BaseSetting");
            formShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(formShowParameter);
        } else if ("btn_newrptinfo".equals(key)) {
            this.showFormula();
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        this.setModified(false);
        if (event.getCallBackId().equals("confirm")) {
            if (Objects.equal((Object)event.getResult(), (Object)MessageBoxResult.Yes)) {
                this.openFormPage();
            }
        } else if (event.getCallBackId().equals("save_comfirm")) {
            this.cacheTrueOrFalseFlag("close_window", true);
            if (Objects.equal((Object)event.getResult(), (Object)MessageBoxResult.Yes)) {
                QueryAnalysisPermHelper.checkModelFunctionPerm(this.getModelId(), this.getBizAppId(), "bcm_paperlist", this.getFormCustomParam("read") != null);
                this.handleSaveEvent();
            } else {
                this.getView().close();
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        if ((this.isModified() || this.getSpreadModel().hasModified(false)) && !this.isTrueFlagInCache("close_window")) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6a21\u677f\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u662f\u5426\u8fdb\u884c\u4fdd\u5b58\uff1f", (String)"WorkPaperTemplatePlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("save_comfirm", (IFormPlugin)this));
            e.setCancel(true);
        } else {
            super.beforeClosed(e);
        }
    }

    private void handleSaveEvent() {
        if (StringUtils.isEmpty((String)((String)this.getModel().getValue("number")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u7f16\u7801\u3002", (String)"WorkPaperTemplatePlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((String)((String)this.getModel().getValue("name")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u540d\u79f0\u3002", (String)"WorkPaperTemplatePlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (this.getPageCache().get("savednum") != null && !this.getModel().getValue("number").toString().equals(this.getPageCache().get("savednum"))) {
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            qFilter.and("number", "=", (Object)this.getModel().getValue("number").toString());
            qFilter.and("templatetype", "=", (Object)String.valueOf(TemplateTypeEnum.MSN.getType()));
            if (QueryServiceHelper.exists((String)"bcm_templateentity", (QFilter[])new QFilter[]{qFilter})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"WorkPaperTemplatePlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        if (this.checkStatus()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u7684\u5de5\u4f5c\u5e95\u7a3f\u6a21\u677f\uff0c\u53ea\u80fd\u67e5\u770b\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"WorkPaperTemplatePlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (this.checkExistArea()) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("callback", "invokeAction");
            params.put("invokemethod", "actionSave");
            SpreadClientInvoker.invokeGetSpreadJsonMethod(this.getClientViewProxy(), "template_spread", params);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u9875\u9762\u5e03\u5c40\u3002", (String)"WorkPaperTemplatePlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private boolean checkStatus() {
        Long templateId = this.getTemplateModel().getId();
        Map<Long, DynamicObject> templateStatus = TemplateUtil.getTemplateStatus(new Object[]{templateId});
        if (templateStatus.get(templateId) != null && "1".equals(templateStatus.get(templateId).getString("status"))) {
            return true;
        }
        this.getTemplateModel().setStatus("0");
        this.cacheTemplateModel(this.getTemplateModel());
        return false;
    }

    private boolean checkExistArea() {
        TemplateModel model = this.getTemplateModel();
        return !model.getAreaRangeEntries().isEmpty();
    }

    public void actionSave(String spreadJson) {
        TemplateModel template = this.getTemplateModel();
        this.getEffectiveSheet().setSheetName(template.getName());
        template.setIsOldTemplate(false);
        template.setIsOnlyRead(true);
        template.setNumber((String)this.getModel().getValue("number"));
        template.setName((String)this.getModel().getValue("name"));
        template.setDescription((String)this.getModel().getValue("description"));
        template.setPermClass(this.getModel().getValue("permclass"));
        Object dataUnit = this.getModel().getValue("dataunit");
        spreadJson = this.beforeSaveTemplate(spreadJson, true, new ArrayList<Map<String, Object>>(16));
        this.getEffectiveSheet().putUserObject("dataunit", (Object)(dataUnit == null ? 0 : Integer.parseInt(dataUnit.toString())));
        String showType = this.getShowType();
        this.getEffectiveSheet().putUserObject("wb_showType", (Object)showType.replace("btn_", "btn_row_"));
        template.setModifierId(this.getUserId());
        template.setModifyTime(this.getCurrentSysTime());
        if (StringUtils.isNotEmpty((String)spreadJson)) {
            template.setSpreadJson(spreadJson);
        }
        template.setData(this.getSpreadModelSerial());
        SpreadManager spreadCopy = this.getCopyOfSpread();
        template.setRptSpreadJson(TempFormulaUtil.removeAccFormula(spreadCopy, template.getSpreadJson()));
        FreeStyleTemplateFinalBuilder builder = new FreeStyleTemplateFinalBuilder(spreadCopy, template);
        builder.doBuildReport(true, false);
        template.setRptData(this.getSpreadModelSerial(spreadCopy));
        WorkPaperUtil.syncSmColumnToTemplate(spreadCopy, template);
        QFilter filter = new QFilter("model", "=", (Object)template.getModelId());
        filter.and("number", "=", (Object)template.getNumber());
        filter.and("group", "!=", (Object)template.getGroup());
        filter.and("templatetype", "=", (Object)String.valueOf(TemplateTypeEnum.MSN.getType()));
        QFilter permClassFilter = new QFilter("model", "=", (Object)template.getModelId());
        permClassFilter = permClassFilter.and(new QFilter("entityname", "=", (Object)"bcm_templateentity"));
        permClassFilter.and(new QFilter("entityid", "=", (Object)template.getId()));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_permclass_entity", (String)"permclass.id,permclass.number", (QFilter[])new QFilter[]{permClassFilter});
        if (QueryServiceHelper.exists((String)"bcm_templateentity", (QFilter[])new QFilter[]{filter})) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u540c\u4e00\u4f53\u7cfb\u4e0b\u5df2\u7ecf\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u6a21\u677f\u3002", (String)"WorkPaperTemplatePlugin_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), template.getNumber()));
        } else {
            template.setTemplateType(TemplateTypeEnum.MSN.getType());
            this.ScanSpreadMemberFill2TemplateModel(spreadCopy);
            DynamicObject t = template.genDynamicObject();
            t.set("status", template.getStatus() == null ? Character.valueOf('0') : template.getStatus().getStatuValue());
            try (TXHandle tx = TX.required((String)"bcm_template_save");){
                try {
                    BusinessDataWriter.delete((IDataEntityType)t.getDataEntityType(), (Object[])new Object[]{t.getPkValue()});
                    BusinessDataWriter.save((IDataEntityType)t.getDataEntityType(), (Object[])new Object[]{t});
                    PermClassEntityHelper.savePermClass((DynamicObject)t);
                    TemplateServiceHelper.removeTemplateModelCacheByIds((Object)this.getModelId(), (Object[])new Object[]{template.getId()});
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
            SpreadUtils.updateCellOnUnchangeState(this.getSpreadModel().getBook(), false);
            if ("true".equals(this.getPageCache().get("isnew"))) {
                this.getPageCache().put("isnew", "false");
                this.writeOperationLog(WorkPaperTemplatePlugin.getOperationSave(), template.getNumber(), template.getName(), WorkPaperTemplatePlugin.getOperationStstusSuccess());
            }
            String bizAppId = "cm";
            DataPermLogHelper.saveDataPermissionLogs((Long)template.getModelId(), (String)template.getNumber(), (DynamicObject)((DynamicObject)template.getPermClass()), (DynamicObject)dynamicObject, (DataPermLogMultiLangEnum)DataPermLogMultiLangEnum.DistributeObject_WORK_PAPER_TEMPLATE, (WatchLogger)log, (String)bizAppId);
            this.setModified(false);
            this.cacheTemplateModel();
            this.cacheSpreadModel();
            this.getPageCache().put("savednum", (String)this.getModel().getValue("number"));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"WorkPaperTemplatePlugin_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            if (this.isTrueFlagInCache("close_window")) {
                this.getView().close();
            }
        }
    }

    private void ScanSpreadMemberFill2TemplateModel(SpreadManager spreadCopy) {
        TemplateScanMemberService service = new TemplateScanMemberService(this.getSpreadModel(), this.getTemplateModel());
        service.scan();
    }

    public void openFormPage() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", "actionGetSpreadJson");
        SpreadClientInvoker.invokeGetSpreadJsonMethod(this.getClientViewProxy(), "template_spread", params);
    }

    public void actionGetSpreadJson(String spreadJson) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_paper_pagesetting");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u9875\u9762\u5e03\u5c40", (String)"WorkPaperTemplatePlugin_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        if (StringUtils.isNotEmpty((String)spreadJson)) {
            this.getTemplateModel().setSpreadJson(spreadJson);
        }
        this.getTemplateModel().setRptSpreadJson(this.getTemplateModel().getSpreadJson());
        formShowParameter.setCustomParam(this.KEY_TEMPLATE_MODEL, (Object)this.getTemplateModelSerial());
        formShowParameter.setCustomParam("columns", (Object)WorkPaperUtil.getColumnListStr(this.getSpreadModel()));
        formShowParameter.setCustomParam(type, (Object)this.getPageCache().get(type));
        formShowParameter.setCustomParam("startrow", (Object)this.getSelectorStartRow());
        formShowParameter.setCustomParam("startcol", (Object)this.getSelectorStartCol());
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "callBack4DimSetting");
        formShowParameter.setCloseCallBack(callBack);
        this.getView().showForm(formShowParameter);
    }

    private void autoMaxRowOrCol(TemplateModel template) {
        Pair<Point, Point> areaRange = this.getAreaRange(template);
        Sheet sheet = this.getEffectiveSheet();
        if (areaRange != null && areaRange.p2 != null && (sheet.getMaxRowCount() <= 2000 || sheet.getMaxRowCount() <= 52)) {
            JSONObject object = JSONObject.parseObject((String)JsonSerializerUtil.uncompress((String)template.getSpreadJson()));
            JSONObject sheets = (JSONObject)object.get((Object)"sheets");
            JSONObject sheetObj = (JSONObject)sheets.values().iterator().next();
            int maxRow = sheetObj.getInteger("rowCount");
            int maxCol = sheetObj.getInteger("columnCount");
            if (((Point)areaRange.p2).y + 1 > maxRow && sheet.getMaxRowCount() <= 2000) {
                SpreadClientInvoker.appendRows(this.getClientViewProxy(), "template_spread", maxRow - 1, ((Point)areaRange.p2).y + 1 - maxRow);
            }
            if (((Point)areaRange.p2).x + 1 > maxCol && sheet.getMaxRowCount() <= 52) {
                LinkedHashMap<String, Integer> count = new LinkedHashMap<String, Integer>(16);
                count.put("count", ((Point)areaRange.p2).x + 1 - maxCol);
                SpreadClientInvoker.invokeAppendCols(this.getClientViewProxy(), "template_spread", count);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "callBack4DimSetting": {
                if (closedCallBackEvent.getReturnData() == null) break;
                Tuple pair = (Tuple)ObjectSerialUtil.deSerializedBytes((String)((String)closedCallBackEvent.getReturnData()));
                TemplateModel template = (TemplateModel)pair.p1;
                SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)((String)pair.p2));
                String type = (String)pair.p3;
                this.fillData2SpreadModel(template, spreadManager, type);
                spreadManager.getBook().getSheet(0).setSheetName(template.getName());
                this.dealLockSysHead(false);
                this.clearFormula();
                this.clearF7TypeCellOnSpreadJS();
                this.autoMaxRowOrCol(template);
                this.resetSpreadJson(spreadManager);
                this.buildRowData(template, spreadManager);
                this.cacheTemplateModel(template);
                this.cacheSpreadModel(spreadManager);
                this.template = null;
                this.spread = null;
                this.getPageCache().remove(ROW);
                this.setF7TypeCellOnSpreadJS(spreadManager, template);
                this.dealLockSysHead(true);
                this.setViewSpreadJs();
                this.getPageCache().put(type, type);
                break;
            }
            case "cellF7": {
                this.handleCellF7ReturnValues(closedCallBackEvent);
                this.cacheSpreadModel();
                break;
            }
            case "insertComponentFormulaCol": {
                this.fillBackSheet(closedCallBackEvent);
                break;
            }
            case "callBack4BaseSetting": {
                this.cacheReturnTemplateSerial(closedCallBackEvent);
                this.getModel().setValue("number", (Object)this.getTemplateModel().getNumber());
                this.getModel().setValue("name", (Object)this.getTemplateModel().getName());
                this.getModel().setValue("permclass", this.getTemplateModel().getPermClass());
                this.getModel().setValue("dataunit", (Object)Integer.parseInt(this.getTemplateModel().getDataUnit()));
                this.getModel().setValue("description", (Object)this.getTemplateModel().getDescription());
                break;
            }
            case "setFormula": {
                if (closedCallBackEvent.getReturnData() == null) break;
                this.handleCallBackFormula(closedCallBackEvent.getReturnData().toString());
                break;
            }
        }
    }

    private void resetSpreadJson(SpreadManager spreadManager) {
        HashMap<String, Integer> map;
        Set postionInfoSet = this.getSpreadModel().getAreaManager().getPostionInfoSet();
        ArrayList cellValues = new ArrayList(16);
        AtomicReference oldLastRow = new AtomicReference();
        AtomicReference oldStartCol = new AtomicReference();
        AtomicReference oldStartRow = new AtomicReference();
        if (!postionInfoSet.isEmpty()) {
            int size = ((AreaRangeEntry)this.getTemplateModel().getAreaRangeEntries().get(0)).getRowDimEntries().size();
            postionInfoSet.forEach(positionInfo -> {
                HashMap<String, Integer> e;
                int i;
                String startRange = positionInfo.getAreaRange().split(":")[0];
                String endRange = positionInfo.getAreaRange().split(":")[1];
                Point startPoint = ExcelUtils.pos2Point((String)startRange);
                Point endPoint = ExcelUtils.pos2Point((String)endRange);
                for (i = startPoint.x; i <= endPoint.x; ++i) {
                    e = new HashMap<String, Integer>(10);
                    e.put("r", startPoint.y - 1);
                    e.put("c", i);
                    e.put("v", null);
                    cellValues.add(e);
                }
                for (i = startPoint.x - size; i < startPoint.x; ++i) {
                    for (int j = startPoint.y - 1; j <= endPoint.y; ++j) {
                        e = new HashMap(10);
                        e.put("r", j);
                        e.put("c", i);
                        e.put("v", null);
                        cellValues.add(e);
                    }
                }
                if (oldStartRow.get() == null || (Integer)oldStartRow.get() > startPoint.y) {
                    oldStartRow.set(startPoint.y);
                }
                if (oldStartCol.get() == null) {
                    oldStartCol.set(Math.max(endPoint.x, startPoint.x));
                }
                int lastRow = Math.max(endPoint.y, startPoint.y);
                if (oldLastRow.get() == null || (Integer)oldLastRow.get() < lastRow) {
                    oldLastRow.set(lastRow);
                }
            });
        }
        AtomicReference newLastRow = new AtomicReference();
        AtomicReference newStartCol = new AtomicReference();
        AtomicReference newStartRow = new AtomicReference();
        postionInfoSet = spreadManager.getAreaManager().getPostionInfoSet();
        if (!postionInfoSet.isEmpty()) {
            postionInfoSet.forEach(positionInfo -> {
                int lastRow;
                String startRange = positionInfo.getAreaRange().split(":")[0];
                String endRange = positionInfo.getAreaRange().split(":")[1];
                Point startPoint = ExcelUtils.pos2Point((String)startRange);
                Point endPoint = ExcelUtils.pos2Point((String)endRange);
                for (int i = startPoint.x; i <= endPoint.x; ++i) {
                    HashMap<String, Object> e = new HashMap<String, Object>(10);
                    e.put("r", startPoint.y - 1);
                    e.put("c", i);
                    e.put("v", spreadManager.getBook().getSheet(0).getCell(startPoint.y - 1, i).getValue());
                    cellValues.add(e);
                }
                if (newStartRow.get() == null || (Integer)newStartRow.get() > startPoint.y) {
                    newStartRow.set(startPoint.y);
                }
                if (newStartCol.get() == null) {
                    newStartCol.set(endPoint.x);
                }
                int n = lastRow = endPoint.y > startPoint.y ? endPoint.y : startPoint.y;
                if (newLastRow.get() == null || (Integer)newLastRow.get() < lastRow) {
                    newLastRow.set(lastRow);
                }
            });
        }
        boolean isAdd = false;
        if (oldLastRow.get() != null && newLastRow.get() != null && (Integer)oldLastRow.get() - (Integer)newLastRow.get() != 0) {
            map = new HashMap<String, Integer>(10);
            isAdd = (Integer)oldLastRow.get() < (Integer)newLastRow.get();
            map.put("index", isAdd ? (Integer)oldLastRow.get() : Integer.valueOf((Integer)newLastRow.get() + 1));
            map.put("count", Math.abs((Integer)oldLastRow.get() - (Integer)newLastRow.get()));
            this.frontRowOrColOperation(map, isAdd, true);
        }
        if (oldStartCol.get() != null && newStartCol.get() != null && (Integer)oldStartCol.get() - (Integer)newStartCol.get() != 0) {
            map = new HashMap(10);
            isAdd = (Integer)oldStartCol.get() < (Integer)newStartCol.get();
            map.put("index", isAdd ? (Integer)oldStartCol.get() : Integer.valueOf((Integer)newStartCol.get() + 1));
            map.put("count", Math.abs((Integer)oldStartCol.get() - (Integer)newStartCol.get()));
            this.frontRowOrColOperation(map, isAdd, false);
            if (isAdd && (Integer)oldStartRow.get() - (Integer)newStartRow.get() != 0) {
                HashMap<String, Integer> e = new HashMap<String, Integer>(10);
                e.put("r", (Integer)oldStartRow.get() - 1);
                e.put("c", (Integer)newStartCol.get());
                e.put("v", null);
                cellValues.add(e);
            }
        }
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "template_spread", cellValues);
    }

    private void frontRowOrColOperation(Map map, boolean isAdd, boolean isRow) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(10);
        linkedHashMap.put("data", Collections.singletonList(map));
        if (isAdd) {
            if (isRow) {
                linkedHashMap.put("dir", "bottom");
                SpreadClientInvoker.invokeInsertRow(this.getClientViewProxy(), "template_spread", linkedHashMap);
                return;
            }
            linkedHashMap.put("dir", "after");
            SpreadClientInvoker.invokeInsertCol(this.getClientViewProxy(), "template_spread", linkedHashMap);
            return;
        }
        if (isRow) {
            SpreadClientInvoker.invokeDelRow(this.getClientViewProxy(), "template_spread", linkedHashMap);
            return;
        }
        SpreadClientInvoker.invokeDelCol(this.getClientViewProxy(), "template_spread", linkedHashMap);
    }

    private void cacheReturnTemplateSerial(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        TemplateModel template = (TemplateModel)this.getReturnData(closedCallBackEvent);
        if (template != null) {
            this.cacheTemplateModel(template);
            this.template = template;
        }
    }

    private void clearF7TypeCellOnSpreadJS() {
        MultiAreaPositionsManager areaManager = this.getSpreadModel().getAreaManager();
        List areaRangeEntries = this.getTemplateModel().getAreaRangeEntries();
        if (areaManager != null && !areaManager.getPostionInfoSet().isEmpty() && !areaRangeEntries.isEmpty()) {
            int wpRowDimSize = 0;
            for (AreaRangeEntry areaRangeEntry : areaRangeEntries) {
                List rowDimEntries = areaRangeEntry.getRowDimEntries();
                if (rowDimEntries.isEmpty()) continue;
                wpRowDimSize = rowDimEntries.size();
                break;
            }
            Set postionInfoSet = areaManager.getPostionInfoSet();
            Pair<Point, Point> pair = this.getAreaRange(postionInfoSet);
            this.setCellFormat(((Point)pair.p1).y, ((Point)pair.p1).x - wpRowDimSize, ((Point)pair.p2).y - ((Point)pair.p1).y + 1, wpRowDimSize);
        }
    }

    private void setCellFormat(int r, int c, int rc, int cc) {
        ArrayList rangeList = new ArrayList();
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>();
        rangeMap.put(SpreadProperties.ResetCellMethod.R.k(), r);
        rangeMap.put(SpreadProperties.ResetCellMethod.C.k(), c);
        rangeMap.put(SpreadProperties.ResetCellMethod.RC.k(), rc);
        rangeMap.put(SpreadProperties.ResetCellMethod.CC.k(), cc);
        rangeList.add(rangeMap);
        HashMap features = new HashMap();
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        SpreadClientInvoker.invokeResetCellMethod(this.getClientViewProxy(), "template_spread", features);
    }

    private Pair<Point, Point> getAreaRange(Set<PositionInfo> postionInfoSet) {
        Point startPoint = null;
        Point endPoint = null;
        for (PositionInfo ps : postionInfoSet) {
            String areaRange = ps.getAreaRange();
            String[] split = areaRange.split(":");
            Point currentStartPoint = ExcelUtils.pos2Point((String)split[0]);
            Point currentEndPoint = ExcelUtils.pos2Point((String)split[1]);
            if (startPoint == null || endPoint == null) {
                startPoint = currentStartPoint;
                endPoint = currentEndPoint;
                continue;
            }
            if (startPoint.y > currentStartPoint.y) {
                startPoint = currentStartPoint;
            }
            if (endPoint.y >= currentEndPoint.y) continue;
            endPoint = currentEndPoint;
        }
        return Pair.onePair(startPoint, endPoint);
    }

    private void setF7TypeCellOnSpreadJS(SpreadManager sm, TemplateModel template) {
        sm.getAreaManager().forEach(area -> {
            String[] areaRange = ((PositionInfo)area.getKey()).getAreaRange().split(":");
            int[] startXY = ExcelUtils.pos2XY((String)areaRange[0]);
            int[] endXY = ExcelUtils.pos2XY((String)areaRange[1]);
            AreaRangeEntry entry = this.getOverlapAreaRange(((PositionInfo)area.getKey()).getAreaRange(), template);
            if (entry != null) {
                for (int i = 0; i < entry.getRowDimEntries().size(); ++i) {
                    this.constructF7TypeFeature(1, startXY, endXY, i + 1);
                }
            }
        });
    }

    private AreaRangeEntry getOverlapAreaRange(String tarArea, TemplateModel template) {
        for (AreaRangeEntry e : template.getAreaRangeEntries()) {
            if (!ExcelUtils.isOverlap((String)e.getAreaRange(), (String)tarArea)) continue;
            return e;
        }
        return null;
    }

    private void constructF7TypeFeature(int selectType, int[] startXY, int[] endXY, int offset) {
        HashMap<String, Serializable> features = new HashMap<String, Serializable>(16);
        ArrayList items = new ArrayList(10);
        for (int r = startXY[1]; r <= endXY[1]; ++r) {
            HashMap<String, Integer> feature = new HashMap<String, Integer>(16);
            feature.put(SpreadProperties.SetF7TypeCellMethod.R.k(), r);
            feature.put(SpreadProperties.SetF7TypeCellMethod.C.k(), startXY[0] - offset);
            items.add(feature);
        }
        features.put(SpreadProperties.SetF7TypeCellMethod.CELL.k(), items);
        features.put(SpreadProperties.SetF7TypeCellMethod.SELECTTYPE.k(), Integer.valueOf(selectType));
        SpreadClientInvoker.invokeSetF7TypeCellMethod(this.getClientViewProxy(), "template_spread", features);
    }

    @Override
    public void spreadF7Click(int r, int c) {
        super.spreadF7Click(r, c);
        String dimNum = this.findEntityNum(r, c);
        if (dimNum == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u7f16\u8f91\u62d6\u62fd\u65b9\u5f0f\u751f\u6210\u7684\u5355\u5143\u683c\u3002", (String)"WorkPaperTemplatePlugin_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        QFilter numberFilter = new QFilter("number", "=", (Object)dimNum);
        DynamicObject dimObj = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)"id,number,name,dseq,membermodel", (QFilter[])new QFilter[]{this.getQFilterByModelID(), numberFilter});
        BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dimObj.getLong("id"), "cellF7", null, true);
        f7.setCallBackClassName(this.getClass().getName());
        f7.setDisplayAllFyOrPeriodMemb(true);
        f7.click();
    }

    private void fillData2SpreadModel(TemplateModel template, SpreadManager spreadManager, String type) {
        String headerName;
        int i;
        String firstStartPosition = ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getStartPosition();
        int[] xy = ExcelUtils.pos2XY((String)firstStartPosition);
        int rowDimAmount = ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getRowDimEntries().size();
        int areaRowSum = 0;
        for (AreaRangeEntry areaRangeEntry : template.getAreaRangeEntries()) {
            int areaRowAmount = SpreadAreaUtil.calcAreaRowAmount((String)areaRangeEntry.getAreaRange());
            areaRowSum = areaRowAmount + areaRowSum;
        }
        Sheet sheet = spreadManager.getBook().getSheet(0);
        sheet.putUserObject(type, (Object)type);
        int startCellRowIdx = xy[1] - 1;
        int startCellColIdx = xy[0] - rowDimAmount;
        for (int i2 = 0; i2 < rowDimAmount; ++i2) {
            Cell cell = sheet.getCell(startCellRowIdx, i2 + startCellColIdx);
            cell.setValue((Object)((RowDimensionEntry)((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getRowDimEntries().get(i2)).getDimension().getName());
        }
        List<Column> headerList = WorkPaperUtil.getColumnList(spreadManager);
        ArrayList<Column> headerListCopy = new ArrayList<Column>();
        for (i = 0; i < headerList.size(); ++i) {
            Column column = headerList.get(i);
            if (column.getLoanShow().booleanValue()) {
                headerName = column.getHeaderName();
                column.setHeaderName(String.format(ResManager.loadKDString((String)"%s\u501f\u65b9", (String)"WorkPaperTemplatePlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), headerName));
                headerListCopy.add(column);
                Column column1 = new Column(column.getNumber(), headerName, column.getColIndex(), column.getDisplayChild().booleanValue(), column.getFormula(), column.getLoanShow().booleanValue());
                column1.setHeaderName(String.format(ResManager.loadKDString((String)"%s\u8d37\u65b9", (String)"WorkPaperTemplatePlugin_22", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), headerName));
                headerListCopy.add(column1);
                continue;
            }
            headerListCopy.add(column);
        }
        for (i = 0; i < headerListCopy.size(); ++i) {
            Cell cell = sheet.getCell(startCellRowIdx, i + rowDimAmount + startCellColIdx);
            headerName = ((Column)headerListCopy.get(i)).getHeaderName();
            cell.setValue((Object)headerName);
        }
        List areaRangeEntries = template.getAreaRangeEntries();
        int areaLenth = 0;
        for (AreaRangeEntry areaRangeEntry : areaRangeEntries) {
            ArrayList<List<Member>> matrix = new ArrayList<List<Member>>(10);
            for (RowDimensionEntry rowDimensionEntry : areaRangeEntry.getRowDimEntries()) {
                List<Member> list = WorkPaperUtil.analyzRowEntryMember(rowDimensionEntry, template.getModelId());
                matrix.add(list);
            }
            List result = Lists.cartesianProduct(matrix);
            for (int i3 = 0; i3 < result.size(); ++i3) {
                List row = (List)result.get(i3);
                for (int j = 0; j < row.size(); ++j) {
                    int r = i3 + 1 + startCellRowIdx + areaLenth;
                    int c = j + startCellColIdx;
                    Cell cell = sheet.getCell(r, c);
                    Member member = (Member)row.get(j);
                    cell.addDim2UserObject(this.getEasyIDimMember(member));
                    cell.setValue((Object)member.getName());
                }
            }
            areaLenth += result.size();
        }
    }

    private IDimMember getEasyIDimMember(Member member) {
        kd.fi.bcm.spread.model.Dimension dimension = new kd.fi.bcm.spread.model.Dimension(member.getDimension().getName(), member.getDimension().getNumber(), null);
        return new DimMember(member.getName(), member.getNumber(), null, (IDimension)dimension);
    }

    private void setCatalog2Model(Predicate<Object> p, TemplateModel template) {
        if (null != this.getFormCustomParam("catalog")) {
            QFilter filter = new QFilter("id", "=", this.getFormCustomParam("catalog"));
            DynamicObject log = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_templatecatalog", (String)"id,name", (QFilter[])new QFilter[]{filter});
            template.setTemplateCatalog(this.defaultIfNull(p, log, null, value -> {
                TemplateCatalog catalog = new TemplateCatalog();
                DynamicObject v = (DynamicObject)value;
                catalog.setId(v.getLong("id"));
                catalog.setName(v.getString("name"));
                return catalog;
            }));
        }
        this.getPageCache().put(this.KEY_TEMPLATE_MODEL, this.getTemplateModelSerial());
    }

    private <R> R defaultIfNull(Predicate<Object> p, Object obj, R defaultValue, Function<Object, R> f) {
        if (p.test(obj)) {
            return defaultValue;
        }
        return f.apply(obj);
    }

    private void initTemplate(TemplateModel template) {
        this.setDefaultValue2cache(this, template);
        WorkPaperTemplatePlugin.fillBack2TemplateModel(this, template);
        template.getViewPointDimensionEntries().clear();
    }

    private void setDefaultValue2cache(AbstractTemplateBasePlugin page, TemplateModel tem) {
        List<Map<String, String>> list = WorkPaperTemplatePlugin.getPointEntry(page, tem);
        for (Map<String, String> map : list) {
            DefaultDimSettingEnum dimSetting = DefaultDimSettingEnum.getDefaultDimSettingEnumByEntity((String)map.get("entity"), (String)page.getBizAppId());
            if (!GENERAL.equals(map.get("panel"))) continue;
            if (dimSetting != null) {
                String number = dimSetting.getNumber();
                if ("ICNone".equals(number) || "MCNone".equals(number)) {
                    TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), number, 10, page, tem);
                    continue;
                }
                TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), number, dimSetting.getRange(), page, tem);
                continue;
            }
            if ("multigaap".equals(map.get("sign"))) {
                TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), "PRCGAAP", 10, page, tem);
                continue;
            }
            if ("datasort".equals(map.get("sign"))) {
                TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), "Actual", 10, page, tem);
                continue;
            }
            TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), map.get("shortnumber") + "None", 10, page, tem);
        }
    }

    public static void fillBack2TemplateModel(AbstractTemplateBasePlugin page, TemplateModel tem) {
        TemplateModel template = tem;
        ArrayList<Map<String, String>> general = new ArrayList<Map<String, String>>();
        List<Map<String, String>> allponit = WorkPaperTemplatePlugin.getPointEntry(page, tem);
        for (Map<String, String> map : allponit) {
            if (!GENERAL.equals(map.get("panel"))) continue;
            general.add(map);
        }
        TemplateDimSettingUtil.handlePageEntryFilltoTemplateModel(template, general, page);
    }

    public static List<String> getRowCacheList(IPageCache pageCache, TemplateModel template) {
        List<Object> result = new ArrayList();
        if (pageCache.get(ROW) == null) {
            List areas = template.getAreaRangeEntries();
            if (areas.isEmpty()) {
                result = template.getModelId() == 0L || !MemberReader.isExistChangeTypeDimension((long)template.getModelId()) ? Collections.singletonList("account") : rownumbers;
                DynamicObjectCollection dims = (DynamicObjectCollection)ThreadCache.get((Object)(template.getModelId() + "dims"), () -> QueryDimensionServiceHelper.getDimensionBaseInfos((Object)template.getModelId()));
                List rowNums = dims.stream().map(d -> d.getString("number").toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
                ArrayList<String> commonDimResult = new ArrayList<String>(16);
                for (PageDimensionEntry pageEntry : template.getPageDimensionEntries()) {
                    commonDimResult.add(pageEntry.getDimension().getNumber().toLowerCase(Locale.ENGLISH));
                }
                for (PageDimPropEntry pagePropEntry : template.getPagePropEntries()) {
                    commonDimResult.add(pagePropEntry.getDimension().getNumber().toLowerCase(Locale.ENGLISH));
                }
                rowNums.removeAll(commonDimResult);
                rowNums.removeAll(colnumbers);
                result = rowNums;
            } else {
                List rowDims = ((AreaRangeEntry)areas.get(0)).getRowDimEntries();
                for (RowDimensionEntry e : rowDims) {
                    result.add(e.getDimension().getNumber().toLowerCase(Locale.ENGLISH));
                }
            }
            pageCache.put(ROW, ObjectSerialUtil.toByteSerialized(result));
        } else {
            result = (List)ObjectSerialUtil.deSerializedBytes((String)pageCache.get(ROW));
        }
        return result;
    }

    public static List<Map<String, String>> getPointEntry(AbstractTemplateBasePlugin page, TemplateModel tem) {
        IPageCache pageCache = page.getPageCache();
        if (pageCache.get(ALL) == null) {
            long modelid = tem.getModelId();
            ArrayList<Map<String, String>> allPoint = new ArrayList<Map<String, String>>(10);
            List<String> row = WorkPaperTemplatePlugin.getRowCacheList(pageCache, tem);
            DynamicObjectCollection dims = QueryDimensionServiceHelper.getDimensionBaseInfos((Object)modelid);
            HashMap rowPointMap = Maps.newHashMap();
            for (DynamicObject dot : dims) {
                HashMap<String, String> map = new HashMap<String, String>(16);
                String number = dot.getString("number").toLowerCase(Locale.ENGLISH);
                map.put("name", dot.getString("name"));
                map.put("entity", dot.getString("membermodel"));
                map.put("sign", number);
                map.put("seq", String.valueOf(dot.getInt("dseq")));
                map.put("number", dot.getString("number"));
                map.put("shortnumber", dot.getString("shortnumber"));
                if (row.contains(number)) {
                    map.put("panel", ROW);
                    rowPointMap.put(number, map);
                    continue;
                }
                if (colnumbers.contains(number)) {
                    map.put("panel", COL);
                } else {
                    map.put("panel", GENERAL);
                }
                allPoint.add(map);
            }
            for (String rowNumber : row) {
                allPoint.add((Map<String, String>)rowPointMap.get(rowNumber));
            }
            pageCache.put(ALL, SerializationUtils.toJsonString(allPoint));
            return allPoint;
        }
        return (List)SerializationUtils.fromJsonString((String)pageCache.get(ALL), List.class);
    }

    private void handleCellF7ReturnValues(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            this.getPageCache().remove("f7select");
            return;
        }
        int row = this.getF7SelectRow();
        int col = this.getF7SelectCol();
        String entityNum = this.findEntityNum(row, col);
        this.removeF7SelectCache();
        Object result = closedCallBackEvent.getReturnData();
        ListSelectedRowCollection rows = new ListSelectedRowCollection();
        rows.add((Object)new ListSelectedRow(((DynamicObject)result).get("id")));
        result = rows;
        if (result instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection coll = (ListSelectedRowCollection)result;
            ArrayList<IDimMember> members = new ArrayList<IDimMember>();
            Sheet sheet = this.getEffectiveSheet();
            if (coll.size() == 0) {
                sheet.getCell(row, col).clearMembersOfUserObject();
                this.invokeJsupdateCellValues(row, col);
            } else {
                DynamicObject dynaObj = QueryServiceHelper.queryOne((String)DimensionServiceHelper.getDimMembEntityNumByDimNum((String)entityNum), (String)"dimension.id,dimension.name,dimension.number", (QFilter[])new QFilter[]{new QFilter("id", "=", coll.get(0).getPrimaryKeyValue())});
                IDimension dimension = ObjectConvertUtils.toIDimension(dynaObj);
                dynaObj = QueryServiceHelper.queryOne((String)DimensionServiceHelper.getDimMembEntityNumByDimNum((String)entityNum), (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", coll.get(0).getPrimaryKeyValue())});
                IDimMember member = ObjectConvertUtils.toDimMember(dynaObj, dimension);
                members.add(member);
                if (!members.isEmpty()) {
                    sheet.getCell(row, col).clearMembersOfUserObject();
                    sheet.getCell(row, col).addDims2UserObject(members);
                    this.invokeJsupdateCellValues(row, col);
                }
                if (dynaObj != null) {
                    ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
                    this.buildSingleCellData(cellValues, sheet.getCell(row, col), member.getName(), member.getNumber());
                    SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "template_spread", Lists.newArrayList(cellValues));
                }
            }
        }
    }

    @Override
    protected void invokeJsupdateCellValues(int r, int c) {
        String msg = ((IDimMember)this.getEffectiveSheet().getCell(r, c).getMemberFromUserObject().get(0)).getName();
        this.getEffectiveSheet().getCell(r, c).setValue((Object)msg);
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
        cellValues.add(this.packedUpdateCellMap(r, c, msg));
        this.invokeSpreadUpdateValueMethod(cellValues);
    }

    private String findEntityNum(int r, int c) {
        AreaRangeEntry area = null;
        for (AreaRangeEntry e2 : this.getTemplateModel().getAreaRangeEntries()) {
            Point start = ExcelUtils.pos2Point((String)e2.getAreaRange().split(":")[0]);
            Point end = ExcelUtils.pos2Point((String)e2.getAreaRange().split(":")[1]);
            if (start.y > r || r > end.y) continue;
            area = e2;
            break;
        }
        try {
            if (area != null) {
                int col = ExcelUtils.pos2X((String)area.getStartPosition());
                ArrayList dimNums = new ArrayList();
                area.getRowDimEntries().forEach(e -> dimNums.add(e.getDimension().getNumber()));
                return (String)dimNums.get(dimNums.size() - (col - c));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void operationCheck(NotifyEvent notifyEvent) {
        String message = WorkPaperUtil.operationRowColCheck((AskExcuteInfo)notifyEvent.getSource(), this.getTemplateModel().getAreaRangeEntries(), this.getSpreadModel());
        if (StringUtils.isNotEmpty((String)message)) {
            notifyEvent.setCancel(true);
            this.getView().showTipNotification(message);
        }
    }

    private void invokeAddOrRemove(NotifyEvent notifyEvent) {
        MarkSpecialCell.cacheOldFloat(this.getPageCache(), this.getSpreadModel());
        AskExcuteInfo info = (AskExcuteInfo)notifyEvent.getSource();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("status", true);
        map.put("data", info.getOperationdata());
        boolean isChangeCol = false;
        boolean isChangeStyle = false;
        List entries = this.getTemplateModel().getAreaRangeEntries();
        RangeModel rangeModel = WorkPaperUtil.getDataRangeModel(entries);
        if (CollectionUtils.isNotEmpty((Collection)entries) && rangeModel != null && info.getOperation() == 1 && (isChangeCol = info.getOperationdata().stream().anyMatch(c -> rangeModel.getX_end() >= c))) {
            boolean bl = isChangeStyle = info.getMethod() == RowColExcuteEnum.INSERTCOL && info.getOperationdata().contains(rangeModel.getX_start() - ((AreaRangeEntry)entries.get(0)).getRowDimEntries().size());
            if (isChangeStyle) {
                this.clearF7TypeCellOnSpreadJS();
            }
        }
        this.adjustHeadList(info);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).invokeControlMethod("template_spread", info.getMethod().getMethod(), new Object[]{map});
        this.adjustPosition(info);
        TemplateFloatUtil.setRightFloatModel(this.getSpreadModel(), this.getTemplateModel());
        this.updateFrontFormulaToData();
        if (info.getMethod() != RowColExcuteEnum.INSERTROW) {
            if (CollectionUtils.isEmpty((Collection)this.getTemplateModel().getAreaRangeEntries())) {
                WorkPaperUtil.saveColumnList(this.getSpreadModel(), null);
            } else if (isChangeCol) {
                WorkPaperUtil.setColHeaderName(this.getClientViewProxy(), "template_spread", this.getSpreadModel(), this.getTemplateModel());
                if (isChangeStyle) {
                    this.setF7TypeCellOnSpreadJS(this.getSpreadModel(), this.getTemplateModel());
                }
            }
        }
        this.setModified(true);
        this.cacheTemplateModel();
        this.cacheSpreadModel();
    }

    private void updateFrontFormulaToData() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpreadProperties.SetUpdateFrontFormula.SI.k(), "0");
        params.put(SpreadProperties.SetUpdateFrontFormula.OPTIONS.k(), "all");
        params.put(SpreadProperties.SetUpdateFrontFormula.CALLBACK.k(), "invokeAction");
        params.put(SpreadProperties.SetUpdateFrontFormula.INVOKEMETHOD.k(), "updateFormula");
        SpreadClientInvoker.invokeGetFormulaMethod(this.getClientViewProxy(), "template_spread", params);
    }

    public void updateFormula(Object formulaJson) {
        if (formulaJson instanceof String && StringUtils.isNotEmpty((String)formulaJson.toString())) {
            JSONArray objArray = JSON.parseArray((String)ObjectSerialUtil.uncompress((String)formulaJson.toString()));
            Sheet sheet = this.getSpreadModel().getBook().getSheet(0);
            for (int i = 0; i < objArray.size(); ++i) {
                JSONObject json = objArray.getJSONObject(i);
                int r = json.getIntValue(SpreadProperties.SetUpdateFrontFormula.R.k());
                int c = json.getIntValue(SpreadProperties.SetUpdateFrontFormula.C.k());
                String f = json.getString(SpreadProperties.SetUpdateFrontFormula.F.k());
                sheet.getCell(r, c).setFormula(f);
            }
            this.cacheSpreadModel();
        }
    }

    private void adjustPosition(AskExcuteInfo info) {
        boolean deleteOrAdd = info.getMethod() == RowColExcuteEnum.DELETECOL || info.getMethod() == RowColExcuteEnum.DELETEROW;
        Map spreadPos2TempModelPos = this.getTemplateModel().getSpreadPos2TempModelPosMap(this.getSpreadModel());
        info.getOperationdata().forEach(dealdata -> {
            AdjustRangeEvent adjust = new AdjustRangeEvent(dealdata.intValue(), info.getOperation(), deleteOrAdd ? -1 : 1);
            this.getSpreadModel().getAreaManager().getPostionInfoSet().forEach(pos -> {
                String originArea = pos.getOriginalAreaRange();
                pos.adjustRange(adjust);
                String startPosition = pos.getStartPosition();
                String areaRange = pos.getAreaRange();
                AreaRangeEntry result = (AreaRangeEntry)spreadPos2TempModelPos.get(originArea);
                if (result != null) {
                    result.setAreaRange(areaRange);
                    result.setStartPosition(startPosition);
                }
            });
        });
    }

    public void moveForwards() {
        this.moveColnumn2SpreadModel(-1);
    }

    public void moveBackwards() {
        this.moveColnumn2SpreadModel(1);
    }

    private void moveColnumn2SpreadModel(int moveStep) {
        if (this.isExistLoanCol()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u501f\u8d37\u5217\uff0c\u9700\u5728\u9875\u9762\u5e03\u5c40\u4e2d\u8c03\u6574\u7ec4\u4ef6\u987a\u5e8f\u3002", (String)"WorkPaperTemplatePlugin_24", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        SpreadManager spreadManager = this.getSpreadModel();
        TemplateModel template = this.getTemplateModel();
        if (template.getAreaRangeEntries() == null || template.getAreaRangeEntries().isEmpty()) {
            return;
        }
        if (!this.isInRange()) {
            return;
        }
        int selectorStartCol = this.getSpreadSelector().getStartCol();
        int selectorEndCol = this.getSpreadSelector().getEndCol();
        int selectorStartRow = this.getSpreadSelector().getStartRow();
        int selectorEndRow = this.getSpreadSelector().getEndRow();
        List<Column> headerList = WorkPaperUtil.getColumnList(spreadManager);
        boolean isMoved = false;
        isMoved = this.moveCol(moveStep, selectorStartCol, selectorEndCol, headerList);
        if (isMoved) {
            int rowCount = selectorEndRow - selectorStartRow + 1;
            int colRount = selectorEndCol - selectorStartCol + 1;
            this.setSelectCell(selectorStartRow, selectorStartCol + moveStep, rowCount, colRount);
        }
        this.reSizeColsIndex(headerList);
        this.setCacheAndUpdateClientCell(headerList);
    }

    private boolean isExistLoanCol() {
        List<Column> columnList = WorkPaperUtil.getColumnList(this.getSpreadModel());
        for (Column column : columnList) {
            if (!column.getLoanShow().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void setSelectCell(int rowIndex, int colIndex, int rowCount, int colRount) {
        HashMap<String, Integer> params = new HashMap<String, Integer>(16);
        params.put(SpreadProperties.FieldInsertMethod.R.k(), rowIndex);
        params.put(SpreadProperties.FieldInsertMethod.C.k(), colIndex);
        params.put(SpreadProperties.FieldInsertMethod.RC.k(), rowCount);
        params.put(SpreadProperties.FieldInsertMethod.CC.k(), colRount);
        SpreadClientInvoker.invokeSetSelectionsMethod(this.getClientViewProxy(), "template_spread", params);
        SpreadSelector selector = new SpreadSelector(rowIndex, colIndex, rowIndex + rowCount - 1, colIndex + colRount - 1);
        this.getPageCache().put("spread_selector", ObjectSerialUtil.toByteSerialized((Object)selector));
    }

    private boolean moveCol(int moveStep, int selectorStartCol, int selectorEndCol, List<Column> headerList) {
        SpreadManager spreadManager = this.getSpreadModel();
        Sheet sheet = spreadManager.getBook().getSheet(0);
        TemplateModel template = this.getTemplateModel();
        if (template.getAreaRangeEntries() == null || template.getAreaRangeEntries().isEmpty()) {
            return false;
        }
        boolean isMoved = false;
        String firstStartPosition = ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getStartPosition();
        int[] xy = ExcelUtils.pos2XY((String)firstStartPosition);
        int rowDimAmount = ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getRowDimEntries().size();
        int startCellRowIdx = xy[1] - 1;
        int startCellColIdx = xy[0] - rowDimAmount;
        int size = headerList.size();
        int relativeStartIndex = -1;
        int relativeEndIndex = -1;
        if (moveStep > 0) {
            relativeStartIndex = selectorStartCol - xy[0];
            relativeEndIndex = selectorEndCol - xy[0];
            isMoved = this.moveItemForList(moveStep, relativeStartIndex, relativeEndIndex, headerList);
            this.resetHeadName2Form(sheet, rowDimAmount, startCellRowIdx, startCellColIdx, headerList);
        } else if (moveStep < 0) {
            Collections.reverse(headerList);
            relativeStartIndex = size - (selectorEndCol - xy[0]) - 1;
            relativeEndIndex = size - (selectorStartCol - xy[0]) - 1;
            isMoved = this.moveItemForList(-moveStep, relativeStartIndex, relativeEndIndex, headerList);
            Collections.reverse(headerList);
            this.resetHeadName2Form(sheet, rowDimAmount, startCellRowIdx, startCellColIdx, headerList);
        }
        return isMoved;
    }

    private boolean isInRange() {
        SpreadManager spreadManager = this.getSpreadModel();
        int selectorStartCol = this.getSpreadSelector().getStartCol();
        int selectorEndCol = this.getSpreadSelector().getEndCol();
        int startcol = -1;
        int endcol = -1;
        for (PositionInfo ps : spreadManager.getAreaManager().getPostionInfoSet()) {
            String[] area = ps.getAreaRange().split(":");
            startcol = ExcelUtils.pos2X((String)area[0]);
            endcol = ExcelUtils.pos2X((String)area[1]);
            if (startcol == -1 || endcol == -1 || selectorStartCol >= startcol && selectorStartCol <= endcol && selectorEndCol >= startcol && selectorEndCol <= endcol) continue;
            return false;
        }
        return true;
    }

    private void setCacheAndUpdateClientCell(List<Column> headerList) {
        SpreadManager spreadManager = this.getSpreadModel();
        WorkPaperUtil.saveColumnList(spreadManager, headerList);
        Sheet sheet = spreadManager.getBook().getSheet(0);
        this.cacheSpreadModel(spreadManager);
        List cellValues = sheet.createClientValuesConfig();
        if (!cellValues.isEmpty()) {
            SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "template_spread", cellValues);
        }
    }

    private void reSizeColsIndex(List<Column> headerList) {
        TemplateModel template = this.getTemplateModel();
        if (template == null || template.getAreaRangeEntries() == null || template.getAreaRangeEntries().isEmpty()) {
            return;
        }
        String firstStartPosition = ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getStartPosition();
        int[] xy = ExcelUtils.pos2XY((String)firstStartPosition);
        for (int i = 0; i < headerList.size(); ++i) {
            headerList.get(i).setColIndex(xy[0] + i);
        }
    }

    private boolean moveItemForList(int moveStep, int startCol, int endCol, List<Column> headerList) {
        if (endCol + moveStep + 1 > headerList.size()) {
            return false;
        }
        ArrayList<Column> tmpList = new ArrayList<Column>(headerList.subList(endCol + 1, endCol + moveStep + 1));
        for (int i = endCol + moveStep; i >= startCol + moveStep; --i) {
            headerList.set(i, headerList.get(i - moveStep));
        }
        int tmpIndex = 0;
        for (int i = startCol; i <= startCol + moveStep - 1; ++i) {
            headerList.set(i, (Column)tmpList.get(tmpIndex));
            ++tmpIndex;
        }
        return true;
    }

    private void resetHeadName2Form(Sheet sheet, int rowDimAmount, int startCellRowIdx, int startCellColIdx, List<Column> headerList) {
        if (headerList == null || headerList.isEmpty()) {
            return;
        }
        for (int i = 0; i < headerList.size(); ++i) {
            Cell cell = sheet.getCell(startCellRowIdx, i + rowDimAmount + startCellColIdx);
            cell.setValue((Object)headerList.get(i).getHeaderName());
        }
    }

    private void adjustHeadList(AskExcuteInfo info) {
        WorkPaperUtil.adjustHeaderColumn(info, this.getTemplateModel(), this.getSpreadModel());
        this.cacheSpreadModel();
        this.cacheTemplateModel();
    }

    private void setViewSpreadJs() {
        ArrayList<Map> MenuItems = new ArrayList<Map>(10);
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)"insertColMany", (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), this.getSpreadKey(), MenuItems);
        SpreadEasyInvoker spreadEasyInvoker = new SpreadEasyInvoker(this.getClientViewProxy(), "template_spread");
        spreadEasyInvoker.addContextMenuItem(INSERT_COMPONENT, ResManager.loadKDString((String)"\u63d2\u5165\u7ec4\u4ef6", (String)"WorkPaperTemplatePlugin_25", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), new String[]{COL_HEADER});
        spreadEasyInvoker.addContextMenuItem(INSERT_FORMULA_COL, ResManager.loadKDString((String)"\u63d2\u5165\u516c\u5f0f\u5217", (String)"WorkPaperTemplatePlugin_26", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), new String[]{COL_HEADER});
    }

    public void insertComponent() {
        if (this.isEmptyAreaRange()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u9875\u9762\u5e03\u5c40\u3002", (String)"WorkPaperTemplatePlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!this.inAreaRange(this.getSelectorStartCol(), (AreaRangeEntry)this.getTemplateModel().getAreaRangeEntries().get(0))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5217\u7ef4\u533a\u57df\u4e2d\u63d2\u5165\u3002", (String)"WorkPaperTemplatePlugin_27", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!this.isDebitCol()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u501f\u8d37\u5217\uff0c\u9009\u62e9\u501f\u65b9\u63d2\u5165\u6216\u9009\u62e9\u8d37\u65b9\u540e\u4e00\u5217\u63d2\u5165\uff0c\u4e0d\u80fd\u5728\u501f\u8d37\u5217\u4e2d\u95f4\u63d2\u5165\u3002", (String)"WorkPaperTemplatePlugin_28", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_coldimension");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        List<Column> column_List = WorkPaperUtil.getColumnList(this.getSpreadModel());
        List<Column4Cache> columnList = this.getColList(column_List);
        List<WorkPaperTypeEnum> elements = WorkPaperUtil.filterPreWorkEnum(columnList);
        parameter.setCustomParam(type, (Object)this.getPageCache().get(type));
        parameter.setCustomParam("sign", (Object)this.getAddColKey(column_List, column_List.size()));
        parameter.setCustomParam(INSERT_COMPONENT, (Object)INSERT_COMPONENT);
        parameter.setCustomParam("cloumn_elements", (Object)ObjectSerialUtil.toByteSerialized(elements));
        parameter.setCustomParam("collist", (Object)ObjectSerialUtil.toByteSerialized(columnList));
        parameter.setCustomParam("isAddCol", (Object)true);
        parameter.setCustomParam("colIndex", (Object)column_List.size());
        parameter.setCustomParam("KEY_MODEL_ID", (Object)String.valueOf(this.getTemplateModel().getModelId()));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, INSERT_COMPONENT_FORMULA_COL);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private String getAddColKey(List<Column> column_List, int colnum) {
        String key = COL_DEFINED + colnum;
        if (column_List.stream().anyMatch(column -> column.getNumber().equals(key))) {
            return this.getAddColKey(column_List, ++colnum);
        }
        return key;
    }

    public void insertFormulaCol() {
        if (this.isEmptyAreaRange()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u9875\u9762\u5e03\u5c40\u3002", (String)"WorkPaperTemplatePlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!this.inAreaRange(this.getSelectorStartCol(), (AreaRangeEntry)this.getTemplateModel().getAreaRangeEntries().get(0))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5217\u7ef4\u533a\u57df\u4e2d\u63d2\u5165\u3002", (String)"WorkPaperTemplatePlugin_27", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!this.isDebitCol()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u501f\u8d37\u5217\uff0c\u9009\u62e9\u501f\u65b9\u63d2\u5165\u6216\u9009\u62e9\u8d37\u65b9\u540e\u4e00\u5217\u63d2\u5165\uff0c\u4e0d\u80fd\u5728\u501f\u8d37\u5217\u4e2d\u95f4\u63d2\u5165\u3002", (String)"WorkPaperTemplatePlugin_28", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String type = this.getPageCache().get(type);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_coldimension");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        List<Column> column_List = WorkPaperUtil.getColumnList(this.getSpreadModel());
        List<Column4Cache> columnList = this.getColList(column_List);
        parameter.setCustomParam(type, (Object)type);
        parameter.setCustomParam("collist", (Object)ObjectSerialUtil.toByteSerialized(columnList));
        parameter.setCustomParam("sign", (Object)this.getAddColKey(column_List, column_List.size()));
        parameter.setCustomParam("colIndex", (Object)column_List.size());
        parameter.setCustomParam("InsertFormulaCol", (Object)"InsertFormulaCol");
        parameter.setCustomParam("isAddCol", (Object)true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, INSERT_COMPONENT_FORMULA_COL);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
        this.getPageCache().put("insert_type", "formulaCol");
    }

    private List<Column4Cache> getColList(List<Column> list) {
        ArrayList<Column4Cache> columnList = new ArrayList<Column4Cache>(list.size());
        int colnum = 0;
        for (Column col : list) {
            Column4Cache column = new Column4Cache(col.getNumber(), col.getHeaderName(), colnum, col.getDisplayChild().booleanValue(), "", col.getProcess().p2 == null ? null : ((Member)col.getProcess().p2).getNumber(), col.getAuditTrial().p2 == null ? null : ((Member)col.getAuditTrial().p2).getNumber(), col.getCurrency().p2 == null ? null : ((Member)col.getCurrency().p2).getNumber(), col.getFormula(), col.getLoanShow().booleanValue());
            column.setUseDefault(Boolean.valueOf(col.isUseDefault()));
            ++colnum;
            columnList.add(column);
        }
        return columnList;
    }

    private boolean inAreaRange(int selectColIndex, AreaRangeEntry areaRangeEntry) {
        String areaRange = areaRangeEntry.getAreaRange();
        String[] splitArr = areaRange.split(":");
        int startcol = ExcelUtils.pos2X((String)splitArr[0]);
        int endcol = ExcelUtils.pos2X((String)splitArr[1]);
        return selectColIndex >= startcol && selectColIndex <= endcol;
    }

    private boolean isEmptyAreaRange() {
        return this.getTemplateModel().getAreaRangeEntries().isEmpty();
    }

    private void fillBackSheet(ClosedCallBackEvent closedCallBackEvent) {
        Set<String> headNameSet;
        TemplateModel template = this.getTemplateModel();
        SpreadManager spreadManager = this.getSpreadModel();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        Pair pair = (Pair)ObjectSerialUtil.deSerializedBytes((String)returnData.toString());
        Column4Cache col4Cache = (Column4Cache)pair.p2;
        if (col4Cache == null) {
            return;
        }
        String header = col4Cache.getHeaderName();
        if (StringUtils.isEmpty((String)header)) {
            return;
        }
        String columnSerializeBase64 = WorkPaperUtil.getColumnListStr(spreadManager);
        PositionInfo positionInfo = (PositionInfo)spreadManager.getAreaManager().getPostionInfoSet().iterator().next();
        Point start = ExcelUtils.pos2Point((String)positionInfo.getStartPosition());
        int row = start.y - 1;
        spreadManager.getBook().getSheet(0).insertColumn(this.getSelectorStartCol());
        if (col4Cache.getLoanShow().booleanValue()) {
            spreadManager.getBook().getSheet(0).insertColumn(this.getSelectorStartCol() + 1);
            spreadManager.getBook().getSheet(0).getCell(row, this.getSelectorStartCol()).setValue((Object)String.format(ResManager.loadKDString((String)"%s\u501f\u65b9", (String)"WorkPaperTemplatePlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), header));
            spreadManager.getBook().getSheet(0).getCell(row, this.getSelectorStartCol() + 1).setValue((Object)String.format(ResManager.loadKDString((String)"%s\u8d37\u65b9", (String)"WorkPaperTemplatePlugin_22", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), header));
        } else {
            spreadManager.getBook().getSheet(0).getCell(row, this.getSelectorStartCol()).setValue((Object)header);
        }
        Map<String, Set<String>> headNameMap = this.getCacheHeadNameMap();
        if (headNameMap != null && (headNameSet = headNameMap.get(columnSerializeBase64)).contains(header)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0\u3002", (String)"WorkPaperTemplatePlugin_29", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.fillDataToSpread(col4Cache, template, spreadManager, this.getPageCache().get(type));
        this.updateFrontFormulaToData();
        this.cacheTemplateModel(template);
        this.cacheSpreadModel(spreadManager);
        this.dealLockSysHead(true);
    }

    private Map<String, Set<String>> getCacheHeadNameMap() {
        Map<String, Set<String>> headNameMap = null;
        SpreadManager spreadManager = this.getSpreadModel();
        String columnSerializeBase64 = WorkPaperUtil.getColumnListStr(spreadManager);
        if (StringUtils.isEmpty((String)columnSerializeBase64)) {
            if (this.getPageCache().get(colBase64headNameMap) != null) {
                this.getPageCache().remove(colBase64headNameMap);
            }
            return headNameMap;
        }
        String colMapBase64 = this.getPageCache().get(colBase64headNameMap);
        if (StringUtils.isEmpty((String)colMapBase64)) {
            headNameMap = this.initheadNameMap(columnSerializeBase64);
        } else {
            headNameMap = (Map<String, Set<String>>)SerializationUtils.deSerializeFromBase64((String)colMapBase64);
            if (!headNameMap.isEmpty()) {
                if (!headNameMap.containsKey(columnSerializeBase64)) {
                    headNameMap.clear();
                    headNameMap = this.initheadNameMap(columnSerializeBase64);
                }
            } else {
                headNameMap = this.initheadNameMap(columnSerializeBase64);
            }
        }
        return headNameMap;
    }

    private Map<String, Set<String>> initheadNameMap(String columnSerializeBase64) {
        HashMap<String, Set<String>> headNameMap = new HashMap<String, Set<String>>(16);
        SpreadManager spreadManager = this.getSpreadModel();
        List<Column> headerList = WorkPaperUtil.getColumnList(spreadManager);
        HashSet<String> haderNameSet = new HashSet<String>(headerList.size());
        headNameMap.put(columnSerializeBase64, haderNameSet);
        if (headerList.isEmpty()) {
            return null;
        }
        for (Column column : headerList) {
            haderNameSet.add(column.getHeaderName());
        }
        this.getPageCache().put(colBase64headNameMap, SerializationUtils.serializeToBase64(headNameMap));
        return headNameMap;
    }

    private void fillDataToSpread(Column4Cache col4Cache, TemplateModel template, SpreadManager spreadManager, String type) {
        String firstStartPosition = ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getStartPosition();
        int[] xy = ExcelUtils.pos2XY((String)firstStartPosition);
        int startCellRowIdx = xy[1] - 1;
        int startCellColIdx = xy[0];
        int insertIndex = this.getSelectorStartCol();
        List<Column> headerList = WorkPaperUtil.getColumnList(spreadManager);
        ArrayList<Column> new_headerList = new ArrayList<Column>(headerList.size() + 1);
        String header = col4Cache.getHeaderName();
        WorkPaperTypeEnum typeEnum = WorkPaperTypeEnum.getEnumByName((String)header);
        String number = typeEnum == null ? col4Cache.getNumber() : typeEnum.getNumber();
        String formula = col4Cache.getFormula();
        AreaRangeEntry firstArea = (AreaRangeEntry)template.getAreaRangeEntries().get(0);
        ColDimensionEntryExt colDimensionEntryExt = WorkPaperUtil.getColDimensionEntryExt(this.getModelId(), firstArea, (AbstractColumn)col4Cache, insertIndex);
        Column column = new Column(number, header, insertIndex, col4Cache.getDisplayChild().booleanValue(), formula, col4Cache.getLoanShow().booleanValue());
        Iterator iterator = colDimensionEntryExt.getDimMembers().iterator();
        column.setOrg((Pair)iterator.next());
        column.setProcess((Pair)iterator.next());
        column.setAuditTrial((Pair)iterator.next());
        column.setCurrency((Pair)iterator.next());
        column.setUseDefault(Boolean.valueOf(col4Cache.isUseDefault()));
        HashMap numberMap = Maps.newHashMap();
        int x = startCellColIdx;
        int index = 0;
        for (Column col : headerList) {
            if (x != insertIndex) {
                col.setColIndex(x);
                new_headerList.add(col);
            } else {
                String oldnNmber;
                if (WorkPaperEnum.USERDEFINED.getNumber().equals(type) && !column.getNumber().startsWith(COL_DEFINED)) {
                    oldnNmber = column.getNumber();
                    column.setNumber(COL_DEFINED + index + "@" + oldnNmber);
                }
                new_headerList.add(column);
                if (column.getNumber().startsWith(COL_DEFINED) && !column.getNumber().contains("@")) {
                    oldnNmber = column.getNumber();
                    column.setNumber(COL_DEFINED + index);
                    numberMap.put(oldnNmber, column.getNumber());
                }
                col.setColIndex(++x);
                new_headerList.add(col);
                ++index;
            }
            if (col.getNumber().startsWith(COL_DEFINED)) {
                String preNumber = col.getNumber();
                String lastNumber = "";
                if (preNumber.contains("@")) {
                    lastNumber = preNumber.substring(preNumber.indexOf("@"));
                    preNumber = preNumber.split("@")[0];
                }
                col.setNumber(COL_DEFINED + index + lastNumber);
                numberMap.put(preNumber, COL_DEFINED + index);
            }
            ++x;
            if (col.getLoanShow().booleanValue()) {
                ++x;
            }
            ++index;
        }
        for (int i = 0; i < new_headerList.size(); ++i) {
            ((Column)new_headerList.get(i)).setColIndex(startCellColIdx + i);
        }
        for (Column col : new_headerList) {
            String oldFormula = col.getFormula();
            if (oldFormula == null || !oldFormula.contains(COL_DEFINED)) continue;
            StringBuilder sb = new StringBuilder();
            WorkPaperUtil.replaceFormulaNumber(sb, oldFormula, numberMap);
            String newFormula = sb.toString();
            if (sb.length() > 0 && newFormula.contains("@")) {
                sb.setLength(0);
                WorkPaperUtil.setFormula(sb, newFormula);
                newFormula = sb.toString();
            }
            col.setFormula(newFormula);
        }
        WorkPaperUtil.saveColumnList(spreadManager, new_headerList);
        this.upgradeData(spreadManager, startCellRowIdx, insertIndex, column.getHeaderName(), column.getLoanShow());
        this.adjustPositionAfterInsertCol(insertIndex, column.getLoanShow());
    }

    private boolean isDebitCol() {
        String firstStartPosition = ((AreaRangeEntry)this.getTemplateModel().getAreaRangeEntries().get(0)).getStartPosition();
        int[] xy = ExcelUtils.pos2XY((String)firstStartPosition);
        int startCellColIdx = xy[0];
        int insertIndex = this.getSelectorStartCol();
        List<Column> columnList = WorkPaperUtil.getColumnList(this.getSpreadModel());
        int index = insertIndex - startCellColIdx;
        ArrayList<Column> newColumnList = new ArrayList<Column>();
        for (Column column : columnList) {
            if (column.getLoanShow().booleanValue()) {
                Column column1 = new Column(column.getNumber(), column.getHeaderName(), column.getColIndex(), column.getDisplayChild().booleanValue(), column.getFormula(), column.getLoanShow().booleanValue());
                Column column2 = new Column(column.getNumber(), column.getHeaderName(), column.getColIndex(), column.getDisplayChild().booleanValue(), column.getFormula(), column.getLoanShow().booleanValue());
                column1.setDebitCredit("0");
                column2.setDebitCredit("1");
                newColumnList.add(column1);
                newColumnList.add(column2);
                continue;
            }
            newColumnList.add(column);
        }
        return ((Column)newColumnList.get(index)).getLoanShow() == false || !"1".equals(((Column)newColumnList.get(index)).getDebitCredit());
    }

    private void upgradeData(SpreadManager spreadManager, int insertRowIndex, int insertColIndex, String columnName, Boolean loanShow) {
        ArrayList<Integer> insertCols = new ArrayList<Integer>(10);
        insertCols.add(insertColIndex);
        if (loanShow.booleanValue()) {
            insertCols.add(insertColIndex + 1);
        }
        LinkedHashMap<String, ArrayList<Integer>> map = new LinkedHashMap<String, ArrayList<Integer>>(16);
        map.put("data", insertCols);
        SpreadClientInvoker.invokeInsertCol(this.getClientViewProxy(), "template_spread", map);
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(10);
        if (loanShow.booleanValue()) {
            cellValues.add(AdjustModelUtil.packedUpdateCellMap(insertRowIndex, insertColIndex, String.format(ResManager.loadKDString((String)"%s\u501f\u65b9", (String)"WorkPaperTemplatePlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), columnName)));
            cellValues.add(AdjustModelUtil.packedUpdateCellMap(insertRowIndex, insertColIndex + 1, String.format(ResManager.loadKDString((String)"%s\u8d37\u65b9", (String)"WorkPaperTemplatePlugin_22", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), columnName)));
        } else {
            cellValues.add(AdjustModelUtil.packedUpdateCellMap(insertRowIndex, insertColIndex, columnName));
        }
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "template_spread", cellValues);
    }

    private void adjustPositionAfterInsertCol(int colIndex, Boolean loanShow) {
        AdjustRangeEvent adjust = loanShow != false ? new AdjustRangeEvent(colIndex, 1, 2) : new AdjustRangeEvent(colIndex, 1, 1);
        this.getSpreadModel().getAreaManager().getPostionInfoSet().forEach(pos -> {
            String adjustBeforePos = pos.getAreaRange();
            pos.adjustRange(adjust);
            AreaRangeEntry result = this.getTemplateModel().findAreaByArea(adjustBeforePos);
            if (result != null) {
                result.setAreaRange(pos.getAreaRange());
                result.setStartPosition(pos.getStartPosition());
            }
        });
    }

    private void changeDisplay() {
        TemplateModel tmplate = this.getTemplateModel();
        this.buildRowData(tmplate, this.getSpreadModel());
    }

    private void buildSingleCellData(List<Map<String, Object>> cellValues, Cell cell, String name, String number) {
        String showType = this.getShowType();
        int rowNum = cell.getRow();
        int colNum = cell.getCol();
        String displayContent = name;
        if ("btn_number".equalsIgnoreCase(showType)) {
            displayContent = number;
        } else if ("btn_numname".equalsIgnoreCase(showType)) {
            displayContent = number + " " + name;
        }
        cell.setValue((Object)displayContent);
        cellValues.add(this.packedUpdateCellMap(rowNum, colNum, displayContent));
    }

    private String getShowType() {
        String showType = this.getModel().getValue("showtype").toString();
        if (showType.isEmpty()) {
            showType = (String)this.getEffectiveSheet().getUserObject("wb_showType");
            showType = showType != null ? showType.replace("btn_row_", "btn_") : "btn_numname";
            this.getModel().setValue("showtype", (Object)showType);
        }
        return showType;
    }

    private void buildRowData(TemplateModel template, SpreadManager spreadManager) {
        List areas = template.getAreaRangeEntries();
        Sheet sheet = spreadManager.getBook().getSheet(0);
        if (!areas.isEmpty()) {
            Pair<Point, Point> areaRange = this.getAreaRange(template);
            if (areaRange == null) {
                return;
            }
            Point spoint = (Point)areaRange.p1;
            ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
            List rowDims = ((AreaRangeEntry)areas.get(0)).getRowDimEntries();
            int rsz = rowDims.size();
            for (int i = 0; i < rsz; ++i) {
                Cell headcell = sheet.getCell(spoint.y - 1, spoint.x - i - 1);
                Dimension dimension = ((RowDimensionEntry)rowDims.get(rsz - i - 1)).getDimension();
                String dname = dimension.getName();
                String dnumber = dimension.getNumber();
                this.buildSingleCellData(cellValues, headcell, dname, dnumber);
                List cols = sheet.getCol(spoint.x - i - 1);
                cols.forEach(cell -> {
                    List uobj = cell.getMemberFromUserObject();
                    if (uobj != null && !uobj.isEmpty()) {
                        IDimMember member = (IDimMember)uobj.get(0);
                        if (uobj.size() == 2) {
                            uobj.remove(member);
                        }
                        String name = member.getName();
                        String number = member.getNumber();
                        if (name == null || StringUtils.isEmpty((String)name)) {
                            name = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)dnumber, (String)number).getName();
                            member.setName(name);
                        }
                        this.buildSingleCellData((List<Map<String, Object>>)cellValues, (Cell)cell, name, number);
                    }
                });
            }
            SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "template_spread", Lists.newArrayList(cellValues));
        }
    }

    private Pair<Point, Point> getAreaRange(TemplateModel tmplate) {
        List areas = tmplate.getAreaRangeEntries();
        Point startPoint = null;
        Point endPoint = null;
        if (areas.isEmpty()) {
            return null;
        }
        for (AreaRangeEntry area : areas) {
            String[] split = area.getAreaRange().split(":");
            Point currentStartPoint = ExcelUtils.pos2Point((String)split[0]);
            Point currentEndPoint = ExcelUtils.pos2Point((String)split[1]);
            if (startPoint == null || endPoint == null) {
                startPoint = currentStartPoint;
                endPoint = currentEndPoint;
                continue;
            }
            if (startPoint.y > currentStartPoint.y) {
                startPoint = currentStartPoint;
            }
            if (endPoint.y >= currentEndPoint.y) continue;
            endPoint = currentEndPoint;
        }
        return Pair.onePair(startPoint, endPoint);
    }

    @Override
    public void showFormulaPanel(int row, int col) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u516c\u5f0f\u7f16\u8f91\u3002", (String)"WorkPaperTemplatePlugin_30", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
    }

    public void showFormula() {
        int col;
        int row = this.getSelectorStartRow();
        if (this.checkPosition(row, col = this.getSelectorStartCol()) && !TemplateVerification.getCanSetFormulDataArea(this.getTemplateModel(), this.getSpreadModel()).contains(row)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df\u4e0d\u80fd\u5f55\u5165\u62a5\u8868\u4fe1\u606f\u3002", (String)"WorkPaperTemplatePlugin_31", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (this.getEffectiveSheet() != null && row >= 0 && col >= 0) {
            Cell cell = this.getEffectiveSheet().getCell(row, col);
            String formula = cell.getFormula();
            if (StringUtils.isEmpty((String)formula)) {
                this.openFormula(null, formula);
            } else {
                try {
                    formula = formula.replaceAll("\\p{C}", "");
                    Expression e = ExcelFormulaPaserHelper.parse((String)formula);
                    this.openFormula(e, formula);
                }
                catch (Exception ee) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u9519\u8bef\u3002", (String)"WorkPaperTemplatePlugin_32", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
            }
            this.getPageCache().put(sfr, String.valueOf(row));
            this.getPageCache().put(sfc, String.valueOf(col));
        }
    }

    private boolean checkPosition(int row, int col) {
        String pos = ExcelUtils.xy2Pos((int)col, (int)row);
        MultiAreaPositionsManager areaManager = this.getSpreadModel().getAreaManager();
        TemplateModel templateModel = this.getTemplateModel();
        if (areaManager != null && !areaManager.getPostionInfoSet().isEmpty() && !templateModel.getAreaRangeEntries().isEmpty()) {
            int wpRowDimSize = 0;
            for (AreaRangeEntry areaRangeEntry : templateModel.getAreaRangeEntries()) {
                List rowDimEntries = areaRangeEntry.getRowDimEntries();
                if (rowDimEntries.isEmpty()) continue;
                wpRowDimSize = rowDimEntries.size();
                break;
            }
            Pair<Point, Point> pair = this.getAreaRange(areaManager.getPostionInfoSet());
            String startStr = ExcelUtils.xy2Pos((int)(((Point)pair.p1).x - wpRowDimSize), (int)(((Point)pair.p1).y - 1));
            String endStr = ExcelUtils.xy2Pos((int)((Point)pair.p2).x, (int)((Point)pair.p2).y);
            return SpreadAreaUtil.isInArea((String)pos, (String)(startStr + ":" + endStr));
        }
        return false;
    }

    private void openFormula(Expression e, String formula) {
        if (e == null) {
            this.openFormulaEdit(formula, "newrptinfo");
        } else if (e instanceof FunctionExpr) {
            String selectedNodeNumber = ((FunctionExpr)e).getFuncionName().toLowerCase(Locale.ENGLISH);
            boolean exitformula = FormulaConfig.getInstance().getFormulaList().stream().anyMatch(f -> selectedNodeNumber.equals(((String)f.get("number")).toLowerCase(Locale.ENGLISH)));
            if (exitformula) {
                this.openFormulaEdit(formula, selectedNodeNumber);
            }
        }
    }

    private void openFormulaEdit(String formula, String selectedNodeNumber) {
        FormShowParameter parameter = new FormShowParameter();
        ShowFormulaUtil.selectGuidePage(ResourcesLoaderUtil.getFormulaByNumber((String)selectedNodeNumber), parameter, this.getModelId());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("accttype", (Object)selectedNodeNumber);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        if (formula != null && !BCMStringUtil.trim((String)formula).isEmpty()) {
            parameter.setCustomParam("formula", (Object)ShowFormulaUtil.formula2LowerCase(formula));
        }
        parameter.setCaption(ResManager.loadKDString((String)"\u62a5\u8868\u4fe1\u606f\u7f16\u8f91", (String)"WorkPaperTemplatePlugin_33", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "setFormula");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void handleCallBackFormula(String returndata) {
        Cell cell = this.getEffectiveSheet().getCell(this.getSelectorStartRow(), this.getSelectorStartCol());
        if (this.getPageCache().get(sfr) != null) {
            int row = Integer.parseInt(this.getPageCache().get(sfr));
            int col = Integer.parseInt(this.getPageCache().get(sfc));
            cell = this.getEffectiveSheet().getCell(row, col);
        }
        cell.setFormula(returndata);
        HashMap<String, Object> formula = new HashMap<String, Object>(4);
        formula.put(SpreadProperties.SetFormulaMethod.R.k(), cell.getRow());
        formula.put(SpreadProperties.SetFormulaMethod.C.k(), cell.getCol());
        formula.put(SpreadProperties.SetFormulaMethod.F.k(), returndata);
        formula.put(SpreadProperties.SetFormulaMethod.isUndo.k(), true);
        SpreadClientInvoker.invokeSetFormulaMethod(this.getClientViewProxy(), "template_spread", Lists.newArrayList((Object[])new Map[]{formula}));
        this.cacheSpreadModel();
    }

    private void registerFormula() {
        for (Map fm : FormulaConfig.getInstance().getFormulaList()) {
            Formula f = ResourcesLoaderUtil.getFormulaByNumber((String)((String)fm.get("number")));
            if (!"newrptinfo".equalsIgnoreCase(f.getNumber())) continue;
            HashMap<String, Object> formula = new HashMap<String, Object>(4);
            formula.put(SpreadProperties.RegisterCustomFormulaMethod.FORMULANAME.k(), f.getNumber());
            formula.put(SpreadProperties.RegisterCustomFormulaMethod.ARGSNUM.k(), f.getParam().size());
            formula.put(SpreadProperties.RegisterCustomFormulaMethod.RETURENTYPE.k(), 1);
            HashMap<String, Object> description = new HashMap<String, Object>(2);
            description.put(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTION.k(), f.getName());
            description.put(SpreadProperties.RegisterCustomFormulaMethod.PARAMETERS.k(), f.getParam());
            formula.put(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTIONIFNO.k(), description);
            SpreadClientInvoker.invokeRegisterCustomFormulaMethod(this.getClientViewProxy(), "template_spread", Lists.newArrayList((Object[])new Map[]{formula}));
        }
    }

    private void clearFormula() {
        ArrayList list = new ArrayList(16);
        this.getSpreadModel().getBook().getSheet(0).iteratorCells(cell -> {
            if (cell.getFormula() != null) {
                HashMap<String, Integer> formula = new HashMap<String, Integer>(4);
                formula.put(SpreadProperties.SetFormulaMethod.R.k(), cell.getRow());
                formula.put(SpreadProperties.SetFormulaMethod.C.k(), cell.getCol());
                formula.put(SpreadProperties.SetFormulaMethod.F.k(), null);
                list.add(formula);
                cell.setFormula(null);
            }
        });
        SpreadClientInvoker.invokeSetFormulaMethod(this.getClientViewProxy(), "template_spread", list);
    }

    protected boolean isModified() {
        return this.isTrueFlagInCache(IS_MODIFY);
    }

    protected void setModified(boolean isModified) {
        this.cacheTrueOrFalseFlag(IS_MODIFY, isModified);
    }
}

