/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.workingpaper;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.ColDimensionEntryExt;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.WorkPaperTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.util.WorkPaperUtil;
import kd.fi.bcm.formplugin.workingpaper.model.Column;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;

public class WorkPaperUpdataService {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean updateWorkPaperTemplate(TemplateModel template) {
        try (DLock lock = DLock.create((String)("fi/bcm/WorkPaper/UpdateTemplateModel/" + template.getId()));){
            if (!lock.tryLock(3000L)) return true;
            try (TXHandle tx = TX.required();){
                try {
                    DynamicObject templateDy = BusinessDataServiceHelper.loadSingle((Object)template.getId(), (String)"bcm_templateentity");
                    if (templateDy == null) {
                        boolean bl = true;
                        return bl;
                    }
                    if (!template.isOldTemplate()) {
                        boolean bl = true;
                        return bl;
                    }
                    if (StringUtil.isEmpty((CharSequence)template.getRptData())) {
                        WorkPaperUpdataService.repairOldWorkPaperTemplate(template);
                    } else {
                        SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)template.getRptData());
                        WorkPaperUpdataService.updateOldWorkPaperTemplate(template, sm);
                        String smJson = JsonSerializerUtil.toJson((SpreadManager)sm);
                        templateDy.set("data", (Object)smJson);
                        templateDy.set("rptdata", (Object)smJson);
                        templateDy.set("isOldTemplate", (Object)"0");
                        SaveServiceHelper.update((DynamicObject)templateDy);
                    }
                    AppCacheServiceHelper.remove((String)Long.toString(template.getId()));
                    GlobalCacheServiceHelper.invalidateTemplateModel((String)Long.toString(template.getId()));
                    return true;
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5347\u7ea7\u5de5\u4f5c\u5e95\u7a3f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1as%\u3002", (String)"WorkPaperUpdataService_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ThrowableHelper.toString((Throwable)e)));
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    private static void repairOldWorkPaperTemplate(TemplateModel template) {
        List colWorkEnumList = WorkPaperTypeEnum.getList((String)"2");
        SpreadManager spreadManager = new SpreadManager(template.getName(), null);
        List areas = template.getAreaRangeEntries();
        PositionInfo newps = new PositionInfo(((AreaRangeEntry)areas.get(0)).getStartPosition(), ((AreaRangeEntry)areas.get(0)).getAreaRange());
        newps.setSplit(true);
        spreadManager.getAreaManager().addArea(newps, null, null);
        WorkPaperUpdataService.updateOldWorkPaperTemplate(template, spreadManager);
        String json = spreadManager.getBook().toJSon();
        String spreadjson = JsonSerializerUtil.toJson((SpreadManager)spreadManager);
        DynamicObject templateDy = BusinessDataServiceHelper.loadSingle((Object)template.getId(), (String)"bcm_templateentity");
        templateDy.set("spreadjson", (Object)json);
        templateDy.set("data", (Object)spreadjson);
        templateDy.set("rptspreadjson", (Object)json);
        templateDy.set("rptdata", (Object)spreadjson);
        templateDy.set("isoldtemplate", (Object)false);
        SaveServiceHelper.update((DynamicObject)templateDy);
    }

    private static void updateOldWorkPaperTemplate(TemplateModel template, SpreadManager oldSm) {
        List colWorkEnumList = WorkPaperTypeEnum.getList((String)"1");
        AreaRangeEntry areaEntry = new AreaRangeEntry(template);
        SchemeContext schemeContext = new SchemeContext(template.getModelId());
        List areas = template.getAreaRangeEntries();
        List columnList = (List)SerializationUtils.deSerializeFromBase64((String)((String)oldSm.getBook().getSheet(0).getUserObject("column_list")));
        String startPos = ((PositionInfo)oldSm.getAreaManager().getPostionInfoSet().iterator().next()).getStartPosition();
        int startColIdx = ExcelUtils.pos2XY((String)startPos)[0];
        ((AreaRangeEntry)areas.get(0)).getColDimEntriesExt().clear();
        columnList.forEach(column -> {
            if (StringUtils.isEmpty((String)column.getFormula())) {
                column.setAuditTrial(WorkPaperUpdataService.updateProcessAndAt((Pair<Dimension, Member>)column.getAuditTrial(), colWorkEnumList, column.getHeaderName(), schemeContext));
                column.setCurrency(WorkPaperUpdataService.updateProcessAndAt((Pair<Dimension, Member>)column.getCurrency(), colWorkEnumList, column.getHeaderName(), schemeContext));
                column.setProcess(WorkPaperUpdataService.updateProcessAndAt((Pair<Dimension, Member>)column.getProcess(), colWorkEnumList, column.getHeaderName(), schemeContext));
            }
            ColDimensionEntryExt newColExt = WorkPaperUpdataService.setColDimensionEntryExt(schemeContext, areaEntry, column);
            ((AreaRangeEntry)areas.get(0)).getColDimEntriesExt().add(newColExt);
        });
        WorkPaperUtil.saveColumnList(oldSm, columnList);
    }

    private static ColDimensionEntryExt setColDimensionEntryExt(SchemeContext schemeContext, AreaRangeEntry areaEntry, Column column) {
        ColDimensionEntryExt colDimensionEntryExt = new ColDimensionEntryExt(areaEntry);
        for (Pair dimensionMemberPair : column.getAllDimensionMemberPair()) {
            colDimensionEntryExt.addDimMember((Dimension)dimensionMemberPair.p1, (Member)dimensionMemberPair.p2);
        }
        colDimensionEntryExt.setHeader(column.getHeaderName());
        colDimensionEntryExt.setNumber(column.getNumber());
        colDimensionEntryExt.setIndex(column.getColIndex());
        colDimensionEntryExt.setDisplayChild(column.getDisplayChild().booleanValue());
        areaEntry.addColDimEntryExt(colDimensionEntryExt);
        return colDimensionEntryExt;
    }

    private static Pair<Dimension, Member> updateProcessAndAt(Pair<Dimension, Member> pair, List<WorkPaperTypeEnum> colWorkEnumList, String headName, SchemeContext schemeContext) {
        Dimension dimension = (Dimension)pair.p1;
        Member member = (Member)pair.p2;
        String dimensionNumber = dimension.getNumber();
        if (dimensionNumber.equalsIgnoreCase("Process") || dimensionNumber.equalsIgnoreCase("AuditTrail") || dimensionNumber.equalsIgnoreCase("Currency")) {
            boolean isSys = false;
            WorkPaperTypeEnum sysWorkPaperTypeEnum = null;
            if (!colWorkEnumList.isEmpty()) {
                for (WorkPaperTypeEnum workPaperTypeEnum : colWorkEnumList) {
                    if (!headName.equals(workPaperTypeEnum.getHeaderName())) continue;
                    isSys = true;
                    sysWorkPaperTypeEnum = workPaperTypeEnum;
                    break;
                }
            }
            String number = "";
            if (member != null) {
                number = member.getNumber();
            }
            switch (dimensionNumber) {
                case "Process": {
                    if (isSys && sysWorkPaperTypeEnum != null) {
                        pair = Pair.onePair((Object)dimension, (Object)WorkPaperUpdataService.convertDynaObj2Member(schemeContext.getModelNumber(), "Process", sysWorkPaperTypeEnum.getProcessNum()));
                        break;
                    }
                    if ("SIRPT".equalsIgnoreCase(number)) {
                        number = "SRPT";
                    } else if ("CS".equalsIgnoreCase(number)) {
                        number = "ERpt";
                    }
                    pair = Pair.onePair((Object)dimension, (Object)WorkPaperUpdataService.convertDynaObj2Member(schemeContext.getModelNumber(), "Process", number));
                    break;
                }
                case "AuditTrail": {
                    if (!isSys || sysWorkPaperTypeEnum == null) break;
                    pair = Pair.onePair((Object)dimension, (Object)WorkPaperUpdataService.convertDynaObj2Member(schemeContext.getModelNumber(), "AuditTrail", sysWorkPaperTypeEnum.getAuditTrailNum()));
                    break;
                }
                case "Currency": {
                    if (isSys && sysWorkPaperTypeEnum != null) {
                        pair = Pair.onePair((Object)dimension, (Object)WorkPaperUpdataService.convertDynaObj2Member(schemeContext.getModelNumber(), "Currency", sysWorkPaperTypeEnum.getCurrencyNum()));
                        break;
                    }
                    number = "PC".equalsIgnoreCase(number) ? "DC" : number;
                    pair = Pair.onePair((Object)dimension, (Object)WorkPaperUpdataService.convertDynaObj2Member(schemeContext.getModelNumber(), "Currency", number));
                    break;
                }
            }
        }
        return pair;
    }

    private static Member convertDynaObj2Member(String modelNum, String dimNum, String memeber) {
        IDNumberTreeNode memTreeNode = MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)memeber);
        Member member = new Member();
        member.setId(memTreeNode.getId().longValue());
        member.setNumber(memTreeNode.getNumber());
        member.setName(memTreeNode.getName());
        member.setDataEntityNumber(SysDimensionEnum.getEnumByNumber((String)memTreeNode.getDimNumber()).getMemberTreemodel());
        return member;
    }
}

