/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.workingpaper.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.ColDimensionEntryExt;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.workpaper.DimensionMemberDisplayTypeEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.analytics.MDQADataQueryHelper;
import kd.fi.bcm.formplugin.analytics.service.MultiDimQAStyleService;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.multiview.TempFormulaUtil;
import kd.fi.bcm.formplugin.template.multiview.validators.TemplateVerification;
import kd.fi.bcm.formplugin.util.WorkPaperUtil;
import kd.fi.bcm.formplugin.util.WpFormulaUtil;
import kd.fi.bcm.formplugin.workingpaper.WorkPaperQueryAnalysisPlugin;
import kd.fi.bcm.formplugin.workingpaper.model.Column;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Header;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.HeadObject;
import kd.fi.bcm.spread.model.IDimMember;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.util.CellRangeAddress;

public class WorkPaperQueryHelper {
    private static final String COLUMN_LIST = "column_list";
    private static final String SIMPLE_NAME = "simplename";
    private static final String KEY_MAXROW = "maxRow";
    private static final String KEY_MAXCOL = "maxcol";
    private static final String KEY_EFFCELLS = "effCells";
    private static final String KEY_SPANS = "spans";
    private static final String KEY_SPANS_VALUES = "spansValues";
    private static final String KEY_FORMULAS = "formulas";
    private static final String KEY_TEMPLATE_COLUMN = "template_column";
    protected String spreadKey;
    protected TemplateModel template;
    protected SpreadManager sm;
    protected Map<String, Pair<String, Long>> commonFilterMap = new HashMap<String, Pair<String, Long>>(16);
    protected WorkPaperQueryAnalysisPlugin plugin;
    protected DimensionMemberDisplayTypeEnum orgDisplayType;
    protected DimensionMemberDisplayTypeEnum rowColDimensionDisplayType;
    private Map<String, Object> changMap = new HashMap<String, Object>(8);
    private List<Column> newColumnList;
    private RangeModel tempRangeModel;

    public WorkPaperQueryHelper(WorkPaperQueryAnalysisPlugin plugin, String spreadKey, TemplateModel template, SpreadManager sm) {
        this.plugin = plugin;
        this.spreadKey = spreadKey;
        this.template = template;
        this.sm = sm;
        this.initCommonFilterMap(null);
        this.initRowColDimensionDisplayType();
    }

    public static Map<String, Object> getHeadMap(List<IDimMember> userObject, String dimNum, String modelNum) {
        String memNum;
        IDNumberTreeNode node;
        Optional<IDimMember> optional;
        if (CollectionUtils.isNotEmpty(userObject) && (optional = userObject.stream().filter(d -> d.getDimension().getNumber().equals(dimNum)).findFirst()).isPresent() && (node = BcmThreadCache.findMemberByNum((String)modelNum, (String)dimNum, (String)(memNum = optional.get().getNumber()))) != IDNumberTreeNode.NotFoundTreeNode) {
            return MDQADataQueryHelper.getHeadMap(node, new HashMap<String, String>(16));
        }
        return new HashMap<String, Object>(16);
    }

    public TemplateModel getTemplate() {
        return this.template;
    }

    public SpreadManager getSm() {
        return this.sm;
    }

    public RangeModel getTempRangeModel() {
        return this.tempRangeModel;
    }

    public void setTempRangeModel(RangeModel tempRangeModel) {
        this.tempRangeModel = tempRangeModel;
    }

    public List<Column> getTemplateColumnList() {
        if (this.changMap.get(KEY_TEMPLATE_COLUMN) != null) {
            return (List)ObjectSerialUtil.deSerializedBytes((String)this.changMap.get(KEY_TEMPLATE_COLUMN).toString());
        }
        return new ArrayList<Column>(16);
    }

    public void setTemplateColumnList(List<Column> columnList) {
        if (columnList != null && !columnList.isEmpty()) {
            this.changMap.put(KEY_TEMPLATE_COLUMN, ObjectSerialUtil.toByteSerialized(columnList));
        }
    }

    public List<Column> getNewColumnList() {
        if (this.newColumnList == null && this.plugin != null) {
            String cacheKey = this.plugin.getCacheKey(COLUMN_LIST);
            if (StringUtils.isNotEmpty((CharSequence)this.plugin.getPageCache().get(cacheKey))) {
                this.newColumnList = (List)SerializationUtils.deSerializeFromBase64((String)this.plugin.getPageCache().get(cacheKey));
            }
        }
        return this.newColumnList;
    }

    public final void setNewColumnList(List<Column> newColumnList) {
        this.newColumnList = newColumnList;
    }

    public Map<String, Object> getSpreadJsonChange() {
        return this.changMap;
    }

    private void initRowColDimensionDisplayType() {
        Object wbShowType;
        if (this.sm != null && (wbShowType = this.sm.getBook().getSheet(0).getUserObject("wb_showType")) != null) {
            String showType;
            switch (showType = wbShowType.toString()) {
                case "btn_row_number": {
                    this.setRowColDimensionDisplayType(DimensionMemberDisplayTypeEnum.NUMBER);
                    break;
                }
                case "btn_row_numname": {
                    this.setRowColDimensionDisplayType(DimensionMemberDisplayTypeEnum.NUMBERANDNAME);
                    break;
                }
                case "btn_row_name": {
                    this.setRowColDimensionDisplayType(DimensionMemberDisplayTypeEnum.NAME);
                    break;
                }
                default: {
                    this.setRowColDimensionDisplayType(DimensionMemberDisplayTypeEnum.NUMBERANDNAME);
                }
            }
        }
    }

    public final void initCommonFilterMap(Map<String, Pair<String, Long>> commonFilterMap) {
        if (commonFilterMap == null) {
            commonFilterMap = new HashMap<String, Pair<String, Long>>(16);
        }
        if (this.plugin != null) {
            Long modelId = LongUtil.toLong((Object)this.plugin.getPageCache().get("KEY_MODEL_ID"));
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            commonFilterMap.put("bcm_model", (Pair<String, Long>)Pair.onePair((Object)modelNumber, (Object)modelId));
            for (Map.Entry<DimTypesEnum, Object> entry : this.plugin.getCurrentReportCommonParam("id").entrySet()) {
                String dimNum = entry.getKey().getNumber();
                IDNumberTreeNode treeNode = BcmThreadCache.findNodeById((String)modelNumber, (String)dimNum, (long)((Long)entry.getValue()));
                if (treeNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                String number = treeNode.getNumber();
                if (DimTypesEnum.ENTITY.getNumber().equals(dimNum)) {
                    number = treeNode.getParent_SonNumber();
                }
                commonFilterMap.put(DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), (Pair<String, Long>)Pair.onePair((Object)number, (Object)treeNode.getId()));
            }
            for (IDimMember p : this.sm.getFilter().getPageDomain().getAllMembers()) {
                String number = p.getNumber();
                String dimNum = p.getDimension().getNumber();
                IDNumberTreeNode treeNode = BcmThreadCache.findMemberByNum((String)modelNumber, (String)dimNum, (String)number);
                if (treeNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                commonFilterMap.put(DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), (Pair<String, Long>)Pair.onePair((Object)number, (Object)treeNode.getId()));
            }
            commonFilterMap.put("bcm_cslscheme", (Pair<String, Long>)Pair.onePair((Object)this.plugin.getFormCustomParam("schemeNum", ""), (Object)this.plugin.getFormCustomParam("schemeId", 0L)));
            this.commonFilterMap = commonFilterMap;
        } else {
            this.commonFilterMap = commonFilterMap;
        }
    }

    private Long getEntityId(String entitySign) {
        Pair<String, Long> pair;
        Long id = 0L;
        if (this.commonFilterMap != null && (pair = this.commonFilterMap.get(entitySign)) != null) {
            id = (Long)pair.p2;
        }
        return id;
    }

    private String getEntityNumber(String entitySign) {
        Pair<String, Long> pair;
        String number = "";
        if (this.commonFilterMap != null && (pair = this.commonFilterMap.get(entitySign)) != null) {
            number = (String)pair.p1;
        }
        return number;
    }

    public Map<Integer, Column> filterDebitCreditColumn(List<Column> columnList) {
        HashMap<Integer, Column> columnMap = new HashMap<Integer, Column>(16);
        if (CollectionUtils.isNotEmpty(columnList)) {
            for (int i = 0; i < columnList.size(); ++i) {
                Column column = columnList.get(i);
                if (!column.getLoanShow().booleanValue()) continue;
                columnMap.put(column.getColIndex(), column);
            }
        }
        return columnMap;
    }

    public void handleDebitCreditColum() {
        Map<Integer, Column> columnMap = this.filterDebitCreditColumn(this.getNewColumnList());
        if (MapUtils.isNotEmpty(columnMap)) {
            RangeModel rangeModel = this.getAreaRangeModel();
            List pageDomain = this.sm.getFilter().getPageDomain().getDimensions();
            List pageDimMembers = this.sm.getFilter().getPageDomain().getAllMembers();
            Set pageDims = pageDomain.stream().map(o -> o.getNumber()).collect(Collectors.toSet());
            String accountNumber = null;
            boolean isRow = true;
            Header header = null;
            Sheet sheet = this.sm.getBook().getSheet(0);
            if (pageDims.contains(DimEntityNumEnum.ACCOUNT.getNumber())) {
                for (IDimMember pageDimMember : pageDimMembers) {
                    if (!pageDimMember.getDimension().getNumber().equals(DimEntityNumEnum.ACCOUNT.getNumber())) continue;
                    accountNumber = pageDimMember.getNumber();
                    break;
                }
            } else {
                header = sheet.getRowHeader();
                isRow = header.getDimNums().contains(DimTypesEnum.ACCOUNT.getNumber());
                if (!isRow) {
                    header = sheet.getColHeader();
                }
            }
            String modelNum = this.getEntityNumber("bcm_model");
            Header finalHeader = header;
            boolean finalIsRow = isRow;
            String finalAccountNumber = accountNumber;
            columnMap.forEach((k, v) -> sheet.iteratorRangeCells(rangeModel.getY_start(), rangeModel.getY_end(), k.intValue(), k.intValue(), cell -> {
                IDNumberTreeNode node;
                HeadObject headObject;
                if (cell == null) {
                    return;
                }
                String memberNum = finalAccountNumber;
                if (finalHeader != null && (headObject = finalHeader.get(finalIsRow ? cell.getRow() : cell.getCol(), false)) != null) {
                    memberNum = headObject.getMemberNum(DimTypesEnum.ACCOUNT.getNumber());
                }
                if (StringUtils.isNotEmpty((CharSequence)memberNum) && (node = BcmThreadCache.findMemberByNum((String)modelNum, (String)DimTypesEnum.ACCOUNT.getNumber(), (String)memberNum)) != IDNumberTreeNode.NotFoundTreeNode) {
                    this.handleDebitCreditCell((Cell)cell, (String)node.getProperty("drcrdirect"), v.getDebitCredit());
                }
            }));
        }
    }

    private void handleDebitCreditCell(Cell cell, String drcrdirect, String debitCredit) {
        BigDecimal value = BigDecimal.ZERO;
        if (cell.getValue() != null) {
            if (cell.getValue() instanceof BigDecimal) {
                value = (BigDecimal)cell.getValue();
            } else if (cell.getValue() instanceof String) {
                try {
                    value = new BigDecimal((String)cell.getValue());
                }
                catch (Exception e) {
                    value = null;
                }
            }
        } else {
            return;
        }
        if (DrCRDirectEnum.NONE.getOIndex().equals(drcrdirect)) {
            cell.setValue(null);
        } else if (DrCRDirectEnum.BORROW_PLUS_lOAN_MINUS.getOIndex().equals(drcrdirect)) {
            if ("0".equals(debitCredit)) {
                cell.setValue((Object)value);
            } else if ("1".equals(debitCredit)) {
                cell.setValue(null);
            }
        } else if (DrCRDirectEnum.BORROW_MINUS_lOAN_PLUS.getOIndex().equals(drcrdirect)) {
            if ("0".equals(debitCredit)) {
                cell.setValue(null);
            } else if ("1".equals(debitCredit)) {
                cell.setValue((Object)value);
            }
        }
    }

    private RangeModel getAreaRangeModel() {
        RangeModel rangeModel = new RangeModel("A1");
        Pair<Point, Point> pair = this.getAreaRange();
        if (pair != null && pair.p1 != null && pair.p2 != null) {
            rangeModel.setX_start(((Point)pair.p1).x);
            rangeModel.setY_start(((Point)pair.p1).y);
            rangeModel.setX_end(((Point)pair.p2).x);
            rangeModel.setY_end(((Point)pair.p2).y);
        }
        return rangeModel;
    }

    private Pair<Point, Point> getAreaRange() {
        Point startPoint = null;
        Point endPoint = null;
        for (PositionInfo ps : this.sm.getAreaManager().getPostionInfoSet()) {
            String areaRange = ps.getAreaRange();
            String[] split = areaRange.split(":");
            Point currentStartPoint = ExcelUtils.pos2Point((String)split[0]);
            Point currentEndPoint = ExcelUtils.pos2Point((String)split[1]);
            if (startPoint == null || endPoint == null) {
                startPoint = currentStartPoint;
                endPoint = currentEndPoint;
                continue;
            }
            if (startPoint.y > currentStartPoint.y) {
                startPoint = currentStartPoint;
            }
            if (endPoint.y >= currentEndPoint.y) continue;
            endPoint = currentEndPoint;
        }
        return Pair.onePair(startPoint, endPoint);
    }

    private void cacheColumnList(List<Column> columnList) {
        if (this.plugin != null) {
            this.plugin.getPageCache().put(this.plugin.getCacheKey(COLUMN_LIST), SerializationUtils.serializeToBase64(columnList));
        }
    }

    private List<Column> getColumList() {
        if (this.sm != null) {
            List<Column> columnList = (List<Column>)SerializationUtils.deSerializeFromBase64((String)((String)this.sm.getBook().getSheet(0).getUserObject(COLUMN_LIST)));
            columnList = this.addDebitCreditColum(columnList);
            this.setTemplateColumnList(columnList);
            return columnList;
        }
        return new ArrayList<Column>(16);
    }

    private Map<Long, IDNumberTreeNode> getIdToIDNumberTreeNodeMap(IDNumberTreeNode node) {
        HashMap<Long, IDNumberTreeNode> map = new HashMap<Long, IDNumberTreeNode>(16);
        map.put(node.getId(), node);
        if (CollectionUtils.isNotEmpty((Collection)node.getChildren())) {
            node.getChildren().forEach(c -> map.put(c.getId(), (IDNumberTreeNode)c));
        }
        return map;
    }

    public void initSMForWp() {
        Long orgId = this.getEntityId("bcm_entitymembertree");
        Long modelId = this.getEntityId("bcm_model");
        IDNumberTreeNode node = BcmThreadCache.findNodeById((String)MemberReader.findModelNumberById((Object)modelId), (String)DimTypesEnum.ENTITY.getNumber(), (long)orgId);
        if (node == IDNumberTreeNode.NotFoundTreeNode) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\u3002", (String)"AbstractChkListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        List<IDNumberTreeNode> nodes = this.filterCancelMergeDataByUnitOrg(node);
        if (CollectionUtils.isEmpty(nodes)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5728\u6240\u9009\u8d22\u5e74\u671f\u95f4\u672a\u751f\u6548\u3002", (String)"WorkPaperQueryUnit_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        List<Column> columnList = this.getColumList();
        Pair<Point, Point> areaRange = this.getAreaRange(this.template.getAreaRangeEntries());
        Map<Long, IDNumberTreeNode> orgCache = this.getIdToIDNumberTreeNodeMap(node);
        if (!columnList.isEmpty() && areaRange != null && areaRange.p1 != null) {
            this.initEffCells(areaRange);
            this.collectTemplateSpans();
            this.fillOrgToColumList(columnList, node, nodes, ((Point)areaRange.p1).x);
            this.fillCurrency(columnList);
            this.setNewColumnList(columnList);
            this.cacheColumnList(columnList);
            this.fillColDimensionEntryExt(this.template);
            this.swichHeaderMode(columnList, orgCache);
            this.inserRowForOrg((Point)areaRange.p1);
            this.adjustDataRange(true);
            this.showDiplayType();
            this.dealPlusCell();
            this.fillFormula(columnList);
            this.modifyOrgRowStyle();
            this.changMap.put(KEY_MAXROW, this.sm.getBook().getSheet(0).getMaxRowCount() - 1);
            this.changMap.put(KEY_MAXCOL, this.sm.getBook().getSheet(0).getMaxColumnCount() - 1);
            this.mergeRowDimCell();
            this.mergeFormulaAndValueCell();
            this.modifyStyle();
            this.setColDimMemToSpreadManager(columnList);
            this.changMap.remove(KEY_TEMPLATE_COLUMN);
            this.changMap.remove(KEY_FORMULAS);
        }
    }

    private void setColDimMemToSpreadManager(List<Column> columnList) {
        ArrayList mapList = new ArrayList(16);
        HashMap<String, List> columnMap = new HashMap<String, List>(16);
        columnList.forEach(column -> {
            if (!column.hasFormula()) {
                String columnNumber = column.getNumber();
                if (columnMap.get(columnNumber) == null) {
                    columnMap.put(columnNumber, new ArrayList(16));
                }
                List columns = (List)columnMap.get(columnNumber);
                columns.add(column);
            }
        });
        columnMap.forEach((k, v) -> {
            HashMap map = new HashMap(16);
            v.forEach(column -> column.getAllDimensionMemberPair().forEach(pair -> {
                Member m = (Member)pair.p2;
                String dimNum = ((Dimension)pair.p1).getNumber();
                if (map.get(dimNum) == null) {
                    map.put(dimNum, new HashSet(16));
                }
                Set memberSets = (Set)map.get(dimNum);
                memberSets.add(m.getNumber());
                if ("Process".equals(m.getNumber())) {
                    memberSets.add("Rpt");
                }
            }));
            mapList.add(map);
        });
        if (!mapList.isEmpty()) {
            this.sm.getBook().getSheet(0).putUserObject("colDimMemListforolap", (Object)ObjectSerialUtil.toByteSerialized(mapList));
        }
    }

    private void initEffCells(Pair<Point, Point> areaRange) {
        Point startPoint = (Point)areaRange.p1;
        Point endPoint = (Point)areaRange.p2;
        ArrayList effCells = new ArrayList(16);
        HashMap<String, List> formulaMap = new HashMap<String, List>(16);
        int rowDimSize = ((AreaRangeEntry)this.template.getAreaRangeEntries().get(0)).getRowDimEntries().size();
        Set<Integer> set = this.getCanSetFormulDataArea();
        this.getSm().getBook().getSheet(0).iteratorCells(cell -> {
            String formula;
            int row = cell.getRow();
            int col = cell.getCol();
            boolean isNeed = false;
            if ((row < startPoint.y - 1 || row > endPoint.y) && col >= startPoint.x && col <= endPoint.x) {
                isNeed = true;
            }
            if (row == startPoint.y - 1 && (col < startPoint.x - rowDimSize || col > endPoint.x)) {
                isNeed = true;
            }
            if (StringUtils.isNotEmpty((CharSequence)(formula = cell.getFormula()))) {
                if (isNeed && cell.getFormula().toLowerCase(Locale.ENGLISH).startsWith("newrptinfo")) {
                    effCells.add(SpreadEasyInvoker.packedUpdateCellMap(row, col, null));
                } else if ((!new RangeModel(startPoint.x, endPoint.x, startPoint.y, endPoint.y).checkIsInArea(cell) || set.contains(row)) && TempFormulaUtil.checkIsOnlyExcel(formula)) {
                    String sign = Integer.toString(col);
                    if (formulaMap.get(sign) == null) {
                        formulaMap.put(sign, new ArrayList());
                    }
                    List mapList = (List)formulaMap.get(sign);
                    mapList.add(SpreadEasyInvoker.packedFormulaCellMap(row, col, formula));
                    cell.setFormula(null);
                }
            }
        });
        List<Column> columnList = this.getTemplateColumnList();
        int index = 0;
        for (int x = startPoint.x; x <= endPoint.x; ++x) {
            String sign = Integer.toString(x);
            if (formulaMap.get(sign) != null) {
                List maps = (List)formulaMap.remove(sign);
                if (columnList.size() > index) {
                    sign = columnList.get(index).getNumber();
                    formulaMap.put(sign, maps);
                }
            }
            ++index;
        }
        this.changMap.put(KEY_EFFCELLS, effCells);
        this.changMap.put(KEY_FORMULAS, formulaMap);
    }

    private Set<Integer> getCanSetFormulDataArea() {
        return TemplateVerification.getCanSetFormulDataArea(this.getTemplate(), this.getSm());
    }

    private List<Map<String, Object>> filterNeedCells(List<Map<String, Object>> effCells, Map<Integer, Integer> mergeRegions, Integer inserRows) {
        ArrayList<Map<String, Object>> needMergeCells = new ArrayList<Map<String, Object>>(16);
        effCells.forEach(map -> {
            Integer col = this.getValueForSign((Map<String, Object>)map, "col");
            Integer row = this.getValueForSign((Map<String, Object>)map, "row");
            if (mergeRegions.containsKey(col)) {
                map.put(SpreadProperties.UpdataValueMethod.V.k(), (Integer)mergeRegions.get(col) + 1);
                map.put("isRow", false);
                map.put("orignCol", col);
                needMergeCells.add((Map<String, Object>)map);
            } else if (inserRows.equals(row)) {
                map.put(SpreadProperties.UpdataValueMethod.V.k(), 2);
                map.put("isRow", true);
                needMergeCells.add((Map<String, Object>)map);
            }
        });
        return needMergeCells;
    }

    private void prepareDataForMergeCell(SpreadEasyInvoker invoker, List<CellRangeAddress> cellRangeAddresses, List<Map<String, Object>> needMergeCells, List<Integer> copyCols, int inserRows) {
        if (!needMergeCells.isEmpty()) {
            ArrayList<Map<String, Integer>> spans = new ArrayList(16);
            if (this.changMap.get(KEY_SPANS) != null) {
                spans = (List)this.changMap.get(KEY_SPANS);
            }
            for (Map<String, Object> map : needMergeCells) {
                int row = this.getValueForSign(map, "row");
                int col = this.getValueForSign(map, "col");
                if (inserRows < row) {
                    map.put(SpreadProperties.UpdataValueMethod.R.k(), ++row);
                }
                int adjustCol = col;
                for (int i = 0; i < copyCols.size(); ++i) {
                    if (copyCols.get(i) >= col) continue;
                    ++adjustCol;
                }
                if (((Boolean)map.get("isRow")).booleanValue()) {
                    this.dealMergerCell(invoker, row, adjustCol, 2, 1, cellRangeAddresses, spans);
                    continue;
                }
                int count = this.getValueForSign(map, "value");
                this.dealMergerCell(invoker, row, adjustCol, 1, count, cellRangeAddresses, spans);
            }
        }
    }

    private void collectTemplateSpans() {
        List spansData;
        String json;
        JSONObject object;
        JSONObject sheets;
        JSONObject sheet;
        if (!(this.template == null || this.template.getSpreadJson() == null && this.template.getRptSpreadJson() == null || (sheet = (JSONObject)(sheets = (JSONObject)(object = JSONObjectUtil.parseObjectOrder((String)(json = JsonSerializerUtil.uncompress((String)(this.template.getSpreadJson() == null ? this.template.getRptSpreadJson() : this.template.getSpreadJson()))))).get((Object)"sheets")).values().iterator().next()) == null || sheet.get((Object)KEY_SPANS) == null || (spansData = (List)sheet.get((Object)KEY_SPANS)).isEmpty())) {
            this.changMap.put(KEY_SPANS, spansData);
            HashMap spanValues = new HashMap(16);
            spansData.forEach(span -> {
                int srow = (Integer)span.get("row");
                int scol = (Integer)span.get("col");
                Cell cell = this.getSm().getBook().getSheet(0).getCell(srow, scol);
                if (cell.hasFormula()) {
                    spanValues.put(this.getSpanVFSign(srow, scol, true), cell.getFormula());
                } else {
                    Object value = cell.getValue();
                    if (!Objects.isNull(value)) {
                        spanValues.put(this.getSpanVFSign(srow, scol, false), value);
                    }
                }
            });
            if (!spanValues.isEmpty()) {
                this.changMap.put(KEY_SPANS_VALUES, spanValues);
            }
        }
    }

    private void dealMergerCell(SpreadEasyInvoker invoker, int row, int col, int rc, int cc, List<CellRangeAddress> cellRangeAddresses, List<Map<String, Integer>> spans) {
        this.updateMergeCell(row, col, rc, cc);
        if (!spans.isEmpty()) {
            for (Map<String, Integer> span : spans) {
                int srow = span.get("row");
                int rowCount = span.get("rowCount");
                int scol = span.get("col");
                int colCount = span.get("colCount");
                String mergeRange = this.getRangeStr(row, col, rc, cc);
                String tempMergeRange = this.getRangeStr(srow, scol, rowCount, colCount);
                if (!ExcelUtils.isOverlap((String)tempMergeRange, (String)mergeRange)) continue;
                rc = Math.abs(row + rc - srow) > Math.abs(srow + rowCount - row) ? Math.abs(row + rc - srow) : Math.abs(srow + rowCount - row);
                cc = Math.abs(col + cc - scol) > Math.abs(scol + colCount - col) ? Math.abs(col + cc - scol) : Math.abs(scol + colCount - col);
                row = srow > row ? row : srow;
                col = scol > col ? col : scol;
            }
        }
        if (invoker != null) {
            HashMap<String, Object> styleMap = new HashMap<String, Object>(16);
            styleMap.put(SpreadProperties.SetCellStyleMethod.WW.k(), true);
            styleMap.put(SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), 1);
            styleMap.put(SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), 1);
            invoker.setStyle(row, col, rc, cc, styleMap);
            invoker.setSpan(row, col, rc, cc);
        } else {
            cellRangeAddresses.add(new CellRangeAddress(row, row + rc - 1, col, col + cc - 1));
        }
    }

    private String getRangeStr(int row, int col, int rc, int cc) {
        String start = ExcelUtils.xy2Pos((int)col, (int)row);
        String end = ExcelUtils.xy2Pos((int)(col + cc - 1), (int)(row + rc - 1));
        return start + ":" + end;
    }

    private void updateMergeCell(int row, int col, int rc, int cc) {
        Cell cell = this.sm.getBook().getSheet(0).getCell(row, col);
        Cell oldCell = this.sm.getBook().getSheet(0).getCell(row + rc - 1, col + cc - 1);
        if (oldCell.getFormula() != null) {
            cell.setFormula(oldCell.getFormula());
            oldCell.setFormula(null);
        } else if (oldCell.getValue() != null) {
            cell.setValue(oldCell.getValue());
            oldCell.setValue(null);
        }
    }

    private void mergeFormulaAndValueCell() {
        Map<String, Object> jsonChange = this.getSpreadJsonChange();
        List effCells = (List)jsonChange.get(KEY_EFFCELLS);
        ArrayList<CellRangeAddress> cellRangeAddresses = new ArrayList<CellRangeAddress>(16);
        List cols = (List)jsonChange.get(SpreadProperties.ContextMenuItemNamesEnum.insertColumns.name());
        Integer inserRows = (Integer)jsonChange.get(SpreadProperties.ContextMenuItemNamesEnum.insertRows.name());
        boolean updateSpans = this.updateSpans(cols, inserRows);
        SpreadEasyInvoker invoker = null;
        if (this.plugin != null) {
            invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spreadKey);
            invoker.setBatch(true);
        }
        if (updateSpans) {
            List spans = new ArrayList(16);
            if (this.changMap.get(KEY_SPANS) != null) {
                spans = (List)this.changMap.get(KEY_SPANS);
            }
            if (!spans.isEmpty()) {
                for (Map span : spans) {
                    int srow = (Integer)span.get("row");
                    int rowCount = (Integer)span.get("rowCount");
                    int scol = (Integer)span.get("col");
                    int colCount = (Integer)span.get("colCount");
                    cellRangeAddresses.add(new CellRangeAddress(srow, srow + rowCount - 1, scol, scol + colCount - 1));
                    if (invoker == null) continue;
                    invoker.setSpan(srow, scol, rowCount, colCount);
                }
            }
        }
        if (!effCells.isEmpty()) {
            LinkedHashMap<Integer, Integer> mergeRegions = new LinkedHashMap<Integer, Integer>(cols.size());
            ArrayList<Integer> copyCols = new ArrayList<Integer>(16);
            if (!cols.isEmpty()) {
                CollectionUtils.addAll(copyCols, (Object[])new Object[cols.size()]);
                Collections.copy(copyCols, cols);
                Collections.reverse(cols);
                cols.forEach(index -> {
                    if (mergeRegions.get(index) == null) {
                        mergeRegions.put((Integer)index, 0);
                    }
                    mergeRegions.put((Integer)index, (Integer)mergeRegions.get(index) + 1);
                });
            }
            List<Map<String, Object>> needMergeCells = this.filterNeedCells(effCells, mergeRegions, inserRows);
            this.prepareDataForMergeCell(invoker, cellRangeAddresses, needMergeCells, copyCols, inserRows);
        }
        if (invoker != null) {
            invoker.startToInvoke();
        } else {
            List cellRangeAddressList = (List)jsonChange.get(SpreadProperties.SetSpanMethod.SETSPAN.k());
            cellRangeAddressList.addAll(cellRangeAddresses);
            jsonChange.put(SpreadProperties.SetSpanMethod.SETSPAN.k(), cellRangeAddressList);
        }
        jsonChange.remove(KEY_EFFCELLS);
    }

    private boolean updateSpans(List<Integer> cols, Integer inserRows) {
        AtomicBoolean isUpdate = new AtomicBoolean(false);
        List spans = new ArrayList(16);
        if (this.changMap.get(KEY_SPANS) != null) {
            spans = (List)this.changMap.get(KEY_SPANS);
        }
        if (!spans.isEmpty()) {
            Map spanValues = new HashMap(16);
            if (this.changMap.get(KEY_SPANS_VALUES) != null) {
                spanValues = (Map)this.changMap.get(KEY_SPANS_VALUES);
            }
            for (Map span : spans) {
                int srow = (Integer)span.get("row");
                int rowCount = (Integer)span.get("rowCount");
                int scol = (Integer)span.get("col");
                int colCount = (Integer)span.get("colCount");
                String sign = this.getSpanVFSign(srow, scol, false);
                String fsign = this.getSpanVFSign(srow, scol, true);
                if (inserRows != null) {
                    if (inserRows < srow) {
                        span.put("row", srow + 1);
                        isUpdate.set(true);
                    } else if (rowCount != 1 && inserRows >= srow && inserRows <= srow + rowCount - 1) {
                        span.put("rowCount", rowCount + 1);
                        isUpdate.set(true);
                    }
                }
                int adjustCol = scol;
                int adjustCount = colCount;
                if (cols != null && !cols.isEmpty()) {
                    for (Integer col : cols) {
                        if (col < scol) {
                            ++adjustCol;
                            isUpdate.set(true);
                            continue;
                        }
                        if (colCount == 1 || col < scol || col > scol + colCount - 1) continue;
                        ++adjustCount;
                        isUpdate.set(true);
                    }
                    span.put("col", adjustCol);
                    span.put("colCount", adjustCount);
                }
                Cell cell1 = this.getSm().getBook().getSheet(0).getCell(((Integer)span.get("row")).intValue(), ((Integer)span.get("col")).intValue());
                if (!isUpdate.get()) continue;
                if (spanValues.get(sign) != null) {
                    cell1.setValue(spanValues.get(sign));
                    continue;
                }
                if (spanValues.get(fsign) == null) continue;
                cell1.setFormula(spanValues.get(fsign).toString());
            }
            this.changMap.put(KEY_SPANS, spans);
        }
        return isUpdate.get();
    }

    private String getSpanVFSign(int row, int col, boolean isFormula) {
        String sign = "row:" + row + "col:" + col;
        if (isFormula) {
            sign = sign + ":formula";
        }
        return sign;
    }

    private int getValueForSign(Map<String, Object> map, String sign) {
        String key = "";
        switch (sign) {
            case "row": {
                key = SpreadProperties.UpdataValueMethod.R.k();
                break;
            }
            case "col": {
                key = SpreadProperties.UpdataValueMethod.C.k();
                break;
            }
            case "value": {
                key = SpreadProperties.UpdataValueMethod.V.k();
                break;
            }
            default: {
                key = sign;
            }
        }
        return (Integer)map.get(key);
    }

    private void modifyStyle() {
        if (this.plugin != null) {
            Pair<Point, Point> areaRange = this.getAreaRange();
            Point startPoint = (Point)areaRange.p1;
            HashMap<String, Integer> rangeMap = new HashMap<String, Integer>(16);
            rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), startPoint.y - 2);
            rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), 0);
            rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), 1);
            rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), this.sm.getBook().getSheet(0).getMaxColumnCount());
            ArrayList<HashMap<String, Integer>> rangeList = new ArrayList<HashMap<String, Integer>>(10);
            rangeList.add(rangeMap);
            HashMap<String, Comparable<Boolean>> styleMap = new HashMap<String, Comparable<Boolean>>(16);
            styleMap.put(SpreadProperties.SetCellStyleMethod.WW.k(), Boolean.valueOf(true));
            styleMap.put(SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), Integer.valueOf(1));
            styleMap.put(SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), Integer.valueOf(1));
            HashMap<String, Cloneable> features = new HashMap<String, Cloneable>(16);
            features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
            features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
            SpreadClientInvoker.invokeSetCellStyleMethod(this.plugin.getClientViewProxy(), this.spreadKey, Collections.singletonList(features));
            HashMap<String, List<Integer>> featureMap = new HashMap<String, List<Integer>>(16);
            featureMap.put(SpreadProperties.AutoFitRows.R.k(), Collections.singletonList(startPoint.y - 2));
            SpreadClientInvoker.invokeAutoFitRows(this.plugin.getClientViewProxy(), this.spreadKey, featureMap);
        }
    }

    private void mergeRowDimCell() {
        SpreadEasyInvoker invoker = null;
        if (this.plugin != null) {
            invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spreadKey);
            invoker.setBatch(true);
        }
        ArrayList<CellRangeAddress> cellRangeAddresses = new ArrayList<CellRangeAddress>(16);
        Pair<Point, Point> pair1 = this.getAreaRange();
        Point startPoint = (Point)pair1.p1;
        int rowDimSize = ((AreaRangeEntry)this.template.getAreaRangeEntries().get(0)).getRowDimEntries().size();
        for (int i = 1; i <= rowDimSize; ++i) {
            if (invoker != null) {
                invoker.setSpan(startPoint.y - 2, startPoint.x - i, 2, 1);
                continue;
            }
            cellRangeAddresses.add(new CellRangeAddress(startPoint.y - 2, startPoint.y - 1, startPoint.x - i, startPoint.x - i));
        }
        for (Column column : this.newColumnList) {
            if (!column.hasFormula()) continue;
            int colIndex = column.getColIndex();
            if (invoker != null) {
                invoker.setSpan(startPoint.y - 2, colIndex, 2, 1);
                continue;
            }
            cellRangeAddresses.add(new CellRangeAddress(startPoint.y - 2, startPoint.y - 1, colIndex, colIndex));
        }
        if (invoker != null) {
            invoker.startToInvoke();
        }
        if (this.plugin == null) {
            this.changMap.put(SpreadProperties.SetSpanMethod.SETSPAN.k(), cellRangeAddresses);
        }
    }

    private List<Column> addDebitCreditColum(List<Column> columnList) {
        ArrayList<Column> newColumnList = new ArrayList<Column>(16);
        int offset = 0;
        for (Column column : columnList) {
            if (column.getLoanShow().booleanValue()) {
                Column column1 = new Column(column.getNumber() + "@credit", column.getHeaderName(), column.getColIndex(), column.getDisplayChild().booleanValue(), column.getFormula(), column.getLoanShow().booleanValue());
                column.setNumber(column.getNumber() + "@debit");
                column1.setProcess(column.getProcess());
                column1.setOrg(column.getOrg());
                column1.setCurrency(column.getCurrency());
                column1.setAuditTrial(column.getAuditTrial());
                column.setHeaderName(String.format(ResManager.loadKDString((String)"%s\u501f\u65b9", (String)"WorkPaperQueryUnit_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), column.getHeaderName()));
                column1.setHeaderName(String.format(ResManager.loadKDString((String)"%s\u8d37\u65b9", (String)"WorkPaperQueryUnit_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), column1.getHeaderName()));
                column.setDebitCredit("0");
                column1.setDebitCredit("1");
                if (offset > 0) {
                    column.setColIndex(column.getColIndex() + offset);
                }
                column1.setColIndex(column.getColIndex() + 1);
                column1.setLoanShow(Boolean.valueOf(true));
                column1.setUseDefault(Boolean.valueOf(column.isUseDefault()));
                newColumnList.add(column);
                newColumnList.add(column1);
                ++offset;
                continue;
            }
            if (offset > 0) {
                column.setColIndex(column.getColIndex() + offset);
            }
            newColumnList.add(column);
        }
        return newColumnList;
    }

    private void modifyOrgRowStyle() {
        if (this.plugin != null) {
            Pair<Point, Point> pair1 = this.getAreaRange();
            Point startPoint = (Point)pair1.p1;
            HashMap<String, Integer> rangeMap = new HashMap<String, Integer>(16);
            rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), startPoint.y - 1);
            rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), 0);
            rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), 1);
            rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), this.sm.getBook().getSheet(0).getMaxColumnCount());
            ArrayList<HashMap<String, Integer>> rangeList = new ArrayList<HashMap<String, Integer>>(10);
            rangeList.add(rangeMap);
            HashMap<String, Comparable<Boolean>> styleMap = new HashMap<String, Comparable<Boolean>>(16);
            styleMap.put(SpreadProperties.SetCellStyleMethod.WW.k(), Boolean.valueOf(true));
            styleMap.put(SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), Integer.valueOf(1));
            styleMap.put(SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), Integer.valueOf(1));
            HashMap<String, Cloneable> features = new HashMap<String, Cloneable>(16);
            features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
            features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
            SpreadClientInvoker.invokeSetCellStyleMethod(this.plugin.getClientViewProxy(), this.spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
            HashMap<String, List<Integer>> featureMap = new HashMap<String, List<Integer>>(16);
            featureMap.put(SpreadProperties.AutoFitRows.R.k(), Collections.singletonList(startPoint.y - 1));
            SpreadClientInvoker.invokeAutoFitRows(this.plugin.getClientViewProxy(), this.spreadKey, featureMap);
        }
    }

    private void dealPlusCell() {
        if (this.plugin != null) {
            Pair<Point, Point> pair1 = this.getAreaRange();
            Point startPoint = (Point)pair1.p1;
            List<Column> newColumnList = this.getNewColumnList();
            List<Pair<Integer, Integer>> spanInfo = this.getSpanInfo(newColumnList);
            SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spreadKey);
            invoker.setBatch(true);
            ArrayList<Map<String, Object>> plus = new ArrayList<Map<String, Object>>(spanInfo.size());
            for (Pair<Integer, Integer> pair : spanInfo) {
                invoker.setSpan(startPoint.y - 2, (Integer)pair.p1, 1, (Integer)pair.p2);
                String string = "- " + newColumnList.get((Integer)pair.p1 - startPoint.x).getHeaderName();
                plus.add(SpreadEasyInvoker.packedUpdateCellMap(startPoint.y - 2, (Integer)pair.p1, string));
                this.sm.getBook().getSheet(0).getCell(startPoint.y - 2, ((Integer)pair.p1).intValue()).setValue((Object)string);
            }
            invoker.startToInvoke();
            if (!plus.isEmpty()) {
                SpreadClientInvoker.invokeUpdataValueMethod(this.plugin.getClientViewProxy(), this.spreadKey, plus);
                ArrayList<1> plusCell = new ArrayList<1>(plus.size());
                for (final Map map : plus) {
                    HashMap<Object, Object> map2 = new HashMap<Object, Object>(){
                        {
                            this.put(map.get("c"), map.get("v"));
                        }
                    };
                    plusCell.add(map2);
                }
                this.plugin.getPageCache().put(this.plugin.getCacheKey("pluscell"), SerializationUtils.toJsonString(plusCell));
            }
        }
    }

    private List<Pair<Integer, Integer>> getSpanInfo(List<Column> newColumnList) {
        ArrayList<Pair<Integer, Integer>> spanInfo = new ArrayList<Pair<Integer, Integer>>();
        Stack<Column> stack = new Stack<Column>();
        for (Column column : newColumnList) {
            if (stack.isEmpty() || column.getNumber().equals(((Column)stack.peek()).getNumber())) {
                stack.push(column);
            }
            if (column.getNumber().equals(((Column)stack.peek()).getNumber())) continue;
            if (stack.size() == 1) {
                stack.clear();
                stack.push(column);
                continue;
            }
            if (stack.size() < 2) continue;
            int colLenth = stack.size();
            for (int i = 0; i < colLenth - 1; ++i) {
                stack.pop();
            }
            Column start = (Column)stack.pop();
            int colStart = start.getColIndex();
            spanInfo.add((Pair<Integer, Integer>)Pair.onePair((Object)colStart, (Object)colLenth));
            stack.push(column);
        }
        if (stack.size() >= 2) {
            int colLenth = stack.size();
            for (int i = 0; i < colLenth - 1; ++i) {
                stack.pop();
            }
            Column start = (Column)stack.pop();
            int colStart = start.getColIndex();
            spanInfo.add((Pair<Integer, Integer>)Pair.onePair((Object)colStart, (Object)colLenth));
        }
        return spanInfo;
    }

    private void fillFormula(List<Column> columnList) {
        ArrayList<Map<String, Object>> formulas = new ArrayList<Map<String, Object>>(16);
        LinkedHashMap<String, Pair<Integer, Boolean>> number_index = new LinkedHashMap<String, Pair<Integer, Boolean>>(16);
        Pair<Point, Point> pair = this.getAreaRange();
        List<Column> templateColumnList = this.getTemplateColumnList();
        Map formulaMap = new HashMap(16);
        if (this.changMap.get(KEY_FORMULAS) != null) {
            formulaMap = (Map)this.changMap.get(KEY_FORMULAS);
        }
        columnList.forEach(column -> {
            String number = column.getNumber();
            if (column.getLoanShow().booleanValue()) {
                number = number.split("@")[0];
            }
            number_index.computeIfAbsent(number, k -> Pair.onePair((Object)column.getColIndex(), (Object)(column.getDisplayChild() != false || column.getLoanShow() != false ? 1 : 0)));
        });
        if (!number_index.isEmpty()) {
            Column column2 = columnList.get(columnList.size() - 1);
            String lastColNumber = column2.getNumber();
            if (column2.getLoanShow().booleanValue()) {
                lastColNumber = lastColNumber.split("@")[0];
            }
            Pair lastPair = (Pair)number_index.get(lastColNumber);
            if (((Boolean)lastPair.p2).booleanValue()) {
                number_index.put(GlobalIdUtil.genStringId(), Pair.onePair((Object)(((Point)pair.p2).x + 1), (Object)false));
            }
        }
        List<ColIndexInfo> colIndexInfos = this.getColIndexInfos(columnList, templateColumnList);
        HashSet<String> colHeadSet = new HashSet<String>(16);
        for (Column column3 : columnList) {
            colHeadSet.add(column3.getNumber());
            if (column3.hasFormula()) {
                this.fillColFormula(column3.getFormula(), formulas, number_index, ((Point)pair.p1).y, ((Point)pair.p2).y, column3.getColIndex());
            }
            if (formulaMap.get(column3.getNumber()) == null) continue;
            ((List)formulaMap.get(column3.getNumber())).forEach(e -> {
                int row = Integer.parseInt(e.get(SpreadProperties.SetFormulaMethod.R.k()).toString());
                String formula = this.getCurrectFormula(colIndexInfos, e.get(SpreadProperties.SetFormulaMethod.F.k()).toString(), column3.getColIndex(), ((Point)pair.p1).y - 1, true);
                if (row >= ((Point)pair.p1).y) {
                    ++row;
                }
                formulas.add(SpreadEasyInvoker.packedFormulaCellMap(row, column3.getColIndex(), formula));
                this.getSm().getBook().getSheet(0).getCell(row, column3.getColIndex()).setFormula(formula);
            });
        }
        if (!formulaMap.isEmpty()) {
            RangeModel rangeModel = this.getTempRangeModel();
            int endCol = rangeModel.getX_end();
            for (Map.Entry entry : formulaMap.entrySet()) {
                if (colHeadSet.contains(entry.getKey())) continue;
                int col = Integer.parseInt((String)entry.getKey());
                if (col > endCol) {
                    col += ((Point)pair.p2).x - endCol;
                }
                for (Map map : (List)entry.getValue()) {
                    int row = Integer.parseInt(map.get(SpreadProperties.SetFormulaMethod.R.k()).toString());
                    String formula = this.getCurrectFormula(colIndexInfos, map.get(SpreadProperties.SetFormulaMethod.F.k()).toString(), col, ((Point)pair.p1).y - 1, false);
                    if (row >= ((Point)pair.p1).y - 1) {
                        ++row;
                    }
                    formulas.add(SpreadEasyInvoker.packedFormulaCellMap(row, col, formula));
                    this.getSm().getBook().getSheet(0).getCell(row, col).setFormula(formula);
                }
            }
        }
        if (this.plugin != null && !formulas.isEmpty()) {
            SpreadClientInvoker.invokeSetFormulaMethod(this.plugin.getClientViewProxy(), this.spreadKey, formulas);
        }
    }

    private void fillColFormula(String formula, List<Map<String, Object>> formulas, LinkedHashMap<String, Pair<Integer, Boolean>> number_index, int startRow, int endRow, int nowCol) {
        for (int row = startRow; row <= endRow; ++row) {
            String temp = WpFormulaUtil.transFormula2Coordinate(row, formula, number_index);
            if (this.plugin != null) {
                formulas.add(SpreadEasyInvoker.packedFormulaCellMap(row, nowCol, temp));
            }
            this.sm.getBook().getSheet(0).getCell(row, nowCol).setFormula(temp);
        }
    }

    private void adjustDataRange(boolean isRow) {
        List<Column> columnList = this.getColumList();
        List<Column> newColumnList = this.getNewColumnList();
        int size = newColumnList.size() - columnList.size();
        this.sm.getAreaManager().getPostionInfoSet().forEach(pos -> {
            String[] split = pos.getAreaRange().split(":");
            Point startPoint = ExcelUtils.pos2Point((String)split[0]);
            Point endPoint = ExcelUtils.pos2Point((String)split[1]);
            String startPosition = ExcelUtils.xy2Pos((int)startPoint.x, (int)(isRow ? startPoint.y + 1 : startPoint.y));
            String endPosition = ExcelUtils.xy2Pos((int)(isRow ? endPoint.x : endPoint.x + size), (int)(isRow ? endPoint.y + 1 : endPoint.y));
            pos.setStartPosition(startPosition);
            pos.setAreaRange(startPosition + ":" + endPosition);
        });
    }

    public void inserRowForOrg(Point startPonit) {
        this.sm.getBook().getSheet(0).insertRow(startPonit.y - 1);
        List row = this.sm.getBook().getSheet(0).getRow(startPonit.y - 1);
        ArrayList formulas = new ArrayList(16);
        ArrayList cellValues = new ArrayList(16);
        row.forEach(cell -> {
            if (cell.getValue() != null) {
                cellValues.add(SpreadEasyInvoker.packedUpdateCellMap(startPonit.y, cell.getCol(), null));
                if (cell.hasFormula()) {
                    formulas.add(SpreadEasyInvoker.packedFormulaCellMap(startPonit.y, cell.getCol(), null));
                }
            }
        });
        if (this.plugin != null) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(10);
            linkedHashMap.put("status", true);
            linkedHashMap.put("copyStyle", true);
            linkedHashMap.put("data", Collections.singletonList(startPonit.y - 1));
            SpreadClientInvoker.invokeInsertRow(this.plugin.getClientViewProxy(), this.spreadKey, linkedHashMap);
            if (!cellValues.isEmpty()) {
                SpreadClientInvoker.invokeUpdataValueMethod(this.plugin.getClientViewProxy(), this.spreadKey, cellValues);
            }
            if (!formulas.isEmpty()) {
                SpreadClientInvoker.invokeSetFormulaMethod(this.plugin.getClientViewProxy(), this.spreadKey, formulas);
            }
        }
        this.changMap.put(SpreadProperties.ContextMenuItemNamesEnum.insertRows.name(), startPonit.y - 1);
    }

    public void showDiplayType() {
        SpreadEasyInvoker invoker = null;
        boolean isNeedInvoker = false;
        if (this.plugin != null) {
            invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spreadKey);
            invoker.setBatch(true);
            isNeedInvoker = true;
        }
        this.dealDisplayType(this.getOrgDisplayType(), true, invoker);
        this.dealDisplayType(this.getRowColDimensionDisplayType(), false, invoker);
        Sheet sheet = this.sm.getBook().getSheet(0);
        RangeModel rangeModel = this.getAreaRangeModel();
        for (Column c : this.getNewColumnList()) {
            Cell cell = sheet.getCell(rangeModel.getY_start() - 2, c.getColIndex());
            cell.setValue((Object)c.getHeaderName());
            cell.setChangeVal(false);
            if (!isNeedInvoker) continue;
            invoker.updataValue(cell.getRow(), cell.getCol(), cell.getValue());
        }
        if (isNeedInvoker) {
            invoker.startToInvoke();
        }
    }

    public void dealDisplayType(DimensionMemberDisplayTypeEnum displayType, boolean isOrg, SpreadEasyInvoker invoker) {
        boolean isFromQuery;
        RangeModel rangeModel = this.getAreaRangeModel();
        Sheet sheet = this.sm.getBook().getSheet(0);
        boolean bl = isFromQuery = invoker != null;
        if (isOrg) {
            Map<Integer, Column> columnMap = WorkPaperUtil.groupColumn(false, this.getNewColumnList());
            Header header = sheet.getHeader(false);
            int row = rangeModel.getY_start() - 1;
            header.iteratorObjects(rangeModel.getX_start(), rangeModel.getX_end(), e -> {
                Column column = (Column)columnMap.get(e.getIndex());
                boolean isParSon = false;
                if (column != null && column.getOrg() != null && column.getOrg().p2 != null && ((Member)column.getOrg().p2).getNumber().split("_").length == 2) {
                    isParSon = true;
                }
                String showValue = e.getShowValue(displayType, DimTypesEnum.ENTITY.getNumber(), false, isParSon);
                if (isFromQuery) {
                    invoker.updataValue(row, e.getIndex(), showValue);
                }
                Cell cell = sheet.getCell(row, e.getIndex());
                cell.setValue((Object)showValue);
                cell.setChangeVal(false);
            });
            if (isFromQuery) {
                invoker.resetCellStyle(row, rangeModel.getX_start(), 1, rangeModel.getColSize());
            }
        } else {
            int headRow = rangeModel.getY_start() - 2;
            Map numMapName = MemberReader.getDimNumberMapNameById((long)this.getEntityId("bcm_model"));
            List dimNums = sheet.getHeader(true).getDimNums();
            int i = 0;
            for (int x = rangeModel.getX_start() - dimNums.size(); x < rangeModel.getX_start(); ++x) {
                String dimNum;
                String dimName;
                Cell cell = sheet.getCell(headRow, x);
                if (dimNums.size() > i && StringUtils.isNotEmpty((CharSequence)(dimName = (String)numMapName.get(dimNum = (String)dimNums.get(i))))) {
                    String value = dimNum + " " + dimName;
                    if (DimensionMemberDisplayTypeEnum.NAME == displayType) {
                        value = dimName;
                    } else if (DimensionMemberDisplayTypeEnum.NUMBER == displayType) {
                        value = dimNum;
                    }
                    cell.setValue((Object)value);
                    cell.setChangeVal(false);
                    if (isFromQuery) {
                        invoker.updataValue(headRow, x, cell.getValue());
                    }
                }
                ++i;
            }
            MultiDimQAStyleService.setRowOrColHeaderValue(invoker, sheet, rangeModel.getY_start(), rangeModel.getY_end(), displayType, true, false, rangeModel.getX_start() - dimNums.size());
        }
    }

    private void fillColDimensionEntryExt(TemplateModel templateModel) {
        List firstAreaList = ((AreaRangeEntry)templateModel.getAreaRangeEntries().get(0)).getColDimEntriesExt();
        firstAreaList.sort(Comparator.comparingInt(ColDimensionEntryExt::getIndex));
        for (int i = 1; i < templateModel.getAreaRangeEntries().size(); ++i) {
            ((AreaRangeEntry)templateModel.getAreaRangeEntries().get(i)).getColDimEntriesExt().addAll(firstAreaList);
        }
    }

    private void fillCurrency(List<Column> columnList) {
        for (Column column : columnList) {
            IDNumberTreeNode currencyMemberByNum;
            String curNum;
            if (column.hasFormula() || column.getOrg() == null || column.getOrg().p2 == null || !(curNum = ((Member)column.getCurrency().p2).getNumber()).equals("EC") && !curNum.equals("DC")) continue;
            long orgId = ((Member)column.getOrg().p2).getId();
            String bpnumber = ((Member)column.getProcess().p2).getNumber();
            Pair pair = TransMemberUtil.transOrgAndCurbyOrgId((String)this.getEntityNumber("bcm_model"), (long)orgId, (String)bpnumber, (String)curNum, (long)0L, (long)0L);
            if (pair == null || (currencyMemberByNum = MemberReader.findCurrencyMemberByNum((String)this.getEntityNumber("bcm_model"), (String)((String)pair.p2))) == null) continue;
            ((Member)column.getCurrency().p2).setNumber((String)pair.p2);
            ((Member)column.getCurrency().p2).setId(currencyMemberByNum.getId().longValue());
            ((Member)column.getCurrency().p2).setName(currencyMemberByNum.getName());
        }
    }

    private void fillOrgToColumList(List<Column> columnList, IDNumberTreeNode node, List<IDNumberTreeNode> orgList, int startRow) {
        ListIterator<Column> iterator = columnList.listIterator();
        ArrayList<Integer> idxs = new ArrayList<Integer>(10);
        Map<String, String> trueOrgName = this.getTrueOrgName(orgList, node);
        while (iterator.hasNext()) {
            Column column = iterator.next();
            if (column.getProcess().p2 == null && !column.hasFormula()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u5347\u7ea7\uff0c\u8bf7\u5148\u4fdd\u5b58\u5e95\u7a3f\u6a21\u677f\u3002", (String)"MultiTabWorkPaperPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (column.hasFormula()) {
                Member member = this.getMemberById(node, trueOrgName);
                column.setOrg(Pair.onePair((Object)column.getOrg().p1, (Object)member));
                continue;
            }
            boolean relaProcess = OrgRelaProcessMembPool.isRelaProcess((String)((Member)column.getProcess().p2).getNumber());
            if (column.isUseDefault() && column.getDisplayChild().booleanValue() && !relaProcess) {
                if (orgList.size() == 0) {
                    iterator.remove();
                    continue;
                }
                column.setOrg(Pair.onePair((Object)column.getOrg().p1, (Object)this.getMemberById(orgList.get(0), trueOrgName)));
                for (int i = 1; i < orgList.size(); ++i) {
                    Column nextColumn = column.copy();
                    idxs.add(column.getColIndex());
                    nextColumn.setOrg(Pair.onePair((Object)nextColumn.getOrg().p1, (Object)this.getMemberById(orgList.get(i), trueOrgName)));
                    iterator.add(nextColumn);
                }
                continue;
            }
            if (relaProcess && !node.isLeaf() && column.getDisplayChild().booleanValue()) {
                if (orgList.size() == 0) {
                    iterator.remove();
                    continue;
                }
                boolean isSelf = orgList.size() == 1 && orgList.get(0).getId().equals(node.getId());
                Member member = this.getMemberById(orgList.get(0), trueOrgName);
                if (!isSelf) {
                    member.setNumber(node.getNumber() + '_' + member.getNumber());
                }
                column.setOrg(Pair.onePair((Object)column.getOrg().p1, (Object)member));
                for (int i = 1; i < orgList.size(); ++i) {
                    Column nextColumn = column.copy();
                    idxs.add(column.getColIndex());
                    member = this.getMemberById(orgList.get(i), trueOrgName);
                    member.setNumber(node.getNumber() + '_' + member.getNumber());
                    nextColumn.setOrg(Pair.onePair((Object)nextColumn.getOrg().p1, (Object)member));
                    iterator.add(nextColumn);
                }
                continue;
            }
            Member member = this.getMemberById(node, trueOrgName);
            if (relaProcess && node.getParent() != null) {
                member.setNumber(node.getParent_SonNumber());
            }
            column.setOrg(Pair.onePair((Object)column.getOrg().p1, (Object)member));
        }
        for (int i = 0; i < columnList.size(); ++i) {
            columnList.get(i).setColIndex(startRow + i);
        }
        this.changMap.put(SpreadProperties.ContextMenuItemNamesEnum.insertColumns.name(), idxs.stream().collect(Collectors.toList()));
        this.setNewColumnList(columnList);
        Sheet sheet = this.sm.getBook().getSheet(0);
        List<Integer> needInsertIndex = this.getNeedInsertIndex(idxs);
        needInsertIndex.forEach(idx -> {
            if (!sheet.ensureMaxCol(idx.intValue())) {
                sheet.addColumns(idx.intValue());
            }
            sheet.insertColumn(idx.intValue());
        });
        this.adjustDataRange(false);
        if (this.plugin != null && CollectionUtils.isNotEmpty(needInsertIndex)) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(16);
            map.put("data", needInsertIndex);
            map.put("status", true);
            SpreadClientInvoker.invokeInsertCol(this.plugin.getClientViewProxy(), this.spreadKey, map);
        }
    }

    private List<IDNumberTreeNode> filterCancelMergeDataByUnitOrg(IDNumberTreeNode currentOrgNode) {
        ArrayList<IDNumberTreeNode> orgList = new ArrayList<IDNumberTreeNode>(16);
        ArrayList<Long> orgIds = new ArrayList<Long>(orgList.size());
        orgList.addAll(currentOrgNode.getChildren());
        orgIds.addAll(currentOrgNode.getChildrenIds());
        if (CollectionUtils.isEmpty(orgList)) {
            orgList.add(currentOrgNode);
            orgIds.add(currentOrgNode.getId());
        }
        Map<String, String> pageViewMember = WorkPaperUtil.getPageViewMember(this.sm);
        String scenarioNum = pageViewMember.get(DimTypesEnum.SCENARIO.getNumber());
        String yearNum = pageViewMember.get(DimTypesEnum.YEAR.getNumber());
        String periodNum = pageViewMember.get(DimTypesEnum.PERIOD.getNumber());
        if (StringUtils.isNotEmpty((CharSequence)scenarioNum) && StringUtils.isNotEmpty((CharSequence)yearNum) && StringUtils.isNotEmpty((CharSequence)periodNum)) {
            String modelNum = this.getEntityNumber("bcm_model");
            long sceneId = BcmThreadCache.findMemberByNum((String)modelNum, (String)DimTypesEnum.SCENARIO.getNumber(), (String)scenarioNum).getId();
            long periodId = BcmThreadCache.findMemberByNum((String)modelNum, (String)DimTypesEnum.PERIOD.getNumber(), (String)periodNum).getId();
            Long modelId = currentOrgNode.getModelId();
            orgIds.removeAll(EntityVersioningUtil.getOrgsByVersion((long)modelId, (long)sceneId, (String)yearNum, (long)periodId, orgIds));
            if (!orgIds.isEmpty()) {
                long yearId = BcmThreadCache.findMemberByNum((String)modelNum, (String)DimTypesEnum.YEAR.getNumber(), (String)yearNum).getId();
                String selectFields = "id,name,number,parent,storagetype,longnumber,level,dseq,isleaf";
                QFilter qFilter = new QFilter("id", "in", orgIds);
                DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)selectFields, (QFilter[])qFilter.toArray());
                OrgServiceHelper.dealNoMergeOrgList((DynamicObjectCollection)orgs, (Long)modelId, (Long)sceneId, (Long)yearId, (Long)periodId);
                orgIds.clear();
                orgs.forEach(d -> orgIds.add(d.getLong("id")));
            }
        }
        Iterator iterator = orgList.iterator();
        while (iterator.hasNext()) {
            IDNumberTreeNode next = (IDNumberTreeNode)iterator.next();
            if (orgIds.contains(next.getId())) continue;
            iterator.remove();
        }
        return orgList;
    }

    private Map<String, String> getTrueOrgName(List<IDNumberTreeNode> orgList, IDNumberTreeNode currentOrgNode) {
        HashSet dims = new HashSet(16);
        this.sm.getFilter().getPageDomain().getDimensions().forEach(d -> dims.add(d.getNumber()));
        if (!(dims.contains(DimTypesEnum.SCENARIO.getNumber()) && dims.contains(DimTypesEnum.YEAR.getNumber()) && dims.contains(DimTypesEnum.PERIOD.getNumber()))) {
            return new HashMap<String, String>(16);
        }
        ArrayList<String> list = new ArrayList<String>(orgList.size());
        orgList.forEach(memberTreeNode -> list.add(memberTreeNode.getNumber()));
        list.add(currentOrgNode.getNumber());
        Map orgNameMap = EntityVersioningUtil.getOrgNameByFYAndPeriod((String)this.getEntityNumber("bcm_model"), list, (String)this.getEntityNumber("bcm_fymembertree"), (String)this.getEntityNumber("bcm_periodmembertree"), (Long)this.getEntityId("bcm_scenemembertree"));
        Table structInfoTable = MergeControlHelper.getAllStructInfoForTable((Long)this.getEntityId("bcm_model"), (Long)this.getEntityId("bcm_scenemembertree"), (Long)this.getEntityId("bcm_fymembertree"), (Long)this.getEntityId("bcm_periodmembertree"));
        HashSet<Object> changedOrgs = new HashSet<Object>(16);
        for (Table.Cell tableCell : structInfoTable.cellSet()) {
            Boolean isMerge = (Boolean)tableCell.getValue();
            if (structInfoTable.get((Object)currentOrgNode.getNumber(), tableCell.getColumnKey()) != null) {
                isMerge = (Boolean)structInfoTable.get((Object)currentOrgNode.getNumber(), tableCell.getColumnKey());
            }
            if (isMerge.booleanValue() || !orgNameMap.containsKey(tableCell.getColumnKey()) || !changedOrgs.add(tableCell.getColumnKey())) continue;
            orgNameMap.put(tableCell.getColumnKey(), String.format(ResManager.loadKDString((String)"%s(\u4e0d\u53c2\u4e0e\u5408\u5e76)", (String)"CheckMainPagePlugin_92", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNameMap.get(tableCell.getColumnKey())));
        }
        return orgNameMap;
    }

    public void fillHeaderFromCell(Header header, Cell cell, List<String> rowDims, int startCol, String modelNum) {
        String dimNum;
        Map<String, Object> map;
        HeadObject headObject = header.get(cell.getRow(), true);
        List userObject = cell.getMemberFromUserObject();
        if (rowDims.size() > cell.getCol() - startCol && MapUtils.isNotEmpty(map = WorkPaperQueryHelper.getHeadMap(userObject, dimNum = rowDims.get(cell.getCol() - startCol), modelNum))) {
            headObject.addMember(dimNum, map);
        }
        cell.clear();
        cell.getUserObject().clear();
    }

    public void swichHeaderMode(List<Column> columnList, Map<Long, IDNumberTreeNode> orgCache) {
        List entries = this.template.getAreaRangeEntries();
        if (CollectionUtils.isEmpty((Collection)entries)) {
            return;
        }
        List rowDimNums = ((AreaRangeEntry)entries.get(0)).getRowDimEntries().stream().map(r -> r.getDimension().getNumber()).collect(Collectors.toList());
        int rowDimSize = rowDimNums.size();
        Long modelId = this.getEntityId("bcm_model");
        Pair<Point, Point> pair = this.getAreaRange();
        Sheet sheet = this.getSm().getBook().getSheet(0);
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        Header header = sheet.getRowHeader();
        header.clear();
        header.setDimNums(rowDimNums);
        int startCol = ((Point)pair.p1).x;
        int startRow = ((Point)pair.p1).y;
        sheet.iteratorRangeCells(startRow, ((Point)pair.p2).y, startCol - rowDimSize, startCol - 1, cell -> this.fillHeaderFromCell(header, (Cell)cell, rowDimNums, ((Point)pair.p1).x - rowDimSize, modelNum));
        Header colHeader = sheet.getColHeader();
        colHeader.clear();
        Map<String, String> orgSimpleNameMap = this.getOrgSimpleNameMap(orgCache);
        for (int i = 0; i < columnList.size(); ++i) {
            this.fillHeaderFromColumn(colHeader, startCol + i, columnList.get(i), modelNum, orgCache, orgSimpleNameMap);
        }
    }

    public Map<String, String> getOrgSimpleNameMap(Map<Long, IDNumberTreeNode> orgCache) {
        HashMap<String, String> orgSimpleNameMap = new HashMap<String, String>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)this.getEntityId("bcm_model"));
        qFilter.and("id", "in", orgCache.keySet());
        QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,simplename", (QFilter[])new QFilter[]{qFilter}).forEach(d -> orgSimpleNameMap.put(d.getString("number"), d.getString(SIMPLE_NAME)));
        return orgSimpleNameMap;
    }

    private void fillHeaderFromColumn(Header colHeader, int index, Column column, String modelNum, Map<Long, IDNumberTreeNode> orgCache, Map<String, String> orgSimpleNameMap) {
        HeadObject headObject = colHeader.get(index, true);
        if (column == null || column.hasFormula()) {
            return;
        }
        List memberPair = column.getAllDimensionMemberPair();
        if (CollectionUtils.isNotEmpty((Collection)memberPair)) {
            boolean notEmpty = CollectionUtils.isNotEmpty((Collection)colHeader.getDimNums());
            ArrayList dimNums = new ArrayList(16);
            memberPair.forEach(p -> {
                IDNumberTreeNode node;
                String dimNum = ((Dimension)p.p1).getNumber();
                if (!notEmpty) {
                    dimNums.add(dimNum);
                }
                String simpleName = "";
                String name = "";
                Map<String, String> orgNameByFYAndPeriod = new HashMap<String, String>(16);
                if (DimTypesEnum.ENTITY.getNumber().equals(dimNum)) {
                    simpleName = (String)orgSimpleNameMap.get(((Member)p.p2).getNumber());
                    node = (IDNumberTreeNode)orgCache.get(((Member)p.p2).getId());
                    name = ((Member)p.p2).getName();
                    orgNameByFYAndPeriod = MapInitHelper.ofMap((Object)((Member)p.p2).getNumber(), (Object)((Member)p.p2).getName());
                } else {
                    node = BcmThreadCache.findMemberByNum((String)modelNum, (String)dimNum, (String)((Member)p.p2).getNumber());
                }
                if (node != null && node != IDNumberTreeNode.NotFoundTreeNode) {
                    Map<String, Object> headMap = MDQADataQueryHelper.getHeadMap(node, orgNameByFYAndPeriod);
                    if (StringUtils.isNotEmpty((CharSequence)simpleName)) {
                        headMap.put(SIMPLE_NAME, simpleName);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)name)) {
                        headMap.put("memName", name);
                    }
                    headObject.addMember(dimNum, headMap);
                }
            });
            if (!notEmpty) {
                colHeader.setDimNums(dimNums);
            }
        }
    }

    private List<Integer> getNeedInsertIndex(List<Integer> idxs) {
        for (int i = 0; i < idxs.size(); ++i) {
            idxs.set(i, idxs.get(i) + i);
        }
        return idxs;
    }

    private Member getMemberById(IDNumberTreeNode node, Map<String, String> trueOrgName) {
        Member member = new Member();
        member.setId(node.getId().longValue());
        String number = node.getNumber();
        member.setNumber(number);
        String name = node.getName();
        if (!trueOrgName.isEmpty() && trueOrgName.containsKey(number)) {
            name = trueOrgName.get(number);
        }
        member.setName(name);
        member.setDataEntityNumber("bcm_entitymembertree");
        return member;
    }

    private Pair<Point, Point> getAreaRange(List<AreaRangeEntry> areas) {
        if (areas.isEmpty()) {
            return null;
        }
        Point startPoint = null;
        Point endPoint = null;
        for (AreaRangeEntry area : areas) {
            String areaRange = area.getAreaRange();
            String[] split = areaRange.split(":");
            Point currentStartPoint = ExcelUtils.pos2Point((String)split[0]);
            Point currentEndPoint = ExcelUtils.pos2Point((String)split[1]);
            if (startPoint == null || endPoint == null) {
                startPoint = currentStartPoint;
                endPoint = currentEndPoint;
                continue;
            }
            if (startPoint.y > currentStartPoint.y) {
                startPoint = currentStartPoint;
            }
            if (endPoint.y >= currentEndPoint.y) continue;
            endPoint = currentEndPoint;
        }
        if (startPoint != null && endPoint != null) {
            this.setTempRangeModel(new RangeModel(startPoint.x, endPoint.x, startPoint.y, endPoint.y));
        }
        return Pair.onePair(startPoint, endPoint);
    }

    private List<ColIndexInfo> getColIndexInfos(List<Column> paperColumnList, List<Column> templateColumnList) {
        ArrayList<ColIndexInfo> indexIfos = new ArrayList<ColIndexInfo>(templateColumnList.size());
        for (Column column : templateColumnList) {
            indexIfos.add(new ColIndexInfo(column.getNumber(), column.getColIndex()));
        }
        for (ColIndexInfo info : indexIfos) {
            for (Column column : paperColumnList) {
                if (!info.getColNumber().equals(column.getNumber())) continue;
                info.addIndex(column.getColIndex());
            }
        }
        return indexIfos;
    }

    private ColIndexInfo getInfoByTemplateIndex(List<ColIndexInfo> infos, int tempIndex) {
        for (ColIndexInfo info : infos) {
            if (info.getTemplateIndex() != tempIndex) continue;
            return info;
        }
        return null;
    }

    public DimensionMemberDisplayTypeEnum getOrgDisplayType() {
        if (this.orgDisplayType == null) {
            this.orgDisplayType = DimensionMemberDisplayTypeEnum.NUMBERANDNAME;
        }
        return this.orgDisplayType;
    }

    public void setOrgDisplayType(DimensionMemberDisplayTypeEnum orgDisplayType) {
        this.orgDisplayType = orgDisplayType;
    }

    public DimensionMemberDisplayTypeEnum getRowColDimensionDisplayType() {
        if (this.rowColDimensionDisplayType == null) {
            this.rowColDimensionDisplayType = DimensionMemberDisplayTypeEnum.NUMBERANDNAME;
        }
        return this.rowColDimensionDisplayType;
    }

    public void setRowColDimensionDisplayType(DimensionMemberDisplayTypeEnum rowColDimensionDisplayType) {
        this.rowColDimensionDisplayType = rowColDimensionDisplayType;
    }

    private String getCurrectFormula(List<ColIndexInfo> colIndexInfos, String formula, int nowCol, int insertRow, boolean isColHead) {
        int i;
        ArrayList<String> factors = new ArrayList<String>();
        String regex = "[A-Z]+[0-9]+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(formula);
        while (matcher.find()) {
            factors.add(matcher.group());
        }
        String[] symbols = formula.split(regex);
        ArrayList points = new ArrayList();
        factors.forEach(e -> points.add(ExcelUtils.pos2Point((String)e)));
        ArrayList coordinate = new ArrayList();
        RangeModel rangeModel = this.getTempRangeModel();
        int endCol = rangeModel.getX_end();
        Pair<Point, Point> pair = this.getAreaRange();
        points.forEach(e -> {
            int col;
            int row = e.y;
            if (e.y >= insertRow) {
                row = e.y + 1;
            }
            ColIndexInfo info = this.getInfoByTemplateIndex(colIndexInfos, e.x);
            StringBuffer buf = new StringBuffer();
            if (info == null || info.getPaperIndexs().isEmpty()) {
                col = e.x;
                if (e.x > endCol) {
                    col = e.x + (((Point)pair.p2).x - endCol);
                }
            } else if (info.getPaperIndexs().contains(nowCol)) {
                col = nowCol;
            } else if (!(isColHead || formula.contains(e + ":") || formula.contains(":" + e) || info.getPaperIndexs().size() == 1)) {
                buf.append("(");
                for (Integer index : info.getPaperIndexs()) {
                    buf.append(ExcelUtils.xy2Pos((int)index, (int)row)).append("+");
                }
                buf = buf.deleteCharAt(buf.lastIndexOf("+"));
                buf.append(")");
                col = info.getPaperIndexs().get(0);
            } else {
                col = info.getPaperIndexs().get(0);
            }
            if (StringUtils.isEmpty((CharSequence)buf.toString())) {
                buf.append(ExcelUtils.xy2Pos((int)col, (int)row));
            }
            coordinate.add(buf.toString());
        });
        StringBuilder result = new StringBuilder();
        for (i = 0; i < factors.size(); ++i) {
            if (symbols.length != 0) {
                result.append(symbols[i]);
            }
            result.append((String)coordinate.get(i));
        }
        if (symbols.length != 0 && i < symbols.length) {
            result.append(symbols[i]);
        }
        return result.toString();
    }

    static class ColIndexInfo {
        private String colNumber;
        private int templateIndex;
        private List<Integer> paperIndexs;

        ColIndexInfo(String colNumber, int templateIndex) {
            this.colNumber = colNumber;
            this.templateIndex = templateIndex;
            this.paperIndexs = new ArrayList<Integer>();
        }

        void addIndex(int paperIndex) {
            this.paperIndexs.add(paperIndex);
        }

        String getColNumber() {
            return this.colNumber;
        }

        List<Integer> getPaperIndexs() {
            return this.paperIndexs;
        }

        int getTemplateIndex() {
            return this.templateIndex;
        }
    }
}

