/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.localcache.SyncCacheUtil;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.mq.BroadcastMessagePublisher;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.collections4.CollectionUtils;

public class CleanDimCacheScheduleTask
extends AbstractTask {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, CleanDimCacheScheduleTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Set models = ConfigServiceHelper.getPreLoadModel();
        if (CollectionUtils.isNotEmpty((Collection)models)) {
            models.forEach(modelNum -> {
                try {
                    log.error("reloadDimensionCache task begin,model number:" + modelNum);
                    SyncCacheUtil.updateAppCacheTime((String)GlobalCacheServiceHelper.packAboutDimCacheKey((String)modelNum, (String)DimEntityNumEnum.INTERCOMPANY.getEntityNum()));
                    GlobalCacheServiceHelper.reloadLocalCache((String)modelNum, (String)DimEntityNumEnum.INTERCOMPANY.getNumber());
                    BroadcastMessagePublisher.publishReloadDimCache((String)modelNum, (String)DimEntityNumEnum.INTERCOMPANY.getNumber(), (boolean)true);
                    SyncCacheUtil.removeMemberCache((String)modelNum, (String)DimEntityNumEnum.INTERCOMPANY.getNumber());
                    log.error("reloadDimensionCache task end,model number:" + modelNum);
                }
                catch (Exception ex) {
                    log.error(String.format("reloadDimensionCache task fail,model number:%s,caused by:%s", modelNum, ThrowableHelper.toString((Exception)ex)));
                }
            });
        }
    }
}

