/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.util.BcmDMLServiceHelper;
import kd.fi.bcm.common.enums.Permission.UserTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DeletedOutEntityMainCleanTaskPlugin
extends AbstractTask {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)Boolean.TRUE, DeletedOutEntityMainCleanTaskPlugin.class);
    protected static final String MAIN_TABLE_NAME = "mainTableName";
    protected static final String ID = "id";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String outTableName = "bos_usergroup";
        String outTableField = ID;
        Object mainTableName = map.get(MAIN_TABLE_NAME);
        String mainTableField = ID;
        String mainTableOutField = "users.id";
        QFBuilder mainTableQFB = new QFBuilder("usertype", "=", (Object)UserTypeEnum.USERGROUP.getName());
        if (Objects.isNull(mainTableField)) {
            DeletedOutEntityMainCleanTaskPlugin.logTableMissErr();
        } else {
            String mainTableNameStr = mainTableName.toString();
            if (StringUtils.isBlank((CharSequence)mainTableNameStr)) {
                DeletedOutEntityMainCleanTaskPlugin.logTableMissErr();
            } else {
                Set uGSIds = QueryServiceHelper.query((String)outTableName, (String)outTableField, (QFilter[])new QFilter[0]).stream().map(t -> t.getLong(outTableField)).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(uGSIds)) {
                    mainTableQFB.and(mainTableOutField, "not in", uGSIds);
                    List dAIds = QueryServiceHelper.query((String)mainTableNameStr, (String)mainTableField, (QFilter[])mainTableQFB.toArray()).stream().map(t -> t.getLong(mainTableField)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(dAIds)) {
                        BcmDMLServiceHelper.batchDelete((String)mainTableNameStr, dAIds, (String)mainTableField);
                    }
                }
            }
        }
    }

    private static void logTableMissErr() {
        log.error("Primary key table parameter is missing, clearing failed!");
    }
}

