/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.message.MessageBcmServiceHelper;
import kd.fi.bcm.common.enums.MessageTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.task.IntelligentSchedulePlan;

public class IntelligentScheduleHelper {
    private static final int MAX_LENGTH_DESC = 500;

    public static DynamicObject[] logBegin(DynamicObject plan, String execType, String operationName) {
        DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_intelschedule_log");
        newObj.set("model", (Object)plan.getLong("model.id"));
        newObj.set("plan", (Object)plan.getLong("id"));
        newObj.set("executor", (Object)Long.valueOf(RequestContext.get().getUserId()));
        newObj.set("operationname", (Object)operationName);
        newObj.set("execoperation", (Object)execType);
        newObj.set("begintime", (Object)new Date());
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObj});
    }

    public static void logSuccess(DynamicObject[] updateObj, String desc) {
        if (updateObj == null) {
            return;
        }
        for (DynamicObject obj : updateObj) {
            obj.set("endtime", (Object)new Date());
            obj.set("execstatus", (Object)1);
            obj.set("desc", (Object)(StringUtils.isEmpty((CharSequence)desc) || desc.length() < 500 ? desc : desc.substring(0, 500)));
        }
        SaveServiceHelper.save((DynamicObject[])updateObj);
    }

    public static void logSuccessForMergeEndTime(DynamicObject[] updateObj, String desc, String endTime) {
        if (updateObj == null) {
            return;
        }
        long time = Long.parseLong(endTime);
        for (DynamicObject obj : updateObj) {
            obj.set("endtime", (Object)time);
            obj.set("execstatus", (Object)1);
            obj.set("desc", (Object)(StringUtils.isEmpty((CharSequence)desc) || desc.length() < 500 ? desc : desc.substring(0, 500)));
        }
        SaveServiceHelper.save((DynamicObject[])updateObj);
    }

    public static void logFail(DynamicObject[] updateObj, String desc) {
        if (updateObj == null) {
            return;
        }
        for (DynamicObject obj : updateObj) {
            obj.set("endtime", (Object)new Date());
            obj.set("execstatus", (Object)0);
            obj.set("desc", (Object)(StringUtils.isEmpty((CharSequence)desc) || desc.length() < 500 ? desc : desc.substring(0, 500)));
        }
        SaveServiceHelper.save((DynamicObject[])updateObj);
    }

    public static void execPlan(Long planId, String appId) {
        Lang lang = RequestContext.get().getLang();
        HashMap<String, String> param = new HashMap<String, String>(8);
        param.put("appId", appId);
        BatchProcessHelper.handleAsync(() -> new IntelligentSchedulePlan().process(planId, true, lang, param));
    }

    public static void sendMessage(DynamicObject plan, String msg) {
        if (plan == null) {
            return;
        }
        List sendTypeList = Arrays.stream(plan.getString("sendtype").split(",")).filter(r -> !StringUtil.isEmptyString((String)r)).collect(Collectors.toList());
        DynamicObjectCollection receivers = plan.getDynamicObjectCollection("receiver");
        List receiverList = receivers.stream().map(receiver -> receiver.getLong("fbasedataid.id")).collect(Collectors.toList());
        if (receiverList.isEmpty() || sendTypeList.isEmpty()) {
            return;
        }
        DynamicObjectCollection receiverDyCol = QueryServiceHelper.query((String)"bos_user", (String)"phone,email", (QFilter[])new QFBuilder("id", "in", receiverList).toArray());
        for (String sendType : sendTypeList) {
            if (StringUtil.isEmptyString((String)sendType)) continue;
            switch (MessageTypeEnum.searchByType((String)sendType)) {
                case MSG_YZJ: {
                    MessageBcmServiceHelper.sendYZJMessage(receiverList, (String)msg);
                    break;
                }
                case MSG_SHORT: {
                    MessageBcmServiceHelper.sendShortMessage(receiverDyCol.stream().map(receiver -> receiver.getString("phone")).collect(Collectors.toList()), (String)msg);
                    break;
                }
                case MSG_EMAIL: {
                    MessageBcmServiceHelper.sendEmailMessage(receiverDyCol.stream().map(receiver -> receiver.getString("email")).collect(Collectors.toList()), (String)msg, (String)msg);
                    break;
                }
                case MSG_SYS: {
                    MessageBcmServiceHelper.sendSystemMessage((String)msg, (String)msg, receiverList, null);
                    break;
                }
            }
        }
    }
}

