/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.util.MessageServiceUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DispatchStrategyEnum;
import kd.fi.bcm.common.enums.ScenarioMemberEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.KDAssert;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.task.IntelligentScheduleHelper;
import kd.fi.bcm.task.common.ISchedulePlanOperator;
import kd.fi.bcm.task.common.IntelligentScheduleConfigHelper;
import kd.fi.bcm.task.common.PlanParam;

public class IntelligentSchedulePlan {
    private static final Log logger = LogFactory.getLog(IntelligentSchedulePlan.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Long planId, boolean executeByHand, Lang lang, Map<String, Object> param) {
        block33: {
            if (lang != null) {
                logger.info("this new plan id:" + planId + ";lang:" + lang.getLocale().toString());
                RequestContext.get().setLang(lang);
            }
            try (DLock lock = DLock.create((String)("IntelligentSchedulePlanKey" + planId)).fastMode();){
                if (lock.tryLock()) {
                    DynamicObject plan = this.getIntelligentPlan(planId, executeByHand);
                    if (plan == null) {
                        logger.error("\u8be5\u65b9\u6848[{}]\u5df2\u5931\u6548\u6216\u5df2\u7981\u7528\uff01", (Object)planId);
                        return;
                    }
                    DynamicObjectCollection doc = (DynamicObjectCollection)plan.get("intelscheduleentry");
                    if (doc.isEmpty()) {
                        logger.error("\u8be5\u65b9\u6848[{}]\u4e0b\u6ca1\u6709\u8bbe\u7f6e\u6267\u884c\u64cd\u4f5c\uff01", (Object)planId);
                        return;
                    }
                    long executor = plan.getLong("executor.id");
                    boolean preStatus = false;
                    Object paramMap = null;
                    long realExecutor = executeByHand ? LongUtil.toLong((Object)RequestContext.get().getUserId()) : executor;
                    Set execParamIds = doc.parallelStream().map(operator -> operator.getLong("execparamid")).collect(Collectors.toSet());
                    QFBuilder qfBuilder = new QFBuilder("id", "in", execParamIds);
                    DynamicObjectCollection queryDspParam = QueryServiceHelper.query((String)"bcm_dspparamentity", (String)"id,subpageconfig", (QFilter[])qfBuilder.toArray());
                    Map<Long, String> id2Config = queryDspParam.stream().filter(dy -> dy.getString("subpageconfig") != null).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("subpageconfig")));
                    for (DynamicObject operator2 : doc) {
                        List<String> resulttype;
                        DynamicObject paramEntity;
                        String execstatus;
                        DynamicObject[] logInfo;
                        String operationName;
                        String execOperation;
                        block32: {
                            block31: {
                                execOperation = operator2.getString("execoperation");
                                String execStrategy = operator2.getString("execstrategy");
                                operationName = operator2.getString("operationname");
                                int seq = operator2.getInt("seq");
                                logInfo = null;
                                logInfo = IntelligentScheduleHelper.logBegin(plan, execOperation, operationName);
                                DispatchStrategyEnum operationStrategy = DispatchStrategyEnum.getDispatchStrategyEnum((String)execStrategy);
                                if (this.checkOperationStatus(operationStrategy, preStatus, seq)) break block31;
                                IntelligentScheduleHelper.logFail(logInfo, ResManager.loadKDString((String)"\u524d\u4e00\u6267\u884c\u64cd\u4f5c\u72b6\u6001\u4e0d\u6ee1\u8db3,\u672c\u6b21\u4efb\u52a1\u4e0d\u6267\u884c\u3002", (String)"IntelligentSchedulePlan_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                                if (logInfo == null || logInfo.length <= 0) continue;
                                String execstatus2 = logInfo[0].getString("execstatus");
                                DynamicObject paramEntity2 = this.getExecParams(operator2);
                                List<String> resulttype2 = Arrays.asList(paramEntity2.getString("resulttype").split(","));
                                if (!resulttype2.contains(execstatus2)) continue;
                                IntelligentScheduleHelper.sendMessage(paramEntity2, String.format(ResManager.loadKDString((String)"\u3010%1s\u3011-\u3010%2s\u3011\u6267\u884c%3s\u3002", (String)"IntelligentSchedulePlan_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), operationName, IntelligentScheduleConfigHelper.getOperatorName(execOperation), preStatus ? ResManager.loadKDString((String)"\u6210\u529f", (String)"IntelligentSchedulePlan_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5931\u8d25", (String)"IntelligentSchedulePlan_10", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                                continue;
                            }
                            try {
                                ISchedulePlanOperator planOperator = IntelligentScheduleConfigHelper.getStrategyNew(execOperation);
                                if (planOperator == null) break block32;
                                String config = id2Config.get(operator2.getLong("execparamid"));
                                preStatus = this.doOperation(plan, realExecutor, planOperator, config, logInfo);
                            }
                            catch (Exception e) {
                                try {
                                    preStatus = false;
                                    String errorMsg = e.getMessage();
                                    if (errorMsg != null && errorMsg.length() > 200) {
                                        errorMsg = errorMsg.substring(0, 200);
                                    }
                                    IntelligentScheduleHelper.logFail(logInfo, errorMsg);
                                    logger.info("IntelligentSchedulePlan errormsg: " + errorMsg);
                                    logger.error("\u8c03\u5ea6\u65b9\u6848[{}-{}]\u6267\u884c\u5931\u8d25,\u539f\u56e0\u4e3a:{}", new Object[]{operationName, IntelligentScheduleConfigHelper.getOperatorName(execOperation), e});
                                    DLock.forceUnlock((String[])new String[]{"IntelligentSchedulePlanKey" + planId});
                                }
                                catch (Throwable throwable) {
                                    if (logInfo != null && logInfo.length > 0) {
                                        String execstatus3 = logInfo[0].getString("execstatus");
                                        DynamicObject paramEntity3 = this.getExecParams(operator2);
                                        List<String> resulttype3 = Arrays.asList(paramEntity3.getString("resulttype").split(","));
                                        if (resulttype3.contains(execstatus3)) {
                                            IntelligentScheduleHelper.sendMessage(paramEntity3, String.format(ResManager.loadKDString((String)"\u3010%1s\u3011-\u3010%2s\u3011\u6267\u884c%3s\u3002", (String)"IntelligentSchedulePlan_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), operationName, IntelligentScheduleConfigHelper.getOperatorName(execOperation), preStatus ? ResManager.loadKDString((String)"\u6210\u529f", (String)"IntelligentSchedulePlan_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5931\u8d25", (String)"IntelligentSchedulePlan_10", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                                        }
                                    }
                                    throw throwable;
                                }
                                if (logInfo == null || logInfo.length <= 0) continue;
                                execstatus = logInfo[0].getString("execstatus");
                                paramEntity = this.getExecParams(operator2);
                                resulttype = Arrays.asList(paramEntity.getString("resulttype").split(","));
                                if (!resulttype.contains(execstatus)) continue;
                                IntelligentScheduleHelper.sendMessage(paramEntity, String.format(ResManager.loadKDString((String)"\u3010%1s\u3011-\u3010%2s\u3011\u6267\u884c%3s\u3002", (String)"IntelligentSchedulePlan_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), operationName, IntelligentScheduleConfigHelper.getOperatorName(execOperation), preStatus ? ResManager.loadKDString((String)"\u6210\u529f", (String)"IntelligentSchedulePlan_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5931\u8d25", (String)"IntelligentSchedulePlan_10", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                                continue;
                            }
                        }
                        if (logInfo == null || logInfo.length <= 0) continue;
                        execstatus = logInfo[0].getString("execstatus");
                        paramEntity = this.getExecParams(operator2);
                        resulttype = Arrays.asList(paramEntity.getString("resulttype").split(","));
                        if (!resulttype.contains(execstatus)) continue;
                        IntelligentScheduleHelper.sendMessage(paramEntity, String.format(ResManager.loadKDString((String)"\u3010%1s\u3011-\u3010%2s\u3011\u6267\u884c%3s\u3002", (String)"IntelligentSchedulePlan_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), operationName, IntelligentScheduleConfigHelper.getOperatorName(execOperation), preStatus ? ResManager.loadKDString((String)"\u6210\u529f", (String)"IntelligentSchedulePlan_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5931\u8d25", (String)"IntelligentSchedulePlan_10", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                    }
                    String planName = plan.getString("name");
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String time = sdf.format(new Date());
                    String title = preStatus ? ResManager.loadKDString((String)"\u8c03\u5ea6\u4efb\u52a1\u6210\u529f", (String)"IntelligentSchedulePlan_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25", (String)"IntelligentSchedulePlan_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    String msg = preStatus ? String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff01\n\u60a8\u7684\u8c03\u5ea6\u4efb\u52a1\u3010%1$s\u3011\u5df2\u4e8e\u3010%2$s\u3011\u6267\u884c\u5b8c\u6210\u3002\n\u611f\u8c22\u60a8\u7684\u4f7f\u7528\uff01", (String)"IntelligentSchedulePlan_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), planName, time) : String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff01\n\u8c03\u5ea6\u4efb\u52a1\u3010%1$s\u3011\u5728\u3010%2$s\u3011\u6267\u884c\u65f6\u9047\u5230\u4e86\u95ee\u9898\uff0c\u672a\u80fd\u6210\u529f\u5b8c\u6210\u3002\n\u8bf7\u68c0\u67e5\u76f8\u5173\u8bbe\u7f6e\u5e76\u5c1d\u8bd5\u91cd\u65b0\u6267\u884c\uff0c\u6216\u8054\u7cfb\u6280\u672f\u652f\u6301\u4ee5\u83b7\u53d6\u5e2e\u52a9\u3002", (String)"IntelligentSchedulePlan_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]), planName, time);
                    MessageServiceUtil.sendMessageByNotice((String)title, (String)msg, (List)Lists.newArrayList((Object[])new Long[]{RequestContext.getOrCreate().getCurrUserId()}));
                    break block33;
                }
                logger.error("\u667a\u80fd\u8c03\u5ea6\u4efb\u52a1[\u65b9\u6848ID:{}]\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25", (Object)planId);
            }
        }
    }

    private boolean doOperation(DynamicObject plan, long realExecutor, ISchedulePlanOperator planOperator, String config, DynamicObject[] logInfo) {
        logger.info("doOperation plan is:" + plan.getString("name") + ";" + plan.getLong("id") + ";" + config);
        KDAssert.assertTrue((planOperator != null ? 1 : 0) != 0, () -> new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8c03\u5ea6\u4efb\u52a1\u5904\u7406\u7c7b\u3002", (String)"IntelligentSchedulePlan_18", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        long logId = logInfo[0].getLong("id");
        String periodType = plan.getString("periodtype");
        PlanParam planParam = new PlanParam();
        planParam.setModelId(plan.getLong("model.id"));
        planParam.setScenarioId(plan.getLong("scenario.id"));
        planParam.setYearOffset(plan.getInt("yearoffset"));
        planParam.setPeriodOffset(plan.getInt("periodoffset"));
        planParam.setPeriodType(periodType);
        planParam.setScenarioMemberEnum(this.setScenarioMemberEnum(plan.getString("scenario.number"), periodType));
        planParam.setExecutor(realExecutor);
        planParam.setParamSetting(config);
        planParam.setLogId(logId);
        Pair<Boolean, Set<String>> operationResult = planOperator.doOperation(planParam);
        KDAssert.assertTrue((operationResult != null ? 1 : 0) != 0, () -> new KDBizException(ResManager.loadKDString((String)"\u8c03\u5ea6\u4efb\u52a1\u5904\u7406\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IntelligentSchedulePlan_19", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        Boolean preStatus = (Boolean)operationResult.p1;
        String msg = String.join((CharSequence)" ", CollectionUtil.isEmpty((Collection)((Collection)operationResult.p2)) ? Collections.emptySet() : (Iterable)operationResult.p2);
        if (preStatus.booleanValue()) {
            Pair<Boolean, String> resultPair = planOperator.waitComplete(logId);
            KDAssert.assertTrue((resultPair != null ? 1 : 0) != 0, () -> new KDBizException(ResManager.loadKDString((String)"\u8c03\u5ea6\u4efb\u52a1\u5904\u7406\u7b49\u5f85\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IntelligentSchedulePlan_20", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            if (((Boolean)resultPair.p1).booleanValue()) {
                if (StringUtils.isNotEmpty((String)((String)resultPair.p2))) {
                    IntelligentScheduleHelper.logSuccessForMergeEndTime(logInfo, msg, (String)resultPair.p2);
                } else {
                    IntelligentScheduleHelper.logSuccess(logInfo, msg);
                }
            } else {
                IntelligentScheduleHelper.logFail(logInfo, msg);
            }
            preStatus = (Boolean)resultPair.p1;
        } else {
            IntelligentScheduleHelper.logFail(logInfo, msg);
            logger.info("IntelligentSchedulePlan failmsg: {}", (Object)msg);
        }
        return preStatus;
    }

    protected boolean checkOperationStatus(DispatchStrategyEnum strategyEnum, boolean preStatus, int seq) {
        if (seq == 1) {
            return true;
        }
        if (DispatchStrategyEnum.SUCCESS == strategyEnum && !preStatus) {
            return false;
        }
        return DispatchStrategyEnum.FAIL != strategyEnum || !preStatus;
    }

    private ScenarioMemberEnum setScenarioMemberEnum(String scenario, String periodtype) {
        if ("1".equals(periodtype)) {
            return ScenarioMemberEnum.MRPT;
        }
        if ("2".equals(periodtype)) {
            return ScenarioMemberEnum.YDRPT;
        }
        if ("3".equals(periodtype)) {
            return ScenarioMemberEnum.SRPT;
        }
        if ("4".equals(periodtype)) {
            return ScenarioMemberEnum.QRPT;
        }
        ScenarioMemberEnum scenarioMember = ScenarioMemberEnum.getMemberByNumber((String)scenario);
        if (ScenarioMemberEnum.YDRPT == scenarioMember) {
            return ScenarioMemberEnum.YDRPT;
        }
        if (ScenarioMemberEnum.MRPT == scenarioMember) {
            return ScenarioMemberEnum.MRPT;
        }
        if (ScenarioMemberEnum.SRPT == scenarioMember) {
            return ScenarioMemberEnum.SRPT;
        }
        if (ScenarioMemberEnum.QRPT == scenarioMember) {
            return ScenarioMemberEnum.QRPT;
        }
        return ScenarioMemberEnum.MRPT;
    }

    protected DynamicObject getExecParams(DynamicObject operator) {
        long execParamId = operator.getLong("execparamid");
        return BusinessDataServiceHelper.loadSingle((Object)execParamId, (String)"bcm_dspparamentity");
    }

    private DynamicObject getIntelligentPlan(Long planId, boolean executeByHand) {
        QFilter pFilters = QFilter.of((String)"id = ?", (Object[])new Object[]{planId});
        pFilters.and(QFilter.of((String)"isenable = ?", (Object[])new Object[]{"1"}));
        if (!executeByHand) {
            pFilters.and(QFilter.of((String)"enddate >= ?", (Object[])new Object[]{new Date()}));
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_intelschedule", (QFilter[])pFilters.toArray());
    }
}

