/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.StringUtils;
import kd.fi.bcm.task.CustomizeCheck;
import kd.fi.bcm.task.IntelligentSchedulePlan;
import org.apache.commons.collections.MapUtils;

public class IntelligentScheduleTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(IntelligentScheduleTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (MapUtils.isNotEmpty(map)) {
            Object object = map.get("intelligentSchedulePlanId");
            if (Objects.isNull(object)) {
                logger.error("\u667a\u80fd\u8c03\u5ea6\u4efb\u52a1\u65b9\u6848ID\u4e3a\u7a7a");
                return;
            }
            boolean customizeCheck = this.customizeCheck(map);
            if (!customizeCheck) {
                logger.info("CustomizeCheck is false,Dispatch termination.");
                return;
            }
            String langStr = (String)map.get("lang");
            Lang lang = null;
            if (langStr != null) {
                lang = Lang.from((String)langStr);
            }
            String appId = (String)map.get("appId");
            HashMap<String, Object> param = new HashMap<String, Object>(8);
            param.put("appId", appId);
            new IntelligentSchedulePlan().process((Long)object, false, lang, param);
        } else {
            logger.error("\u667a\u80fd\u8c03\u5ea6\u4efb\u52a1\u672a\u914d\u7f6e\u53c2\u6570");
        }
    }

    private boolean customizeCheck(Map<String, Object> map) {
        Object intelligentSchedulePlanId = map.get("intelligentSchedulePlanId");
        String className = (String)map.get("customizeCheck");
        if (StringUtils.isEmpty((String)className)) {
            logger.info("intelligentSchedulePlanId:" + intelligentSchedulePlanId + ";className is null or empty");
            return true;
        }
        return this.customizeCheckByClass(className, intelligentSchedulePlanId);
    }

    private boolean customizeCheckByClass(String className, Object intelligentSchedulePlanId) {
        try {
            Class<?> customizeClass = Class.forName(className);
            if (!CustomizeCheck.class.isAssignableFrom(customizeClass)) {
                logger.error("intelligentSchedulePlanId:" + intelligentSchedulePlanId + ";isAssignableFrom CustomizeCheck is false\uff0cDispatch termination.");
                return false;
            }
            Method method = customizeClass.getMethod("check", Long.class);
            return (Boolean)method.invoke(customizeClass.newInstance(), intelligentSchedulePlanId);
        }
        catch (ClassNotFoundException e) {
            logger.error("intelligentSchedulePlanId:" + intelligentSchedulePlanId + ";ClassNotFoundException className is:" + className + ";Dispatch termination.");
            return false;
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.error("intelligentSchedulePlanId:" + intelligentSchedulePlanId + ";SecurityException is:" + e.getMessage() + ";Dispatch termination.");
            return false;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            logger.error("intelligentSchedulePlanId:" + intelligentSchedulePlanId + ";method.invoke error is:" + e.getMessage() + ";Dispatch termination.");
            return false;
        }
    }
}

