/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.common.BCMConstant;

public class PermLogAutoCleanPlugin
extends AbstractTask {
    private static Log log = LogFactory.getLog(PermLogAutoCleanPlugin.class);
    private static final String BCM_FUNCTIONPERMLOG = "bcm_functionpermlog";
    private static final Long LEAVE_FUNCTIONPERMLOG_COUNT = 50000L;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.cleanFunctionPermLog();
    }

    private void cleanFunctionPermLog() {
        try {
            String sql = "select count(fid) as count from t_bcm_functionpermlog";
            Long count = (Long)DB.query((DBRoute)BCMConstant.DBROUTE, (String)sql, (ResultSetHandler)new ResultSetHandler<Long>(){

                public Long handle(ResultSet rs) throws Exception {
                    Long count = 0L;
                    if (rs.next()) {
                        count = rs.getLong("count");
                    }
                    return count;
                }
            });
            if (count > LEAVE_FUNCTIONPERMLOG_COUNT) {
                this.excuteDel(count);
            }
        }
        catch (KDException e) {
            log.error((Throwable)e);
        }
    }

    public void excuteDel(Long count) {
        Long deleteCount = count - LEAVE_FUNCTIONPERMLOG_COUNT;
        String sql1 = "select top " + deleteCount + " fid from t_bcm_functionpermlog order by fmodifytime asc";
        Set fids = (Set)DB.query((DBRoute)BCMConstant.DBROUTE, (String)sql1, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> set = new HashSet<Long>(16);
                while (rs.next()) {
                    set.add(rs.getLong("fid"));
                }
                return set;
            }
        });
        PermLogAutoCleanPlugin.batchDeleteDataPermLog(fids);
    }

    public static void batchDeleteDataPermLog(Set<Long> fids) {
        if (fids.size() > 0) {
            int batchSize = 2000;
            if (fids.size() < batchSize) {
                DeleteServiceHelper.delete((String)BCM_FUNCTIONPERMLOG, (QFilter[])new QFilter[]{new QFilter("id", "in", fids)});
            } else {
                ArrayList<Long> batch = new ArrayList<Long>(batchSize);
                for (Long id : fids) {
                    batch.add(id);
                    if (batch.size() < batchSize) continue;
                    DeleteServiceHelper.delete((String)BCM_FUNCTIONPERMLOG, (QFilter[])new QFilter[]{new QFilter("id", "in", batch)});
                    batch.clear();
                }
                if (!batch.isEmpty()) {
                    DeleteServiceHelper.delete((String)BCM_FUNCTIONPERMLOG, (QFilter[])new QFilter[]{new QFilter("id", "in", batch)});
                    batch.clear();
                }
            }
        }
    }
}

