/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.adjust;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.task.common.IScheduleSubPage;
import org.jetbrains.annotations.Nullable;

public class ContinueEntryParamPlugin
extends AbstractBaseFormPlugin
implements IScheduleSubPage {
    private static final List<String> dimKeys = Arrays.asList("scenario", "year", "period");

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("entity");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("entity".equals(key) && newValue == null || "".equals(newValue)) {
            this.getPageCache().remove("entity");
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Long scenarioId;
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getFormCustomParam("model");
        this.getModel().setValue("model", (Object)modelId);
        this.getPageCache().put("KEY_MODEL_ID", modelId + "");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Map sceneParam = (Map)this.getView().getFormShowParameter().getCustomParam("initdata");
        Long l = scenarioId = sceneParam.get("scenario") == null ? null : (Long)((Map)sceneParam.get("scenario")).get("id");
        if (OperationStatus.ADDNEW == status) {
            if (scenarioId != null && scenarioId != 0L) {
                this.getModel().setValue("scenario", (Object)scenarioId);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"scenario"});
            }
        } else if (OperationStatus.EDIT == status) {
            String param = this.getConfigFromFormShowParameter();
            if (param == null || param.trim().isEmpty()) {
                return;
            }
            Map dimMap = (Map)SerializationUtils.deSerializeFromBase64((String)param);
            if (scenarioId != null && scenarioId != 0L) {
                this.getModel().setValue("scenario", (Object)scenarioId);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"scenario"});
            }
            if (this.getFormCustomParam("scenario") != null && (Long)this.getFormCustomParam("scenario") != 0L) {
                this.getModel().setValue("scenario", this.getFormCustomParam("scenario"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"scenario"});
            } else {
                this.getModel().setValue("scenario", (Object)Long.parseLong((String)dimMap.get("scenario")));
            }
            this.getModel().setValue("year", dimMap.get("year") == null ? null : Long.valueOf(Long.parseLong((String)dimMap.get("year"))));
            this.getModel().setValue("period", dimMap.get("period") == null ? null : Long.valueOf(Long.parseLong((String)dimMap.get("period"))));
            if (StringUtils.isNotEmpty((String)((String)dimMap.get("entity")))) {
                List list = SerializationUtils.fromJsonStringToList((String)((String)dimMap.get("entity")), Map.class);
                StringBuilder sb = new StringBuilder();
                for (Map stringStringMap : list) {
                    this.buildPageViewShowName(sb, stringStringMap);
                }
                this.getModel().setValue("entity", (Object)sb.substring(0, sb.length() - 1));
                this.getPageCache().put("entity", (String)dimMap.get("entity"));
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("entity".equals(key)) {
            this.showMultiMemberF7(key);
        }
    }

    private void showMultiMemberF7(String number) {
        DynamicObject dim = QueryDimensionServiceHelper.getMsgByNumberIgnoreCase((long)((DynamicObject)this.getModel().getValue("model")).getLong("id"), (String)number);
        if (dim == null) {
            return;
        }
        FormShowParameter para = new FormShowParameter();
        if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dim.getString("number"))) {
            para.setFormId("bcm_mulmemberf7_tem_ic");
        } else {
            para.setFormId("bcm_mulmemberf7base_tem");
        }
        para.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dimension", dim.getInt("dseq") + "");
        params.put("KEY_MODEL_ID", ((DynamicObject)this.getModel().getValue("model")).getString("id"));
        params.put("sign", number);
        para.setCustomParams(params);
        para.setCaption(dim.getString("name"));
        IFormView view = this.getView();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, number);
        para.setCloseCallBack(closeCallBack);
        view.showForm(para);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        DynamicObjectCollection doc;
        String key;
        Object returnData = evt.getReturnData();
        if (returnData != null && ("entity".equals(key = evt.getActionId()) || "process".equals(key)) && (doc = (DynamicObjectCollection)evt.getReturnData()) != null) {
            IDataModel model = this.getModel();
            if (doc.isEmpty()) {
                model.setValue(key, null);
                this.getPageCache().remove(key);
            } else {
                StringBuilder sb = new StringBuilder();
                ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>(doc.size());
                for (DynamicObject dynamicObject : doc) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", dynamicObject.get(4).toString());
                    map.put("scope", dynamicObject.get(5).toString());
                    map.put("number", dynamicObject.get(2).toString());
                    map.put("name", dynamicObject.get(3).toString());
                    map.put("pid", dynamicObject.get(6).toString());
                    this.buildPageViewShowName(sb, map);
                    list.add(map);
                }
                model.setValue(key, (Object)sb.substring(0, sb.length() - 1));
                String s = SerializationUtils.toJsonString(list);
                this.getPageCache().put(key, s);
            }
        }
    }

    private void buildPageViewShowName(StringBuilder sb, Map<String, String> map) {
        this.buildMultiF7ShowName(sb, map.get("name"), map.get("number"), Integer.parseInt(map.get("scope")));
    }

    @Override
    @Nullable
    public String sendConfig() {
        IDataModel model = this.getModel();
        DynamicObject sceneDyn = (DynamicObject)model.getValue("scenario");
        if (sceneDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3002", (String)"DispatchParamSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)this.getPageCache().get("entity"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"DispatchParamSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject periodDyn = (DynamicObject)model.getValue("period");
        DynamicObject yearDyn = (DynamicObject)model.getValue("year");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("entity", this.getPageCache().get("entity"));
        if (yearDyn != null) {
            data.put("year", yearDyn.getString("id"));
        }
        if (periodDyn != null) {
            data.put("period", periodDyn.getString("id"));
        }
        if (this.sendScene() != null && this.sendScene() != 0L) {
            data.put("scenario", Objects.requireNonNull(this.sendScene()).toString());
        } else {
            data.put("scenario", sceneDyn.getString("id"));
        }
        return SerializationUtils.serializeToBase64(data);
    }

    @Override
    @Nullable
    public Long sendScene() {
        Long scenarioId;
        Map sceneParam = (Map)this.getView().getFormShowParameter().getCustomParam("initdata");
        Long l = scenarioId = sceneParam.get("scenario") == null ? null : (Long)((Map)sceneParam.get("scenario")).get("id");
        if (scenarioId != null && scenarioId != 0L) {
            return scenarioId;
        }
        DynamicObject sceneDyn = (DynamicObject)this.getModel().getValue("scenario");
        if (sceneDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3002", (String)"DispatchParamSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return sceneDyn.getLong("id");
    }

    @Override
    public String getConfigFromFormShowParameter() {
        return IScheduleSubPage.super.getConfigFromFormShowParameter();
    }
}

