/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.adjust;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.msservice.MsServiceHelper;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.task.common.AbstractScheduleOperator;
import kd.fi.bcm.task.common.OperatorHelper;
import kd.fi.bcm.task.common.PlanParam;

public class RptContinueEntryOperator
extends AbstractScheduleOperator {
    private final Set<String> warningMsg = new HashSet<String>(16);

    public Set<String> getWarningMsg() {
        return this.warningMsg;
    }

    @Override
    public Pair<Boolean, Set<String>> doOperation(PlanParam planParam) {
        if (StringUtils.isNotEmpty((String)planParam.getParamSetting())) {
            Map dimMap = (Map)SerializationUtils.deSerializeFromBase64((String)planParam.getParamSetting());
            Long modelId = planParam.getModelId();
            Long yearId = LongUtil.toLong(dimMap.get("year"));
            Long periodId = LongUtil.toLong(dimMap.get("period"));
            Long scenarioId = LongUtil.toLong(dimMap.get("scenario"));
            String scenarioNumber = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId).getNumber();
            Pair<Long, Long> yearAndPeriod = OperatorHelper.calYearAndPeriod(planParam, scenarioNumber, yearId, periodId);
            yearId = (Long)yearAndPeriod.p1;
            periodId = (Long)yearAndPeriod.p2;
            String entityJson = (String)dimMap.get("entity");
            Pair<Set<Long>, Set<String>> entitySet = OperatorHelper.getEntitySet(modelId, scenarioId, yearId, periodId, entityJson);
            this.getWarningMsg().addAll((Collection)entitySet.p2);
            HashSet<Long> entityIds = new HashSet<Long>(OperatorHelper.toBaseId(modelId, "bcm_entitymembertree", (Set)entitySet.p1));
            if (!entityIds.isEmpty()) {
                HashMap<String, Serializable> parameters = new HashMap<String, Serializable>(16);
                parameters.put("model", modelId);
                parameters.put("scenario", scenarioId);
                parameters.put("year", yearId);
                parameters.put("period", periodId);
                parameters.put("continueOrgScope", entityIds);
                Map res = (Map)MsServiceHelper.invokeService((String)"fi", (String)"bcm", (String)"AdjustMsService", (String)"continueEntry", (Object[])new Object[]{parameters});
                int successCount = (Integer)res.get("successCount");
                int billCount = (Integer)res.get("billCount");
                if (billCount != 0 && successCount == billCount) {
                    this.getWarningMsg().add(ResManager.loadKDString((String)"\u751f\u6210\u5ef6\u7eed\u5206\u5f55\u5b8c\u6210\u3002", (String)"GenerateContinueJournalOperator_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else {
                    String errorMsg = (String)res.get("detailMsg");
                    if (errorMsg != null) {
                        StringJoiner massages = new StringJoiner(";");
                        OperationResult result = (OperationResult)JSON.toJavaObject((JSON)JSON.parseObject((String)errorMsg), OperationResult.class);
                        this.addMessage(massages, result.getMessage());
                        List info = result.getAllErrorOrValidateInfo();
                        for (IOperateInfo operateInfo : info) {
                            this.addMessage(massages, operateInfo.getMessage());
                        }
                        this.getWarningMsg().add(massages.toString().replace("/**ERROR**/", "").replace("\u3002", ""));
                    }
                }
            }
        }
        return Pair.onePair((Object)true, this.getWarningMsg());
    }

    private void addMessage(StringJoiner massages, String message) {
        if (message != null) {
            massages.add(message);
        }
    }
}

