/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.adjust;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.invest.InvCopyModuleEnum;
import kd.fi.bcm.common.msservice.MsServiceHelper;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.task.common.AbstractScheduleOperator;
import kd.fi.bcm.task.common.OperatorHelper;
import kd.fi.bcm.task.common.PlanParam;

public class RptCreateAutoEntryOperator
extends AbstractScheduleOperator {
    private final Set<String> warningMsg = new HashSet<String>(16);

    public Set<String> getWarningMsg() {
        return this.warningMsg;
    }

    @Override
    public Pair<Boolean, Set<String>> doOperation(PlanParam planParam) {
        Map paramSetting = (Map)SerializationUtils.fromJsonString((String)planParam.getParamSetting(), Map.class);
        Long modelId = planParam.getModelId();
        Long yearId = LongUtil.toLong(paramSetting.get("year"));
        Long periodId = LongUtil.toLong(paramSetting.get("period"));
        Long scenarioId = LongUtil.toLong(paramSetting.get("scenario"));
        Long orgId = LongUtil.toLong(paramSetting.get("entity"));
        int effectiveRange = (Integer)ObjectConverter.convert(paramSetting.get("effectiverange"), Integer.class, (boolean)false);
        List<String> mergeSet = Arrays.asList(((String)paramSetting.get("mergeset")).split(","));
        HashSet commonPaperIds = paramSetting.get("commonpapers") == null ? new HashSet(16) : (Set)SerializationUtils.deSerializeFromBase64((String)((String)paramSetting.get("commonpapers")));
        HashSet investedTemplateIds = paramSetting.get("investedtemplates") == null ? new HashSet(16) : (Set)SerializationUtils.deSerializeFromBase64((String)((String)paramSetting.get("investedtemplates")));
        String scenarioNumber = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId).getNumber();
        Pair<Long, Long> yearAndPeriod = OperatorHelper.calYearAndPeriod(planParam, scenarioNumber, yearId, periodId);
        yearId = (Long)yearAndPeriod.p1;
        periodId = (Long)yearAndPeriod.p2;
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>(16);
        parameters.put("model", modelId);
        parameters.put("scenario", scenarioId);
        parameters.put("year", yearId);
        parameters.put("period", periodId);
        parameters.put("org", orgId);
        parameters.put("commonpapers", commonPaperIds);
        parameters.put("investedtemplates", investedTemplateIds);
        parameters.put("scope", Integer.valueOf(effectiveRange));
        parameters.put("isCreateAdjust", Boolean.valueOf(mergeSet.contains(InvCopyModuleEnum.MERGE_NODE.getMappingStr())));
        parameters.put("isCreateElim", Boolean.valueOf(mergeSet.contains(InvCopyModuleEnum.MERGE_STRUCT.getMappingStr())));
        parameters.put("isCommonPaperSelected", Boolean.valueOf(mergeSet.contains("4")));
        parameters.put("isInvestTempSelected", Boolean.valueOf(mergeSet.contains(InvCopyModuleEnum.INVEST_REF.getMappingStr())));
        parameters.put("isInvSheetPaperSelected", Boolean.valueOf(mergeSet.contains(InvCopyModuleEnum.DYNAMICTYPE_REF.getMappingStr())));
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId);
        IDNumberTreeNode fyNode = MemberReader.findFyMemberById((Long)modelId, (Long)yearId);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId);
        if (LockScopeServiceHelper.isExistArchiving((long)modelId, (String)sceneNode.getNumber(), (String)fyNode.getNumber(), (String)periodNode.getNumber())) {
            this.getWarningMsg().add(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u56e0\u4e3a\u5f53\u671f\u671f\u95f4\u5206\u9636\u6bb5\u65b9\u6848\u5df2\u5f52\u6863\u3002", (String)"ReportAdjustShareFromPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)true, this.getWarningMsg());
        }
        Map res = (Map)MsServiceHelper.invokeService((String)"fi", (String)"bcm", (String)"AdjustMsService", (String)"createAutoAdjust", (Object[])new Object[]{parameters});
        int successCount = Optional.ofNullable(res.get("successCount")).map(Integer.class::cast).orElseGet(() -> 0);
        int billCount = (Integer)res.get("billCount");
        if (billCount != 0 && successCount == billCount) {
            this.getWarningMsg().add(ResManager.loadKDString((String)"\u751f\u6210\u81ea\u52a8\u5206\u5f55\u5b8c\u6210\u3002", (String)"RptCreateAutoAdjust_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            String errorMsg = (String)res.get("errorMsg");
            if (errorMsg != null) {
                this.getWarningMsg().add(errorMsg.replace("kd.fi.bcm.service.AdjustMsServiceImpl", "").replace("/**ERROR**/", ""));
            }
        }
        return Pair.onePair((Object)true, this.getWarningMsg());
    }
}

