/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.adjust;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.invest.InvCopyModuleEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.task.common.IScheduleSubPage;
import org.jetbrains.annotations.Nullable;

public class RptCreateAutoEntryParamPlugin
extends AbstractBaseFormPlugin
implements IScheduleSubPage {
    private static final List<String> leafDimKeys = Arrays.asList("scenario", "year", "period");
    private static final List<String> commonDimKeys = Collections.singletonList("entity");

    @Override
    public void initialize() {
        super.initialize();
        HashMap leafDimMap = new HashMap();
        this.asMapF7toType(leafDimKeys, SingleF7TypeEnum.LEAF, leafDimMap);
        this.asMapF7toType(commonDimKeys, SingleF7TypeEnum.COMMON, leafDimMap);
        this.initSingleMemberF7(leafDimMap);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit commonPapers = (MulBasedataEdit)this.getControl("commonpapers");
        commonPapers.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Long modelId = this.getModelId();
            TemplateCatalogEnum catalogEnum = TemplateCatalogEnum.PRTADJUST;
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).add("longnumber", "like", (Object)(catalogEnum.getLongnumber() + "%"));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_papertemplatecatalog", (String)"id", (QFilter[])qfBuilder.toArray());
            Set catalogIds = dynamicObjects.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            QFilter customQFilter = new QFilter("model", "=", (Object)modelId);
            customQFilter.and("status", "=", (Object)"1");
            customQFilter.and("templatecatalog", "in", catalogIds);
            beforeF7SelectEvent.addCustomQFilter(customQFilter);
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setCustomParam("catalog", (Object)catalogEnum.getNumber());
        });
        MulBasedataEdit investedTemplates = (MulBasedataEdit)this.getControl("investedtemplates");
        investedTemplates.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter customQFilter = new QFilter("model", "=", (Object)this.getModelId());
            customQFilter.and("billstatus", "=", (Object)"C");
            beforeF7SelectEvent.addCustomQFilter(customQFilter);
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Long scenarioId;
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getFormCustomParam("model");
        this.getModel().setValue("model", (Object)modelId);
        this.getPageCache().put("KEY_MODEL_ID", modelId + "");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Map sceneParam = (Map)this.getFormCustomParam("initdata");
        Long l = scenarioId = sceneParam.get("scenario") == null ? null : (Long)((Map)sceneParam.get("scenario")).get("id");
        if (OperationStatus.ADDNEW == status) {
            if (scenarioId != null && scenarioId != 0L) {
                this.getModel().setValue("scenario", (Object)scenarioId);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"scenario"});
            }
        } else if (OperationStatus.EDIT == status) {
            String param = this.getConfigFromFormShowParameter();
            if (param == null || param.trim().isEmpty()) {
                return;
            }
            if (scenarioId != null && scenarioId != 0L) {
                this.getModel().setValue("scenario", (Object)scenarioId);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"scenario"});
            }
            Map paramSetting = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
            this.getModel().setValue("scenario", (Object)LongUtil.toLong(paramSetting.get("scenario")));
            this.getModel().setValue("year", (Object)LongUtil.toLong(paramSetting.get("year")));
            this.getModel().setValue("period", (Object)LongUtil.toLong(paramSetting.get("period")));
            this.getModel().setValue("entity", (Object)LongUtil.toLong(paramSetting.get("entity")));
            this.getModel().setValue("orgscope", paramSetting.get("effectiverange"));
            List<String> mergeSet = Arrays.asList(paramSetting.computeIfAbsent("mergeset", a -> "").split(","));
            this.getModel().setValue("createadjust", (Object)mergeSet.contains(InvCopyModuleEnum.MERGE_NODE.getMappingStr()));
            this.getModel().setValue("createelim", (Object)mergeSet.contains(InvCopyModuleEnum.MERGE_STRUCT.getMappingStr()));
            this.getModel().setValue("iscommonpaperselected", (Object)mergeSet.contains("4"));
            this.getModel().setValue("isinvesttempselected", (Object)mergeSet.contains(InvCopyModuleEnum.INVEST_REF.getMappingStr()));
            this.getModel().setValue("isinvsheetpaperselected", (Object)mergeSet.contains(InvCopyModuleEnum.DYNAMICTYPE_REF.getMappingStr()));
            if (paramSetting.get("commonpapers") != null) {
                Set commonPaperSet = (Set)SerializationUtils.deSerializeFromBase64((String)((String)paramSetting.get("commonpapers")));
                this.getModel().setValue("commonpapers", (Object)commonPaperSet.toArray());
            }
            if (paramSetting.get("investedtemplates") != null) {
                Set investedTemplateSet = (Set)SerializationUtils.deSerializeFromBase64((String)((String)paramSetting.get("investedtemplates")));
                this.getModel().setValue("investedtemplates", (Object)investedTemplateSet.toArray());
            }
        }
    }

    @Override
    @Nullable
    public String sendConfig() {
        DynamicObjectCollection investedTemplates;
        IDataModel model = this.getModel();
        DynamicObject sceneDyn = (DynamicObject)model.getValue("scenario");
        if (sceneDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3002", (String)"DispatchParamSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject entityDyn = (DynamicObject)model.getValue("entity");
        if (entityDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"DispatchParamSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject periodDyn = (DynamicObject)model.getValue("period");
        DynamicObject yearDyn = (DynamicObject)model.getValue("year");
        HashMap<String, String> data = new HashMap<String, String>(16);
        if (yearDyn != null) {
            data.put("year", yearDyn.getString("id"));
        }
        if (periodDyn != null) {
            data.put("period", periodDyn.getString("id"));
        }
        if (this.sendScene() != null && this.sendScene() != 0L) {
            data.put("scenario", Objects.requireNonNull(this.sendScene()).toString());
        } else {
            data.put("scenario", sceneDyn.getString("id"));
        }
        data.put("entity", entityDyn.getString("id"));
        data.put("effectiverange", String.valueOf(this.getModel().getValue("orgscope")));
        data.put("mergeset", String.join((CharSequence)",", this.createAutoAdjustOrCopyInvest()));
        DynamicObjectCollection commonPapers = this.getModel().getDataEntity(true).getDynamicObjectCollection("commonpapers");
        if (!CollectionUtil.isEmpty((Collection)commonPapers)) {
            data.put("commonpapers", SerializationUtils.serializeToBase64(commonPapers.stream().map(p -> p.getLong("fbasedataid.id")).collect(Collectors.toSet())));
        }
        if (!CollectionUtil.isEmpty((Collection)(investedTemplates = this.getModel().getDataEntity(true).getDynamicObjectCollection("investedtemplates")))) {
            data.put("investedtemplates", SerializationUtils.serializeToBase64(investedTemplates.stream().map(p -> p.getLong("fbasedataid.id")).collect(Collectors.toSet())));
        }
        return SerializationUtils.toJsonString(data);
    }

    @Override
    @Nullable
    public Long sendScene() {
        Long scenarioId;
        Map sceneParam = (Map)this.getView().getFormShowParameter().getCustomParam("initdata");
        Long l = scenarioId = sceneParam.get("scenario") == null ? null : (Long)((Map)sceneParam.get("scenario")).get("id");
        if (scenarioId != null && scenarioId != 0L) {
            return scenarioId;
        }
        DynamicObject sceneDyn = (DynamicObject)this.getModel().getValue("scenario");
        if (sceneDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3002", (String)"DispatchParamSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return sceneDyn.getLong("id");
    }

    private List<String> createAutoAdjustOrCopyInvest() {
        ArrayList<String> bussinessSet = new ArrayList<String>(5);
        if (((Boolean)this.getModel().getValue("createadjust")).booleanValue()) {
            bussinessSet.add(InvCopyModuleEnum.MERGE_NODE.getMappingStr());
        }
        if (((Boolean)this.getModel().getValue("createelim")).booleanValue()) {
            bussinessSet.add(InvCopyModuleEnum.MERGE_STRUCT.getMappingStr());
        }
        if (CollectionUtil.isEmpty(bussinessSet)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RptCreateAutoEntryParamPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        ArrayList<String> templateTypeSet = new ArrayList<String>(5);
        if (((Boolean)this.getModel().getValue("isinvesttempselected")).booleanValue()) {
            templateTypeSet.add(InvCopyModuleEnum.INVEST_REF.getMappingStr());
        }
        if (((Boolean)this.getModel().getValue("isinvsheetpaperselected")).booleanValue()) {
            templateTypeSet.add(InvCopyModuleEnum.DYNAMICTYPE_REF.getMappingStr());
        }
        if (((Boolean)this.getModel().getValue("iscommonpaperselected")).booleanValue()) {
            templateTypeSet.add("4");
        }
        if (CollectionUtil.isEmpty(templateTypeSet)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RptCreateAutoEntryParamPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        bussinessSet.addAll(templateTypeSet);
        return bussinessSet;
    }
}

