/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.carryperiod;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.bcm.business.carry.CarryServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.task.common.AbstractScheduleOperator;
import kd.fi.bcm.task.common.OperatorHelper;
import kd.fi.bcm.task.common.PlanParam;
import org.apache.commons.collections.CollectionUtils;

public class CarryPeriodOperator
extends AbstractScheduleOperator {
    @Override
    public Pair<Boolean, Set<String>> doOperation(PlanParam planParam) {
        HashSet<String> msgS = new HashSet<String>(16);
        long modelId = planParam.getModelId();
        long executor = planParam.getExecutor();
        Map configMap = (Map)SerializationUtils.fromJsonString((String)planParam.getParamSetting(), Map.class);
        OperatorHelper.checkPermission(modelId, "bcm_carrylist", "/=NAF=U/PB06", executor);
        long scenarioId = planParam.getScenarioId();
        String scenarioNumber = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId).getNumber();
        long yearId = LongUtil.toLong((Object)configMap.getOrDefault("year", 0L));
        long periodId = LongUtil.toLong((Object)configMap.getOrDefault("period", 0L));
        Pair<Long, Long> yearAndPeriod = OperatorHelper.calYearAndPeriod(planParam, scenarioNumber, yearId, periodId);
        yearId = (Long)yearAndPeriod.p1;
        periodId = (Long)yearAndPeriod.p2;
        Object multiEntityObj = configMap.get("entity");
        if (!(multiEntityObj instanceof List)) {
            msgS.add(ResManager.loadKDString((String)"\u5e74\u521d\u7ed3\u8f6c\u6267\u884c\u53c2\u6570\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"CarryPeriodOperator_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)false, msgS);
        }
        List list1 = (List)multiEntityObj;
        if (CollectionUtils.isEmpty((Collection)list1)) {
            msgS.add(ResManager.loadKDString((String)"\u5e74\u521d\u7ed3\u8f6c\u6267\u884c\u53c2\u6570\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"CarryPeriodOperator_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)false, msgS);
        }
        Set memberIds = QueryMemberDetailsHelper.queryMemberIdsByListData((long)modelId, (String)"bcm_entitymembertree", (List)list1);
        OperatorHelper.dealNoPermOrg(modelId, memberIds);
        if (CollectionUtils.isEmpty((Collection)memberIds)) {
            msgS.add(ResManager.loadKDString((String)"\u6267\u884c\u667a\u80fd\u8c03\u5ea6\u7684\u7528\u6237\u6ca1\u6709\u53ef\u6267\u884c\u7ec4\u7ec7\u7684\u6570\u636e\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u8be5\u7528\u6237\u7684\u6570\u636e\u6743\u9650\u8303\u56f4\u3002", (String)"CarryPeriodOperator_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)false, msgS);
        }
        CarryServiceHelper.carryYear((long)modelId, (long)scenarioId, (long)yearId, (long)periodId, (Set)memberIds);
        return Pair.onePair((Object)true, msgS);
    }
}

