/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.carryperiod;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.task.common.IScheduleSubPage;

public class CarryPeriodPlugin
extends AbstractBaseFormPlugin
implements IScheduleSubPage {
    private static final List<String> dimKeys = Arrays.asList("scenario", "year", "period");

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("entity");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        List multiDim;
        super.afterCreateNewData(e);
        Map sceneParam = (Map)this.getView().getFormShowParameter().getCustomParam("initdata");
        Long scenarioId = sceneParam.get("scenario") == null ? null : (Long)((Map)sceneParam.get("scenario")).get("id");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String configStr = this.getConfigFromFormShowParameter();
        Map configMap = new HashMap(16);
        if (!StringUtils.isBlank((CharSequence)configStr)) {
            configMap = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
        }
        this.getModel().setValue("scenario", configMap.get("scenario"));
        if (scenarioId != null && scenarioId != 0L) {
            this.getModel().setValue("scenario", (Object)scenarioId);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"scenario"});
        }
        if (OperationStatus.EDIT == status) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"scenario"});
        }
        this.getModel().setValue("year", configMap.get("year"));
        this.getModel().setValue("period", configMap.get("period"));
        if (configMap.get("entity") instanceof List && !CollectionUtil.isEmpty((Collection)(multiDim = (List)configMap.get("entity")))) {
            StringBuilder showName = new StringBuilder();
            for (Map item : multiDim) {
                this.buildMultiF7ShowName(showName, (String)item.get("name"), (String)item.get("number"), Integer.parseInt((String)item.get("scope")));
            }
            this.getModel().setValue("entity", (Object)showName.substring(0, showName.length() - 1));
            this.getPageCache().put(DimTypesEnum.ENTITY.getNumber(), SerializationUtils.toJsonString((Object)multiDim));
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("entity".equals(key)) {
            this.showMultiMemberF7("Entity");
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("year".equals(propertyName) && e.getChangeSet()[0].getNewValue() == null) {
            this.getModel().setValue("period", null);
        } else if ("entity".equals(propertyName) && (e.getChangeSet()[0].getNewValue() == null || StringUtils.isEmpty((CharSequence)e.getChangeSet()[0].getNewValue().toString()))) {
            this.getPageCache().remove(DimTypesEnum.ENTITY.getNumber());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (closedCallBackEvent.getReturnData() != null && "Entity".equals(key)) {
            DynamicObjectCollection doc = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
            MultiF7Results mps = MultiF7Results.buildParam((DynamicObjectCollection)doc);
            if (doc.isEmpty()) {
                this.getModel().setValue(key, null);
                this.getPageCache().remove(key);
            } else {
                this.getModel().setValue(key, (Object)mps.getShowText());
                this.getPageCache().put(key, SerializationUtils.toJsonString((Object)mps.toList()));
            }
        }
    }

    @Override
    public String sendConfig() {
        IDataModel model = this.getModel();
        DynamicObject sceneDyn = (DynamicObject)model.getValue("scenario");
        if (sceneDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3002", (String)"DispatchParamSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String multiEntityStr = this.getPageCache().get(DimTypesEnum.ENTITY.getNumber());
        if (StringUtils.isEmpty((CharSequence)multiEntityStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"DispatchParamSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("scenario", sceneDyn.getLong("id"));
        DynamicObject yearObj = (DynamicObject)model.getValue("year");
        result.put("year", yearObj == null ? 0L : yearObj.getLong("id"));
        DynamicObject periodObj = (DynamicObject)model.getValue("period");
        result.put("period", periodObj == null ? 0L : periodObj.getLong("id"));
        result.put("entity", SerializationUtils.fromJsonString((String)multiEntityStr, List.class));
        return SerializationUtils.toJsonString(result);
    }

    @Override
    public Long sendScene() {
        DynamicObject sceneDyn = (DynamicObject)this.getModel().getValue("scenario");
        return sceneDyn == null ? 0L : sceneDyn.getLong("id");
    }

    private void showMultiMemberF7(String number) {
        long modelId = this.getModelId();
        DynamicObject dim = MemberReader.getDimensionDynById((long)MemberReader.getDimensionIdByNum((long)modelId, (String)number));
        if (dim != null) {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("bcm_mulmemberf7base_tem");
            para.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("dimension", dim.getInt("dseq") + "");
            params.put("KEY_MODEL_ID", String.valueOf(modelId));
            params.put("sign", number);
            para.setCustomParams(params);
            para.setCaption(dim.getString("name"));
            IFormView view = this.getView();
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, number);
            para.setCloseCallBack(closeCallBack);
            view.showForm(para);
        }
    }

    @Override
    public long getModelId() {
        return (Long)this.getFormCustomParam("model");
    }

    @Override
    public String getModelNumber() {
        return MemberReader.findModelNumberById((Object)this.getModelId());
    }
}

