/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.checkupchk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.chkcheck.CheckResultenum;
import kd.fi.bcm.common.enums.chkcheck.ChkSourceEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.task.common.AbstractScheduleOperator;
import kd.fi.bcm.task.common.OperatorHelper;
import kd.fi.bcm.task.common.PlanParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CheckUpChkNewOperator
extends AbstractScheduleOperator {
    private static final Log logger = LogFactory.getLog(CheckUpChkNewOperator.class);
    protected static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private final Set<String> execMsg = new HashSet<String>(16);

    @Override
    public Pair<Boolean, Set<String>> doOperation(PlanParam planParam) {
        if (planParam == null || StringUtils.isBlank((String)planParam.getParamSetting())) {
            this.execMsg.add(ResManager.loadKDString((String)"\u53c2\u6570\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u3002", (String)"CheckUpChkNewOperator_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return Pair.onePair((Object)Boolean.FALSE, this.execMsg);
        }
        Map configMap = (Map)SerializationUtils.fromJsonString((String)planParam.getParamSetting(), Map.class);
        long modelId = planParam.getModelId();
        Long yearId = LongUtil.toLong(configMap.get("year"));
        Long periodId = LongUtil.toLong(configMap.get("period"));
        Long scenarioId = LongUtil.toLong(configMap.get("scenario"));
        OperatorHelper.checkPermission(modelId, "bcm_mergecontrollist", "13X5JXHMW=OF", planParam.getExecutor());
        Pair<Long, Long> fyAndPeriod = OperatorHelper.calYearAndPeriod(planParam, planParam.getScenarioMemberEnum().number, yearId, periodId);
        yearId = (Long)fyAndPeriod.p1;
        periodId = (Long)fyAndPeriod.p2;
        String entityStr = JSON.toJSONString(configMap.get("entity"));
        Set<Pair<String, Long>> entitySet = this.getEntitySet(entityStr, modelId);
        Set<Long> entityIds = entitySet.stream().map(p -> (Long)p.p2).collect(Collectors.toSet());
        OperatorHelper.dealNoPermOrg(modelId, entityIds);
        if (CollectionUtils.isEmpty(entityIds)) {
            this.execMsg.add(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u6267\u884c\u7684\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u6743\u3002", (String)"CheckUpChkNewOperator_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return Pair.onePair((Object)Boolean.FALSE, this.execMsg);
        }
        entitySet.removeIf(pair -> !entityIds.contains(pair.p2));
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        DynamicObject fy = OperatorHelper.getDynamicObject(yearId, "bcm_fymembertree");
        DynamicObject scenari = OperatorHelper.getDynamicObject(scenarioId, "bcm_scenemembertree");
        DynamicObject period = OperatorHelper.getDynamicObject(periodId, "bcm_periodmembertree");
        CalContext ctx = new CalContext(modelNumber, ParamConstant.MergeProcess, new ArrayList<Pair<String, Long>>(entitySet), fy.getString("number"), period.getString("number"), scenari.getString("number"));
        ctx.setProperty("chksourcetype", (Object)ChkSourceEnum.INTELLIGENT_SCHEDULE);
        Pair chkResult = ChkCheckServiceHelper.intelligentScheduleCheck((ICalContext)ctx);
        if (StringUtils.isNotBlank((String)((String)chkResult.p2))) {
            this.getExecMsg().add((String)chkResult.p2);
        }
        return Pair.onePair((Object)(chkResult.p1 == CheckResultenum.COMPLETE ? 1 : 0), this.execMsg);
    }

    private Set<Pair<String, Long>> getEntitySet(String entityStr, Long modelId) {
        HashSet<Pair<String, Long>> resSet = new HashSet<Pair<String, Long>>();
        JSONArray parseArray = JSONObject.parseArray((String)entityStr);
        for (Object object : parseArray) {
            JSONObject obj = (JSONObject)object;
            Long id = obj.getLong("id");
            Integer scope = obj.getInteger("scope");
            String entityNum = MemberReader.findMemberById((long)modelId, (String)"bcm_entitymembertree", (Long)id).getNumber();
            new MembRangeItem("bcm_entitymembertree", id, entityNum, scope.intValue(), false, (Object)modelId).matchItems(c -> resSet.add(Pair.onePair((Object)c.getNumber(), (Object)c.getId())));
        }
        return resSet;
    }

    public Set<String> getExecMsg() {
        return this.execMsg;
    }
}

