/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import kd.fi.bcm.common.enums.DispatchTypeEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.task.adjust.RptContinueEntryOperator;
import kd.fi.bcm.task.adjust.RptCreateAutoEntryOperator;
import kd.fi.bcm.task.basedata.BaseDataOperator;
import kd.fi.bcm.task.carryperiod.CarryPeriodOperator;
import kd.fi.bcm.task.checkupchk.CheckUpChkNewOperator;
import kd.fi.bcm.task.common.ISchedulePlanOperator;
import kd.fi.bcm.task.dimension.DataExtractOperator;
import kd.fi.bcm.task.formulacollect.FormulaCollectOperator;
import kd.fi.bcm.task.integration.DataIntegrationOperator;
import kd.fi.bcm.task.invest.CopyInvestOperator;
import kd.fi.bcm.task.invest.ShareHoldingCalcOperator;
import kd.fi.bcm.task.mergecontrol.MergeControlOperator;
import kd.fi.bcm.task.mergeflow.MergeFlowNewOperator;
import kd.fi.bcm.task.periodmanage.PeriodOperator;
import kd.fi.bcm.task.rulecalculate.RuleCalculateOperator;
import org.apache.commons.lang3.tuple.Triple;

public class IntelligentScheduleConfigHelper {
    private static final Map<String, Triple<String, String, Supplier<ISchedulePlanOperator>>> DISPATCH_TYPE_TO_OPERATOR = new HashMap<String, Triple<String, String, Supplier<ISchedulePlanOperator>>>(16);

    public static ISchedulePlanOperator getStrategyNew(String operatorType) {
        Triple<String, String, Supplier<ISchedulePlanOperator>> triple = DISPATCH_TYPE_TO_OPERATOR.get(operatorType);
        return triple == null ? null : (ISchedulePlanOperator)((Supplier)triple.getRight()).get();
    }

    public static boolean isUpdated(String operatorType) {
        return DISPATCH_TYPE_TO_OPERATOR.containsKey(operatorType);
    }

    public static String getOperatorName(String operatorType) {
        Triple<String, String, Supplier<ISchedulePlanOperator>> triple = DISPATCH_TYPE_TO_OPERATOR.get(operatorType);
        return triple != null ? (String)triple.getLeft() : Optional.ofNullable(DispatchTypeEnum.getDispatchTypeEnum((String)operatorType)).map(DispatchTypeEnum::getName).orElseGet(() -> "");
    }

    public static String getConfigFormId(String operatorType) {
        Triple<String, String, Supplier<ISchedulePlanOperator>> triple = DISPATCH_TYPE_TO_OPERATOR.get(operatorType);
        return triple == null ? null : (String)triple.getMiddle();
    }

    static {
        for (OperatorConfig operatorConfig : OperatorConfig.values()) {
            DISPATCH_TYPE_TO_OPERATOR.put(operatorConfig.number, (Triple<String, String, Supplier<ISchedulePlanOperator>>)Triple.of((Object)operatorConfig.name.loadKDString(), (Object)operatorConfig.fromId, (Object)operatorConfig.operatorSupplier));
        }
    }

    static enum OperatorConfig {
        MERGEFLOW(DispatchTypeEnum.MERGEFLOW.getValue(), DispatchTypeEnum.MERGEFLOW.getNameBridge(), "bcm_dispatchmergeflow", MergeFlowNewOperator::new),
        CONTINUE_ENTRY(DispatchTypeEnum.CONTINUE_ENTRY.getValue(), DispatchTypeEnum.CONTINUE_ENTRY.getNameBridge(), "bcm_continueentryparam", RptContinueEntryOperator::new),
        COPYINVEST(DispatchTypeEnum.COPYINVEST.getValue(), DispatchTypeEnum.COPYINVEST.getNameBridge(), "bcm_copyinvestparam", CopyInvestOperator::new),
        SHAREHOLDINGCALC(DispatchTypeEnum.SHAREHOLDINGCALC.getValue(), DispatchTypeEnum.SHAREHOLDINGCALC.getNameBridge(), "bcm_shareholdingcalc", ShareHoldingCalcOperator::new),
        CREATE_AUTO_ADJUST(DispatchTypeEnum.CREATE_AUTO_ADJUST.getValue(), DispatchTypeEnum.CREATE_AUTO_ADJUST.getNameBridge(), "bcm_createautoadjustparam", RptCreateAutoEntryOperator::new),
        INTEGRATION(DispatchTypeEnum.INTEGRATION.getValue(), DispatchTypeEnum.INTEGRATION.getNameBridge(), "bcm_scheduleintegration", () -> new DataIntegrationOperator(){}),
        DATA_EXTRACTION(DispatchTypeEnum.DATA_EXTRACTION.getValue(), DispatchTypeEnum.DATA_EXTRACTION.getNameBridge(), "bcm_sche_dataextract", () -> new DataExtractOperator(){}),
        MERGE(DispatchTypeEnum.MERGE.getValue(), DispatchTypeEnum.MERGE.getNameBridge(), "bcm_dispatchmergeconfig", MergeControlOperator::new),
        PERIODMANAGE(DispatchTypeEnum.PERIODMANAGE.getValue(), DispatchTypeEnum.PERIODMANAGE.getNameBridge(), "bcm_dispatchperiod", PeriodOperator::new),
        RULE_CALCULATE(DispatchTypeEnum.CALCULATE.getValue(), DispatchTypeEnum.CALCULATE.getNameBridge(), "bcm_dispatchcalculate", RuleCalculateOperator::new),
        FORMULA_COLLECT(DispatchTypeEnum.FOMULAR.getValue(), DispatchTypeEnum.FOMULAR.getNameBridge(), "bcm_formulacollect", FormulaCollectOperator::new),
        CARRY_PERIOD(DispatchTypeEnum.BEGIN_YEAR_CARRY.getValue(), DispatchTypeEnum.BEGIN_YEAR_CARRY.getNameBridge(), "bcm_carryperiod", CarryPeriodOperator::new),
        BASEDATA(DispatchTypeEnum.BASEDATA.getValue(), DispatchTypeEnum.BASEDATA.getNameBridge(), "", BaseDataOperator::new),
        CHECK_UP_CHK(DispatchTypeEnum.MERGETASK.getValue(), DispatchTypeEnum.MERGETASK.getNameBridge(), "bcm_dispatchcheckupchk", CheckUpChkNewOperator::new);

        private final String number;
        private final MultiLangEnumBridge name;
        private final String fromId;
        private final Supplier<ISchedulePlanOperator> operatorSupplier;

        private OperatorConfig(String number, MultiLangEnumBridge name, String fromId, Supplier<ISchedulePlanOperator> operatorSupplier) {
            this.number = number;
            this.name = name;
            this.fromId = fromId;
            this.operatorSupplier = operatorSupplier;
        }
    }
}

