/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.serviceHelper.ScenePeriodServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.ScenarioMemberEnum;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.task.common.PlanParam;

public class OperatorHelper {
    private OperatorHelper() {
        throw new IllegalStateException(String.format(ResManager.loadKDString((String)"%1$s\u7c7b\u4e3a\u5e38\u91cf\u7c7b\uff0c\u65e0\u6cd5\u7ee7\u627f\u548c\u5b9e\u4f8b\u5316\u3002", (String)"OperatorHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getClass().getName()));
    }

    public static Pair<Long, Long> calYearAndPeriod(PlanParam planParam, String scenarioNumber, long yearIdSetting, long periodIdSetting) {
        long modelId = planParam.getModelId();
        long scenarioId = planParam.getScenarioId();
        int yearOffset = planParam.getYearOffset();
        int periodOffset = planParam.getPeriodOffset();
        ScenarioMemberEnum scenarioMemberEnum = planParam.getScenarioMemberEnum();
        long yearIdNew = yearIdSetting;
        long periodIdNew = periodIdSetting;
        if (yearIdNew == 0L || periodIdNew == 0L) {
            List periodIds;
            if (yearIdNew != 0L) {
                yearOffset = 0;
            }
            if (periodIdNew != 0L) {
                periodOffset = 0;
            }
            Tuple newPeriod = PeriodUtils.getPeriodByOffset((long)modelId, (ScenarioMemberEnum)scenarioMemberEnum, (long)yearIdNew, (long)periodIdNew, (int)yearOffset, (int)periodOffset);
            if ((Long)newPeriod.item1 == 0L || (Long)newPeriod.item2 == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u5e74\u6216\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"OperatorHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (yearIdNew != 0L && yearIdNew != (Long)newPeriod.item1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u6307\u5b9a\u8d22\u5e74\u65f6\u671f\u95f4\u504f\u79fb\u4e0d\u80fd\u8de8\u8d22\u5e74\u3002", (String)"OperatorHelper_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (scenarioNumber != null && (periodIds = (List)ScenePeriodServiceHelper.getScenePeriodByModel((Long)modelId, Collections.singletonList(scenarioNumber)).get(scenarioNumber)) != null && !periodIds.isEmpty() && !periodIds.contains(newPeriod.item2)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u504f\u79fb\u8ba1\u7b97\u540e\u7684\u671f\u95f4\u4e0d\u5b58\u5728\u4e8e\u201c\u60c5\u666f\u201d\u7684\u9002\u7528\u671f\u95f4\u3002", (String)"OperatorHelper_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            yearIdNew = (Long)newPeriod.item1;
            periodIdNew = (Long)newPeriod.item2;
        }
        if (!MemberPermHelper.getLimitedModelListByUser().contains(modelId)) {
            HashSet scenarioIds = Sets.newHashSet((Object[])new Long[]{scenarioId});
            OperatorHelper.retainReadWriteMembers(modelId, PresetConstant.SCENE_DIM, "bcm_scenemembertree", scenarioIds);
            if (scenarioIds.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u60c5\u666f\u65e0\u5199\u5165\u6743\u9650\u3002", (String)"OperatorHelper_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            HashSet yearIds = Sets.newHashSet((Object[])new Long[]{yearIdNew});
            OperatorHelper.retainReadWriteMembers(modelId, PresetConstant.FY_DIM, "bcm_fymembertree", yearIds);
            if (yearIds.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u5e74\u65e0\u5199\u5165\u6743\u9650\u3002", (String)"OperatorHelper_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            HashSet periodIds = Sets.newHashSet((Object[])new Long[]{periodIdNew});
            OperatorHelper.retainReadWriteMembers(modelId, PresetConstant.PERIOD_DIM, "bcm_periodmembertree", periodIds);
            if (periodIds.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u65e0\u5199\u5165\u6743\u9650\u3002", (String)"OperatorHelper_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        return Pair.onePair((Object)yearIdNew, (Object)periodIdNew);
    }

    public static Set<String> checkPeriodStatus(long modelId, long scenarioId, long yearId, long periodId, Collection<Long> entityIds) {
        if (CollectionUtils.isEmpty(entityIds) || !ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM012")) {
            return Collections.emptySet();
        }
        Map orgNodeMap = MemberReader.getAllNodeFromCache((String)"bcm_entitymembertree", (String)MemberReader.findModelNumberById((Object)modelId));
        HashMultimap orgNumber2IdMap = HashMultimap.create();
        for (Long entityId : entityIds) {
            orgNumber2IdMap.put((Object)orgNodeMap.getOrDefault(entityId, IDNumberTreeNode.NotFoundTreeNode).getNumber(), (Object)entityId);
        }
        Set periodOpenOrgSet = PeriodSettingHelper.batchSelectPeriodStatusOpen((Long)modelId, (Set)orgNumber2IdMap.keySet(), (Long)scenarioId, (Long)yearId, (Long)periodId, (String)"datastatus");
        HashSet<String> periodClosed = new HashSet<String>(orgNumber2IdMap.size());
        orgNumber2IdMap.forEach((num, id) -> {
            if (!periodOpenOrgSet.contains(num)) {
                entityIds.remove(id);
                periodClosed.add((String)num);
            }
        });
        return periodClosed;
    }

    public static String checkPeriodStatusWithMsg(long modelId, long scenarioId, long yearId, long periodId, Collection<Long> entityIds) {
        Set<String> periodFilterResult = OperatorHelper.checkPeriodStatus(modelId, scenarioId, yearId, periodId, entityIds);
        return periodFilterResult.isEmpty() ? null : String.format(ResManager.loadKDString((String)"%1$s\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"OperatorHelper_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), periodFilterResult);
    }

    public static void checkPermission(long modelId, String entityNum, String permItemId, Long userId) {
        int permission;
        if (MemberPermHelper.ifUserHasRootPermByModel((long)userId, (String)String.valueOf(modelId))) {
            return;
        }
        DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"reporttype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
        String appnum = ApplicationTypeEnum.CM.getAppnum();
        if (ApplicationTypeEnum.RPT.index.equals(model.getString("reporttype"))) {
            appnum = ApplicationTypeEnum.RPT.getAppnum();
        }
        if ((permission = PermissionServiceHelper.checkPermission((long)userId, (String)"bcm_model", (long)modelId, (String)AppMetadataCache.getAppInfo((String)appnum).getId(), (String)entityNum, (String)permItemId)) == 0) {
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u65e0\u6267\u884c\u64cd\u4f5c\u6743\u9650\u3002", (String)"OperatorHelper_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), user != null ? user.getString("name") : ""));
        }
    }

    public static Set<Long> toBaseId(long modelId, String entityNum, Set<Long> entitySet) {
        Map result = MemberReader.getAllNodeFromCache((String)entityNum, (Object)modelId);
        return entitySet.stream().map(p -> {
            IDNumberTreeNode node = (IDNumberTreeNode)result.get(p);
            if (node != null && node.isShare()) {
                return node.getCopyfromId();
            }
            return p;
        }).collect(Collectors.toSet());
    }

    public static Pair<Set<Long>, Set<String>> getEntitySet(long modelId, long scenarioId, long yearId, long periodId, String entityStr) {
        Set<String> periodFilterResult;
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId);
        JSONArray parseArray = JSON.parseArray((String)entityStr);
        HashSet<String> msg = new HashSet<String>(16);
        HashMap<Long, Integer> orgIdScopeMap = new HashMap<Long, Integer>(8);
        for (Object object : parseArray) {
            orgIdScopeMap.put(((JSONObject)object).getLong("id"), ((JSONObject)object).getInteger("scope"));
        }
        DimensionScope ds = new DimensionScope(Long.toString(modelId), new SchemeContext(modelId).getDimensionByNumber("Entity"), orgIdScopeMap);
        Pair<Set<Long>, Set<String>> effectiveFilterResult = OperatorHelper.getEffectiveEntity(modelId, scenarioId, yearId, periodId, ds.getResolveScopeIds());
        Set resSet = (Set)effectiveFilterResult.p1;
        Pair<Set<Long>, Set<String>> permFilterResult = OperatorHelper.dealNoPermOrg(modelId, resSet);
        if (!((Set)permFilterResult.p2).isEmpty()) {
            msg.add(String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u5408\u5e76\u8282\u70b9\u65e0\u6743\uff0c\u5df2\u8df3\u8fc7\u6267\u884c\uff1a%s\u3002", (String)"OperatorHelper_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable)permFilterResult.p2)));
        }
        if (!(periodFilterResult = OperatorHelper.checkPeriodStatus(modelId, scenarioId, yearId, periodId, resSet)).isEmpty()) {
            msg.add(String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u5408\u5e76\u8282\u70b9\u5728\u671f\u95f4%1$s\u7684\u6570\u636e\u671f\u95f4\u672a\u5f00\u542f\uff0c\u5df2\u8df3\u8fc7\u6267\u884c\uff1a%2$s\u3002", (String)"OperatorHelper_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), periodNode.getNumber(), String.join((CharSequence)",", periodFilterResult)));
        }
        return Pair.onePair((Object)resSet, msg);
    }

    public static Pair<Set<Long>, Set<String>> getEntitySetWithMsg(long modelId, long scenarioId, long yearId, long periodId, String entityStr) {
        JSONArray parseArray = JSON.parseArray((String)entityStr);
        HashMap<Long, Integer> orgIdScopeMap = new HashMap<Long, Integer>(8);
        for (Object object : parseArray) {
            orgIdScopeMap.put(((JSONObject)object).getLong("id"), ((JSONObject)object).getInteger("scope"));
        }
        DimensionScope ds = new DimensionScope(Long.toString(modelId), new SchemeContext(modelId).getDimensionByNumber("Entity"), orgIdScopeMap);
        Pair<Set<Long>, String> effectiveFilterResult = OperatorHelper.getEffectiveEntityWithMsg(modelId, scenarioId, yearId, periodId, ds.getResolveScopeIds());
        Set resSet = (Set)effectiveFilterResult.p1;
        Pair<Set<Long>, String> permFilterResult = OperatorHelper.dealNoPermOrgWithMsg(modelId, resSet);
        String periodFilterResult = OperatorHelper.checkPeriodStatusWithMsg(modelId, scenarioId, yearId, periodId, resSet);
        HashSet<Object> warringMsg = new HashSet<Object>(3);
        warringMsg.add(effectiveFilterResult.p2);
        warringMsg.add(permFilterResult.p2);
        warringMsg.add(periodFilterResult);
        warringMsg.remove(null);
        return Pair.onePair((Object)resSet, warringMsg);
    }

    public static Pair<Set<Long>, Set<String>> dealNoPermOrg(long modelId, Set<Long> resSet) {
        if (!MemberPermHelper.getLimitedModelListByUser().contains(modelId)) {
            Set writePermissionIds = PermissionServiceImpl.getInstance((Long)modelId).matchWritePermMembers(MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity"), "bcm_entitymembertree", resSet);
            HashSet noWritePermSet = new HashSet(resSet.size());
            resSet.removeIf(org -> {
                if (!writePermissionIds.contains(org)) {
                    noWritePermSet.add(MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)org).getNumber());
                    return true;
                }
                return false;
            });
            if (!noWritePermSet.isEmpty()) {
                return Pair.onePair(resSet, noWritePermSet);
            }
        }
        return Pair.onePair(resSet, Collections.emptySet());
    }

    public static Pair<Set<Long>, String> dealNoPermOrgWithMsg(long modelId, Set<Long> resSet) {
        Pair<Set<Long>, Set<String>> permFilterResult = OperatorHelper.dealNoPermOrg(modelId, resSet);
        Set p2 = (Set)permFilterResult.p2;
        String format = p2.isEmpty() ? null : String.format(ResManager.loadKDString((String)"\u6267\u884c\u4eba\u65e0\u7ec4\u7ec7\u6210\u5458%1$s\u5199\u5165\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OperatorHelper_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), p2);
        return Pair.onePair((Object)permFilterResult.p1, format);
    }

    public static Pair<Set<Long>, Set<String>> getEffectiveEntity(long modelId, long scenarioId, long yearId, long periodId, Set<Long> resSet) {
        DynamicObject dyYear = OperatorHelper.getDynamicObject(yearId, "bcm_fymembertree");
        DynamicObject dyPeriod = OperatorHelper.getDynamicObject(periodId, "bcm_periodmembertree");
        DynamicObject dyScenario = OperatorHelper.getDynamicObject(scenarioId, "bcm_scenemembertree");
        Set<Long> saveRes = OperatorHelper.getResSave(modelId, dyYear, dyPeriod, dyScenario);
        HashSet res = new HashSet();
        HashSet noEffectiveSet = new HashSet();
        HashSet effectiveSet = new HashSet();
        resSet.forEach(e -> {
            if (saveRes.contains(e)) {
                res.add(e);
                effectiveSet.add(MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)e).getNumber());
            } else {
                noEffectiveSet.add(MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)e).getNumber());
            }
        });
        noEffectiveSet.removeAll(effectiveSet);
        return Pair.onePair(res, noEffectiveSet);
    }

    public static Pair<Set<Long>, String> getEffectiveEntityWithMsg(long modelId, long scenarioId, long yearId, long periodId, Set<Long> resSet) {
        Pair<Set<Long>, Set<String>> effectiveFilterResult = OperatorHelper.getEffectiveEntity(modelId, scenarioId, yearId, periodId, resSet);
        Set p2 = (Set)effectiveFilterResult.p2;
        String format = p2.isEmpty() ? null : String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6210\u5458%1$s\u5728\u5f53\u524d\u8d22\u5e74\u671f\u95f4\u5df2\u88ab\u5904\u7f6e", (String)"OperatorHelper_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), p2);
        return Pair.onePair((Object)effectiveFilterResult.p1, format);
    }

    public static Pair<Set<Long>, Set<String>> getEntityIds(long modelId, String entityJson, String entity) {
        List list = SerializationUtils.fromJsonStringToList((String)entityJson, Map.class);
        Set memberIds = QueryMemberDetailsHelper.queryMemberIdsByListData((long)modelId, (String)entity, (List)list);
        if (!MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(modelId))) {
            Set<String> noWritePermSet = OperatorHelper.retainReadWriteMembers(modelId, PresetConstant.ENTITY_DIM, entity, memberIds);
            return Pair.onePair((Object)memberIds, noWritePermSet);
        }
        return Pair.onePair((Object)memberIds, Collections.emptySet());
    }

    public static DynamicObject getDynamicObject(long entityId, String entityType) {
        return BusinessDataServiceHelper.loadSingle((Object)entityId, (String)entityType);
    }

    private static Set<String> retainReadWriteMembers(long modelId, String dimNum, String entity, Set<Long> memberIds) {
        if (CollectionUtils.isEmpty(memberIds)) {
            return Collections.emptySet();
        }
        Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
        Set readWritePermissionIds = PermissionServiceImpl.getInstance((Long)modelId).matchWritePermMembers(dimId, entity, memberIds);
        HashSet<String> noWritePermSet = new HashSet<String>(10);
        memberIds.removeIf(memberId -> {
            if (!readWritePermissionIds.contains(memberId)) {
                noWritePermSet.add(MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)memberId).getNumber());
                return true;
            }
            return false;
        });
        return noWritePermSet;
    }

    private static Set<Long> getResSave(long modelId, DynamicObject dyYear, DynamicObject dyPeriod, DynamicObject dyScenario) {
        HashSet<Long> res = new HashSet<Long>();
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection orgsSave = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)OperatorHelper.getSelector(), (QFilter[])new QFilter[]{modelQf}, (String)"level, dseq");
        FilterOrgStructParam param = new FilterOrgStructParam(modelId, dyScenario.getLong("id"), dyYear.getString("number"), dyPeriod.getLong("id"));
        ArrayList orgList = new ArrayList(orgsSave.size());
        orgList.addAll(orgsSave);
        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, orgList);
        orgList.forEach(e -> res.add(e.getLong("id")));
        return res;
    }

    private static String getSelector() {
        return "id,name,number,member,parent.id,dseq,level,longnumber,storageType,share,isleaf";
    }
}

