/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.formulacollect;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.model.excel.ApiResponseModel;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.report.util.DataCollectUtil;
import kd.fi.bcm.task.common.AbstractScheduleOperator;
import kd.fi.bcm.task.common.OperatorHelper;
import kd.fi.bcm.task.common.PlanParam;
import org.apache.commons.collections.CollectionUtils;

public class FormulaCollectOperator
extends AbstractScheduleOperator {
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final int SLEEP_TIME = 60000;

    @Override
    public Pair<Boolean, Set<String>> doOperation(PlanParam planParam) {
        String templateStr;
        HashSet<String> msgS = new HashSet<String>(16);
        long modelId = planParam.getModelId();
        long executor = planParam.getExecutor();
        Map configMap = (Map)SerializationUtils.fromJsonString((String)planParam.getParamSetting(), Map.class);
        OperatorHelper.checkPermission(modelId, "bcm_datacollection", "1GB4V51GHCE/", executor);
        long scenarioId = planParam.getScenarioId();
        String scenarioNumber = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId).getNumber();
        long yearId = LongUtil.toLong((Object)configMap.getOrDefault("year", 0L));
        long periodId = LongUtil.toLong((Object)configMap.getOrDefault("period", 0L));
        Pair<Long, Long> yearAndPeriod = OperatorHelper.calYearAndPeriod(planParam, scenarioNumber, yearId, periodId);
        yearId = (Long)yearAndPeriod.p1;
        periodId = (Long)yearAndPeriod.p2;
        Object multiEntityObj = configMap.get("entity");
        if (!(multiEntityObj instanceof List)) {
            msgS.add(ResManager.loadKDString((String)"\u516c\u5f0f\u53d6\u6570\u6267\u884c\u53c2\u6570\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"FormulaCollectOperator_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return Pair.onePair((Object)false, msgS);
        }
        List list = (List)multiEntityObj;
        Set memberIds = QueryMemberDetailsHelper.queryMemberIdsByListData((long)modelId, (String)"bcm_entitymembertree", (List)list);
        memberIds = OperatorHelper.toBaseId(modelId, "bcm_entitymembertree", FormulaCollectOperator.getEntitySet(modelId, scenarioId, yearId, periodId, memberIds));
        memberIds = this.getLeafId(modelId, memberIds);
        Pair<Set<Long>, Set<String>> effectiveFilterResult = OperatorHelper.getEffectiveEntity(modelId, scenarioId, yearId, periodId, memberIds);
        Set noEffectiveSet = (Set)effectiveFilterResult.p2;
        memberIds = (Set)effectiveFilterResult.p1;
        if (noEffectiveSet != null && !noEffectiveSet.isEmpty()) {
            msgS.add(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6210\u5458%s\u5728\u5f53\u524d\u8d22\u5e74\u671f\u95f4\u5df2\u88ab\u5904\u7f6e/\u7981\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u64cd\u4f5c\u3002", (String)"FormulaCollectionOperator_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), noEffectiveSet));
        }
        if (memberIds.isEmpty()) {
            msgS.add(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u6267\u884c\u516c\u5f0f\u53d6\u6570\u3002", (String)"FormulaCollectionOperator_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return Pair.onePair((Object)false, msgS);
        }
        String string = templateStr = configMap.get("template") == null ? "" : configMap.get("template").toString();
        if (StringUtils.isEmpty((CharSequence)templateStr)) {
            msgS.add(ResManager.loadKDString((String)"\u516c\u5f0f\u53d6\u6570\u6267\u884c\u53c2\u6570\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"FormulaCollectOperator_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return Pair.onePair((Object)false, msgS);
        }
        HashSet<Long> templateIdSet = new HashSet<Long>(16);
        Arrays.stream(templateStr.split(",")).forEach(tem -> templateIdSet.add(LongUtil.toLong((Object)tem)));
        if (!MemberPermHelper.ifUserHasRootPermByModel((long)executor, (String)String.valueOf(modelId))) {
            List readPermIds;
            ArrayListMultimap map = PermClassEntityHelper.getPermissionMap((String)"bcm_templateentity", (String)String.valueOf(modelId), (String)String.valueOf(executor));
            List noPermIds = map.get((Object)DataTypeEnum.NO.getIndex());
            if (CollectionUtils.isNotEmpty((Collection)noPermIds)) {
                noPermIds.forEach(templateIdSet::remove);
            }
            if (CollectionUtils.isNotEmpty((Collection)(readPermIds = map.get((Object)DataTypeEnum.READ.getIndex())))) {
                readPermIds.forEach(templateIdSet::remove);
            }
            if (templateIdSet.isEmpty()) {
                msgS.add(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u6240\u9009\u6a21\u677f\u662f\u5426\u6709\u5199\u5165\u6743\u9650\u3002", (String)"FormulaCollectionOperator_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return Pair.onePair((Object)false, msgS);
            }
        }
        Set<String> markSet = this.getMarkSet(modelId, memberIds, templateIdSet);
        Multimap<Long, Long> markMap = this.reverseMarkSet(markSet);
        HashMultimap realSelectRow = HashMultimap.create();
        boolean executeorder = configMap.get("executeorder") instanceof Boolean ? (Boolean)configMap.get("executeorder") : Boolean.parseBoolean(configMap.get("executeorder").toString());
        boolean reexecute = configMap.get("reexecute") instanceof Boolean ? (Boolean)configMap.get("reexecute") : Boolean.parseBoolean(configMap.get("reexecute").toString());
        ApiResponseModel apiResponseModel = DataCollectUtil.easyBatchExecuteDCNew(markMap = this.getLastVermarkMap(modelId, yearId, periodId, markMap), OperatorHelper.getDynamicObject(modelId, "bcm_model"), OperatorHelper.getDynamicObject(scenarioId, "bcm_scenemembertree"), OperatorHelper.getDynamicObject(yearId, "bcm_fymembertree"), OperatorHelper.getDynamicObject(periodId, "bcm_periodmembertree"), reexecute, executeorder, (Multimap<Long, Long>)realSelectRow, planParam.getLogId());
        if (!apiResponseModel.isSuccess()) {
            if (apiResponseModel.getBackData() instanceof KDBizException) {
                throw new KDBizException(((KDBizException)((Object)apiResponseModel.getBackData())).getMessage());
            }
            throw new KDBizException(apiResponseModel.getBackData().toString());
        }
        return Pair.onePair((Object)true, msgS);
    }

    @Override
    public Pair<Boolean, String> waitComplete(Long logId) {
        DynamicObjectCollection load;
        QFilter groupQf = new QFilter("group", "=", (Object)logId);
        QFilter statusQf = new QFilter("collectstatus", "!=", (Object)"3");
        while ((load = QueryServiceHelper.query((String)"bcm_datacollect", (String)"id", (QFilter[])new QFilter[]{groupQf, statusQf})) != null && load.size() != 0) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        return Pair.onePair((Object)true, (Object)"");
    }

    private Set<Long> getLeafId(long modelId, Set<Long> queryMemberIdsByRange) {
        HashSet<Long> res = new HashSet<Long>();
        for (Long id : queryMemberIdsByRange) {
            IDNumberTreeNode entity = MemberReader.findEntityMemberById((Long)modelId, (Long)id);
            if (!entity.isLeaf()) continue;
            res.add(id);
        }
        return res;
    }

    private Set<String> getMarkSet(long modelId, Set<Long> entityIdSet, Set<Long> templateIdSet) {
        Map distributeMap = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense((Long)modelId, new HashSet<Long>(templateIdSet), entityIdSet);
        QFBuilder qfBuilder = new QFBuilder("id", "in", templateIdSet);
        qfBuilder.add("status", "=", (Object)"0");
        Set noIncludes = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])qfBuilder.toArray()).stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
        HashSet<String> markSet = new HashSet<String>();
        for (Long entityId : entityIdSet) {
            for (Long templateId : templateIdSet) {
                if (!distributeMap.getOrDefault(templateId, Collections.EMPTY_SET).contains(entityId) || noIncludes.contains(templateId)) continue;
                markSet.add(entityId + "#" + templateId);
            }
        }
        return markSet;
    }

    private Multimap<Long, Long> reverseMarkSet(Set<String> markSet) {
        HashMultimap markMap = HashMultimap.create();
        String[] split = null;
        for (String mark : markSet) {
            split = mark.split("#");
            markMap.put((Object)Long.valueOf(split[0]), (Object)Long.valueOf(split[1]));
        }
        return markMap;
    }

    private Multimap<Long, Long> getLastVermarkMap(long modelId, long yearId, long periodId, Multimap<Long, Long> markMap) {
        HashMultimap newMarkMap = HashMultimap.create();
        HashSet idSet = new HashSet(markMap.values());
        Map newVerMap = TemplateUtil.getRightTplIdByVersioned((Long)modelId, (Long)yearId, (Long)periodId, idSet);
        for (Map.Entry map : markMap.entries()) {
            Long newId = (Long)newVerMap.get(map.getValue());
            if (newId == null) continue;
            newMarkMap.put(map.getKey(), newVerMap.get(map.getValue()));
        }
        return newMarkMap;
    }

    public static Set<Long> getEntitySet(long modelId, long scenarioId, long yearId, long periodId, Set<Long> entities) {
        Pair<Set<Long>, Set<String>> effectiveFilterResult = OperatorHelper.getEffectiveEntity(modelId, scenarioId, yearId, periodId, entities);
        HashSet<Long> resSet = (HashSet<Long>)effectiveFilterResult.p1;
        resSet = new HashSet<Long>((Collection)OperatorHelper.dealNoPermOrg((long)modelId, (Set<Long>)resSet).p1);
        OperatorHelper.checkPeriodStatus(modelId, scenarioId, yearId, periodId, resSet);
        return resSet;
    }
}

