/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.formulacollect;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.task.common.IScheduleSubPage;

public class FormulaCollectPlugin
extends AbstractBaseFormPlugin
implements IScheduleSubPage {
    private static final List<String> dimKeys = Arrays.asList("scenario", "year", "period");
    private static final String MUL_SPLIT = ",";

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("entity");
        BasedataEdit multiTemplate = (BasedataEdit)this.getControl("template");
        multiTemplate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("template".equals(name)) {
            ListShowParameter l = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter lsp = l.getListFilterParameter();
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            qFilter.and("templatetype", "!=", (Object)(TemplateTypeEnum.MSN.getType() + ""));
            lsp.getQFilters().add(qFilter);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("executeorder".equals(propName)) {
            this.setValue("reexecute", false);
            if (((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"reexecute"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"reexecute"});
            }
        } else if ("year".equals(propName) && e.getChangeSet()[0].getNewValue() == null) {
            this.getModel().setValue("period", null);
        } else if ("entity".equals(propName) && (e.getChangeSet()[0].getNewValue() == null || StringUtils.isEmpty((CharSequence)e.getChangeSet()[0].getNewValue().toString()))) {
            this.getPageCache().remove(DimTypesEnum.ENTITY.getNumber());
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map sceneParam = (Map)this.getView().getFormShowParameter().getCustomParam("initdata");
        Long scenarioId = sceneParam.get("scenario") == null ? null : (Long)((Map)sceneParam.get("scenario")).get("id");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW == status) {
            this.setValue("executeorder", false);
            this.setValue("reexecute", false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"reexecute"});
            if (scenarioId != null && scenarioId != 0L) {
                this.getModel().setValue("scenario", (Object)scenarioId);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"scenario"});
            }
        } else {
            String templateStr;
            List multiDim;
            String configStr = this.getConfigFromFormShowParameter();
            Map configMap = new HashMap(16);
            if (!StringUtils.isBlank((CharSequence)configStr)) {
                configMap = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
            }
            this.getModel().setValue("scenario", configMap.get("scenario"));
            if (scenarioId != null && scenarioId != 0L) {
                this.getModel().setValue("scenario", (Object)scenarioId);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"scenario"});
            }
            this.getModel().setValue("year", configMap.get("year"));
            this.getModel().setValue("period", configMap.get("period"));
            this.getModel().setValue("executeorder", configMap.get("executeorder"));
            this.getModel().setValue("reexecute", configMap.get("reexecute"));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"scenario"});
            if (!((Boolean)this.getModel().getValue("executeorder")).booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"reexecute"});
            }
            if (configMap.get("entity") instanceof List && !CollectionUtil.isEmpty((Collection)(multiDim = (List)configMap.get("entity")))) {
                StringBuilder showName = new StringBuilder();
                for (Map item : multiDim) {
                    this.buildMultiF7ShowName(showName, (String)item.get("name"), (String)item.get("number"), Integer.parseInt((String)item.get("scope")));
                }
                this.getModel().setValue("entity", (Object)showName.substring(0, showName.length() - 1));
                this.getPageCache().put(DimTypesEnum.ENTITY.getNumber(), SerializationUtils.toJsonString((Object)multiDim));
            }
            String string = templateStr = configMap.get("template") == null ? "" : configMap.get("template").toString();
            if (StringUtils.isNotEmpty((CharSequence)templateStr)) {
                List schemeList = Arrays.stream(templateStr.split(MUL_SPLIT)).map(Long::parseLong).collect(Collectors.toList());
                Set exists = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter("id", "in", schemeList).toArray()).stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
                schemeList.removeIf(id -> !exists.contains(id));
                if (!schemeList.isEmpty()) {
                    this.getModel().setValue("template", (Object)schemeList.toArray());
                }
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("entity".equals(key)) {
            this.showMultiMemberF7("Entity");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (closedCallBackEvent.getReturnData() != null && "Entity".equals(key)) {
            DynamicObjectCollection doc = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
            MultiF7Results mps = MultiF7Results.buildParam((DynamicObjectCollection)doc);
            if (doc.isEmpty()) {
                this.getModel().setValue(key, null);
                this.getPageCache().remove(key);
            } else {
                this.getModel().setValue(key, (Object)mps.getShowText());
                this.getPageCache().put(key, SerializationUtils.toJsonString((Object)mps.toList()));
            }
        }
    }

    @Override
    public String sendConfig() {
        IDataModel model = this.getModel();
        DynamicObject sceneDyn = (DynamicObject)model.getValue("scenario");
        if (sceneDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3002", (String)"DispatchParamSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String multiEntityStr = this.getPageCache().get(SysDimensionEnum.Entity.getNumber());
        if (StringUtils.isEmpty((CharSequence)multiEntityStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"DispatchParamSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!(this.getModel().getValue("template") instanceof DynamicObjectCollection) || ((DynamicObjectCollection)this.getModel().getValue("template")).isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868\u6a21\u677f\u3002", (String)"DispatchParamSettingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("scenario", sceneDyn.getLong("id"));
        DynamicObject yearObj = (DynamicObject)model.getValue("year");
        result.put("year", yearObj == null ? 0L : yearObj.getLong("id"));
        DynamicObject periodObj = (DynamicObject)model.getValue("period");
        result.put("period", periodObj == null ? 0L : periodObj.getLong("id"));
        result.put("entity", SerializationUtils.fromJsonString((String)multiEntityStr, List.class));
        result.put("executeorder", this.getModel().getValue("executeorder"));
        result.put("reexecute", this.getModel().getValue("reexecute"));
        DynamicObjectCollection templates = (DynamicObjectCollection)this.getModel().getValue("template");
        List templateIds = templates.stream().map(s -> s.getString("fbasedataid_id")).collect(Collectors.toList());
        String templateStr = String.join((CharSequence)MUL_SPLIT, templateIds);
        result.put("template", templateStr);
        return SerializationUtils.toJsonString(result);
    }

    @Override
    public Long sendScene() {
        DynamicObject sceneDyn = (DynamicObject)this.getModel().getValue("scenario");
        return sceneDyn == null ? 0L : sceneDyn.getLong("id");
    }

    private void showMultiMemberF7(String number) {
        long modelId = this.getModelId();
        DynamicObject dim = MemberReader.getDimensionDynById((long)MemberReader.getDimensionIdByNum((long)modelId, (String)number));
        if (dim != null) {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("bcm_mulmemberf7base_tem");
            para.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("dimension", dim.getInt("dseq") + "");
            params.put("KEY_MODEL_ID", String.valueOf(modelId));
            params.put("sign", number);
            para.setCustomParams(params);
            para.setCaption(dim.getString("name"));
            IFormView view = this.getView();
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, number);
            para.setCloseCallBack(closeCallBack);
            view.showForm(para);
        }
    }

    @Override
    public long getModelId() {
        return (Long)this.getFormCustomParam("model");
    }

    @Override
    public String getModelNumber() {
        return MemberReader.findModelNumberById((Object)this.getModelId());
    }
}

