/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integrationnew.servicehelper.IntegrateServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.task.common.AbstractScheduleOperator;
import kd.fi.bcm.task.common.OperatorHelper;
import kd.fi.bcm.task.common.PlanParam;

public class DataIntegrationOperator
extends AbstractScheduleOperator {
    protected static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final int SLEEP_TIME = 60000;
    private final Set<String> warningMsg = new HashSet<String>(16);
    private Long modelId;
    private Long scenarioId;
    private Long logId;

    public Set<String> getWarningMsg() {
        return this.warningMsg;
    }

    @Override
    public Pair<Boolean, Set<String>> doOperation(PlanParam planParam) {
        if (StringUtils.isNotEmpty((String)planParam.getParamSetting())) {
            ArrayList<Long> entityIds;
            Map dimMap = (Map)SerializationUtils.fromJsonString((String)planParam.getParamSetting(), Map.class);
            this.modelId = planParam.getModelId();
            this.logId = planParam.getLogId();
            long yearId = LongUtil.toLong(dimMap.get("year"));
            long periodId = LongUtil.toLong(dimMap.get("period"));
            this.scenarioId = LongUtil.toLong(dimMap.get("scenario"));
            String scenarioNumber = MemberReader.findScenaMemberById((Long)this.modelId, (Long)this.scenarioId).getNumber();
            String scheme = (String)dimMap.get("isscheme");
            List<Long> schemeList = Arrays.stream(scheme.split(",")).map(Long::parseLong).collect(Collectors.toList());
            OperatorHelper.checkPermission(this.modelId, "bcm_isschemecollectlist2", "1T8/1A25NK8=", planParam.getExecutor());
            Pair<Long, Long> yearAndPeriod = OperatorHelper.calYearAndPeriod(planParam, scenarioNumber, yearId, periodId);
            String entityJson = (String)dimMap.get("entity");
            Pair<Set<Long>, Set<String>> entityPair = OperatorHelper.getEntitySetWithMsg(this.modelId, this.scenarioId, (Long)yearAndPeriod.p1, (Long)yearAndPeriod.p2, entityJson);
            Set entitySet = (Set)entityPair.p2;
            if (!CollectionUtil.isEmpty((Collection)entitySet)) {
                this.getWarningMsg().addAll(entitySet);
            }
            if (CollectionUtils.isEmpty(entityIds = new ArrayList<Long>(OperatorHelper.toBaseId(this.modelId, "bcm_entitymembertree", (Set)entityPair.p1)))) {
                return Pair.onePair((Object)false, this.getWarningMsg());
            }
            List noPermList = DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)this.modelId, (Long)planParam.getExecutor());
            HashSet<Long> inNoPermIds = new HashSet<Long>(schemeList.size());
            for (Long schemeId : schemeList) {
                if (!noPermList.contains(schemeId)) continue;
                inNoPermIds.add(schemeId);
            }
            if (!inNoPermIds.isEmpty()) {
                schemeList.removeAll(inNoPermIds);
                QFilter filter = new QFilter("id", "in", inNoPermIds);
                DynamicObjectCollection names = QueryServiceHelper.query((String)"bcm_isscheme", (String)"number", (QFilter[])filter.toArray());
                List listNames = names.stream().map(f -> f.getString("number")).collect(Collectors.toList());
                String result = String.join((CharSequence)" ", listNames);
                String error = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u7528\u6237\u65e0\u7f16\u7801\u4e3a%s\u7684\u96c6\u6210\u65b9\u6848\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u3002", (String)"DataIntegrationOperator_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), result);
                this.getWarningMsg().add(error);
            }
            this.removeUnableSchemeIds(schemeList);
            if (schemeList.isEmpty()) {
                this.getWarningMsg().add(ResManager.loadKDString((String)"\u65e0\u53ef\u6267\u884c\u65b9\u6848\u3002", (String)"DataIntegrationOperator_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return Pair.onePair((Object)false, this.getWarningMsg());
            }
            HashSet<String> tarCollectStatus = new HashSet<String>(16);
            String collectStatusStr = (String)dimMap.get("collectstatus");
            if (!StringUtil.isEmptyString((String)collectStatusStr)) {
                tarCollectStatus.addAll(Arrays.asList(collectStatusStr.split(",")));
            }
            IntegrateServiceHelper.doCollect((boolean)false, (Long)this.logId, (Long)this.modelId, entityIds, (Long)this.scenarioId, (Long)((Long)yearAndPeriod.p1), (Long)((Long)yearAndPeriod.p2), schemeList, tarCollectStatus);
        }
        return Pair.onePair((Object)true, this.getWarningMsg());
    }

    private void removeUnableSchemeIds(List<Long> schemeIds) {
        if (schemeIds.isEmpty()) {
            return;
        }
        int size = schemeIds.size();
        QFilter filter = new QFilter("id", "in", schemeIds);
        QFilter enableFilter = new QFilter("status", "=", (Object)"1");
        DynamicObject[] schemeObj = BusinessDataServiceHelper.load((String)"bcm_isscheme", (String)"id", (QFilter[])new QFilter[]{filter, enableFilter});
        schemeIds.clear();
        if (schemeObj.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : schemeObj) {
            schemeIds.add(dynamicObject.getLong("id"));
        }
        if (size != schemeIds.size()) {
            this.getWarningMsg().add(ResManager.loadKDString((String)"\u5b58\u5728\u7981\u7528\u6216\u5220\u9664\u7684\u65b9\u6848\u3002", (String)"DataIntegrationOperator_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    @Override
    public Pair<Boolean, String> waitComplete(Long logId) {
        QFilter groupQf = new QFilter("schedulelog", "=", (Object)logId);
        DynamicObject[] execLogs;
        while ((execLogs = BusinessDataServiceHelper.load((String)"bcm_schedule_statuslog", (String)"id,integrateexeclog,status", (QFilter[])new QFilter[]{groupQf})) != null && execLogs.length != 0) {
            int success = 0;
            int fail = 0;
            for (DynamicObject log : execLogs) {
                String status = log.getString("status");
                if (String.valueOf(CollectStatusEnum.LINEUP.getValue()).equals(status)) break;
                if (String.valueOf(CollectStatusEnum.SUCCESS.getValue()).equals(status)) {
                    ++success;
                    continue;
                }
                if (!String.valueOf(CollectStatusEnum.FAIL.getValue()).equals(status)) continue;
                ++fail;
            }
            if (success + fail == execLogs.length) {
                if (success != 0) {
                    return Pair.onePair((Object)Boolean.TRUE, (Object)"");
                }
                return Pair.onePair((Object)Boolean.FALSE, (Object)"");
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", ThrowableHelper.toString((Exception)e)), new Object[0]);
            }
        }
        return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u96c6\u6210\u91c7\u96c6\u72b6\u6001\u3002", (String)"IntelligentSchedulePlan_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
    }
}

