/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.invest;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.relation.InvRelationLogContext;
import kd.fi.bcm.business.invest.relation.InvRelationLogService;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ScenarioMemberEnum;
import kd.fi.bcm.common.enums.invest.InvCopyModuleEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.task.common.AbstractScheduleOperator;
import kd.fi.bcm.task.common.OperatorHelper;
import kd.fi.bcm.task.common.PlanParam;

public class CopyInvestOperator
extends AbstractScheduleOperator {
    private static final Log logger = LogFactory.getLog(CopyInvestOperator.class);
    protected static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private final Set<String> warningMsg = new HashSet<String>(16);

    public Set<String> getWarningMsg() {
        return this.warningMsg;
    }

    @Override
    public Pair<Boolean, Set<String>> doOperation(PlanParam planParam) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)planParam.getParamSetting())) {
            Map dimMap = (Map)SerializationUtils.fromJsonString((String)planParam.getParamSetting(), Map.class);
            Long modelId = planParam.getModelId();
            Long yearId = LongUtil.toLong(dimMap.get("year"));
            Long periodId = LongUtil.toLong(dimMap.get("period"));
            Long scenarioId = LongUtil.toLong(dimMap.get("scenario"));
            String scenarioNumber = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId).getNumber();
            OperatorHelper.checkPermission(modelId, "bcm_invrelation_search", "4730fc9f000020ae", planParam.getExecutor());
            Pair<Long, Long> yearAndPeriod = OperatorHelper.calYearAndPeriod(planParam, scenarioNumber, yearId, periodId);
            yearId = (Long)yearAndPeriod.p1;
            periodId = (Long)yearAndPeriod.p2;
            Long orgId = LongUtil.toLong(dimMap.get("mergeentity"));
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)orgId);
            if (IDNumberTreeNode.NotFoundTreeNode == orgNode) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"CopyInvestOperator_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            Set orgSet = Sets.newHashSet((Object[])new Long[]{orgId});
            OperatorHelper.dealNoPermOrg(modelId, orgSet);
            Pair<Set<Long>, String> effectiveEntity = OperatorHelper.getEffectiveEntityWithMsg(modelId, scenarioId, yearId, periodId, orgSet);
            orgSet = (Set)effectiveEntity.p1;
            if (effectiveEntity.p2 != null) {
                this.getWarningMsg().add((String)effectiveEntity.p2);
            }
            if (orgSet.isEmpty()) {
                this.getWarningMsg().add(ResManager.loadKDString((String)"\u65e0\u53ef\u6267\u884c\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u6267\u884c\u4eba\u7684\u6743\u9650\u6216\u7ec4\u7ec7\u7684\u6709\u6548\u6027\u3002", (String)"IntelligentSchedulePlan_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return Pair.onePair((Object)false, this.getWarningMsg());
            }
            kd.bos.dataentity.Tuple newPeriod = PeriodUtils.getPeriodByOffset((long)modelId, (ScenarioMemberEnum)planParam.getScenarioMemberEnum(), (long)yearId, (long)periodId, (int)Integer.parseInt((String)dimMap.get("yearoffset")), (int)Integer.parseInt((String)dimMap.get("periodoffset")));
            if ((Long)newPeriod.item1 == 0L || (Long)newPeriod.item2 == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u5e74\u6216\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"Operator_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("yearId", newPeriod.item1);
            returnData.put("periodId", newPeriod.item2);
            Long srcSceneId = LongUtil.toLong(dimMap.get("srcscenario"));
            if (srcSceneId == 0L) {
                srcSceneId = planParam.getScenarioId();
            }
            returnData.put("sceneId", srcSceneId);
            returnData.put("copyway", dimMap.get("effectiverange"));
            List<String> mergeset = Arrays.asList(((String)dimMap.get("mergeset")).split(","));
            returnData.put("mergenode", mergeset.contains(InvCopyModuleEnum.MERGE_NODE.getMappingStr()));
            returnData.put("mergestruct", mergeset.contains(InvCopyModuleEnum.MERGE_STRUCT.getMappingStr()));
            returnData.put("investref", mergeset.contains(InvCopyModuleEnum.INVEST_REF.getMappingStr()));
            returnData.put("dynamictype", mergeset.contains(InvCopyModuleEnum.DYNAMICTYPE_REF.getMappingStr()));
            returnData.put("copyallstruct", mergeset.contains(InvCopyModuleEnum.COPY_ALL_STRUCT.getMappingStr()));
            DynamicObject orgDy = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bcm_entitymembertree");
            InvRelationLogContext logContext = new InvRelationLogContext(modelId.longValue(), scenarioId.longValue(), yearId.longValue(), periodId.longValue(), orgNode.getBaseTreeNode().getId().longValue());
            InvRelationLogService invRelationLogService = InvRelationLogService.logWithoutStaticChange((InvRelationLogContext)logContext);
            invRelationLogService.logCopy(returnData);
            invRelationLogService.saveLogs(InvRelationLogService.OperationEnum.DISPATCH_COPY);
            logger.info("call periodCopy params is:" + JSONObject.toJSONString(returnData) + ":" + orgDy.getLong("id") + ":" + modelId + ":" + scenarioId + ":" + yearId + ":" + periodId);
            Tuple tuple = InvestServiceHelper.periodCopy(returnData, (DynamicObject)orgDy, (Long)modelId, (Long)scenarioId, (Long)yearId, (Long)periodId);
            logger.info("call periodCopy res is:" + JSONObject.toJSONString((Object)tuple));
            String exMsg = (String)tuple.p1;
            String header = (String)tuple.p2;
            String detail = (String)tuple.p3;
            if (StringUtils.isBlank((CharSequence)header) && StringUtils.isBlank((CharSequence)exMsg)) {
                this.getWarningMsg().add(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"CopyInvestOperator_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            } else {
                if (StringUtils.isBlank((CharSequence)header) && !StringUtils.isBlank((CharSequence)exMsg)) {
                    this.getWarningMsg().add(exMsg);
                    return Pair.onePair((Object)false, this.getWarningMsg());
                }
                if (!StringUtils.isBlank((CharSequence)exMsg)) {
                    StringJoiner sj = new StringJoiner("\n");
                    sj.add(detail).add(exMsg);
                    detail = sj.toString();
                }
                this.getWarningMsg().add(detail);
                return Pair.onePair((Object)false, this.getWarningMsg());
            }
        }
        return Pair.onePair((Object)true, this.getWarningMsg());
    }
}

