/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.invest;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.invest.invratio.InvRelationSearchService;
import kd.fi.bcm.business.invest.invstructuretable.InvDynamicStockService;
import kd.fi.bcm.business.invest.relation.InvRelationLogContext;
import kd.fi.bcm.business.invest.relation.InvRelationLogService;
import kd.fi.bcm.business.invest.shareholder.InvCalculateShareRelaService;
import kd.fi.bcm.business.invest.shareholder.model.InvRelationSearchConfig;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.task.common.AbstractScheduleOperator;
import kd.fi.bcm.task.common.OperatorHelper;
import kd.fi.bcm.task.common.PlanParam;

public class ShareHoldingCalcOperator
extends AbstractScheduleOperator {
    protected static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private final Set<String> warningMsg = new HashSet<String>(16);

    public Set<String> getWarningMsg() {
        return this.warningMsg;
    }

    @Override
    public Pair<Boolean, Set<String>> doOperation(PlanParam planParam) {
        if (StringUtils.isNotEmpty((String)planParam.getParamSetting())) {
            Set<Object> orgSet;
            Map dimMap = (Map)SerializationUtils.fromJsonString((String)planParam.getParamSetting(), Map.class);
            Long modelId = planParam.getModelId();
            Long yearId = LongUtil.toLong(dimMap.get("year"));
            Long periodId = LongUtil.toLong(dimMap.get("period"));
            Long scenarioId = LongUtil.toLong(dimMap.get("scenario"));
            String scenarioNumber = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId).getNumber();
            OperatorHelper.checkPermission(planParam.getModelId(), "bcm_invrelation_search", "4715a0df000000ac", planParam.getExecutor());
            boolean isCalcDynamicStock = Boolean.parseBoolean((String)dimMap.get("dynamicstock"));
            boolean isCalcStaticStock = Boolean.parseBoolean((String)dimMap.get("staticstock"));
            int calcType = Integer.parseInt((String)dimMap.get("caltype"));
            int calcRange = Integer.parseInt((String)dimMap.get("calrange"));
            if (!isCalcDynamicStock && !isCalcStaticStock) {
                this.getWarningMsg().add(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u91cd\u9009\u7684\u80a1\u6bd4\u7c7b\u578b\u3002", (String)"ShareHoldingCalcOprator_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return Pair.onePair((Object)true, this.getWarningMsg());
            }
            Pair<Long, Long> yearAndPeriod = OperatorHelper.calYearAndPeriod(planParam, scenarioNumber, yearId, periodId);
            yearId = (Long)yearAndPeriod.p1;
            periodId = (Long)yearAndPeriod.p2;
            Long orgId = LongUtil.toLong(dimMap.get("mergeentity"));
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)orgId);
            if (IDNumberTreeNode.NotFoundTreeNode == orgNode) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6210\u5458\u4e0d\u5b58\u5728", (String)"IntelligentSchedulePlan_6", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            if (calcRange == InvDynamicStockService.CalcRangeEnum.includeSub.getCode()) {
                QFBuilder orgQf = new QFBuilder("model", "=", (Object)modelId);
                orgQf.add("isleaf", "=", (Object)"0");
                orgQf.add("longnumber", "like", (Object)(orgNode.getLongNumber() + "!%"));
                orgSet = QueryServiceHelper.queryPrimaryKeys((String)"bcm_entitymembertree", (QFilter[])orgQf.toArray(), null, (int)-1).stream().map(LongUtil::toLong).collect(Collectors.toSet());
                orgSet.add(orgId);
            } else {
                orgSet = Sets.newHashSet((Object[])new Long[]{orgId});
            }
            OperatorHelper.dealNoPermOrg(modelId, (Set<Long>)orgSet);
            InvRelationSearchService.dealPeriodOpen((long)modelId, (Set)orgSet, (Long)scenarioId, (Long)yearId, (Long)periodId);
            Pair<Set<Long>, String> effectiveEntity = OperatorHelper.getEffectiveEntityWithMsg(modelId, scenarioId, yearId, periodId, (Set<Long>)orgSet);
            orgSet = (Set)effectiveEntity.p1;
            if (effectiveEntity.p2 != null) {
                this.getWarningMsg().add((String)effectiveEntity.p2);
            }
            if (orgSet.isEmpty()) {
                this.getWarningMsg().add(ResManager.loadKDString((String)"\u65e0\u53ef\u6267\u884c\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u6267\u884c\u4eba\u7684\u6743\u9650\u6216\u7ec4\u7ec7\u7684\u6709\u6548\u6027\u3002", (String)"IntelligentSchedulePlan_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return Pair.onePair((Object)false, this.getWarningMsg());
            }
            InvRelationSearchConfig config = new InvRelationSearchConfig(modelId.longValue(), scenarioId.longValue(), yearId.longValue(), periodId.longValue(), orgId.longValue());
            InvCalculateShareRelaService reCalService = new InvCalculateShareRelaService(config, isCalcStaticStock, isCalcDynamicStock, calcType, calcRange, orgSet);
            List checkRs = reCalService.doCheck();
            if (!checkRs.isEmpty()) {
                throw new KDBizException(String.join((CharSequence)"\n", checkRs));
            }
            List calculateRs = reCalService.doCalculate();
            InvRelationLogContext logContext = new InvRelationLogContext(modelId.longValue(), scenarioId.longValue(), yearId.longValue(), periodId.longValue(), MemberReader.findEntityMemberById((Long)modelId, (Long)orgId).getBaseTreeNode().getId().longValue());
            InvRelationLogService invRelationLogService = InvRelationLogService.logWithoutStaticChange((InvRelationLogContext)logContext);
            invRelationLogService.logReCalculate(isCalcStaticStock, isCalcDynamicStock, calcType, calcRange, reCalService.isSupportRuleExc());
            invRelationLogService.saveLogs(InvRelationLogService.OperationEnum.DISPATCH_CALCULATE);
            this.getWarningMsg().add(String.join((CharSequence)" ", calculateRs));
        }
        return Pair.onePair((Object)true, this.getWarningMsg());
    }
}

