/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.mergecontrol;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.allinone.service.MergeProgressHelper;
import kd.fi.bcm.business.mergecontrol.MergeCondition;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ProgressStatusEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.task.DispatchParamKeyConstant;
import kd.fi.bcm.task.common.AbstractScheduleOperator;
import kd.fi.bcm.task.common.OperatorHelper;
import kd.fi.bcm.task.common.PlanParam;

public class MergeControlOperator
extends AbstractScheduleOperator {
    private static final int SLEEP_TIME = 60000;
    private Long progressId;

    @Override
    public Pair<Boolean, Set<String>> doOperation(PlanParam planParam) {
        String periodTip;
        HashSet<Object> msgs = new HashSet<Object>(16);
        if (planParam == null || StringUtils.isBlank((CharSequence)planParam.getParamSetting())) {
            msgs.add(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u6267\u884c\u53c2\u6570\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"MergeControlOperator_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)false, msgs);
        }
        Map configMap = (Map)SerializationUtils.fromJsonString((String)planParam.getParamSetting(), Map.class);
        Long modelId = planParam.getModelId();
        Long scenarioId = planParam.getScenarioId();
        String scenarioNumber = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId).getNumber();
        Long yearId = LongUtil.toLong((Object)configMap.getOrDefault("year", 0L));
        Long periodId = LongUtil.toLong((Object)configMap.getOrDefault("period", 0L));
        OperatorHelper.checkPermission(modelId, "bcm_mergecontrol", "13X5UC=DY6XF", planParam.getExecutor());
        Pair<Long, Long> yearAndPeriod = OperatorHelper.calYearAndPeriod(planParam, scenarioNumber, yearId, periodId);
        yearId = (Long)yearAndPeriod.p1;
        periodId = (Long)yearAndPeriod.p2;
        Long orgId = LongUtil.toLong((Object)configMap.getOrDefault("mergeentity", 0L));
        if (orgId == null || orgId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"IntelligentMergeOperator_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Set orgSet = Sets.newHashSet((Object[])new Long[]{orgId});
        Pair<Set<Long>, Set<String>> orgSetPair = OperatorHelper.dealNoPermOrg(modelId, orgSet);
        if (!CollectionUtils.isEmpty((Collection)((Collection)orgSetPair.p2))) {
            msgs.add(String.format(ResManager.loadKDString((String)"\u6267\u884c\u4eba\u65e0\u7ec4\u7ec7\u6210\u5458%s\u5199\u5165\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"Operator_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgSetPair.p2));
        }
        if (orgSet.isEmpty()) {
            return Pair.onePair((Object)false, msgs);
        }
        Pair<Set<Long>, String> effectiveEntityWithMsg = OperatorHelper.getEffectiveEntityWithMsg(modelId, scenarioId, yearId, periodId, orgSet);
        orgSet = (Set)effectiveEntityWithMsg.p1;
        if (effectiveEntityWithMsg.p2 != null) {
            msgs.add(effectiveEntityWithMsg.p2);
        }
        if ((periodTip = OperatorHelper.checkPeriodStatusWithMsg(modelId, scenarioId, yearId, periodId, orgSet)) != null) {
            msgs.add(periodTip);
        }
        if (orgSet.isEmpty()) {
            return Pair.onePair((Object)false, msgs);
        }
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        if (IDNumberTreeNode.NotFoundTreeNode != orgNode) {
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            FixedItem fixedItem = FixedItem.newOne((SimpleItem)SimpleItem.newOne((Object)modelId, (String)modelNumber), (SimpleItem)SimpleItem.newOne((Object)scenarioId, (String)MemberReader.findScenaMemberById((String)modelNumber, (Long)scenarioId).getNumber()), (SimpleItem)SimpleItem.newOne((Object)yearId, (String)MemberReader.findFyMemberById((String)modelNumber, (Long)yearId).getNumber()), (SimpleItem)SimpleItem.newOne((Object)periodId, (String)MemberReader.findPeriodMemberById((String)modelNumber, (Long)periodId).getNumber()), (SimpleItem)SimpleItem.newOne((Object)orgNode.getId(), (String)orgNode.getNumber()));
            fixedItem.setOrg(SimpleItem.newOne((Object)orgNode.getId(), (String)orgNode.getNumber()));
            MergeCondition condition = this.getMergeCondition(configMap);
            ResultBox result = MergeControlHelper.execMerge((FixedItem)fixedItem, (MergeCondition)condition);
            String errorMsg = result.getMessageText();
            if (result.isNotSuccess()) {
                if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                    msgs.add(errorMsg);
                }
                return Pair.onePair((Object)false, msgs);
            }
            if (Objects.nonNull(result.getData())) {
                this.progressId = (Long)result.getData();
            }
        } else {
            msgs.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"IntelligentSchedulePlan_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)false, msgs);
        }
        return Pair.onePair((Object)true, msgs);
    }

    private MergeCondition getMergeCondition(Map<String, Object> configMap) {
        MergeCondition condition = new MergeCondition();
        condition.setMergeScope(1);
        condition.setMergeCondition(this.getInt(configMap.get("mergeradiogroup"), 1));
        condition.setPcRuleCondition(this.getInt(configMap.get("pcradiogroup"), 1));
        condition.setEcRuleCondition(this.getInt(configMap.get("ecradiogroup"), 1));
        condition.setInterCheckCondition(this.getInt(configMap.get("chkradiogroup"), 1));
        condition.setInvElimCondition(this.getInt(configMap.get("rightoffsetgroup"), 1));
        condition.setCommonPaperElimCondition(this.getInt(configMap.get(DispatchParamKeyConstant.commonpapergroup), 1));
        condition.setIntrElimCondition(this.getInt(configMap.get(DispatchParamKeyConstant.intrgroup), 1));
        return condition;
    }

    private int getInt(Object value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value.toString());
    }

    @Override
    public Pair<Boolean, String> waitComplete(Long logId) {
        DynamicObject mergeProgress;
        int i = 0;
        while ((mergeProgress = MergeProgressHelper.getMergeProgress((long)this.progressId)) != null) {
            String progressStatus = mergeProgress.getString("fstatus");
            if (Objects.equals(progressStatus, ProgressStatusEnum.SUCCESS.getCode())) {
                Date endTime = mergeProgress.getDate("endtime");
                return Pair.onePair((Object)Boolean.TRUE, (Object)String.valueOf(endTime.getTime()));
            }
            if (Objects.equals(progressStatus, ProgressStatusEnum.FAIL.getCode()) || Objects.equals(progressStatus, ProgressStatusEnum.TERMING.getCode()) || Objects.equals(progressStatus, ProgressStatusEnum.TERMINATION.getCode())) {
                return Pair.onePair((Object)Boolean.FALSE, (Object)progressStatus);
            }
            if (++i > 30) {
                progressStatus = "time over!";
                return Pair.onePair((Object)Boolean.FALSE, (Object)progressStatus);
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", ThrowableHelper.toString((Exception)e)), new Object[0]);
            }
        }
        return Pair.onePair((Object)Boolean.FALSE, (Object)"progressStatus is null");
    }
}

