/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.mergecontrol;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.task.DispatchParamKeyConstant;
import kd.fi.bcm.task.common.IScheduleSubPage;

public class MergeControlParamPlugin
extends AbstractBaseFormPlugin
implements IScheduleSubPage {
    private static final List<String> dimKeys = Arrays.asList("scenario", "year", "period");

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.asMapF7toType(Collections.singletonList("mergeentity"), SingleF7TypeEnum.NOLEAF, map);
        HashMap<String, String> key2dim = new HashMap<String, String>(1);
        key2dim.put("mergeentity", "entity");
        this.getPageCache().put("f7Key2Dim", this.toByteSerialized(key2dim));
        this.initSingleMemberF7(map);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getFormCustomParam("model");
        this.getModel().setValue("model", (Object)modelId);
        Map sceneParam = (Map)this.getView().getFormShowParameter().getCustomParam("initdata");
        Long scenarioid = sceneParam.get("scenario") == null ? null : (Long)((Map)sceneParam.get("scenario")).get("id");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Map configMap = new HashMap(16);
        String configStr = this.getConfigFromFormShowParameter();
        if (!StringUtils.isBlank((CharSequence)configStr)) {
            configMap = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
        }
        this.getModel().setValue("scenario", configMap.get("scenario"));
        if (scenarioid != null && scenarioid != 0L) {
            this.getModel().setValue("scenario", (Object)scenarioid);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"scenario"});
        }
        if (OperationStatus.EDIT == status) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"scenario"});
        }
        this.getModel().setValue("year", configMap.get("year"));
        this.getModel().setValue("period", configMap.get("period"));
        this.getModel().setValue("mergeentity", configMap.get("mergeentity"));
        this.getModel().setValue("mergeradiogroup", (Object)configMap.getOrDefault("mergeradiogroup", "1"));
        this.setReportPanel(configMap.getOrDefault("mergeradiogroup", "1"));
        this.getModel().setValue("ecradiogroup", (Object)configMap.getOrDefault("ecradiogroup", "1"));
        this.getModel().setValue("pcradiogroup", (Object)configMap.getOrDefault("pcradiogroup", "1"));
        this.getModel().setValue("chkradiogroup", (Object)configMap.getOrDefault("chkradiogroup", "1"));
        this.getModel().setValue("rightoffsetgroup", (Object)configMap.getOrDefault("rightoffsetgroup", "1"));
        this.getModel().setValue(DispatchParamKeyConstant.commonpapergroup, (Object)configMap.getOrDefault(DispatchParamKeyConstant.commonpapergroup, "1"));
        this.getModel().setValue(DispatchParamKeyConstant.intrgroup, (Object)configMap.getOrDefault(DispatchParamKeyConstant.intrgroup, "1"));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("mergeradiogroup".equals(propName)) {
            this.setReportPanel(e.getChangeSet()[0].getNewValue());
        }
    }

    private void setReportPanel(Object value) {
        if ("2".equals(value)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"ecradiogroup", "pcradiogroup"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"ecradiogroup", "pcradiogroup"});
        }
        this.getModel().setValue("ecradiogroup", value);
        this.getModel().setValue("pcradiogroup", value);
    }

    @Override
    public String sendConfig() {
        IDataModel model = this.getModel();
        DynamicObject sceneDyn = (DynamicObject)model.getValue("scenario");
        if (sceneDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3002", (String)"DispatchParamSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject entityDyn = (DynamicObject)model.getValue("mergeentity");
        if (entityDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"DispatchParamSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("scenario", this.getDynId(sceneDyn));
        result.put("year", this.getDynId((DynamicObject)model.getValue("year")));
        result.put("period", this.getDynId((DynamicObject)model.getValue("period")));
        result.put("mergeentity", this.getDynId((DynamicObject)model.getValue("mergeentity")));
        result.put("mergeradiogroup", model.getValue("mergeradiogroup"));
        result.put("ecradiogroup", model.getValue("ecradiogroup"));
        result.put("pcradiogroup", model.getValue("pcradiogroup"));
        result.put("chkradiogroup", model.getValue("chkradiogroup"));
        result.put("rightoffsetgroup", model.getValue("rightoffsetgroup"));
        result.put(DispatchParamKeyConstant.commonpapergroup, model.getValue(DispatchParamKeyConstant.commonpapergroup));
        result.put(DispatchParamKeyConstant.intrgroup, model.getValue(DispatchParamKeyConstant.intrgroup));
        return SerializationUtils.toJsonString(result);
    }

    private Long getDynId(DynamicObject dyn) {
        if (dyn != null) {
            return dyn.getLong("id");
        }
        return 0L;
    }

    @Override
    public Long sendScene() {
        DynamicObject sceneDyn = (DynamicObject)this.getModel().getValue("scenario");
        return this.getDynId(sceneDyn);
    }
}

