/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.mergeflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StageOpTypeEnum;
import kd.fi.bcm.common.model.MessageInfo;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.task.common.ISchedulePlanOperator;
import kd.fi.bcm.task.common.OperatorHelper;
import kd.fi.bcm.task.common.PlanParam;

public class MergeFlowNewOperator
implements ISchedulePlanOperator {
    private final Set<String> warningMsg = new HashSet<String>(16);
    private final Set<String> execMsg = new HashSet<String>(16);
    private final MergeControlService mergeService = MergeControlService.getInstance();

    public Set<String> getWarningMsg() {
        return this.warningMsg;
    }

    @Override
    public Pair<Boolean, Set<String>> doOperation(PlanParam planParam) {
        if (planParam == null || StringUtils.isBlank((CharSequence)planParam.getParamSetting())) {
            this.execMsg.add(ResManager.loadKDString((String)"\u5408\u5e76\u6d41\u7a0b\u6267\u884c\u53c2\u6570\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"MergeFlowNewOperator_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)Boolean.FALSE, this.execMsg);
        }
        Map configMap = (Map)SerializationUtils.fromJsonString((String)planParam.getParamSetting(), Map.class);
        Long modelId = planParam.getModelId();
        Long yearId = LongUtil.toLong(configMap.get("year"));
        Long periodId = LongUtil.toLong(configMap.get("period"));
        Long scenarioId = LongUtil.toLong(configMap.get("scenario"));
        String scenarioNumber = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId).getNumber();
        Pair<Long, Long> yearAndPeriod = OperatorHelper.calYearAndPeriod(planParam, scenarioNumber, yearId, periodId);
        yearId = (Long)yearAndPeriod.p1;
        periodId = (Long)yearAndPeriod.p2;
        Set<Long> orgIdSet = new HashSet(16);
        Object multiEntityObj = configMap.get("entity");
        if (!(multiEntityObj instanceof List)) {
            this.execMsg.add(ResManager.loadKDString((String)"\u671f\u95f4\u7ba1\u7406\u7684\u6267\u884c\u53c2\u6570\u7ec4\u7ec7\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"MergeFlowNewOperator_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)Boolean.FALSE, this.execMsg);
        }
        List multiEntityList = (List)multiEntityObj;
        if (multiEntityList.isEmpty()) {
            this.execMsg.add(ResManager.loadKDString((String)"\u5408\u5e76\u6d41\u7a0b\u6267\u884c\u53c2\u6570\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"MergeFlowNewOperator_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)Boolean.FALSE, this.execMsg);
        }
        orgIdSet = QueryMemberDetailsHelper.queryMemberIdsByListData((long)modelId, (String)"bcm_entitymembertree", (List)multiEntityList);
        Pair<Set<Long>, Set<String>> effectiveFilterResult = OperatorHelper.getEffectiveEntity(modelId, scenarioId, yearId, periodId, orgIdSet);
        Set noEffectiveSet = (Set)effectiveFilterResult.p2;
        orgIdSet = (Set)effectiveFilterResult.p1;
        if (noEffectiveSet != null && !noEffectiveSet.isEmpty()) {
            this.execMsg.add(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6210\u5458%s\u5728\u5f53\u524d\u8d22\u5e74\u671f\u95f4\u5df2\u88ab\u5904\u7f6e/\u7981\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u64cd\u4f5c\u3002", (String)"MergeFlowNewOperator_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), noEffectiveSet));
        }
        if (orgIdSet.isEmpty() && !this.execMsg.isEmpty()) {
            return Pair.onePair((Object)Boolean.FALSE, this.execMsg);
        }
        OperatorHelper.dealNoPermOrg(modelId, orgIdSet);
        if (orgIdSet.isEmpty()) {
            this.execMsg.add(ResManager.loadKDString((String)"\u65e0\u53ef\u6267\u884c\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u6267\u884c\u4eba\u7684\u6743\u9650\u6216\u7ec4\u7ec7\u7684\u6709\u6548\u6027\u3002", (String)"MergeFlowNewOperator_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)Boolean.FALSE, this.execMsg);
        }
        int mergeFlowStatus = Integer.parseInt(configMap.get("mergeflowstatus").toString());
        String comfortableCurrency = (String)configMap.get("comfortablecurrency");
        switch (mergeFlowStatus) {
            case 1: {
                OperatorHelper.checkPermission(modelId, "bcm_mergecontrollist", "804f6478000000ac", planParam.getExecutor());
                return this.stageCommit(modelId, scenarioId, yearId, periodId, orgIdSet, comfortableCurrency);
            }
            case 2: {
                OperatorHelper.checkPermission(modelId, "bcm_mergecontrollist", "4730fc9f000000ae", planParam.getExecutor());
                return this.stageBack(modelId, scenarioId, yearId, periodId, orgIdSet, comfortableCurrency);
            }
            case 3: {
                OperatorHelper.checkPermission(modelId, "bcm_mergecontrollist", "/=N=NAA4+3V2", planParam.getExecutor());
                return this.archiveStatus(modelId, scenarioId, yearId, periodId, orgIdSet);
            }
            case 4: {
                OperatorHelper.checkPermission(modelId, "bcm_mergecontrollist", "/=N=Y++CAOOZ", planParam.getExecutor());
                return this.cancelArchiveStatus(modelId, scenarioId, yearId, periodId, orgIdSet);
            }
        }
        return Pair.onePair((Object)Boolean.TRUE, this.execMsg);
    }

    @Override
    public Pair<Boolean, String> waitComplete(Long logId) {
        return Pair.onePair((Object)Boolean.TRUE, (Object)"");
    }

    private FixedItem getFixedItem(Long modelId, Long sceneId, Long yearId, Long periodId, Set<Long> orgIdSet) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        FixedItem ctx = FixedItem.newOne((SimpleItem)SimpleItem.newOne((Object)modelId, (String)modelNum), (SimpleItem)SimpleItem.newOne((Object)sceneId, (String)MemberReader.findScenaMemberById((String)modelNum, (Long)sceneId).getNumber()), (SimpleItem)SimpleItem.newOne((Object)yearId, (String)MemberReader.findFyMemberById((String)modelNum, (Long)yearId).getNumber()), (SimpleItem)SimpleItem.newOne((Object)periodId, (String)MemberReader.findPeriodMemberById((String)modelNum, (Long)periodId).getNumber()));
        ArrayList orgItem = new ArrayList(orgIdSet.size());
        orgIdSet.forEach(r -> {
            IDNumberTreeNode orgMember = MemberReader.findEntityMemberById((String)modelNum, (Long)r);
            if (orgMember.getId() != -1L) {
                orgItem.add(SimpleItem.newOne((Object)r, (String)orgMember.getNumber()));
            }
        });
        ctx.setOrgList(orgItem);
        return ctx;
    }

    private Pair<Boolean, Set<String>> stageCommit(Long modelId, Long sceneId, Long yearId, Long periodId, Set<Long> orgIdSet, String isEc) {
        FixedItem fixedItem = this.getFixedItem(modelId, sceneId, yearId, periodId, orgIdSet);
        HashMap<String, String> resultMap = new HashMap<String, String>(10);
        resultMap.put("stepid", null);
        resultMap.put("opinion", "");
        resultMap.put("includeson", "1");
        resultMap.put("stageoptype", StageOpTypeEnum.COMMIT.getCode());
        if ("0".equals(isEc)) {
            resultMap.put("isEc", "EC");
        } else {
            resultMap.put("isEc", "PC");
        }
        ResultBox result = this.mergeService.stageOp(fixedItem, resultMap);
        List msg = result.getMessageList().stream().map(MessageInfo::getMessage).collect(Collectors.toList());
        this.getWarningMsg().addAll(msg);
        return Pair.onePair((Object)msg.isEmpty(), this.getWarningMsg());
    }

    private Pair<Boolean, Set<String>> stageBack(Long modelId, Long sceneId, Long yearId, Long periodId, Set<Long> orgIdSet, String isEc) {
        FixedItem fixedItem = this.getFixedItem(modelId, sceneId, yearId, periodId, orgIdSet);
        HashMap<String, String> resultMap = new HashMap<String, String>(10);
        resultMap.put("opinion", "");
        resultMap.put("includeson", "1");
        resultMap.put("stageoptype", StageOpTypeEnum.BACK.getCode());
        if ("0".equals(isEc)) {
            resultMap.put("isEc", "EC");
        } else {
            resultMap.put("isEc", "PC");
        }
        ResultBox result = this.mergeService.stageOp(fixedItem, resultMap);
        List msg = result.getMessageList().stream().map(MessageInfo::getMessage).collect(Collectors.toList());
        this.getWarningMsg().addAll(msg);
        return Pair.onePair((Object)msg.isEmpty(), this.getWarningMsg());
    }

    private Pair<Boolean, Set<String>> archiveStatus(Long modelId, Long sceneId, Long yearId, Long periodId, Set<Long> orgIdSet) {
        ResultBox result = this.mergeService.archive(this.getFixedItem(modelId, sceneId, yearId, periodId, orgIdSet));
        List msg = result.getMessageList().stream().map(MessageInfo::getMessage).collect(Collectors.toList());
        this.getWarningMsg().addAll(msg);
        return Pair.onePair((Object)msg.isEmpty(), this.getWarningMsg());
    }

    private Pair<Boolean, Set<String>> cancelArchiveStatus(Long modelId, Long sceneId, Long yearId, Long periodId, Set<Long> orgIdSet) {
        ResultBox result = this.mergeService.cancelArchive(this.getFixedItem(modelId, sceneId, yearId, periodId, orgIdSet));
        List msg = result.getMessageList().stream().map(MessageInfo::getMessage).collect(Collectors.toList());
        this.getWarningMsg().addAll(msg);
        return Pair.onePair((Object)msg.isEmpty(), this.getWarningMsg());
    }
}

