/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.periodmanage;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.task.common.AbstractScheduleOperator;
import kd.fi.bcm.task.common.OperatorHelper;
import kd.fi.bcm.task.common.PlanParam;

public class PeriodOperator
extends AbstractScheduleOperator {
    @Override
    public Pair<Boolean, Set<String>> doOperation(PlanParam planParam) {
        String opType;
        HashSet<String> msgs = new HashSet<String>(16);
        if (planParam == null || StringUtils.isBlank((CharSequence)planParam.getParamSetting())) {
            msgs.add(ResManager.loadKDString((String)"\u671f\u95f4\u7ba1\u7406\u7684\u6267\u884c\u53c2\u6570\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"PeriodOperator_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)false, msgs);
        }
        Map configMap = (Map)SerializationUtils.fromJsonString((String)planParam.getParamSetting(), Map.class);
        Long modelId = planParam.getModelId();
        Long scenarioId = planParam.getScenarioId();
        String scenarioNumber = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId).getNumber();
        Long yearId = LongUtil.toLong((Object)configMap.getOrDefault("year", 0L));
        Long periodId = LongUtil.toLong((Object)configMap.getOrDefault("period", 0L));
        String string = opType = configMap.get("optype") == null ? "" : configMap.get("optype").toString();
        if (StringUtils.isBlank((CharSequence)opType)) {
            msgs.add(ResManager.loadKDString((String)"\u671f\u95f4\u7ba1\u7406\u7684\u6267\u884c\u53c2\u6570\u64cd\u4f5c\u9009\u9879\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"PeriodOperator_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)false, msgs);
        }
        OperatorHelper.checkPermission(modelId, "bcm_periodsetting", "1".equals(opType) ? "13X5X/B5GMEL" : "13X5Z+VF3JD+", planParam.getExecutor());
        Pair<Long, Long> yearAndPeriod = OperatorHelper.calYearAndPeriod(planParam, scenarioNumber, yearId, periodId);
        yearId = (Long)yearAndPeriod.p1;
        periodId = (Long)yearAndPeriod.p2;
        Object multiEntityObj = configMap.get("entity");
        if (!(multiEntityObj instanceof List)) {
            msgs.add(ResManager.loadKDString((String)"\u671f\u95f4\u7ba1\u7406\u7684\u6267\u884c\u53c2\u6570\u7ec4\u7ec7\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"PeriodOperator_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)false, msgs);
        }
        List multiEntitys = (List)multiEntityObj;
        if (CollectionUtil.isEmpty((Collection)multiEntitys)) {
            msgs.add(ResManager.loadKDString((String)"\u671f\u95f4\u7ba1\u7406\u7684\u6267\u884c\u53c2\u6570\u7ec4\u7ec7\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"PeriodOperator_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)false, msgs);
        }
        Set<String> numbers = this.getEntitySet(modelId, scenarioId, yearId, periodId, multiEntitys, msgs);
        if (CollectionUtils.isEmpty(numbers)) {
            msgs.add(ResManager.loadKDString((String)"\u89e3\u6790\u51fa\u6765\u7684\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6267\u884c\u53c2\u6570\u7684\u7ec4\u7ec7\u914d\u7f6e\u3002", (String)"PeriodOperator_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)false, msgs);
        }
        PeriodSettingHelper.intelDispatchPeriodManage((long)modelId, numbers, (long)scenarioId, (long)yearId, (long)periodId, (String)opType);
        return Pair.onePair((Object)true, msgs);
    }

    private Set<String> getEntitySet(long modelId, Long scenarioId, Long yearId, Long periodId, List<Map<String, String>> multiEntitys, Set<String> msgs) {
        HashMap<Long, Integer> orgIdScopeMap = new HashMap<Long, Integer>(8);
        for (Map<String, String> item : multiEntitys) {
            orgIdScopeMap.put(LongUtil.toLong((Object)item.get("id")), Integer.parseInt(item.get("scope")));
        }
        DimensionScope ds = new DimensionScope(Long.toString(modelId), new SchemeContext(modelId).getDimensionByNumber("Entity"), orgIdScopeMap);
        Set resSet = ds.getResolveScopeIds();
        Pair<Set<Long>, String> effectiveEntityWithMsg = OperatorHelper.getEffectiveEntityWithMsg(modelId, scenarioId, yearId, periodId, resSet);
        resSet = (Set)effectiveEntityWithMsg.p1;
        if (effectiveEntityWithMsg.p2 != null) {
            msgs.add((String)effectiveEntityWithMsg.p2);
        }
        Pair<Set<Long>, Set<String>> orgSetPair = OperatorHelper.dealNoPermOrg(modelId, resSet);
        if (!CollectionUtils.isEmpty((Collection)((Collection)orgSetPair.p2))) {
            msgs.add(String.format(ResManager.loadKDString((String)"\u6267\u884c\u4eba\u65e0\u7ec4\u7ec7\u6210\u5458%s\u5199\u5165\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"Operator_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgSetPair.p2));
        }
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        return resSet.stream().map(e -> MemberReader.findEntityMemberById((String)modelNumber, (Long)e)).filter(e -> IDNumberTreeNode.NotFoundTreeNode != e).map(IDNumberTreeNode::getNumber).collect(Collectors.toSet());
    }
}

