/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.periodmanage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.task.common.IScheduleSubPage;

public class PeriodParamPlugin
extends AbstractBaseFormPlugin
implements IScheduleSubPage {
    private static final List<String> dimKeys = Arrays.asList("scenario", "year", "period");

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("entity");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getFormCustomParam("model");
        this.getModel().setValue("model", (Object)modelId);
        Map sceneParam = (Map)this.getView().getFormShowParameter().getCustomParam("initdata");
        Long scenarioid = sceneParam.get("scenario") == null ? null : (Long)((Map)sceneParam.get("scenario")).get("id");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Map configMap = new HashMap(16);
        String configStr = this.getConfigFromFormShowParameter();
        if (!StringUtils.isBlank((CharSequence)configStr)) {
            configMap = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
        }
        this.getModel().setValue("scenario", configMap.get("scenario"));
        if (scenarioid != null && scenarioid != 0L) {
            this.getModel().setValue("scenario", (Object)scenarioid);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"scenario"});
        }
        if (OperationStatus.EDIT == status) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"scenario"});
        }
        this.getModel().setValue("year", configMap.get("year"));
        this.getModel().setValue("period", configMap.get("period"));
        Object entityObj = configMap.get("entity");
        if (entityObj instanceof List) {
            List multiEntitys = (List)entityObj;
            if (!CollectionUtil.isEmpty((Collection)multiEntitys)) {
                StringBuilder showName = new StringBuilder();
                for (Map item : multiEntitys) {
                    this.buildPageViewShowName(showName, item);
                }
                this.getModel().setValue("entity", (Object)showName.substring(0, showName.length() - 1));
            }
            this.getPageCache().put("entity", SerializationUtils.toJsonString((Object)multiEntitys));
        }
        this.getModel().setValue("optype", configMap.get("optype"));
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("entity".equals(key)) {
            this.showMultiMemberF7("Entity");
        }
    }

    private void buildPageViewShowName(StringBuilder sb, Map<String, String> map) {
        this.buildMultiF7ShowName(sb, map.get("name"), map.get("number"), Integer.parseInt(map.get("scope")));
    }

    private void showMultiMemberF7(String number) {
        long modelId = this.getModelId();
        DynamicObject dim = MemberReader.getDimensionDynById((long)MemberReader.getDimensionIdByNum((long)modelId, (String)number));
        if (dim == null) {
            return;
        }
        number = number.toLowerCase(Locale.ENGLISH);
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bcm_mulmemberf7base_tem");
        para.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dimension", dim.getInt("dseq") + "");
        params.put("KEY_MODEL_ID", String.valueOf(modelId));
        params.put("sign", number);
        para.setCustomParams(params);
        para.setCaption(dim.getString("name"));
        IFormView view = this.getView();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, number);
        para.setCloseCallBack(closeCallBack);
        view.showForm(para);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String keyName = e.getProperty().getName();
        if ("Entity".equalsIgnoreCase(keyName) && (e.getChangeSet()[0].getNewValue() == null || e.getChangeSet()[0].getNewValue().toString().isEmpty())) {
            this.getPageCache().remove("Entity".toLowerCase(Locale.ENGLISH));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        DynamicObjectCollection doc;
        String key;
        Object returnData = evt.getReturnData();
        if (returnData != null && "Entity".equalsIgnoreCase(key = evt.getActionId()) && (doc = (DynamicObjectCollection)evt.getReturnData()) != null) {
            IDataModel model = this.getModel();
            if (doc.isEmpty()) {
                model.setValue(key, null);
                this.getPageCache().remove(key);
            } else {
                StringBuilder sb = new StringBuilder();
                ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>(doc.size());
                for (DynamicObject dynamicObject : doc) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", dynamicObject.get(4).toString());
                    map.put("scope", dynamicObject.get(5).toString());
                    map.put("number", dynamicObject.get(2).toString());
                    map.put("name", dynamicObject.get(3).toString());
                    map.put("pid", dynamicObject.get(6).toString());
                    this.buildPageViewShowName(sb, map);
                    list.add(map);
                }
                model.setValue(key, (Object)sb.substring(0, sb.length() - 1));
                String s = SerializationUtils.toJsonString(list);
                this.getPageCache().put(key, s);
            }
        }
    }

    @Override
    public String sendConfig() {
        IDataModel model = this.getModel();
        DynamicObject sceneDyn = (DynamicObject)model.getValue("scenario");
        if (sceneDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3002", (String)"DispatchParamSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String multiEntityStr = this.getPageCache().get("entity");
        if (StringUtils.isBlank((CharSequence)multiEntityStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"DispatchParamSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String optype = (String)model.getValue("optype");
        if (StringUtils.isBlank((CharSequence)optype)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u64cd\u4f5c\u9009\u9879\u3002", (String)"PeriodParamPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("scenario", this.getDynId(sceneDyn));
        result.put("year", this.getDynId((DynamicObject)model.getValue("year")));
        result.put("period", this.getDynId((DynamicObject)model.getValue("period")));
        result.put("entity", SerializationUtils.fromJsonString((String)multiEntityStr, List.class));
        result.put("optype", model.getValue("optype"));
        return SerializationUtils.toJsonString(result);
    }

    @Override
    public Long sendScene() {
        DynamicObject sceneDyn = (DynamicObject)this.getModel().getValue("scenario");
        return this.getDynId(sceneDyn);
    }

    private Long getDynId(DynamicObject dyn) {
        if (dyn != null) {
            return dyn.getLong("id");
        }
        return 0L;
    }
}

