/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.task.rulecalculate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.bcm.business.computing.BizRuleExecuteHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.task.common.AbstractScheduleOperator;
import kd.fi.bcm.task.common.OperatorHelper;
import kd.fi.bcm.task.common.PlanParam;
import org.apache.commons.collections.CollectionUtils;

public class RuleCalculateOperator
extends AbstractScheduleOperator {
    @Override
    public Pair<Boolean, Set<String>> doOperation(PlanParam planParam) {
        HashSet<String> msgS = new HashSet<String>(16);
        long modelId = planParam.getModelId();
        long executor = planParam.getExecutor();
        Map configMap = (Map)SerializationUtils.fromJsonString((String)planParam.getParamSetting(), Map.class);
        OperatorHelper.checkPermission(modelId, "bcm_form_list", "4730fc9f000025ae", executor);
        long scenarioId = planParam.getScenarioId();
        String scenarioNumber = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId).getNumber();
        long yearId = LongUtil.toLong((Object)configMap.getOrDefault("year", 0L));
        long periodId = LongUtil.toLong((Object)configMap.getOrDefault("period", 0L));
        Pair<Long, Long> yearAndPeriod = OperatorHelper.calYearAndPeriod(planParam, scenarioNumber, yearId, periodId);
        yearId = (Long)yearAndPeriod.p1;
        periodId = (Long)yearAndPeriod.p2;
        Object multiEntityObj = configMap.get("entity");
        Object multiProcessObj = configMap.get("process");
        if (!(multiEntityObj instanceof List) || !(multiProcessObj instanceof List)) {
            msgS.add(ResManager.loadKDString((String)"\u89c4\u5219\u8ba1\u7b97\u6267\u884c\u53c2\u6570\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"RuleCalculateOperator_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)false, msgS);
        }
        List list1 = (List)multiEntityObj;
        List list2 = (List)multiProcessObj;
        if (CollectionUtils.isEmpty((Collection)list1) || CollectionUtils.isEmpty((Collection)list2)) {
            msgS.add(ResManager.loadKDString((String)"\u89c4\u5219\u8ba1\u7b97\u6267\u884c\u53c2\u6570\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"RuleCalculateOperator_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)false, msgS);
        }
        Set memberIds = QueryMemberDetailsHelper.queryMemberIdsByListData((long)modelId, (String)"bcm_entitymembertree", (List)list1);
        HashSet srcIds = new HashSet(memberIds);
        HashSet<String> noWritePermSet = new HashSet<String>();
        OperatorHelper.dealNoPermOrg(modelId, memberIds);
        for (Long srcId : srcIds) {
            if (memberIds.contains(srcId)) continue;
            noWritePermSet.add(MemberReader.findEntityMemberById((Long)modelId, (Long)srcId).getNumber());
        }
        if (!noWritePermSet.isEmpty()) {
            msgS.add(String.format(ResManager.loadKDString((String)"\u6267\u884c\u4eba\u65e0\u7ec4\u7ec7\u6210\u5458%s\u5199\u5165\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"Operator_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), noWritePermSet));
            return Pair.onePair((Object)false, msgS);
        }
        ArrayList<Long> entityIds = new ArrayList<Long>(memberIds);
        OperatorHelper.checkPeriodStatus(modelId, scenarioId, yearId, periodId, entityIds);
        if (CollectionUtils.isEmpty(entityIds)) {
            msgS.add(ResManager.loadKDString((String)"\u671f\u95f4\u672a\u5f00\u542f\u3002", (String)"RuleCalculateOperator_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Pair.onePair((Object)false, msgS);
        }
        Set processIds = QueryMemberDetailsHelper.queryMemberIdsByListData((long)modelId, (String)"bcm_processmembertree", (List)list2);
        BizRuleExecuteHelper.executeBizRule((long)modelId, entityIds, (long)scenarioId, (long)yearId, (long)periodId, new ArrayList(processIds));
        return Pair.onePair((Object)true, msgS);
    }
}

