/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.orm.query.QFilter;
import kd.bos.script.ScriptObject;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.SysMembConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.InvokeUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.ScopeInfo;
import kd.fi.bcm.computing.ScriptDimension;
import kd.fi.bcm.computing.ScriptMember;
import kd.fi.bcm.computing.XDMScopeInfo;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import kd.fi.bcm.computing.bizrule.log.AuditLogHelper;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.properties.IProperty;
import kd.fi.bcm.fel.common.StringUtils;

@KSObject
public class ComputingContext
implements ScriptObject {
    private final OlapConnection olapConnection;
    private final IOutline outline;
    private final Map<String, Pair<Long, String>> scopeItems;
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ComputingContext.class);
    private final Stack<ScopeInfo> scopeStack = new Stack();
    private final Stack<Integer> precisionStack = new Stack();
    private static final Map<String, IProperty> properties = new HashMap<String, IProperty>();
    private final Map<String, Object> cache = new HashMap<String, Object>();
    private String runtime_Fy;
    private String runtime_Period;
    private boolean isIgnoreVerify = false;
    private Set<String> extendNumbers;
    private final BizRuleExecParam.BizRuleExecCommonParam commParam;
    private Map<String, String> shortNumber2NumberMap = null;
    private Set<String> numberSet = null;

    public static ComputingContext create(OlapConnection olapConnection, IOutline outline, BizRuleExecParam.BizRuleExecCommonParam commParam) {
        return (ComputingContext)AuditLogHelper.proxyWithAuditEvent(new ComputingContext(olapConnection, outline, commParam), new Class[]{OlapConnection.class, IOutline.class, BizRuleExecParam.BizRuleExecCommonParam.class}, new Object[]{olapConnection, outline, commParam});
    }

    public ComputingContext(OlapConnection olapConnection, IOutline outline, BizRuleExecParam.BizRuleExecCommonParam commParam) {
        this.olapConnection = olapConnection;
        this.outline = outline;
        this.scopeItems = commParam.getParams();
        this.commParam = commParam;
        if (this.scopeItems != null) {
            ScopeInfo globalScope = new ScopeInfo();
            this.scopeItems.forEach((key, value) -> {
                globalScope.getFilters().add(new DimensionFilterItem(key, (List)Lists.newArrayList((Object[])new String[]{(String)value.p2})));
                if (DimTypesEnum.YEAR.getNumber().equals(key)) {
                    this.runtime_Fy = (String)value.p2;
                } else if (DimTypesEnum.PERIOD.getNumber().equals(key)) {
                    this.runtime_Period = (String)value.p2;
                }
            });
            commParam.getExternalCommParams().forEach((key, value) -> globalScope.getFilters().add(new DimensionFilterItem(key, (List)Lists.newArrayList((Object[])value))));
            this.scopeStack.push(globalScope);
        }
    }

    private Set<String> getExtendNumbersByModel(String modelNum) {
        return (Set)CacheGenFactory.getTemporaryCache().getOrLoad("allExtendDimMember" + modelNum, () -> {
            QFilter qf = new QFilter("model.number", "=", (Object)modelNum);
            return QueryServiceHelper.query((String)"bcm_structofextend", (String)"number", (QFilter[])qf.toArray()).stream().map(dyo -> dyo.getString("number")).collect(Collectors.toSet());
        });
    }

    public void ignoreVerify(boolean v) {
        this.isIgnoreVerify = v;
    }

    public boolean isIgnoreVerify() {
        return this.isIgnoreVerify;
    }

    public Object __getUndefinedProperty(String propertyName) {
        if (propertyName != null && !propertyName.isEmpty()) {
            String number;
            if (this.shortNumber2NumberMap == null) {
                this.shortNumber2NumberMap = MemberReader.getDimensionShortNumber2NumberMap((String)this.outline.getModelNum());
                this.numberSet = new HashSet<String>(this.shortNumber2NumberMap.values());
                this.numberSet.add("EntityView");
            }
            if (this.numberSet.contains(propertyName)) {
                number = propertyName;
            } else {
                number = this.shortNumber2NumberMap.get(propertyName);
                if (number == null) {
                    throw new BizRuleException((Throwable)new UnsupportedOperationException(String.format("ctx not supported property [%s] operate", propertyName)));
                }
            }
            String cacheKey = String.format("%s|%s", this.outline.getModelNum(), number);
            Object v = this.cache.get(cacheKey);
            if (v != null) {
                if (v instanceof UnspecifiedDimension) {
                    return null;
                }
                return v;
            }
            IProperty p = properties.get(number);
            if (p != null) {
                v = p.get(propertyName, this.commParam, this.outline, this.olapConnection);
                if (v == null) {
                    this.cache.put(cacheKey, UnspecifiedDimension.instance);
                    return null;
                }
                this.cache.put(cacheKey, v);
                return v;
            }
            if ("EntityView".equals(number)) {
                Pair<Long, String> entityPair = this.commParam.getDimMemberPair(DimTypesEnum.ENTITY.getNumber());
                if (entityPair != null) {
                    IDNumberTreeNode entity = MemberReader.findEntityMemberById((String)this.outline.getModelNum(), (Long)((Long)entityPair.p1));
                    if (entity != IDNumberTreeNode.NotFoundTreeNode) {
                        v = entity.getProperty("cslscheme");
                        this.cache.put(cacheKey, v);
                        return v;
                    }
                    return null;
                }
            } else {
                this.cache.put(cacheKey, UnspecifiedDimension.instance);
            }
            return null;
        }
        throw new BizRuleException((Throwable)new UnsupportedOperationException(String.format("ctx not supported property [%s] operate", propertyName)));
    }

    public OlapConnection getOlapConnection() {
        return this.olapConnection;
    }

    public IOutline getOutline() {
        return this.outline;
    }

    public Map<String, Pair<Long, String>> getScopeItems() {
        return this.scopeItems;
    }

    public void pushScope(ScopeInfo scope) {
        this.scopeStack.push(scope);
    }

    public void popScope() {
        if (this.scopeStack.size() <= 1) {
            throw new BizRuleException((Throwable)new RuntimeException("endFix flag is not compared ."));
        }
        this.scopeStack.pop();
    }

    public void pushPrecision(String precisionStr) {
        Integer precision = 2;
        if (StringUtils.isEmpty((CharSequence)precisionStr)) {
            String selectFields = "scaleentry.scale as scale";
            QFilter qFilter = new QFilter("id", "=", this.scopeItems.get((Object)PresetConstant.SCENE_DIM).p1);
            qFilter.and("scaleentry.currency", "=", this.scopeItems.get((Object)PresetConstant.CURRENCY_DIM).p1);
            DynamicObject dimObj = QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)selectFields, (QFilter[])qFilter.toArray());
            if (dimObj != null && dimObj.get("scale") != null) {
                precision = dimObj.getInt("scale");
            }
        } else {
            try {
                precision = Integer.parseInt(precisionStr);
                if (precision > 15) {
                    precision = 15;
                }
            }
            catch (NumberFormatException e) {
                throw new BizRuleException((Throwable)new RuntimeException("round(precision) is not int .", e));
            }
        }
        this.precisionStack.push(precision);
    }

    public void popPrecision() {
        if (this.precisionStack.isEmpty()) {
            throw new BizRuleException((Throwable)new RuntimeException(ResManager.loadKDString((String)"endRound()\u672a\u627e\u5230\u4e0e\u4e4b\u5bf9\u5e94\u7684round()\u51fd\u6570\u3002", (String)"ComputingContext_3", (String)"fi-bcm-computing", (Object[])new Object[0])));
        }
        this.precisionStack.pop();
    }

    public String joinRound(String expression) {
        if (!this.precisionStack.empty()) {
            return "round(" + expression + "," + this.precisionStack.peek() + ")";
        }
        return expression;
    }

    public Object executeRound(Object value) {
        if (value instanceof Number && !this.precisionStack.empty()) {
            return new BigDecimal(value.toString()).setScale((int)this.precisionStack.peek(), 4);
        }
        return value;
    }

    public ScopeInfo getRuntimeScope(ScopeInfo info) {
        if (info instanceof XDMScopeInfo) {
            return info;
        }
        ArrayList<ScopeInfo> scopes = new ArrayList<ScopeInfo>(this.scopeStack);
        if (info != null) {
            scopes.add(info);
        }
        Collections.reverse(scopes);
        ScopeInfo runtimeScope = ScopeInfo.mergeReduce(scopes.toArray(new ScopeInfo[0]));
        runtimeScope.getFilters().forEach(f -> {
            if (DimTypesEnum.YEAR.getNumber().equals(f.getName())) {
                this.runtime_Fy = (String)f.getValues().get(0);
            } else if (DimTypesEnum.PERIOD.getNumber().equals(f.getName())) {
                this.runtime_Period = (String)f.getValues().get(0);
            }
        });
        if (info != null && !info.getExcludeFilterSet().isEmpty()) {
            runtimeScope.getFilters().removeIf(df -> info.getExcludeFilterSet().contains(df.getName()));
        }
        this.handleRelaWithParentProcess(runtimeScope);
        for (DimensionFilterItem item : runtimeScope.getFilters()) {
            if (!PresetConstant.PROCESS_DIM.equals(item.getName())) continue;
            item.getValues().replaceAll(e -> "EIRpt".equals(e) ? "IRpt" : ("ERAdj".equals(e) ? "RAdj" : e));
            break;
        }
        return runtimeScope;
    }

    private void handleRelaWithParentProcess(ScopeInfo scopeInfo) {
        Pair<Long, String> entity;
        boolean hasRelaProcess = scopeInfo.getFilters().stream().anyMatch(p -> p.getName().equals(PresetConstant.PROCESS_DIM) && p.getValues().stream().anyMatch(OrgRelaProcessMembPool::isRelaProcess));
        List entities = null;
        List process = null;
        for (DimensionFilterItem f : scopeInfo.getFilters()) {
            if (PresetConstant.ENTITY_DIM.equals(f.getName())) {
                entities = f.getValues();
                continue;
            }
            if (!PresetConstant.PROCESS_DIM.equals(f.getName())) continue;
            process = f.getValues();
        }
        if (hasRelaProcess && entities != null && !entities.isEmpty() && (entity = this.getScopeItems().get(PresetConstant.ENTITY_DIM)) != null && process != null) {
            boolean isAllRelaProcess = process.stream().allMatch(OrgRelaProcessMembPool::isRelaProcess);
            if (entities.size() == 1 && ((String)entities.get(0)).equals(entity.p2)) {
                entities.add(MemberReader.findEntityMemberById((String)this.outline.getModelNum(), (Long)((Long)entity.p1)).getVirtualEntity());
                if (isAllRelaProcess) {
                    entities.remove(entity.p2);
                }
                return;
            }
            long cslSchemeId = BusinessDataServiceHelper.loadSingleFromCache((Object)entity.p1, (String)"bcm_entitymembertree", (String)"cslscheme.id").getLong("cslscheme.id");
            QFBuilder qf = new QFBuilder();
            qf.add("number", "in", (Object)entities);
            qf.add("model.id", "=", (Object)MemberReader.findModelIdByNum((String)this.outline.getModelNum()));
            qf.add("cslscheme.id", "=", (Object)cslSchemeId);
            Collection dynas = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id,number", (QFilter[])qf.toArray()).values();
            for (DynamicObject dy : dynas) {
                String vt = MemberReader.findEntityMemberById((String)this.outline.getModelNum(), (Long)dy.getLong("id")).getVirtualEntity();
                if (!entities.contains(vt)) {
                    entities.add(vt);
                }
                if (!isAllRelaProcess) continue;
                entities.remove(dy.getString("number"));
            }
        }
        if ((entities == null || entities.isEmpty()) && scopeInfo.getFilters().stream().noneMatch(p -> p.getName().equals(PresetConstant.FY_DIM)) && scopeInfo.getFilters().stream().noneMatch(p -> p.getName().equals(PresetConstant.PERIOD_DIM))) {
            log.error(ThrowableHelper.generatekernelMessageInfo((Throwable)new RuntimeException("Scope not limit Entity." + scopeInfo), (int)50));
        }
    }

    public String getRuntimeFy() {
        return this.runtime_Fy;
    }

    public String getRuntimePeriod() {
        return this.runtime_Period;
    }

    private static void initProperties() {
        Pair[] ctxDims;
        for (Pair ctxDim : ctxDims = new Pair[]{Pair.onePair((Object)DimTypesEnum.ENTITY, (Object)"bcm_entitymembertree"), Pair.onePair((Object)DimTypesEnum.CURRENCY, (Object)"bcm_currencymembertree"), Pair.onePair((Object)DimTypesEnum.YEAR, (Object)"bcm_fymembertree"), Pair.onePair((Object)DimTypesEnum.PERIOD, (Object)"bcm_periodmembertree"), Pair.onePair((Object)DimTypesEnum.PROCESS, (Object)"bcm_processmembertree"), Pair.onePair((Object)DimTypesEnum.SCENARIO, (Object)"bcm_scenemembertree")}) {
            String dimNumber = ((DimTypesEnum)ctxDim.p1).getNumber();
            IProperty p = (name, commParam, outline, olapConnection) -> {
                String[] members;
                Pair<Long, String> v = commParam.getDimMemberPair(dimNumber);
                if (v != null) {
                    Long id = (Long)v.p1;
                    IDNumberTreeNode node = MemberReader.findMemberById((String)outline.getModelNum(), (String)((String)ctxDim.p2), (Long)id);
                    if (node != null) {
                        return ScriptMember.create(node.getNumber(), ScriptDimension.create(dimNumber, olapConnection, outline), id);
                    }
                } else if (commParam.getExternalCommParams().containsKey(name) && (members = commParam.getExternalCommParams().get(name)).length == 1) {
                    IDNumberTreeNode node = MemberReader.findProcessMemberByNum((String)outline.getModelNum(), (String)members[0]);
                    return ScriptMember.create(members[0], ScriptDimension.create(dimNumber, olapConnection, outline), node.getId());
                }
                return null;
            };
            properties.put(dimNumber, p);
        }
    }

    public void checkHasModifiedGlobalScopeInfo(ScopeInfo scope) {
        if (this.isIgnoreVerify) {
            log.error("execute biz rule ignore verify,scope-->" + scope);
            return;
        }
        HashMap<String, DimensionFilterItem> filterMap = new HashMap<String, DimensionFilterItem>(scope.getFilters().size());
        for (DimensionFilterItem dimFilter : scope.getFilters()) {
            filterMap.put(dimFilter.getName(), dimFilter);
        }
        DimensionFilterItem dimFilter = (DimensionFilterItem)filterMap.get(PresetConstant.PROCESS_DIM);
        String localProMember = dimFilter != null ? (dimFilter.getValues().size() != 1 ? "" : (String)dimFilter.getValues().get(0)) : "";
        for (Map.Entry<String, Pair<Long, String>> e : this.commParam.getParams().entrySet()) {
            dimFilter = (DimensionFilterItem)filterMap.get(e.getKey());
            if (dimFilter != null) {
                boolean isProcess = dimFilter.getName().equals(PresetConstant.PROCESS_DIM);
                String globalMember = (String)e.getValue().p2;
                String member = (String)dimFilter.getValues().get(0);
                if (dimFilter.getValues().size() == 1 && (isProcess || member.equals(this.transRelaMember(e.getKey(), globalMember, localProMember))) && (!isProcess || member.equals(globalMember) || SysMembConstant.EIRptAndIRptSet.containsAll(Arrays.asList(member, globalMember)) || SysMembConstant.EAdjAndRAdjSet.containsAll(Arrays.asList(member, globalMember)))) continue;
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"runs\u6216save\u51fd\u6570\u6267\u884c\u65f6\uff0c\u5728scope\u4e2d\u4e0d\u5141\u8bb8\u91cd\u65b0\u5b9a\u4e49\u80cc\u666f\u7ef4\u201c%1$s\u201d\u7684\u6210\u5458\u201c%2$s\u201d\u4e3a\u201c%3$s\u201d\u3002", (String)"ComputingContext_0", (String)"fi-bcm-computing", (Object[])new Object[0]), e.getKey(), e.getValue().p2, Joiner.on((char)',').join((Iterable)dimFilter.getValues())));
            }
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"runs\u6216save\u51fd\u6570\u6267\u884c\u65f6\uff0c\u5728scope\u4e2d\u4e0d\u5141\u8bb8\u91cd\u65b0\u5b9a\u4e49\u80cc\u666f\u7ef4\u201c%1$s\u201d\u7684\u6210\u5458\u201c%2$s\u201d\u4e3a\u201c%3$s\u201d\u3002", (String)"ComputingContext_0", (String)"fi-bcm-computing", (Object[])new Object[0]), e.getKey(), e.getValue().p2, ResManager.loadKDString((String)"\u7a7a", (String)"ComputingContext_1", (String)"fi-bcm-computing", (Object[])new Object[0])));
        }
    }

    private String transRelaMember(String dim, String member, String process) {
        if (PresetConstant.ENTITY_DIM.equals(dim) && OrgRelaProcessMembPool.isRelaProcess((String)process)) {
            return MemberReader.findEntityMemberById((String)this.outline.getModelNum(), (Long)((Long)this.commParam.getParams().get((Object)PresetConstant.ENTITY_DIM).p1)).getVirtualEntity();
        }
        return member;
    }

    public void verifyCanExecuteRule() {
        if (this.isIgnoreVerify) {
            return;
        }
        Pair<Long, String> entity = this.getDimMemberPairOnCommParam(PresetConstant.ENTITY_DIM);
        Pair<Long, String> fy = this.getDimMemberPairOnCommParam(PresetConstant.FY_DIM);
        Pair<Long, String> period = this.getDimMemberPairOnCommParam(PresetConstant.PERIOD_DIM);
        Pair<Long, String> scenario = this.getDimMemberPairOnCommParam(PresetConstant.SCENE_DIM);
        Pair<Long, String> currency = this.getDimMemberPairOnCommParam(PresetConstant.CURRENCY_DIM);
        if (entity != null && fy != null && period != null && scenario != null && currency != null) {
            long entityId = (Long)entity.p1;
            if (((String)entity.p2).contains("_")) {
                entityId = MemberReader.findEntityMemberByNum((String)this.getOutline().getModelNum(), (String)((String)entity.p2).split("_")[0]).getId();
            }
            long entityId2 = entityId;
            boolean canExecute = (Boolean)ThreadCache.get((Object)Joiner.on((String)"|").join(entity.p2, fy.p2, new Object[]{period.p2, scenario.p2, currency.p2}), () -> (Boolean)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.olap.verify.OlapDataVerifyServiceHelper", (String)"verifyCanExecute", (Object[])new Object[]{this.outline.getModelNum(), entityId2, scenario.p1, fy.p1, period.p1, currency.p2}));
            if (!canExecute) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u5728%2$s\u5e74%3$s\u671f%4$s\u60c5\u666f\u4e0b\u7684\u672c\u4f4d\u5e01\u6d41\u7a0b\u5df2\u7ecf\u63d0\u4ea4\u6216\u5f52\u6863\uff0c\u4ea6\u6216\u671f\u95f4\u672a\u5f00\u542f\uff0c\u4e0d\u80fd\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u3002", (String)"ComputingContext_2", (String)"fi-bcm-computing", (Object[])new Object[0]), entity.p2, fy.p2, period.p2, scenario.p2));
            }
        }
    }

    public String toString() {
        return this.scopeStack.toString();
    }

    public Pair<Long, String> getDimMemberPairOnCommParam(String dimNum) {
        return this.commParam.getDimMemberPair(dimNum);
    }

    public Stack<Integer> getPrecisionStack() {
        return this.precisionStack;
    }

    public Set<String> getExtendNumbers() {
        if (this.extendNumbers == null) {
            this.extendNumbers = this.getExtendNumbersByModel(this.getOutline().getModelNum());
        }
        return this.extendNumbers;
    }

    static {
        ComputingContext.initProperties();
    }

    private static class UnspecifiedDimension {
        public static final UnspecifiedDimension instance = new UnspecifiedDimension();

        private UnspecifiedDimension() {
        }
    }
}

