/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.script.ScriptConfig;
import kd.bos.script.ScriptExecutor;
import kd.bos.script.ScriptInfo;
import kd.bos.script.jsengine.KContext;
import kd.bos.script.jsengine.mate.KContextEnv;
import kd.bos.script.util.SimpleScriptInfo;
import kd.fi.bcm.common.bizrule.BizRuleServiceHelper;
import kd.fi.bcm.common.exception.ScriptAnalyzeException;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.threadlocal.ThreadLocalFactory;
import kd.fi.bcm.computing.ComputingContext;
import kd.fi.bcm.computing.VarProviderImpl;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import kd.fi.bcm.computing.bizrule.log.AuditLogHelper;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.datasource.JavaScriptLoader;
import kd.fi.bcm.computing.datasource.Outline;
import kd.fi.bcm.computing.util.PlatFormVersionUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;

public class ComputingEngine {
    private final OlapConnection olapConnection;
    private final IOutline outline;
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ComputingEngine.class);
    private static final String MIN_PLATFORM_VERSION = "5.0.014.0";

    public ComputingEngine(OlapConnection olapConnection) {
        this.olapConnection = olapConnection;
        this.outline = new Outline(olapConnection);
    }

    public ComputingEngine(OlapConnection olapConnection, IOutline outline) {
        this.olapConnection = olapConnection;
        this.outline = outline;
    }

    private void initComputingContext4Outline(Map<String, Object> args) {
        this.outline.setComputingContext((ComputingContext)args.get("ctx"));
        if (this.outline.getComputingContext() == null) {
            ComputingContext context = ComputingContext.create(this.olapConnection, this.outline, new BizRuleExecParam(null).getCommonParam());
            this.outline.setComputingContext(context);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(String script, Map<String, Object> args) {
        Object object;
        log.startWatch();
        ScriptExecutor executor = (ScriptExecutor)AuditLogHelper.proxyWithAuditEvent(ScriptExecutor.create(), new Class[]{ClassLoader.class, Boolean.TYPE}, new Object[]{Thread.currentThread().getContextClassLoader(), false});
        this.initComputingContext4Outline(args);
        VarProviderImpl varProvider = new VarProviderImpl(this.olapConnection, args, this.outline);
        this.outline.setScriptExecutor(executor);
        ArrayList<Object> scriptInfos = new ArrayList<Object>();
        scriptInfos.add(JavaScriptLoader.getInstance().getBizRuleScript());
        if (PlatFormVersionUtil.getVersionInfos().compareToIgnoreCase(MIN_PLATFORM_VERSION) >= 0) {
            scriptInfos.add(new SimpleScriptInfo("biz_scale.js", "beginBigDecimalScale(15,'half_up');"));
        }
        scriptInfos.addAll((ComputingContext)args.get("ctx") == null ? new ArrayList(0) : JavaScriptLoader.getInstance().getDefImportScript(this.outline.getModelNum()));
        scriptInfos.add(new SimpleScriptInfo(this.getRuleName(args), script));
        executor.init(ctx -> {
            ctx.setVarProvider(varProvider);
            ctx.require(new String[]{"kd.fi.bcm.business.journal.KJournal"});
            ctx.require(new String[]{"kd.fi.bcm.computing.model.BcmMap"});
            ((KContext)ctx).setLimit(ScriptConfig.getTimeOut(), ScriptConfig.getDebugTimeOut(), -1L, 100000);
        });
        try {
            if (KContext.get() != null) {
                throw new KDBizException("exist nest script execute in cunrrent thread.");
            }
            executor.begin();
            ((Context)executor.getContext()).getWrapFactory().setJavaPrimitiveWrap(false);
            object = executor.exec(scriptInfos.toArray(new ScriptInfo[0]));
        }
        catch (RhinoException re) {
            try {
                log.error(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u811a\u672c\u6267\u884c\u5f02\u5e38\u3002", (String)"ComputingEngine_4", (String)"fi-bcm-computing", (Object[])new Object[0]), (Throwable)re);
                throw re;
                catch (ClassCastException e1) {
                    log.error((Throwable)e1);
                    throw new RuntimeException(ResManager.loadKDString((String)"\u811a\u672c\u6216\u8005\u4f20\u53c2\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u76f8\u5173\u7ef4\u5ea6\u6210\u5458\u662f\u5426\u5b58\u5728\u3002", (String)"ComputingEngine_0", (String)"fi-bcm-computing", (Object[])new Object[0]), e1);
                }
                catch (ScriptAnalyzeException e3) {
                    log.error((Throwable)e3);
                    throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u811a\u672c\u89e3\u6790\u51fa\u9519\uff1a%s", (String)"ComputingEngine_2", (String)"fi-bcm-computing", (Object[])new Object[0]), new Object[]{e3}), e3);
                }
                catch (ArrayIndexOutOfBoundsException e5) {
                    log.error((Throwable)e5);
                    if (e5.getStackTrace() != null && e5.getStackTrace().length > 1 && e5.getStackTrace()[1].getMethodName().equals("matchMethodInfo")) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u6216\u65b9\u6cd5\u7f3a\u5c11\u53c2\u6570\u3002", (String)"ComputingEngine_6", (String)"fi-bcm-computing", (Object[])new Object[0]));
                    }
                    throw new RuntimeException(e5);
                }
                catch (Exception e4) {
                    log.error((Throwable)e4);
                    throw new RuntimeException(String.format(ResManager.loadKDString((String)"OLAP \u64cd\u4f5c\u5931\u8d25\uff0c%s", (String)"ComputingEngine_3", (String)"fi-bcm-computing", (Object[])new Object[0]), e4.getMessage()), e4);
                }
            }
            catch (Throwable throwable) {
                executor.end();
                KContextEnv.exit();
                String script2 = args.get("ruleid") != null ? BizRuleServiceHelper.getBizRuleBaseInfo((long)Long.parseLong(args.get("ruleid").toString())) : script;
                log.info(String.format("%s,\u6267\u884c\u811a\u672c[%s],%s\u8017\u65f6", ThreadLocalFactory.getThreadLocalOprt(), script2, args));
                throw throwable;
            }
        }
        executor.end();
        KContextEnv.exit();
        String script2 = args.get("ruleid") != null ? BizRuleServiceHelper.getBizRuleBaseInfo((long)Long.parseLong(args.get("ruleid").toString())) : script;
        log.info(String.format("%s,\u6267\u884c\u811a\u672c[%s],%s\u8017\u65f6", ThreadLocalFactory.getThreadLocalOprt(), script2, args));
        return (T)object;
    }

    private String getRuleName(Map<String, Object> args) {
        return args.get("ruleid") != null ? BizRuleServiceHelper.getBizRuleName((long)Long.parseLong((String)args.get("ruleid"))) + ".js" : "main.js";
    }
}

