/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class Int32EnumTypeFactory {
    private int _bitStart = 0;
    private static final String TrueString = "true";
    private static final String FalseString = "false";

    private int getNeedBitCount(int maxValue) {
        if (maxValue == 0) {
            return 0;
        }
        int tmp = 1;
        for (int i = 1; i <= 30; ++i) {
            if ((tmp *= 2) < maxValue) continue;
            return i;
        }
        throw new RuntimeException(String.format("too long data.%d", maxValue));
    }

    public EnumType create(String enumTypeName, String[] items) {
        int bitCount = this.getNeedBitCount(items.length);
        if (this._bitStart + bitCount > 32) {
            throw new RuntimeException("more enum items.");
        }
        HashSet<String> dict = new HashSet<String>();
        for (String item : items) {
            if (item.isEmpty()) {
                throw new RuntimeException("item is empty");
            }
            if (dict.add(item.toUpperCase(Locale.ENGLISH))) continue;
            throw new RuntimeException("Duplicate enum value");
        }
        EnumItem[] itemsObject = new EnumItem[items.length];
        for (int i = 0; i < items.length; ++i) {
            itemsObject[i] = new EnumItem(items[i], i);
        }
        EnumType result = new EnumType(enumTypeName, this._bitStart, bitCount, itemsObject);
        this._bitStart += bitCount;
        return result;
    }

    public EnumType createBoolType(String typeName) {
        return this.create(typeName, new String[]{TrueString, FalseString});
    }

    public static class EnumType
    implements Iterable<EnumItem> {
        private final int mask;
        private final int mask2;
        private final EnumItem[] items;
        private final String name;
        private final int bitStart;
        private final int bitCount;

        public final String getName() {
            return this.name;
        }

        public EnumType(String name, int bitStart, int bitCount, EnumItem[] items) {
            this.name = name;
            this.bitStart = bitStart;
            this.bitCount = bitCount;
            this.items = items;
            this.mask = bitCount == 32 ? -1 : (1 << this.bitCount) - 1;
            this.mask2 = ~(this.mask << this.bitStart);
        }

        public final EnumItem get(int index) {
            return this.items[index];
        }

        public final EnumItem getValueWithNull(int state) {
            if (this.bitCount == 0) {
                return null;
            }
            return this.getValue(state);
        }

        public final EnumItem getValue(int state) {
            if (this.bitCount <= 0) {
                throw new IllegalArgumentException("Failed requirement.");
            }
            int index = state >>> this.bitStart & this.mask;
            return this.items[index];
        }

        public final int setValue(int state, EnumItem value) {
            int index = value.getIndex() << this.bitStart;
            return state & this.mask2 | index;
        }

        public String toString() {
            return this.name;
        }

        @Override
        @NotNull
        public Iterator<EnumItem> iterator() {
            return Arrays.asList(this.items).iterator();
        }
    }

    public static class EnumItem {
        private final String name;
        private final int index;

        public final String getName() {
            return this.name;
        }

        public final int getIndex() {
            return this.index;
        }

        public EnumItem(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof EnumItem) {
                return this == other;
            }
            if (other instanceof String) {
                return this.name == other || this.name.equalsIgnoreCase(other.toString());
            }
            if (other instanceof Boolean) {
                return this.name == Int32EnumTypeFactory.TrueString && (Boolean)other != false;
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

