/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing;

import java.util.Comparator;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.mozilla.javascript.WrappedException;

public class LambdaParser {
    private static final Pattern DIMENSION_COMPOSITION_START = Pattern.compile("(?!\")[_a-zA-Z][_a-zA-Z0-9]*@[-a-zA-Z0-9_.]+,?");
    private static final Pattern DIMENSION_COMPOSITION_END_1 = Pattern.compile("(?!\")[_a-zA-Z][_a-zA-Z0-9]*@[-a-zA-Z0-9_.]+(?=\\s*[+\\-*/:?)])");
    private static final Pattern DIMENSION_COMPOSITION_END_2 = Pattern.compile("(?!\")[_a-zA-Z][_a-zA-Z0-9]*@[-a-zA-Z0-9_.]+\\s*$");
    private static final Pattern PATTERN = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*@[-a-zA-Z0-9_.]+,?\\s*");

    public static Pair<String, String> parseExpression(String expression) {
        String value = expression.trim();
        if (LambdaParser.startCheck(value, "value(") || LambdaParser.startCheck(value, "v(") || LambdaParser.startCheck(value, "V(")) {
            return LambdaParser.valueParse(value);
        }
        return LambdaParser.stringParse(value);
    }

    private static boolean startCheck(String data, String startString) {
        int i = 0;
        for (char c : startString.toCharArray()) {
            if (i >= data.length()) {
                return false;
            }
            if (data.charAt(i) <= ' ') {
                ++i;
                continue;
            }
            if (c != data.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Pair<String, String> stringParse(String expression) {
        String[] leftAndRight = expression.split("=", 2);
        if (leftAndRight.length < 2) {
            throw new WrappedException((Throwable)new RuntimeException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f(%s)\u7f3a\u5c11\u7b49\u53f7\u3002", (String)"LambdaParser_4", (String)"fi-bcm-computing", (Object[])new Object[0]), expression)));
        }
        String left = leftAndRight[0].trim();
        String right = leftAndRight[1].trim();
        if (StringUtils.isEmpty((CharSequence)left) || StringUtils.isEmpty((CharSequence)right)) {
            throw new WrappedException((Throwable)new RuntimeException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f(%s)\u7b49\u53f7\u4e24\u8fb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LambdaParser_5", (String)"fi-bcm-computing", (Object[])new Object[0]), expression)));
        }
        Matcher matcher = PATTERN.matcher(left);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            sb.append(matcher.group());
        }
        if (!left.equals(sb.toString())) {
            throw new WrappedException((Throwable)new RuntimeException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f(%s)\u7b49\u53f7\u7684\u5de6\u8fb9\u5e94\u7b26\u5408\u8981\u6c42\uff1a\u201c\u7ef4\u5ea6\u7f16\u7801@\u7ef4\u5ea6\u6210\u5458\u201d\u3002", (String)"LambdaParser_1", (String)"fi-bcm-computing", (Object[])new Object[0]), expression)));
        }
        right = LambdaParser.wrapFunction(right);
        return Pair.of((Object)left.trim(), (Object)right.trim());
    }

    private static String wrapFunction(String right) {
        Matcher matcherEnd1 = DIMENSION_COMPOSITION_END_1.matcher(right);
        Matcher matcherEnd2 = DIMENSION_COMPOSITION_END_2.matcher(right);
        Matcher matcherStart = DIMENSION_COMPOSITION_START.matcher(right);
        TreeSet<String> dimensionComposition = new TreeSet<String>(Comparator.comparing(String::toString).reversed());
        StringBuilder dimensionString = new StringBuilder();
        int cursor = 0;
        cursor = LambdaParser.findDimensionComposition(matcherEnd1, matcherStart, dimensionComposition, dimensionString, cursor);
        LambdaParser.findDimensionComposition(matcherEnd2, matcherStart, dimensionComposition, dimensionString, cursor);
        int index = 0;
        for (String d : dimensionComposition) {
            right = right.replace(d, String.format("{{index_%s}}", index++));
        }
        index = 0;
        for (String d : dimensionComposition) {
            right = right.replace(String.format("{{index_%s}}", index++), String.format("v(\"%s\")", d));
        }
        return right;
    }

    private static int findDimensionComposition(Matcher matcherEnd, Matcher matcherStart, Set<String> dimensionComposition, StringBuilder dimensionString, int cursor) {
        while (matcherEnd.find()) {
            dimensionString.setLength(0);
            String group = matcherEnd.group();
            matcherStart.region(cursor, matcherEnd.start());
            cursor = matcherEnd.end();
            while (matcherStart.find()) {
                dimensionString.append(matcherStart.group());
            }
            dimensionString.append(group);
            dimensionComposition.add(dimensionString.toString());
        }
        return cursor;
    }

    private static Pair<String, String> valueParse(String expression) {
        char temp;
        int i;
        StringBuilder builder = new StringBuilder();
        Stack<Character> stack = new Stack<Character>();
        for (i = 0; i < expression.length(); ++i) {
            temp = expression.charAt(i);
            if (temp != '(') continue;
            stack.push(Character.valueOf(expression.charAt(i)));
            ++i;
            break;
        }
        int errorFlg = -1;
        while (i < expression.length() && errorFlg <= 0) {
            temp = expression.charAt(i);
            if (stack.empty()) {
                if (temp == '=') break;
                if (temp >= '!' && temp <= '~') {
                    errorFlg = 4;
                    break;
                }
            }
            if (temp == '\'') {
                if (((Character)stack.lastElement()).charValue() == expression.charAt(i)) {
                    stack.pop();
                    ++errorFlg;
                } else {
                    stack.push(Character.valueOf(expression.charAt(i)));
                }
            } else if (temp == ')') {
                if (((Character)stack.lastElement()).charValue() == '(') {
                    stack.pop();
                } else if (((Character)stack.lastElement()).charValue() != '\'') {
                    errorFlg = 2;
                    break;
                }
            } else if (temp >= '!' && temp <= '~' && ((Character)stack.lastElement()).charValue() != '\'') {
                errorFlg = 3;
                break;
            }
            builder.append(expression.charAt(i));
            ++i;
        }
        String left = builder.toString();
        if ((left = left.trim()).endsWith(")")) {
            left = left.substring(0, left.length() - 1).trim();
        }
        if (left.startsWith("'")) {
            left = left.substring(1);
        }
        if (left.endsWith("'")) {
            left = left.substring(0, left.length() - 1);
        }
        if (errorFlg > 0 || i >= expression.length() - 1) {
            throw new WrappedException((Throwable)new RuntimeException(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8868\u8fbe\u5f0f\u201c%s\u201d\u5931\u8d25\uff0c\u8868\u8fbe\u5f0f\u7b49\u53f7\u5de6\u8fb9\u5e94\u7b26\u5408\uff1avalue('a,b,...,c')\u6216\u8005 v('a,b,...,c')\u4e14a\u3001b\u3001c\u5747\u4e0d\u80fd\u542b\u6709\u5355\u5f15\u53f7\u3002", (String)"LambdaParser_2", (String)"fi-bcm-computing", (Object[])new Object[0]), expression)));
        }
        String right = expression.substring(i + 1);
        return Pair.of((Object)left, (Object)right.trim());
    }
}

