/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.InvokeUtils;
import kd.fi.bcm.computing.ScriptMember;
import kd.fi.bcm.computing.datasource.OutlineNode;

public class ScopeInfo {
    private final Collection<DimensionFilterItem> filters;
    private final Set<String> excludeFilterSet = new HashSet<String>(1);
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(MemberReader.class);
    private String modelNum;

    public ScopeInfo() {
        this.filters = new ArrayList<DimensionFilterItem>();
    }

    public Set<String> getExcludeFilterSet() {
        return this.excludeFilterSet;
    }

    public ScopeInfo(Collection<DimensionFilterItem> filters) {
        this.filters = filters;
    }

    public final Collection<DimensionFilterItem> getFilters() {
        return this.filters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ScopeInfo{");
        StringJoiner sj = new StringJoiner(",");
        if (this.filters != null) {
            this.filters.forEach(f -> sj.add(String.format("%s:[%s]", f.getName(), String.join((CharSequence)",", f.getValues()))));
        }
        sb.append(sj).append('}');
        return sb.toString();
    }

    @Deprecated
    private ScopeInfo and(ScopeInfo ... scopes) {
        HashMap<String, Set<String>> tempMap = new HashMap<String, Set<String>>();
        for (DimensionFilterItem filter : this.filters) {
            List values = filter.getValues();
            if (values.isEmpty()) continue;
            HashSet filterValues = new HashSet(values);
            tempMap.put(filter.getName(), filterValues);
        }
        this.mergeScope(scopes, tempMap);
        ArrayList<DimensionFilterItem> tempFilter = new ArrayList<DimensionFilterItem>(tempMap.size());
        for (Map.Entry entry : tempMap.entrySet()) {
            DimensionFilterItem filterItem = new DimensionFilterItem();
            filterItem.setName((String)entry.getKey());
            Set values = (Set)entry.getValue();
            ArrayList newValues = new ArrayList();
            values.forEach(e -> {
                if (StringUtils.isNotEmpty((String)e)) {
                    newValues.add(e);
                }
            });
            filterItem.addAllValues(newValues);
            tempFilter.add(filterItem);
        }
        return new ScopeInfo(tempFilter);
    }

    private void mergeScope(ScopeInfo[] scopes, Map<String, Set<String>> tempMap) {
        for (ScopeInfo scope : scopes) {
            for (DimensionFilterItem filter : scope.getFilters()) {
                String dimName = filter.getName();
                Set<String> filterValues = tempMap.get(dimName);
                if (filterValues == null) {
                    filterValues = new HashSet<String>();
                }
                filterValues.addAll(filter.getValues());
                tempMap.put(dimName, filterValues);
            }
        }
    }

    public ScopeInfo and(Object ... anys) {
        return this.scope(anys);
    }

    public ScopeInfo scope(Object ... anys) {
        HashMap<String, Set<String>> tempMap = new HashMap<String, Set<String>>(16);
        if (anys.length == 1 && anys[0] instanceof Object[]) {
            Object items = anys[0];
            ScopeInfo.merge(new Object[]{items}, tempMap);
        } else {
            ScopeInfo.merge(anys, tempMap);
        }
        ArrayList<DimensionFilterItem> tempFilter = new ArrayList<DimensionFilterItem>(tempMap.size());
        for (DimensionFilterItem dimensionFilterItem : this.filters) {
            DimensionFilterItem filterItem;
            Set otherFilter = (Set)tempMap.get(dimensionFilterItem.getName());
            if (otherFilter == null) {
                filterItem = new DimensionFilterItem(dimensionFilterItem.getName(), new ArrayList(dimensionFilterItem.getValues()));
            } else {
                otherFilter.addAll(dimensionFilterItem.getValues());
                filterItem = new DimensionFilterItem(dimensionFilterItem.getName(), new ArrayList(otherFilter));
                tempMap.remove(filterItem.getName());
            }
            tempFilter.add(filterItem);
        }
        for (Map.Entry entry : tempMap.entrySet()) {
            tempFilter.add(new DimensionFilterItem((String)entry.getKey(), new ArrayList((Collection)entry.getValue())));
        }
        return new ScopeInfo(tempFilter);
    }

    public void setModelNum(String modelNum) {
        this.modelNum = modelNum;
    }

    public ScopeInfo except(Object ... anys) {
        HashMap<String, Set<String>> exceptMap = new HashMap<String, Set<String>>(16);
        if (anys.length == 1 && anys[0] instanceof Object[]) {
            Object items = anys[0];
            ScopeInfo.merge(new Object[]{items}, exceptMap);
        } else {
            ScopeInfo.merge(anys, exceptMap);
        }
        for (Map.Entry filter : exceptMap.entrySet()) {
            DimensionFilterItem inFilter = null;
            HashSet src = new HashSet((Collection)filter.getValue());
            for (DimensionFilterItem in : this.getFilters()) {
                if (!in.getName().equals(filter.getKey())) continue;
                inFilter = in;
                HashSet tar = new HashSet(in.getValues());
                tar.removeAll(src);
                inFilter.setValues(new ArrayList(tar));
                in.setValues(new ArrayList(tar));
                break;
            }
            if (inFilter != null) continue;
            Collection nodes = MemberReader.getAllNodeByDimNum((String)((String)filter.getKey()), (String)this.modelNum);
            DimensionFilterItem item = new DimensionFilterItem();
            ArrayList<String> values = new ArrayList<String>();
            for (IDNumberTreeNode node : nodes) {
                if (src.contains(node.getNumber())) continue;
                values.add(node.getNumber());
            }
            item.setName((String)filter.getKey());
            item.getValues().addAll(values);
            this.filters.add(item);
        }
        return this;
    }

    private static void merge(Object[] anys, Map<String, Set<String>> tempMap) {
        for (Object any : anys) {
            if (any instanceof ScriptMember) {
                ScopeInfo.mergeWithScriptMember(tempMap, any);
                continue;
            }
            if (any instanceof ScopeInfo) {
                ScopeInfo.mergeWithScopeInfo(tempMap, any);
                continue;
            }
            if (any instanceof String) {
                ScopeInfo.mergeWithString(tempMap, any);
                continue;
            }
            if (any instanceof List) {
                ScopeInfo.mergeWithList(tempMap, any);
                continue;
            }
            if (any instanceof Object[]) {
                ScopeInfo.merge((Object[])any, tempMap);
                continue;
            }
            log.error(String.format(ResManager.loadKDString((String)"\u6784\u9020\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u65f6\uff0c\u4f7f\u7528\u4e86\u65e0\u6cd5\u8bc6\u522b\u7684\u7c7b\u578b\uff1a%s\u3002", (String)"ScopeInfo_0", (String)"fi-bcm-computing", (Object[])new Object[0]), any == null ? null : any.getClass()));
        }
    }

    private static void mergeWithList(Map<String, Set<String>> tempMap, Object any) {
        for (Object obj : (List)any) {
            if (obj instanceof OutlineNode) {
                Set members = tempMap.computeIfAbsent(((OutlineNode)obj).getDimension(), k -> new HashSet(16));
                members.add(((OutlineNode)obj).getNumber());
                continue;
            }
            if (obj instanceof ScriptMember) {
                ScopeInfo.mergeWithScriptMember(tempMap, any);
                continue;
            }
            if (obj instanceof Object[]) {
                ScopeInfo.merge((Object[])obj, tempMap);
                continue;
            }
            if (obj instanceof List) {
                ScopeInfo.merge(((List)obj).toArray(), tempMap);
                continue;
            }
            throw new BizRuleException("params error");
        }
    }

    private static void mergeWithScriptMember(Map<String, Set<String>> tempMap, Object any) {
        Set members = tempMap.computeIfAbsent(((ScriptMember)any).getDimension().getNumber(), k -> new HashSet(16));
        members.add(((ScriptMember)any).getNumber());
    }

    private static void mergeWithScopeInfo(Map<String, Set<String>> tempMap, Object any) {
        for (DimensionFilterItem filter : ((ScopeInfo)any).getFilters()) {
            List values = filter.getValues();
            String dimName = filter.getName();
            Set<String> members = tempMap.get(dimName);
            if (members == null) {
                tempMap.put(dimName, new HashSet(values));
                continue;
            }
            members.addAll(values);
        }
    }

    private static void mergeWithString(Map<String, Set<String>> tempMap, Object any) {
        int beforeIndex = ((String)any).indexOf(91);
        int afterIndex = ((String)any).indexOf(93);
        if (beforeIndex < 0 || afterIndex < 0) {
            throw new RuntimeException("the format of string: " + any + " is unSupport");
        }
        String dimName = ((String)any).substring(0, beforeIndex).trim();
        String subStr = ((String)any).substring(beforeIndex + 1, afterIndex).trim();
        String[] array = subStr.split(",");
        Set members = tempMap.computeIfAbsent(dimName, k -> new HashSet(16));
        members.addAll(Arrays.asList(array));
    }

    public static boolean instance(Object arg) {
        return arg instanceof ScopeInfo;
    }

    public static ScopeInfo create(Object ... scopeInfo) {
        ScopeInfo newScopeInfo = new ScopeInfo();
        newScopeInfo = newScopeInfo.scope(scopeInfo);
        return newScopeInfo;
    }

    public static ScopeInfo mergeReduce(ScopeInfo ... infos) {
        ScopeInfo newScope = new ScopeInfo();
        for (ScopeInfo s : infos) {
            ScopeInfo.mergeReduceFilter(newScope, s);
        }
        return newScope;
    }

    public static ScopeInfo doMergeReduce(ScopeInfo scope1, ScopeInfo scope2, boolean isReturnNewScope) {
        if (isReturnNewScope) {
            ScopeInfo newScope = new ScopeInfo();
            ScopeInfo.mergeReduceFilter(newScope, scope1);
            ScopeInfo.mergeReduceFilter(newScope, scope2);
            return newScope;
        }
        ScopeInfo.mergeReduceFilter(scope1, scope2);
        return scope1;
    }

    private static void mergeReduceFilter(ScopeInfo scope1, ScopeInfo scope2) {
        Collection<DimensionFilterItem> filters1 = scope1.getFilters();
        Collection<DimensionFilterItem> filters2 = scope2.getFilters();
        HashSet dimNames = new HashSet(filters1.size());
        filters1.forEach(f -> dimNames.add(f.getName()));
        filters2.forEach(f -> {
            if (!dimNames.contains(f.getName())) {
                filters1.add(new DimensionFilterItem(f.getName(), f.getValues()));
            }
        });
    }

    public ScopeInfo exclude(String dimNum) {
        this.excludeFilterSet.add(dimNum);
        return this;
    }

    public static ScopeInfo mergeScope(String scopeExpr, ScopeInfo baseScope, String modelNum) {
        ScopeInfo scope1 = ScopeInfo.parserScopeExpr(scopeExpr, modelNum);
        return ScopeInfo.mergeReduce(scope1, baseScope);
    }

    public static ScopeInfo parserScopeExpr(String scopeExpr, String modelNum) {
        Map map = (Map)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"parseDimStr", (Object[])new Object[]{modelNum, scopeExpr});
        ScopeInfo scope = new ScopeInfo();
        map.forEach((key, val) -> scope.getFilters().add(new DimensionFilterItem(key, Collections.singletonList(val))));
        return scope;
    }
}

