/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.BatchCommandInfo;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.ComputingCommandInfo;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.FelLambdaExpressionItem;
import kd.bos.olap.dataSources.Level;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataWriter;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.olap.metadata.IMetadataBuilder;
import kd.bos.olap.metadata.StringMetadataBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.script.ScriptFunction;
import kd.bos.script.ScriptObject;
import kd.bos.script.annotations.KSMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.bizrule.BizRuleServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.msservice.param.ConvertParam;
import kd.fi.bcm.common.msservice.param.MergeControlParam;
import kd.fi.bcm.common.trace.OlapComTraceUtil;
import kd.fi.bcm.common.util.InvokeUtils;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.OlapMeasureHandleUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ToStringHelper;
import kd.fi.bcm.computing.ComputingContext;
import kd.fi.bcm.computing.LambdaParser;
import kd.fi.bcm.computing.ScopeInfo;
import kd.fi.bcm.computing.ScriptDimension;
import kd.fi.bcm.computing.ScriptFactorList;
import kd.fi.bcm.computing.ScriptMember;
import kd.fi.bcm.computing.XDMScopeInfo;
import kd.fi.bcm.computing.bizabout.AboutFormulaServer;
import kd.fi.bcm.computing.bizabout.cach.ScriptCache;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import kd.fi.bcm.computing.bizrule.formula.BizRuleInvFormulaHelper;
import kd.fi.bcm.computing.bizrule.formula.BizRuleTranslateFormulaHelper;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.datasource.ScriptAgg;
import kd.fi.bcm.computing.member.ScriptAllMemberExtDimensionNode;
import kd.fi.bcm.computing.member.ScriptCellSet;
import kd.fi.bcm.computing.member.ScriptMemberPeriodNode;
import kd.fi.bcm.computing.member.ScriptMemberYearNode;
import kd.fi.bcm.computing.model.WhenFilterItem;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.computing.util.EntityVersioningUtil;
import kd.fi.bcm.computing.util.OlapQueryHelper;
import kd.fi.bcm.computing.util.RuleExecuteServiceHelper;
import kd.fi.bcm.computing.util.ScriptBuiltinHelper;
import kd.fi.bcm.computing.util.ScriptDebugLogInfoUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.mozilla.javascript.NativeObject;

public class ScriptBuiltin {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ScriptBuiltin.class);
    public static final String tracer_type = "olap";
    public static final String tracer_type_compute = "olap-compute";
    public static final String audit_name = "olap_cost";
    public static final String tracer_dbroutekey = "route";
    public static final String tracer_parameter = "parameter";
    public static final String tracer_sql = "sql";
    public static final int cellSet_max_count = 100000;
    private final OlapConnection olapConnection;
    private final Map<String, Object> args;
    private final IOutline outline;
    private static Set<String> dims = Sets.newHashSet((Object[])new String[]{PresetConstant.ENTITY_DIM, PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.SCENE_DIM});
    private static Map<String, String> NUM_SHORT_MAP = new HashMap<String, String>(4);
    private static Map<String, String> SHORT_NUM_MAP = new HashMap<String, String>(4);
    private static ScriptCache cache = new ScriptCache();
    private final BatchCommandInfo batchCommands = new BatchCommandInfo();
    private boolean beginBatch = false;
    private static Set<String> ruleDims = Sets.newHashSet((Object[])new String[]{PresetConstant.ENTITY_DIM, PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.SCENE_DIM, PresetConstant.PROCESS_DIM, PresetConstant.CURRENCY_DIM});
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ScriptBuiltin.class);
    public static final List<String> SPECIAL_PROCESS = Arrays.asList("ADJ", "ARPT", "CADJ", "PRPT", "EJE", "CC", "CCADJ", "CCTotal");
    private static final Set<String> PARENT_JOURNAL_BPS = Sets.newHashSet((Object[])new String[]{"ADJ", "CADJ", "EJE", "CCADJ"});
    private static final Set<String> MERGE_JOURNAL_BPS = Sets.newHashSet((Object[])new String[]{"ERAdj", "RAdj", "DADJ", "DEJE"});

    public ScriptBuiltin(OlapConnection olapConnection, Map<String, Object> args, IOutline outline) {
        this.olapConnection = olapConnection;
        this.args = args;
        this.outline = outline;
    }

    public OlapConnection getOlapConnection() {
        return this.olapConnection;
    }

    public Map<String, Object> getArgs() {
        return this.args;
    }

    public IOutline getOutline() {
        return this.outline;
    }

    public String[] createStringArray(int size) {
        return new String[size];
    }

    public void addString(String[] array, int index, String value) {
        array[index] = value;
    }

    public void addString(String[] array, int index, ScriptDimension value) {
        array[index] = value.getNumber();
    }

    public void addString(String[] array, int index, ScriptMember value) {
        array[index] = value.getDimension().getNumber() + value.getNumber();
    }

    public String[] split(String s, String regex) {
        return s.split(regex);
    }

    public Object[] createObjectArray(int size) {
        return new Object[size];
    }

    public ScopeInfo getScopeInfo(Object params) {
        if (params == null) {
            return null;
        }
        if (params instanceof ScopeInfo) {
            return (ScopeInfo)params;
        }
        if (params.getClass().isArray() && ((Object[])params).length > 0 && ((Object[])params)[0] instanceof ScopeInfo) {
            Object[] args = (Object[])params;
            return (ScopeInfo)args[0];
        }
        return null;
    }

    public Object[] transParamsWithScope(Object params) {
        if (params == null) {
            return new Object[]{this.outline.getComputingContext().getRuntimeScope(null)};
        }
        if (params instanceof ScopeInfo) {
            return new Object[]{this.outline.getComputingContext().getRuntimeScope((ScopeInfo)params)};
        }
        if (params.getClass().isArray()) {
            Object[] args = (Object[])params;
            ArrayList<Object> trans = new ArrayList<Object>(args.length);
            for (Object o : args) {
                if (o instanceof ScopeInfo) {
                    trans.add(this.outline.getComputingContext().getRuntimeScope((ScopeInfo)o));
                    continue;
                }
                if (o != null && o.getClass().isArray()) {
                    Collections.addAll(trans, (Object[])o);
                    continue;
                }
                if (o instanceof Collection) {
                    trans.addAll((Collection)o);
                    continue;
                }
                trans.add(o);
            }
            if (!trans.isEmpty() && !(trans.get(0) instanceof ScopeInfo)) {
                trans.add(0, this.outline.getComputingContext().getRuntimeScope(null));
            }
            return trans.toArray();
        }
        return new Object[]{this.outline.getComputingContext().getRuntimeScope(null), params};
    }

    @KSMethod
    public void computeSerial(String engineType, String mainDimension, ScopeInfo scopeInfo, String ... expressions) {
        this.sendComputingComand(engineType, mainDimension, scopeInfo, expressions, false);
    }

    private void sendComputingComand(String engineType, String mainDimension, ScopeInfo scopeInfo, String[] expressions, boolean isXSyn) {
        Objects.requireNonNull(expressions);
        if (StringUtils.isEmpty((String)engineType)) {
            engineType = "fel";
        }
        ComputingContext computingContext = this.outline.getComputingContext();
        computingContext.checkHasModifiedGlobalScopeInfo(scopeInfo);
        computingContext.verifyCanExecuteRule();
        BatchCommandInfo commands = this.beginBatch ? this.batchCommands : new BatchCommandInfo();
        this.handleProcess(scopeInfo);
        expressions = this.replaceVirtualMem(expressions);
        ComputingCommandInfo command = null;
        FelLambdaExpressionItem item = null;
        for (String expression : expressions) {
            command = new ComputingCommandInfo();
            command.setFilter((List)scopeInfo.getFilters());
            command.setMainDimName(mainDimension);
            command.setMainMeaName("FMONEY");
            item = new FelLambdaExpressionItem();
            Pair<String, String> pair = LambdaParser.parseExpression(expression);
            item.setExpressLeft((String)pair.getLeft());
            item.setExpression(computingContext.joinRound((String)pair.getRight()));
            command.getExpressionItems().add(item);
            if (isXSyn) {
                OlapCommandUtil.addSourceMeasure((String)this.outline.getModelNum(), (CommandInfo)command, (Integer)OlapSourceEnum.X1.getType());
            } else {
                OlapCommandUtil.addSourceMeasure((String)this.outline.getModelNum(), (CommandInfo)command, this.args.get("ruleInternal") instanceof Integer ? (Integer)this.args.get("ruleInternal") : null);
            }
            Level level = new Level();
            level.addCommand((CommandInfo)command);
            commands.addLevel(level);
        }
        if (!this.beginBatch) {
            this.executeOlapCommand((CommandInfo)commands);
        }
        this.submitOlapCommand();
        this.logIgnoreVerifyCommand(computingContext, scopeInfo, expressions);
    }

    @KSMethod
    public void compute(String engineType, String mainDimension, ScopeInfo scopeInfo, String ... expressions) {
        if (StringUtils.isEmpty((String)engineType)) {
            engineType = "fel";
        }
        ComputingContext computingContext = this.outline.getComputingContext();
        computingContext.checkHasModifiedGlobalScopeInfo(scopeInfo);
        computingContext.verifyCanExecuteRule();
        ComputingCommandInfo command = new ComputingCommandInfo();
        this.handleProcess(scopeInfo);
        command.setFilter((List)scopeInfo.getFilters());
        command.setMainDimName(mainDimension);
        if (this.args.get("FLOCK") != null) {
            command.setMainMeaName("FLOCK");
        } else {
            command.setMainMeaName("FMONEY");
        }
        Integer type = this.args.get("ruleInternal") == null ? (this.args.get("sourceType") instanceof Integer ? (Integer)this.args.get("sourceType") : null) : (Integer)this.args.get("ruleInternal");
        OlapCommandUtil.addSourceMeasure((String)this.outline.getModelNum(), (CommandInfo)command, (Integer)type);
        for (String expression : expressions) {
            FelLambdaExpressionItem item = new FelLambdaExpressionItem();
            Pair<String, String> pair = LambdaParser.parseExpression(expression);
            item.setExpressLeft((String)pair.getLeft());
            item.setExpression(computingContext.joinRound((String)pair.getRight()));
            command.getExpressionItems().add(item);
        }
        if (this.beginBatch) {
            Level level = new Level();
            level.addCommand((CommandInfo)command);
            this.batchCommands.addLevel(level);
        } else {
            this.executeOlapCommand((CommandInfo)command);
        }
        this.submitOlapCommand();
        this.logIgnoreVerifyCommand(computingContext, scopeInfo, expressions);
    }

    private void executeOlapCommand(CommandInfo command) {
        try (TraceSpan ts = Tracer.create((String)tracer_type_compute, (String)tracer_type_compute);){
            OlapCommand cmd = new OlapCommand(this.olapConnection, command);
            OlapComTraceUtil.setTraceId((CommandInfo)command);
            cmd.executeNonQuery();
        }
    }

    private void logIgnoreVerifyCommand(ComputingContext computingContext, ScopeInfo scopeInfo, String ... expressions) {
        if (computingContext.isIgnoreVerify()) {
            log.warn("ignore biz rule verify warn;runScope-->" + scopeInfo.toString() + ";runExprs-->" + Arrays.toString(expressions));
        }
    }

    private void submitOlapCommand() {
        if (this.beginBatch && this.batchCommands.getLevels().size() >= 512) {
            this.batchExecuteComputingCommand();
        }
    }

    private void handleProcess(ScopeInfo scope) {
        if (scope != null) {
            scope.getFilters().forEach(f -> {
                if (f.getName().equals(PresetConstant.PROCESS_DIM)) {
                    f.getValues().replaceAll(e -> {
                        if ("EIRpt".equals(e)) {
                            return "IRpt";
                        }
                        if ("ERAdj".equals(e)) {
                            return "RAdj";
                        }
                        return e;
                    });
                }
            });
        }
    }

    private String handleProcess(String expression) {
        expression = expression.replaceAll("@EIRpt", "@IRpt");
        expression = expression.replaceAll("@ERAdj", "@RAdj");
        return expression;
    }

    @KSMethod
    public void agg(ScopeInfo scopeInfo, String ... memberNames) {
        ScriptAgg scriptAgg = new ScriptAgg(this.olapConnection, this.outline);
        scriptAgg.agg(scopeInfo, memberNames);
    }

    @KSMethod
    public ScopeInfo create(Object ... scopeInfo) {
        ScopeInfo info = ScopeInfo.create(scopeInfo);
        info.setModelNum(this.outline.getModelNum());
        return info;
    }

    @KSMethod
    public XDMScopeInfo XDMScope(Object[] scopeInfo) {
        XDMScopeInfo info = XDMScopeInfo.create(scopeInfo);
        info.setModelNum(this.outline.getModelNum());
        return info;
    }

    @KSMethod
    public ScopeInfo mergeScope(ScopeInfo scope, ScopeInfo pageIncomeScope, String expression) {
        ScopeInfo newScope = new ScopeInfo();
        newScope.getFilters().addAll(scope.getFilters());
        if (pageIncomeScope != null) {
            Collection<DimensionFilterItem> filters = pageIncomeScope.getFilters();
            for (DimensionFilterItem filterItem : filters) {
                boolean match;
                String dimNumber = filterItem.getName();
                if (expression.contains(dimNumber + ".") || expression.contains(dimNumber + "@") || (match = scope.getFilters().stream().map(DimensionFilterItem::getName).anyMatch(name -> name.equals(dimNumber)))) continue;
                DimensionFilterItem item = new DimensionFilterItem();
                item.setName(dimNumber);
                item.getValues().addAll(filterItem.getValues());
                newScope.getFilters().add(item);
            }
        }
        return newScope;
    }

    @KSMethod
    public Object evalOld(ScopeInfo scopeInfo, String expression, Object defValue) {
        scopeInfo = ScopeInfo.mergeScope(expression, scopeInfo, this.outline.getModelNum());
        Map<String, List> map = scopeInfo.getFilters().stream().collect(Collectors.toMap(DimensionFilterItem::getName, DimensionFilterItem::getValues));
        SelectCommandInfo commandInfo = new SelectCommandInfo();
        map.forEach((k, v) -> {
            commandInfo.addDims(new String[]{k});
            commandInfo.addFilter(k, v.toArray(new String[0]));
        });
        commandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        commandInfo.setTop(2);
        List<Map<String, Object>> resultList = OlapQueryHelper.queryData(commandInfo, this.olapConnection);
        if (resultList.size() == 1 && resultList.get(0) != null) {
            Map<String, Object> result = resultList.get(0);
            Object o = result.get(FacTabFieldDefEnum.FIELD_MONEY.getField());
            return o instanceof Number ? new BigDecimal(o.toString()) : (o == null ? defValue : o);
        }
        if (resultList.size() > 1) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"v\u51fd\u6570\u201c%1$s\u201d\u7684\u53d6\u6570\u7ed3\u679c\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u7ec4\u5408\u5b9a\u4e49\u201c%2$s\u201d\u3002", (String)"ScriptBuiltin_5", (String)"fi-bcm-computing", (Object[])new Object[0]), expression, scopeInfo));
        }
        return defValue;
    }

    public Object eval(ScopeInfo scopeInfo, Object defaultValue) {
        ScopeInfo targetScope = this.getTargetScope(scopeInfo);
        Collection<DimensionFilterItem> targetFilters = targetScope.getFilters();
        SelectCommandInfo selectCommandInfo = new SelectCommandInfo();
        targetFilters.forEach(f -> {
            String key = f.getName();
            List values = f.getValues();
            if (values.size() > 1) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"v\u51fd\u6570\u4e2d\u7ef4\u5ea6[%1$s]%2$s", (String)"ScriptBuiltin_6", (String)"fi-bcm-computing", (Object[])new Object[]{"fi-bcm-computing"}), key, targetScope));
            }
            if (values.isEmpty()) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"v\u51fd\u6570\u4e2d\u7ef4\u5ea6[%1$s]%2$s", (String)"ScriptBuiltin_6", (String)"fi-bcm-computing", (Object[])new Object[]{"fi-bcm-computing"}), key, targetScope));
            }
            selectCommandInfo.addFilter(key, values.toArray(new String[0]));
        });
        selectCommandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        List<Map<String, Object>> resultList = OlapQueryHelper.queryData(selectCommandInfo, this.olapConnection);
        if (resultList.size() == 1 && resultList.get(0) != null) {
            Map<String, Object> result = resultList.get(0);
            Object measure = result.get(FacTabFieldDefEnum.FIELD_MONEY.getField());
            if (measure == null) {
                return defaultValue instanceof Number ? new BigDecimal(defaultValue.toString()) : defaultValue;
            }
            if (measure instanceof BigDecimal) {
                return measure;
            }
            return measure instanceof Number ? new BigDecimal(measure.toString()) : measure;
        }
        if (resultList.size() > 1) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"v\u51fd\u6570\u53d6\u6570\u7ed3\u679c\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5scope:%s\u3002", (String)"ScriptBuiltin_7", (String)"fi-bcm-computing", (Object[])new Object[0]), scopeInfo));
        }
        if (defaultValue == null) {
            return null;
        }
        return defaultValue instanceof Number ? new BigDecimal(defaultValue.toString()) : defaultValue;
    }

    @KSMethod
    public Object evalNew(Object[] args) {
        if (args.length > 2) {
            StringJoiner joiner = new StringJoiner(",");
            for (Object arg : args) {
                if (arg == null) continue;
                joiner.add(arg.toString().trim());
            }
            return this.evalOld(this.outline.getComputingContext().getRuntimeScope(null), joiner.toString(), null);
        }
        if (args.length > 0) {
            if (args[0] instanceof String) {
                return this.evalOld(this.outline.getComputingContext().getRuntimeScope(null), args[0].toString(), args.length == 2 ? args[1] : null);
            }
            if (args[0] instanceof ScopeInfo) {
                return this.eval((ScopeInfo)args[0], args.length == 2 ? args[1] : null);
            }
            throw new BizRuleException("params error");
        }
        throw new BizRuleException("params missing");
    }

    @KSMethod
    public Object inv(String dimStr, String typeStr) {
        Map<String, String> scope = BizRuleInvFormulaHelper.checkParamAndSetDefault(this.outline, dimStr, typeStr);
        return BizRuleInvFormulaHelper.getInvValue(this.outline, scope, typeStr);
    }

    private ScopeInfo getTargetScope(ScopeInfo scopeInfo) {
        ScopeInfo fixScope = this.outline.getComputingContext().getRuntimeScope(null);
        Collection<DimensionFilterItem> fixFilters = fixScope.getFilters();
        List fixNames = fixFilters.stream().map(DimensionFilterItem::getName).collect(Collectors.toList());
        Collection<DimensionFilterItem> filters = scopeInfo.getFilters();
        filters.forEach(f -> {
            String key = f.getName();
            if (fixNames.contains(key)) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"FixScope\u5df2\u6307\u5b9a\u7ef4\u5ea6\uff08%s\uff09\uff0c\u8bf7\u68c0\u67e5scope:", (String)"ScriptBuiltin_8", (String)"fi-bcm-computing", (Object[])new Object[0]), key) + scopeInfo);
            }
        });
        ScopeInfo targetScope = ScopeInfo.mergeReduce(scopeInfo, fixScope);
        this.checkIncludeAllDim(targetScope);
        return targetScope;
    }

    private void checkIncludeAllDim(ScopeInfo scope) {
        Collection dimNumbers = MemberReader.getDimensionShortNumber2NumberMap((String)this.outline.getModelNum()).values();
        Collection<DimensionFilterItem> targetFilters = scope.getFilters();
        if (dimNumbers.size() != targetFilters.size()) {
            List targetNames = targetFilters.stream().map(DimensionFilterItem::getName).collect(Collectors.toList());
            dimNumbers.forEach(dimNumber -> {
                if (!targetNames.contains(dimNumber)) {
                    throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6307\u5b9a\u4e0d\u5168\uff0c\u8bf7\u8bbe\u7f6e\u7ef4\u5ea6\u201c%1$s\u201d\u6210\u5458\u503c\uff0c%2$s\u3002", (String)"ScriptBuiltin_9", (String)"fi-bcm-computing", (Object[])new Object[0]), dimNumber, scope));
                }
            });
        }
    }

    public void save(ScopeInfo scopeInfo, Object value) {
        ScopeInfo targetScope = this.getTargetScope(scopeInfo);
        this.doSave(targetScope, value);
    }

    private void doSave(ScopeInfo scopeInfo, Object value) {
        ComputingContext computingContext = this.outline.getComputingContext();
        value = computingContext.executeRound(OlapMeasureHandleUtil.handleMeasure((Object)value));
        computingContext.checkHasModifiedGlobalScopeInfo(scopeInfo);
        this.handleProcess(scopeInfo);
        Collection<DimensionFilterItem> targetFilters = scopeInfo.getFilters();
        ArrayList dims = new ArrayList();
        ArrayList dimMembers = new ArrayList();
        targetFilters.forEach(f -> {
            String key = f.getName();
            List values = f.getValues();
            if (values.size() != 1) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"save\u51fd\u6570\u6307\u5b9a\u7684\u7ef4\u5ea6\u201c%s\u201d\u6210\u5458\u503c\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u7ec4\u5408\u5b9a\u4e49\u3002", (String)"ScriptBuiltin_10", (String)"fi-bcm-computing", (Object[])new Object[0]), key) + scopeInfo);
            }
            dims.add(key);
            dimMembers.add(values.get(0));
        });
        SaveCommandInfo saveCommandInfo = new SaveCommandInfo();
        saveCommandInfo.setDimensions(dims.toArray(new String[0]));
        saveCommandInfo.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        OlapCommand cmd = new OlapCommand(this.olapConnection, (CommandInfo)saveCommandInfo);
        OlapComTraceUtil.setTraceId((CommandInfo)saveCommandInfo);
        OlapCommandUtil.addSourceMeasure((String)computingContext.getOutline().getModelNum(), (CommandInfo)saveCommandInfo, this.args.get("ruleInternal") instanceof Integer ? (Integer)this.args.get("ruleInternal") : null);
        try (OlapDataWriter writer = cmd.CreateWriter();){
            Object[] values = new Object[targetFilters.size() + 1];
            values[0] = value;
            for (int i = 1; i < targetFilters.size() + 1; ++i) {
                values[i] = dimMembers.get(i - 1);
            }
            writer.setValues(values);
            writer.flush();
        }
    }

    public void save(String crossExpress, Object value) {
        ScopeInfo filterScope = ScopeInfo.parserScopeExpr(crossExpress, this.outline.getModelNum());
        filterScope = this.outline.getComputingContext().getRuntimeScope(filterScope);
        this.checkIncludeAllDim(filterScope);
        this.doSave(filterScope, value);
    }

    public ScriptCellSet getCellSet(ScopeInfo scopeInfo, boolean isSelectAll) {
        return this.getCellSet(scopeInfo, isSelectAll, null);
    }

    public ScriptCellSet getCellSet(ScopeInfo scopeInfo, boolean isSelectAll, String isAsc) {
        if (scopeInfo instanceof XDMScopeInfo) {
            throw new BizRuleException(ResManager.loadKDString((String)"getCellSet\u51fd\u6570\u4e0d\u80fd\u53ea\u7528\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u8303\u56f4\u4f5c\u4e3a\u83b7\u53d6\u591a\u7ef4\u6570\u636e\u96c6\u7684\u8303\u56f4\u53c2\u6570\u3002", (String)"ScriptBuiltin_59", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        Map dimShort2NumMap = MemberReader.getDimensionShortNumber2NumberMap((String)this.outline.getModelNum());
        ArrayList<String> selectDims = new ArrayList<String>(dimShort2NumMap.values());
        Collection<DimensionFilterItem> targetFilters = scopeInfo.getFilters();
        ArrayList<DimensionFilterItem> fixDims = new ArrayList<DimensionFilterItem>();
        HashMap<String, Set<String>> memberMap = new HashMap<String, Set<String>>();
        SelectCommandInfo selectCommandInfo = new SelectCommandInfo();
        for (DimensionFilterItem f : targetFilters) {
            String key = f.getName();
            List values = f.getValues();
            int size = values.size();
            if (size > 1) {
                selectCommandInfo.addFilter(key, values.toArray(new String[0]));
                memberMap.put(key, new HashSet(values));
                continue;
            }
            if (size != 1) continue;
            fixDims.add(new DimensionFilterItem(key, values));
            selectDims.remove(key);
            selectCommandInfo.addFilter(key, values.toArray(new String[0]));
        }
        if (selectDims.isEmpty() || isSelectAll) {
            selectDims = new ArrayList(MemberReader.getDimensionShortNumber2NumberMap((String)this.outline.getModelNum()).values());
            fixDims.clear();
            memberMap.clear();
        }
        selectCommandInfo.addDims(selectDims.toArray(new String[0]));
        selectCommandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        OlapCommand olapCommand = new OlapCommand(this.olapConnection, (CommandInfo)selectCommandInfo);
        CellSet cellSet = olapCommand.executeCellSet((IMetadataBuilder)StringMetadataBuilder.INSTANCE);
        if (cellSet.getCount() > 100000) {
            throw new IllegalArgumentException(String.format("getCellSet load data count must less than %d ,but count is %d", 100000, cellSet.getCount()));
        }
        if (isAsc == null) {
            return new ScriptCellSet(this.olapConnection, cellSet, fixDims, selectDims, memberMap, dimShort2NumMap, this.outline.getComputingContext());
        }
        if ("ASC".equals(isAsc)) {
            return new ScriptCellSet(this.olapConnection, cellSet, fixDims, selectDims, memberMap, dimShort2NumMap, this.outline.getComputingContext(), true);
        }
        if ("DESC".equals(isAsc)) {
            return new ScriptCellSet(this.olapConnection, cellSet, fixDims, selectDims, memberMap, dimShort2NumMap, this.outline.getComputingContext(), false);
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6392\u5e8f\u53c2\u6570\u201c%s\u201d,\u6392\u5e8f\u53c2\u6570\u4ec5\u652f\u6301\u201cASC\u201d\u6216\u201cDESC\u201d\u3002", (String)"ScriptBuiltin_34", (String)"fi-bcm-computing", (Object[])new Object[0]), isAsc));
    }

    public ScriptFactorList createScriptFactorList() {
        return new ScriptFactorList();
    }

    public void runRule(ScopeInfo scopeInfo, String ruleNumber) {
        QFilter filter1;
        String modelNum = this.outline.getModelNum();
        DynamicObject doj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id", (QFilter[])new QFilter("number", "=", (Object)modelNum).toArray());
        if (doj == null) {
            return;
        }
        long modelId = doj.getLong("id");
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        DynamicObject rule = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_bizruleentity", (String)"id,status,content", (QFilter[])new QFilter[]{filter, filter1 = new QFilter("number", "=", (Object)ruleNumber)});
        if (rule != null && rule.getInt("status") == 1) {
            String script = rule.getString("content");
            BizRuleExecParam param = new BizRuleExecParam(modelNum);
            scopeInfo.getFilters().forEach(e -> {
                DimTypesEnum typesEnum = DimTypesEnum.getDimTypesEnumByNumber((String)e.getName());
                param.addExternalCommParams(typesEnum.getNumber(), e.getValues().toArray(new String[0]));
            });
            param.addBizRuleList((kd.fi.bcm.common.Pair<Long, String>)kd.fi.bcm.common.Pair.onePair((Object)rule.getLong("id"), (Object)script));
            param.getCommonParam().addAllCommonParamPair(this.outline.getComputingContext().getScopeItems());
            ArrayList<BizRuleExecParam> params = new ArrayList<BizRuleExecParam>();
            params.add(param);
            RuleExecuteServiceHelper.excuteScript4ReportParams(modelNum, params, ApplicationTypeEnum.CM, true);
        }
    }

    public void runConvert(ScopeInfo scopeInfo, String srcCurrency, String targetCurrency) {
        if (srcCurrency.equals(targetCurrency)) {
            return;
        }
        String modelNum = this.outline.getModelNum();
        DynamicObject doj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id", (QFilter[])new QFilter("number", "=", (Object)modelNum).toArray());
        if (doj == null) {
            return;
        }
        kd.fi.bcm.common.Pair model = kd.fi.bcm.common.Pair.onePair((Object)doj.getLong("id"), (Object)modelNum);
        QFilter filter = new QFilter("model", "=", (Object)doj.getLong("id"));
        QFilter targetFilter = new QFilter("number", "=", (Object)targetCurrency);
        DynamicObject targetCurrencyObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_currencymembertree", (String)"id", (QFilter[])new QFilter[]{filter, targetFilter});
        QFilter srcFilter = new QFilter("number", "=", (Object)srcCurrency);
        DynamicObject srcCurrencyObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_currencymembertree", (String)"id", (QFilter[])new QFilter[]{filter, srcFilter});
        kd.fi.bcm.common.Pair cvtCurrency = kd.fi.bcm.common.Pair.onePair((Object)targetCurrencyObj.getLong("id"), (Object)targetCurrency);
        ConvertParam param = new ConvertParam(null, cvtCurrency, model);
        for (DimensionFilterItem item : scopeInfo.getFilters()) {
            String dimNumber = item.getName();
            if (dims.contains(dimNumber)) {
                QFilter filter1 = new QFilter("number", "=", item.getValues().get(0));
                DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)SysDimensionEnum.getEnumByNumber((String)dimNumber).getMemberTreemodel(), (String)"id", (QFilter[])new QFilter[]{filter, filter1});
                param.addFixScope(dimNumber, (String)item.getValues().get(0), Long.valueOf(obj.getLong("id")));
                continue;
            }
            param.addScope(item.getName(), item.getValues().toArray(new String[0]));
        }
        param.addFixScope(PresetConstant.CURRENCY_DIM, srcCurrency, Long.valueOf(srcCurrencyObj.getLong("id")));
        try {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"bcm", (String)"ConvertService", (String)"convert", (Object[])new Object[]{param.toString()});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void runConsolidate(ScopeInfo scopeInfo, NativeObject condition) {
        String modelNum = this.outline.getModelNum();
        DynamicObject doj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id", (QFilter[])new QFilter("number", "=", (Object)modelNum).toArray());
        if (doj == null) {
            return;
        }
        MergeControlParam param = new MergeControlParam();
        param.setModel(doj.getLong("id"), modelNum);
        QFilter filter = new QFilter("model", "=", (Object)doj.getLong("id"));
        for (DimensionFilterItem item : scopeInfo.getFilters()) {
            DimTypesEnum typesEnum = DimTypesEnum.getDimTypesEnumByNumber((String)item.getName());
            if (!dims.contains(typesEnum.getNumber())) continue;
            QFilter filter1 = new QFilter("number", "=", item.getValues().get(0));
            param.addDimension(typesEnum, BusinessDataServiceHelper.loadSingleFromCache((String)SysDimensionEnum.getEnumByNumber((String)typesEnum.getNumber()).getMemberTreemodel(), (String)"id", (QFilter[])new QFilter[]{filter, filter1}).getLong("id"), (String)item.getValues().get(0));
        }
        param.setBooleanValue(((Boolean)condition.get((Object)"calcAll")).booleanValue(), ((Boolean)condition.get((Object)"check")).booleanValue(), ((Boolean)condition.get((Object)"elim")).booleanValue(), ((Boolean)condition.get((Object)"recordShare")).booleanValue());
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"bcm_calcnode", (String)"CslService", (String)"cslCalculateFormBizrule", (Object[])new Object[]{param.toString()});
    }

    public void debug(Object arg) {
        if (!ThreadCache.exists((Object)"all_in_one_thread")) {
            ScriptDebugLogInfoUtil.debug((String)this.args.get("ruleid"), arg);
        }
    }

    public void log(Object arg) {
        ScriptDebugLogInfoUtil.log((String)this.args.get("ruleid"), arg);
    }

    public BigDecimal esp(Object[] args) {
        return new AboutFormulaServer(this.getOutline()).esp(args);
    }

    public BigDecimal getRate(Object[] args) {
        return new AboutFormulaServer(this.getOutline()).getRate(args);
    }

    public void setRate(Object[] args) {
        new AboutFormulaServer(this.getOutline()).setRate(args);
    }

    public void importScriptLib(Object[] args) {
        if (args == null || args.length == 0) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u811a\u672c\u5e93\u53c2\u6570\u5bfc\u5165\u9519\u8bef\u3002", (String)"ScriptBuiltin_11", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        String[] rules = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            rules[i] = args[i].toString();
        }
        String importScript = BizRuleServiceHelper.getImportScript((String)this.outline.getModelNum(), (String[])rules);
        if (StringUtils.isEmpty((String)importScript)) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8981\u516c\u5171\u5e93\u89c4\u5219\u201c%s\u201d\u7684\u5185\u5bb9\u3002", (String)"ScriptBuiltin_12", (String)"fi-bcm-computing", (Object[])new Object[0]), Arrays.toString(args)));
        }
        this.outline.getScriptExecutor().exec(new String[]{importScript});
    }

    public String getConAttr(Object[] args) {
        String result = "";
        DynamicObject structInfo = null;
        if (args == null || args.length == 0 || args.length > 3) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u53c2\u6570\u4f20\u5165\u6709\u8bef", (String)"ScriptBuiltin_13", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        String[] params = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            params[i] = args[i].toString();
        }
        String attrCode = params[0].toLowerCase(Locale.ENGLISH);
        String dimStr = "";
        boolean isNewCT = false;
        if (params.length >= 2) {
            dimStr = params[1];
        }
        if (params.length == 3) {
            isNewCT = Boolean.parseBoolean(params[2]);
        }
        Map<String, Pair<String, Long>> queryParams = this.dealDimStr(dimStr);
        this.supplyQueryParams(queryParams);
        Map<String, Object> structInfoMap = this.getMergeStructInfo(queryParams);
        if ("ds".equals(attrCode)) {
            return (String)structInfoMap.get("ds");
        }
        if ("ct".equals(attrCode)) {
            if (isNewCT) {
                return (String)structInfoMap.get("ct");
            }
            return (String)structInfoMap.get("ctOldCode");
        }
        if (!((Boolean)structInfoMap.get("isParent")).booleanValue()) {
            return "null";
        }
        if (structInfoMap.get("info") == null) {
            return "as".equals(attrCode) ? "Y" : result;
        }
        structInfo = (DynamicObject)structInfoMap.get("info");
        switch (attrCode) {
            case "cm": {
                if (structInfo.getString("mergemethod.number") != null) {
                    result = structInfo.getString("mergemethod.number");
                    break;
                }
                result = "None";
                break;
            }
            case "as": {
                if (structInfo.getBoolean("ismerge")) {
                    result = "Y";
                    break;
                }
                result = "N";
                break;
            }
            case "ud1": {
                String userdefined1 = structInfo.getString("userdefined1");
                if (!StringUtils.isNotEmpty((String)userdefined1)) break;
                result = userdefined1;
                break;
            }
            case "ud2": {
                String userdefined2 = structInfo.getString("userdefined2");
                if (!StringUtils.isNotEmpty((String)userdefined2)) break;
                result = userdefined2;
                break;
            }
            case "ud3": {
                String userdefined3 = structInfo.getString("userdefined3");
                if (!StringUtils.isNotEmpty((String)userdefined3)) break;
                result = userdefined3;
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Object> getMergeStructInfo(Map<String, Pair<String, Long>> queryParams) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        String parentNum = "";
        String currentNum = "";
        if ((Long)queryParams.get(PresetConstant.ENTITY_DIM).getRight() == 0L) {
            String entityStr = (String)queryParams.get(PresetConstant.ENTITY_DIM).getLeft();
            if (!entityStr.contains("_")) throw new RuntimeException("need appoint a parent entity!!!");
            String[] splits = entityStr.split("_");
            if (splits.length > 2) {
                throw new RuntimeException("entity only support parent_child!!!");
            }
            String parent = splits[0];
            currentNum = splits[1];
            QFBuilder range = new QFBuilder("model.number", "=", (Object)this.outline.getModelNum());
            range.add("number", "=", (Object)currentNum).add("parent.number", "=", (Object)parent);
            DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"parent.number", (QFilter[])range.toArray());
            if (dyn == null) {
                map.put("isParent", Boolean.FALSE);
                return map;
            }
            parentNum = dyn.getString("parent.number");
        } else {
            IDNumberTreeNode node = MemberReader.findMemberById((String)this.outline.getModelNum(), (String)"bcm_entitymembertree", (Long)((Long)queryParams.get(PresetConstant.ENTITY_DIM).getRight()));
            if (node.getParent() != null) {
                parentNum = node.getParent().getNumber();
            }
            currentNum = node.getNumber();
        }
        String key = this.outline.getModelNum() + "|" + currentNum + "|" + parentNum + "|" + (String)queryParams.get(PresetConstant.SCENE_DIM).getLeft() + "|" + (String)queryParams.get(PresetConstant.FY_DIM).getLeft() + "|" + (String)queryParams.get(PresetConstant.PERIOD_DIM).getLeft();
        map.put("isParent", Boolean.TRUE);
        String currentNum2 = currentNum;
        String parentNum2 = parentNum;
        Map infoMap = (Map)ThreadCache.get((Object)key, () -> {
            IDNumberTreeNode entityMemberById;
            String fields = "mergemethod.number,ismerge,userdefined1,userdefined2,userdefined3";
            QFBuilder range = new QFBuilder("model.number", "=", (Object)this.outline.getModelNum());
            range.add("orgnumber", "=", (Object)currentNum2);
            range.add("orgpnumber", "=", (Object)parentNum2);
            range.and("scenario.number", "=", ((Pair)queryParams.get(PresetConstant.SCENE_DIM)).getLeft());
            range.and("year.number", "=", ((Pair)queryParams.get(PresetConstant.FY_DIM)).getLeft());
            range.and("period.number", "=", ((Pair)queryParams.get(PresetConstant.PERIOD_DIM)).getLeft());
            DynamicObject info2 = BusinessDataServiceHelper.loadSingle((String)"bcm_mergestructinfo", (String)fields, (QFilter[])range.toArray());
            Long orgId = MemberReader.findEntityMemberByNum((String)this.outline.getModelNum(), (String)(parentNum2 + "_" + currentNum2)).getId();
            Long modelId = MemberReader.findModelIdByNum((String)this.outline.getModelNum());
            Long yearId = MemberReader.findFyMemberByNum((String)this.outline.getModelNum(), (String)((String)((Pair)queryParams.get(PresetConstant.FY_DIM)).getLeft())).getId();
            Long periodId = MemberReader.findPeriodMemberByNum((String)this.outline.getModelNum(), (String)((String)((Pair)queryParams.get(PresetConstant.PERIOD_DIM)).getLeft())).getId();
            Long sceneId = MemberReader.findScenaMemberByNum((String)this.outline.getModelNum(), (String)((String)((Pair)queryParams.get(PresetConstant.SCENE_DIM)).getLeft())).getId();
            HashMap<String, Object> tempMap = new HashMap<String, Object>(3);
            tempMap.put("info", info2);
            DynamicObject orgBizInfo = EntityVersioningUtil.getOrgBizInfo(orgId, modelId, yearId, periodId);
            if (orgBizInfo != null) {
                String changetype = orgBizInfo.getString("bizchangerds.changetype");
                OrgBizChangeTypeEnum orgBizChangeTypeEnum = OrgBizChangeTypeEnum.getEnumByValue4Rule((String)changetype);
                if (orgBizChangeTypeEnum != null && StringUtils.isNotEmpty((String)orgBizChangeTypeEnum.getOldCode())) {
                    tempMap.put("ctOldCode", orgBizChangeTypeEnum.getOldCode());
                } else {
                    tempMap.put("ctOldCode", changetype);
                }
                tempMap.put("ct", changetype);
            }
            if ((entityMemberById = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId)).isShare()) {
                orgId = entityMemberById.getCopyfromId();
            }
            QFBuilder qf = new QFBuilder("org", "=", (Object)orgId);
            qf.add("model", "=", (Object)modelId);
            qf.and("scenario", "=", (Object)sceneId);
            qf.and("year", "=", (Object)yearId);
            qf.and("period", "=", (Object)periodId);
            DynamicObject mergeobj = BusinessDataServiceHelper.loadSingle((String)"bcm_mergesetentity", (String)"mergedatasource", (QFilter[])qf.toArray());
            if (mergeobj != null) {
                tempMap.put("ds", mergeobj.getString("mergedatasource"));
            } else if (orgBizInfo != null && !orgBizInfo.getBoolean("isleaf")) {
                tempMap.put("ds", MergeDataSourceEnum.SIRpt.getIndex());
            } else {
                tempMap.put("ds", "-1");
            }
            return tempMap;
        });
        map.putAll(infoMap);
        return map;
    }

    private void supplyQueryParams(Map<String, Pair<String, Long>> queryParams) {
        Map<String, kd.fi.bcm.common.Pair<Long, String>> scopeItems = ((ComputingContext)this.args.get("ctx")).getScopeItems();
        NUM_SHORT_MAP.forEach((key, value) -> {
            if (queryParams.get(key) == null) {
                queryParams.put((String)key, (Pair<String, Long>)Pair.of((Object)((kd.fi.bcm.common.Pair)scopeItems.get((Object)key)).p2, (Object)((kd.fi.bcm.common.Pair)scopeItems.get((Object)key)).p1));
            }
        });
    }

    private Map<String, Pair<String, Long>> dealDimStr(String dimStr) {
        String[] splits;
        HashMap<String, Pair<String, Long>> memberMap = new HashMap<String, Pair<String, Long>>(4);
        if (StringUtils.isEmpty((String)dimStr)) {
            return memberMap;
        }
        for (String split : splits = dimStr.split(",")) {
            if (split.contains("@")) {
                String[] temps = split.split("@");
                String dim = temps[0];
                String mem = temps[1];
                if (NUM_SHORT_MAP.containsKey(dim)) {
                    memberMap.put(dim, (Pair<String, Long>)Pair.of((Object)mem, (Object)0L));
                    continue;
                }
                String key = SHORT_NUM_MAP.get(dim);
                if (key != null) {
                    memberMap.put(key, (Pair<String, Long>)Pair.of((Object)mem, (Object)0L));
                    continue;
                }
                throw new RuntimeException("only support scenario,year,period,entity!!!");
            }
            throw new RuntimeException("dimension or member missed!!!");
        }
        return memberMap;
    }

    public void setCache(String cacheKey, Object v) {
        cache.setCache(cacheKey, v);
    }

    public Object loadOrCache(String cacheKey, ScriptFunction f) {
        return cache.getCache(cacheKey, f);
    }

    public Object getFromCache(String cacheKey) {
        return cache.getFromCache(cacheKey);
    }

    public void beginBatch() {
        if (this.beginBatch) {
            throw new KDBizException("repead set beginBatch command");
        }
        this.beginBatch = true;
    }

    public void endBatch() {
        if (!this.beginBatch) {
            throw new KDBizException("not set beginBatch command");
        }
        this.batchExecuteComputingCommand();
        this.beginBatch = false;
    }

    private void batchExecuteComputingCommand() {
        if (!this.batchCommands.getLevels().isEmpty()) {
            this.executeOlapCommand((CommandInfo)this.batchCommands);
        }
        this.batchCommands.getLevels().clear();
    }

    public String formatString(Object args) {
        return ToStringHelper.reflectionToString((Object)args);
    }

    @KSMethod
    public void translate(String entCode, String tarCurrency) {
        Map<String, IDNumberTreeNode> dimAndMemMap = BizRuleTranslateFormulaHelper.checkParamAndSetDefault(this.outline, entCode, tarCurrency);
        BizRuleTranslateFormulaHelper.translate(this.outline, dimAndMemMap, entCode, tarCurrency);
    }

    @KSMethod
    public void clear(ScopeInfo scope) {
        String modelNum = this.outline.getModelNum();
        String entity = (String)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM).p2;
        String scenario = (String)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p2;
        String year = (String)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p2;
        String period = (String)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p2;
        String process = (String)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PROCESS_DIM).p2;
        String currency = (String)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.CURRENCY_DIM).p2;
        if (entity != null && year != null && period != null && scenario != null && currency != null && process != null) {
            if (scope != null) {
                scope.getFilters().iterator().forEachRemaining(e -> {
                    if (ruleDims.contains(e.getName())) {
                        throw new IllegalArgumentException(ResManager.loadKDString((String)"scope\u8303\u56f4\u4e0e\u4e0a\u4e0b\u6587\u51b2\u7a81\u3002", (String)"ScriptBuiltin_14", (String)"fi-bcm-computing", (Object[])new Object[0]));
                    }
                    Long memberId = MemberReader.findMemberByNumber((String)modelNum, (String)e.getName(), (String)((String)e.getValues().get(0))).getId();
                    if (memberId == -1L) {
                        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%1$s\u201d\u7684\u6210\u5458\u201c%2$s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539scope\u3002", (String)"ScriptBuiltin_15", (String)"fi-bcm-computing", (Object[])new Object[0]), e.getName(), e.getValues().get(0)));
                    }
                });
            }
            ArrayList errors = new ArrayList(10);
            BatchProcessHelper.handleSync(() -> {
                try {
                    InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.olap.verify.OlapDataCleanServiceHelper", (String)"cleanOlapData", (Object[])new Object[]{modelNum, entity, scenario, year, period, currency, process, scope, this.args.get("ruleInternal")});
                }
                catch (Exception e) {
                    errors.add(e.getMessage());
                }
            });
            if (!errors.isEmpty()) {
                throw new KDBizException((String)errors.get(0));
            }
        }
    }

    @KSMethod
    public String getLastYearEnd() {
        return ScriptBuiltinHelper.getLastYearEnd(this.outline);
    }

    @KSMethod
    public String getEntityLastPeriod(String entity) {
        return ScriptBuiltinHelper.getEntityLastPeriod(this.outline, entity);
    }

    @KSMethod
    public String getAccountLastPeriod(String account) {
        return ScriptBuiltinHelper.getAccountLastPeriod(this.outline, account);
    }

    @KSMethod
    public String getSpecialLastPeriod(String entity, String account) {
        return ScriptBuiltinHelper.getSpecialLastPeriod(this.outline, entity, account);
    }

    @KSMethod
    public String getLastPeriod() {
        String modelNum = this.outline.getModelNum();
        ComputingContext context = this.outline.getComputingContext();
        String periodNum = (String)context.getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p2;
        if ("M_M01".equals(periodNum)) {
            return this.getLastYearEnd();
        }
        String[] lastPeriodIncludeYear = PeriodUtils.getLastPeriodIncludeYear((String)modelNum, (String)((String)context.getScopeItems().get((Object)PresetConstant.FY_DIM).p2), (String)periodNum, (boolean)true);
        if (lastPeriodIncludeYear[0] == null) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u6240\u9009\u8d22\u5e74\u671f\u95f4\u4e3a\u5f53\u524d\u4f53\u7cfb\u7684\u7b2c\u4e00\u4e2a\u8d22\u5e74\u671f\u95f4\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u8d22\u5e74\u671f\u95f4\u540e\u91cd\u8bd5\u3002", (String)"ScriptBuiltin_20", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        return "FY@" + lastPeriodIncludeYear[0] + ",P@" + lastPeriodIncludeYear[1];
    }

    @KSMethod
    public void copy(Object rightExpression, ScopeInfo scope) {
        StringBuilder right;
        FelLambdaExpressionItem item;
        ComputingCommandInfo command;
        if (rightExpression == null || rightExpression instanceof ScopeInfo) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u6765\u6e90\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"ScriptBuiltin_23", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        if (rightExpression instanceof String) {
            List ctxFilters;
            if (StringUtils.isEmpty((String)rightExpression.toString())) {
                throw new BizRuleException(ResManager.loadKDString((String)"copy\u51fd\u6570\u7684\u6765\u6e90\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u4e0e\u5f53\u524d\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u91cd\u590d\uff0c\u4e0d\u53ef\u590d\u5236\u3002", (String)"ScriptBuiltin_21", (String)"fi-bcm-computing", (Object[])new Object[0]));
            }
            HashSet<String> numbers = new HashSet<String>();
            numbers.addAll(Arrays.asList(DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.SCENARIO.getNumber()));
            numbers.addAll(Arrays.asList(DimTypesEnum.ENTITY.getShortNumber(), DimTypesEnum.YEAR.getShortNumber(), DimTypesEnum.PERIOD.getShortNumber(), DimTypesEnum.CURRENCY.getShortNumber(), DimTypesEnum.PROCESS.getShortNumber(), DimTypesEnum.SCENARIO.getShortNumber()));
            Map shortNums = MemberReader.getDimensionShortNumber2NumberMap((String)this.outline.getModelNum());
            String value = ((String)rightExpression).trim();
            HashMap<String, String> dimValueMap = new HashMap<String, String>(16);
            String[] splits = value.split(",");
            String sourceEntity = "";
            for (String split : splits) {
                String comma = split.indexOf("@") > -1 ? "@" : (split.indexOf(".") > -1 ? "." : "");
                if (StringUtils.isEmpty((String)comma)) {
                    throw new BizRuleException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6216\u6210\u5458\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"ScriptBuiltin_22", (String)"fi-bcm-computing", (Object[])new Object[0]));
                }
                String[] dimAndMem = split.split(comma);
                String dim = dimAndMem[0];
                String mem = dimAndMem[1];
                if (!numbers.contains(dim)) {
                    throw new BizRuleException(ResManager.loadKDString((String)"copy\u51fd\u6570\u7684\u6765\u6e90\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u683c\u5f0f\u4e0d\u5bf9\u3002", (String)"ScriptBuiltin_24", (String)"fi-bcm-computing", (Object[])new Object[0]));
                }
                if (SysDimensionEnum.Entity.getNumber().equals(dim) || SysDimensionEnum.Entity.getShortnumber().equals(dim)) {
                    sourceEntity = mem;
                }
                if (shortNums.get(dim) != null) {
                    dim = (String)shortNums.get(dim);
                }
                dimValueMap.put(dim, mem);
            }
            StringBuilder sourceStr = new StringBuilder();
            StringBuilder targetStr = new StringBuilder();
            this.outline.getComputingContext().getScopeItems();
            this.outline.getComputingContext().getScopeItems().forEach((key, val) -> {
                String sourceVal = dimValueMap.get(key) == null ? (String)val.p2 : (String)dimValueMap.get(key);
                sourceStr.append((String)key).append(sourceVal).append("|");
                targetStr.append((String)key).append((String)val.p2).append("|");
            });
            if (sourceStr.toString().equals(targetStr.toString())) {
                throw new BizRuleException(ResManager.loadKDString((String)"copy\u51fd\u6570\u7684\u6765\u6e90\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u4e0e\u5f53\u524d\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u91cd\u590d\uff0c\u4e0d\u53ef\u590d\u5236\u3002", (String)"ScriptBuiltin_21", (String)"fi-bcm-computing", (Object[])new Object[0]));
            }
            if (SPECIAL_PROCESS.contains(this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PROCESS_DIM).p2) && StringUtils.isNotEmpty((String)sourceEntity) && !sourceEntity.contains("_")) {
                throw new BizRuleException(ResManager.loadKDString((String)"copy\u51fd\u6570\u7684\u6765\u6e90\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u683c\u5f0f\u4e0d\u5bf9\u3002", (String)"ScriptBuiltin_24", (String)"fi-bcm-computing", (Object[])new Object[0]));
            }
            command = new ComputingCommandInfo();
            if (scope != null) {
                ctxFilters = (List)scope.getFilters();
                for (DimensionFilterItem ctxFilter : ctxFilters) {
                    if (!numbers.contains(ctxFilter.getName())) continue;
                    throw new BizRuleException(ResManager.loadKDString((String)"copy\u51fd\u6570\u7684\u6765\u6e90\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u7684\u7ec4\u7ec7\u548c\u8fc7\u7a0b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltin_55", (String)"fi-bcm-computing", (Object[])new Object[0]));
                }
            }
            scope = this.outline.getComputingContext().getRuntimeScope(scope);
            ctxFilters = (List)scope.getFilters();
            ctxFilters.removeIf(filter -> filter.getName().equals(PresetConstant.ENTITY_DIM));
            command.setFilter(ctxFilters);
            command.setMainDimName("");
            command.setMainMeaName("FMONEY");
            OlapCommandUtil.addSourceMeasure((String)this.outline.getModelNum(), (CommandInfo)command, this.args.get("ruleInternal") instanceof Integer ? (Integer)this.args.get("ruleInternal") : null);
            item = new FelLambdaExpressionItem();
            item.setExpressLeft("E@" + (String)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM).p2);
            right = new StringBuilder();
            right.append("v('");
            right.append(rightExpression);
            if (StringUtils.isEmpty((String)sourceEntity)) {
                right.append(",E@");
                right.append((String)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM).p2);
            }
        } else {
            throw new BizRuleException("params error");
        }
        right.append("')");
        item.setExpression(right.toString());
        command.getExpressionItems().add(item);
        this.executeOlapCommand((CommandInfo)command);
    }

    @KSMethod
    public JSONObject shareJournal(String virEntCode) {
        String modelNum = this.outline.getModelNum();
        long modelId = MemberReader.findModelIdByNum((String)modelNum);
        long tarEntityId = (Long)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM).p1;
        String tarEntityNum = (String)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM).p2;
        long sceneId = (Long)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1;
        long yearId = (Long)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1;
        long periodId = (Long)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1;
        long processId = (Long)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PROCESS_DIM).p1;
        String processNum = (String)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PROCESS_DIM).p2;
        if (StringUtils.isNotEmpty((String)virEntCode)) {
            IDNumberTreeNode entityMemberByNum;
            if (virEntCode.contains("_")) {
                virEntCode = virEntCode.substring(virEntCode.lastIndexOf("_") + 1);
            }
            if ((entityMemberByNum = MemberReader.findEntityMemberByNum((String)modelNum, (String)virEntCode)).getId() == -1L) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u6307\u5b9a\u5206\u5f55\u6765\u6e90\u7ec4\u7ec7\u7f16\u7801\u65e0\u6548\u3002", (String)"ScriptBuiltin_27", (String)"fi-bcm-computing", (Object[])new Object[0]));
            }
            try {
                if (entityMemberByNum.isLeaf()) {
                    throw new RuntimeException(ResManager.loadKDString((String)"\u6307\u5b9a\u5206\u5f55\u6765\u6e90\u7ec4\u7ec7\u5fc5\u987b\u662f\u5408\u5e76\u8282\u70b9\u3002", (String)"ScriptBuiltin_26", (String)"fi-bcm-computing", (Object[])new Object[0]));
                }
                IDNumberTreeNode targetEntitynumber = MemberReader.findEntityMemberById((String)modelNum, (Long)tarEntityId);
                if (MERGE_JOURNAL_BPS.contains(processNum)) {
                    if (targetEntitynumber.isLeaf()) {
                        throw new RuntimeException(ResManager.loadKDString((String)"\u6307\u5b9a\u5206\u5f55\u76ee\u6807\u7ec4\u7ec7\u5fc5\u987b\u662f\u5408\u5e76\u8282\u70b9\u3002", (String)"ScriptBuiltin_28", (String)"fi-bcm-computing", (Object[])new Object[0]));
                    }
                    if (tarEntityNum.equals(virEntCode)) {
                        throw new RuntimeException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u548c\u8fc7\u7a0b\u7684\u7ec4\u5408\u4e0d\u6ee1\u8db3\u5171\u4eab\u5206\u5f55\u51fd\u6570shareJournal\u7684\u6267\u884c\u6761\u4ef6\u3002", (String)"ScriptBuiltin_33", (String)"fi-bcm-computing", (Object[])new Object[0]));
                    }
                }
                if (targetEntitynumber.isLeaf()) {
                    if (!PARENT_JOURNAL_BPS.contains(processNum)) {
                        throw new RuntimeException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u548c\u8fc7\u7a0b\u7684\u7ec4\u5408\u4e0d\u6ee1\u8db3\u5171\u4eab\u5206\u5f55\u51fd\u6570shareJournal\u7684\u6267\u884c\u6761\u4ef6\u3002", (String)"ScriptBuiltin_33", (String)"fi-bcm-computing", (Object[])new Object[0]));
                    }
                    if (!IDNumberTreeNode.NotFoundTreeNode.equals(targetEntitynumber.getParent())) {
                        tarEntityId = targetEntitynumber.getParent().getId();
                    }
                } else if (PARENT_JOURNAL_BPS.contains(processNum) && !IDNumberTreeNode.NotFoundTreeNode.equals(targetEntitynumber.getParent())) {
                    tarEntityId = targetEntitynumber.getParent().getId();
                }
                Object[] params = new Object[]{modelId, entityMemberByNum.getId(), tarEntityId, sceneId, yearId, periodId, processId};
                OperationResult operationResult = (OperationResult)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.adjust.CslSchemeAdjustShareHelper", (String)"shareEntry", (Object[])params);
                JSONObject resultJson = JSONObject.parseObject((String)operationResult.getMessage(), (Feature[])new Feature[]{Feature.OrderedField});
                if (!operationResult.getAllErrorInfo().isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (OperateErrorInfo errorInfo : operationResult.getAllErrorInfo()) {
                        sb.append(errorInfo.getMessage()).append(";");
                    }
                    logger.info(String.format(ResManager.loadKDString((String)"\u6e90\u7ec4\u7ec7%1$s\u5171\u4eab\u5230\u76ee\u6807\u7ec4\u7ec7%2$s\u5931\u8d25\u4fe1\u606f\uff1a", (String)"ScriptBuiltin_29", (String)"fi-bcm-computing", (Object[])new Object[0]), virEntCode, targetEntitynumber.getNumber()) + sb);
                }
                return resultJson;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException(ResManager.loadKDString((String)"\u7f3a\u5931\u5206\u5f55\u6765\u6e90\u7ec4\u7ec7\u7f16\u7801\u3002", (String)"ScriptBuiltin_25", (String)"fi-bcm-computing", (Object[])new Object[0]));
    }

    @KSMethod
    public JSONArray getOwnership(Object[] params) {
        return ScriptBuiltinHelper.getOwnership(this.outline, params);
    }

    @KSMethod
    public JSONArray getOwnershipMap(String parent, String startEntity, String endEntity) {
        return ScriptBuiltinHelper.getOwnershipMap(this.outline, parent, startEntity, endEntity);
    }

    @KSMethod
    public void setOwnership(Object ... params) {
        ScriptBuiltinHelper.setOwnership(this.outline, params);
    }

    @KSMethod
    public void delOwnership(Object ... params) {
        ScriptBuiltinHelper.delOwnership(this.outline, params);
    }

    @KSMethod
    public ScriptObject getXDMSet(Object[] args) {
        int argsNum = args.length;
        if (argsNum == 0) {
            throw new BizRuleException(ResManager.loadKDString((String)"getXDMSet\u51fd\u6570\u5fc5\u9700\u6307\u5b9a\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801\u6216\u62d3\u5c55\u6570\u636e\u6a21\u578b\u5b57\u6bb5\u8303\u56f4\u53c2\u6570\u3002", (String)"ScriptBuiltin_45", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        return (ScriptObject)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"getXDMSet", (Object[])new Object[]{args, argsNum, this.outline});
    }

    @KSMethod
    public Boolean checkXdmScope(Object[] args) {
        if (args.length < 2) {
            throw new BizRuleException(ResManager.loadKDString((String)"xRuns\u51fd\u6570\u4e2d\u5fc5\u987b\u6307\u5b9a\u62d3\u5c55\u6570\u636e\u6a21\u578b\u548c\u8ba1\u7b97\u8868\u8fbe\u5f0f\u3002", (String)"ScriptBuiltin_52", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        if (!(args[0] instanceof ScriptAllMemberExtDimensionNode)) {
            throw new BizRuleException(ResManager.loadKDString((String)"xRuns\u51fd\u6570\u4e2d\u5fc5\u987b\u6307\u5b9a\u62d3\u5c55\u6570\u636e\u6a21\u578b\u3002", (String)"ScriptBuiltin_46", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        if (args.length == 2) {
            if (args[1] instanceof XDMScopeInfo) {
                throw new BizRuleException(ResManager.loadKDString((String)"xRuns\u51fd\u6570\u4e2d\u5fc5\u987b\u6307\u5b9a\u8ba1\u7b97\u8868\u8fbe\u5f0f\u3002", (String)"ScriptBuiltin_47", (String)"fi-bcm-computing", (Object[])new Object[0]));
            }
            return Boolean.FALSE;
        }
        if (args[1] instanceof XDMScopeInfo) {
            return Boolean.TRUE;
        }
        return false;
    }

    @KSMethod
    public ScopeInfo creatNewXdmScope() {
        return new XDMScopeInfo();
    }

    @KSMethod
    public void xRuns(ScriptAllMemberExtDimensionNode node, XDMScopeInfo xdmScopeInfo, String ... expressions) {
        ScriptBuiltinHelper.checkNormalModelMethod(this.outline, node.getGroupType(), "xRuns");
        InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"xRuns", (Object[])new Object[]{this.outline, node, xdmScopeInfo, expressions});
    }

    @KSMethod
    public void xSyn(Object[] params) {
        String[] expressions = (String[])InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"xSyn", (Object[])new Object[]{this.outline, this.args, params});
        if (expressions.length != 0) {
            this.sendComputingComand("fel", "", this.outline.getComputingContext().getRuntimeScope(null), expressions, true);
        }
    }

    private String[] replaceVirtualMem(String[] expressions) {
        String[] newExpressions = new String[expressions.length];
        ScriptDimension periodDim = ScriptDimension.create(DimTypesEnum.PERIOD.getNumber(), this.olapConnection, this.outline);
        ScriptDimension yearDim = ScriptDimension.create(DimTypesEnum.YEAR.getNumber(), this.olapConnection, this.outline);
        if (this.outline.getComputingContext().getScopeItems() == null) {
            return expressions;
        }
        String periodNam = "null";
        String lastPeriod = "null";
        if (this.outline.getComputingContext().getScopeItems().get(DimTypesEnum.PERIOD.getNumber()) != null) {
            periodNam = (String)this.outline.getComputingContext().getScopeItems().get((Object)DimTypesEnum.PERIOD.getNumber()).p2;
            Long periodId = (Long)this.outline.getComputingContext().getScopeItems().get((Object)DimTypesEnum.PERIOD.getNumber()).p1;
            ScriptMember lastPeriodMem = new ScriptMemberPeriodNode(periodNam, periodDim, periodId).lastPeriod();
            lastPeriod = lastPeriodMem == null ? "null" : lastPeriodMem.getNumber();
        }
        String yearNam = "null";
        String lastYear = "null";
        if (this.outline.getComputingContext().getScopeItems().get(DimTypesEnum.YEAR.getNumber()) != null) {
            yearNam = (String)this.outline.getComputingContext().getScopeItems().get((Object)DimTypesEnum.YEAR.getNumber()).p2;
            Long yearId = (Long)this.outline.getComputingContext().getScopeItems().get((Object)DimTypesEnum.YEAR.getNumber()).p1;
            ScriptMember lastYearMem = new ScriptMemberYearNode(yearNam, yearDim, yearId).lastYear();
            lastYear = lastYearMem == null ? "null" : lastYearMem.getNumber();
        }
        for (int i = 0; i < expressions.length; ++i) {
            String newGroup;
            String group;
            String temp = expressions[i];
            Pattern periodReg = Pattern.compile("[',\\s](P|Period){1}[.@](LastPeriod|CurrentPeriod){1}[',\\s]");
            Pattern yearReg = Pattern.compile("[',\\s](FY|Year){1}[.@](LastYear|CurrentYear){1}[',\\s]");
            Matcher periodMatch = periodReg.matcher(temp);
            Matcher yearMatch = yearReg.matcher(temp);
            while (periodMatch.find()) {
                group = periodMatch.group();
                newGroup = group.contains("LastPeriod") ? group.replace("LastPeriod", lastPeriod) : group.replace("CurrentPeriod", periodNam);
                temp = temp.replace(group, newGroup);
                periodMatch = periodReg.matcher(temp);
            }
            while (yearMatch.find()) {
                group = yearMatch.group();
                newGroup = group.contains("LastYear") ? group.replace("LastYear", lastYear) : group.replace("CurrentYear", yearNam);
                temp = temp.replace(group, newGroup);
                yearMatch = yearReg.matcher(temp);
            }
            newExpressions[i] = temp;
        }
        return newExpressions;
    }

    @KSMethod
    public JSONArray getInvestInfo(String solution, String ... customParams) {
        return ScriptBuiltinHelper.getInvestInfo(solution, this.outline, customParams);
    }

    @KSMethod
    public boolean isRptStatMatched(Object[] params) {
        return ScriptBuiltinHelper.isRptStatMatched(this.outline, params);
    }

    @KSMethod
    public String getRptStats(Object[] params) {
        return ScriptBuiltinHelper.getRptStats(this.outline, params);
    }

    @KSMethod
    public void xCopy(Object[] params) {
        try {
            InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"xCopy", (Object[])new Object[]{this.outline, params});
        }
        catch (Exception e) {
            if (e.getCause().getCause() instanceof BizRuleException) {
                if (e.getCause().getCause().getMessage().contains("insertRow")) {
                    throw new BizRuleException(e.getCause().getCause().getMessage().replace("insertRow", "xCopy"));
                }
                throw e;
            }
            throw new BizRuleException("Internal Error");
        }
    }

    @KSMethod
    public WhenFilterItem when(Object[] params) {
        return (WhenFilterItem)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"when", (Object[])new Object[]{this.outline, params});
    }

    @KSMethod
    public Object getConFlowStatus(Object[] params) {
        return ScriptBuiltinHelper.getConFlowStatus(this.outline, params);
    }

    static {
        NUM_SHORT_MAP.put(PresetConstant.ENTITY_DIM, DimTypesEnum.ENTITY.getShortNumber());
        NUM_SHORT_MAP.put(PresetConstant.FY_DIM, DimTypesEnum.YEAR.getShortNumber());
        NUM_SHORT_MAP.put(PresetConstant.PERIOD_DIM, DimTypesEnum.PERIOD.getShortNumber());
        NUM_SHORT_MAP.put(PresetConstant.SCENE_DIM, DimTypesEnum.SCENARIO.getShortNumber());
        SHORT_NUM_MAP.put(DimTypesEnum.ENTITY.getShortNumber(), PresetConstant.ENTITY_DIM);
        SHORT_NUM_MAP.put(DimTypesEnum.YEAR.getShortNumber(), PresetConstant.FY_DIM);
        SHORT_NUM_MAP.put(DimTypesEnum.PERIOD.getShortNumber(), PresetConstant.PERIOD_DIM);
        SHORT_NUM_MAP.put(DimTypesEnum.SCENARIO.getShortNumber(), PresetConstant.SCENE_DIM);
    }
}

