/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.prop.DimPropList;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.common.exception.ScriptAnalyzeException;
import kd.fi.bcm.common.util.InvokeUtils;
import kd.fi.bcm.computing.ScopeInfo;
import kd.fi.bcm.computing.ScriptMember;
import kd.fi.bcm.computing.ScriptNode;
import kd.fi.bcm.computing.XDMScopeInfo;
import kd.fi.bcm.computing.bizrule.log.AuditLogHelper;
import kd.fi.bcm.computing.datasource.ExtOutlineNode;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.datasource.OutlineNode;
import kd.fi.bcm.computing.datasource.ScriptAgg;
import kd.fi.bcm.computing.member.ScriptAllMemberExtDimensionNode;
import kd.fi.bcm.computing.member.ScriptMemberEntityNode;
import kd.fi.bcm.computing.member.ScriptMemberExtDimensionNode;
import kd.fi.bcm.computing.util.BizRuleUtil;
import kd.fi.bcm.computing.util.ScriptBuiltinHelper;
import kd.fi.bcm.fel.common.StringUtils;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;

@KSObject
public class ScriptDimension
extends ScriptNode
implements Callable {
    private OlapConnection olapConnection;
    private final IOutline outline;
    private Boolean isExtDimension;
    private Boolean isXdmFunction;
    private final Map<String, ScriptMember> map = new HashMap<String, ScriptMember>();

    public ScriptDimension(String number, OlapConnection olapConnection, IOutline outline) {
        super(number);
        this.olapConnection = olapConnection;
        this.outline = outline;
    }

    public ScriptDimension(String number, OlapConnection olapConnection, IOutline outline, Boolean isExtDimension, Boolean isXdmFunction) {
        super(number);
        this.olapConnection = olapConnection;
        this.outline = outline;
        this.isExtDimension = isExtDimension;
        this.isXdmFunction = isXdmFunction;
    }

    public static ScriptDimension create(String number, OlapConnection olapConnection, IOutline outline) {
        ScriptDimension dimension = new ScriptDimension(number, olapConnection, outline);
        return (ScriptDimension)AuditLogHelper.proxyWithAuditEvent(dimension, new Class[]{String.class, OlapConnection.class, IOutline.class}, new Object[]{number, olapConnection, outline});
    }

    public static ScriptDimension create(String number, OlapConnection olapConnection, IOutline outline, boolean isExtDimension, boolean isXdmFunction) {
        ScriptDimension dimension = new ScriptDimension(number, olapConnection, outline, isExtDimension, isXdmFunction);
        return (ScriptDimension)AuditLogHelper.proxyWithAuditEvent(dimension, new Class[]{String.class, OlapConnection.class, IOutline.class, Boolean.class, Boolean.class}, new Object[]{number, olapConnection, outline, isExtDimension, isXdmFunction});
    }

    public OlapConnection getOlapConnection() {
        return this.olapConnection;
    }

    public void setOlapConnection(OlapConnection olapConnection) {
        this.olapConnection = olapConnection;
    }

    @Override
    public IOutline getOutline() {
        return this.outline;
    }

    public Map<String, ScriptMember> getMap() {
        return this.map;
    }

    public Object __getUndefinedElement(Object element) {
        if (element != null) {
            String eleStr = element.toString();
            ScriptMember member = this.map.get(eleStr);
            if (member == null) {
                int firstExclamationMark = eleStr.indexOf(33);
                if (firstExclamationMark >= 0) {
                    String _longNumber = firstExclamationMark == 0 ? this.number + eleStr : eleStr;
                    String modelNum = this.outline.getModelNum();
                    IDNumberTreeNode node = MemberReader.findMemberByLongNumber((String)modelNum, (String)this.number, (String)_longNumber);
                    if (node == IDNumberTreeNode.NotFoundTreeNode) {
                        throw new ScriptAnalyzeException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u4e2d\u627e\u4e0d\u5230\u6210\u5458: %2$s\uff0c\u8bf7\u786e\u8ba4\u8be5\u7ef4\u5ea6\u6210\u5458\u662f\u5426\u5b58\u5728\u3002", (String)"ScriptDimension_0", (String)"fi-bcm-computing", (Object[])new Object[0]), this.number, _longNumber));
                    }
                    member = ScriptMember.create(node.getNumber(), this, node.getId());
                    this.map.put(eleStr, member);
                    return member;
                }
                return this.__getUndefinedProperty(eleStr);
            }
            return member;
        }
        throw new UnsupportedOperationException(String.format("%s not supported property [%s] operate", this.number, element));
    }

    @Override
    public Object __getUndefinedProperty(String propertyName) {
        if (propertyName != null && !propertyName.trim().isEmpty()) {
            if ("number".equals(propertyName)) {
                return this.number;
            }
            if ("members".equals(propertyName)) {
                String modelNum = this.outline.getModelNum();
                Collection nodes = MemberReader.getAllNodeByDimNum((String)this.number, (String)modelNum);
                ArrayList<ScriptMember> members = new ArrayList<ScriptMember>();
                for (IDNumberTreeNode node : nodes) {
                    members.add(ScriptMember.create(node.getNumber(), this, node.getId()));
                }
                return members.toArray();
            }
            ScriptMember member = this.map.get(propertyName);
            if (member == null) {
                OutlineNode memberNode = null;
                if (Boolean.TRUE.equals(this.isExtDimension)) {
                    if (Boolean.TRUE.equals(this.isXdmFunction)) {
                        ArrayList<ScriptMember> members = new ArrayList<ScriptMember>(10);
                        QFilter qf = new QFilter("model.id", "=", (Object)MemberReader.findModelIdByNum((String)this.outline.getModelNum()));
                        qf.and(new QFilter("number", "=", (Object)propertyName));
                        DynamicObject extmodel = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_extendsmodel", (String)"id,extendsgroup.number,extendsgroup.id,extendsgroup.grouptype", (QFilter[])qf.toArray());
                        if (extmodel == null) {
                            throw new WrappedException((Throwable)new ScriptAnalyzeException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u6709\u6548\u7684\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801\u3002", (String)"ExtendDimisionUtil_0", (String)"fi-bcm-computing", (Object[])new Object[0]), propertyName)));
                        }
                        List extObjectList = (List)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"getExtNodeListById", (Object[])new Object[]{extmodel});
                        for (DynamicObject dyo : extObjectList) {
                            members.add(ScriptMember.extCreate(dyo.getString("extfield.number"), this, dyo.getLong("extfield.id"), extmodel.getString("number")));
                        }
                        ScriptAllMemberExtDimensionNode allExtNodes = new ScriptAllMemberExtDimensionNode(members, propertyName, extmodel.getLong("id"), this.outline, extmodel.getLong("extendsgroup.id"), extmodel.getString("extendsgroup.grouptype"));
                        return allExtNodes;
                    }
                    ExtOutlineNode extOutlineNode = this.outline.getExtAggNode(propertyName, this.outline.getModelNum());
                    if (extOutlineNode != null) {
                        member = ScriptMember.extCreate(extOutlineNode.getNumber(), this, extOutlineNode.getId());
                        this.map.put(propertyName, member);
                        return member;
                    }
                } else {
                    memberNode = this.outline.getAggNode(this.number, propertyName);
                }
                if (memberNode != null) {
                    member = ScriptMember.create(memberNode.getNumber(), this, memberNode.getId());
                    this.map.put(propertyName, member);
                    return member;
                }
            } else {
                return member;
            }
        }
        throw new UnsupportedOperationException(String.format("%s not supported property [%s] operate", this.number, propertyName));
    }

    @KSMethod
    public ScopeInfo In(String ... memberNames) {
        if (this.outline.getComputingContext().getExtendNumbers().contains(this.number)) {
            ScriptMember scriptMember = this.getScriptExtMember();
            if (scriptMember != null) {
                return ((ScriptMemberExtDimensionNode)scriptMember).in(memberNames);
            }
            throw new WrappedException((Throwable)new ScriptAnalyzeException(ResManager.loadKDString((String)"\u5f53\u524d\u62d3\u5c55\u7ef4\u5ea6\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScriptDimension_7", (String)"fi-bcm-computing", (Object[])new Object[0])));
        }
        DimensionFilterItem filterItem = new DimensionFilterItem();
        filterItem.setName(this.number);
        if (memberNames == null) {
            throw new WrappedException((Throwable)new ScriptAnalyzeException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u5b57\u6bb5%s\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScriptDimension_9", (String)"fi-bcm-computing", (Object[])new Object[0]), this.number)));
        }
        filterItem.getValues().addAll(Arrays.asList(memberNames));
        ArrayList<DimensionFilterItem> list = new ArrayList<DimensionFilterItem>();
        list.add(filterItem);
        return new ScopeInfo(list);
    }

    private ScriptMember getScriptExtMember() {
        ExtOutlineNode extOutlineNode;
        ScriptMember member = this.map.get(this.number);
        if (member == null && (extOutlineNode = this.outline.getExtAggNode(this.number, this.outline.getModelNum())) != null) {
            member = ScriptMember.extCreate(extOutlineNode.getNumber(), this, extOutlineNode.getId());
            this.map.put(this.number, member);
            return member;
        }
        return member;
    }

    @KSMethod
    public ScopeInfo in(String ... memberNames) {
        List<String> list = Arrays.stream(memberNames).filter(StringUtils::isNotEmpty).map(String::trim).collect(Collectors.toList());
        return this.In(list.toArray(new String[0]));
    }

    @KSMethod
    public XDMScopeInfo greaterThan(String number) {
        if (this.outline.getComputingContext().getExtendNumbers().contains(this.number)) {
            ScriptMember scriptMember = this.getScriptExtMember();
            if (scriptMember != null) {
                return ((ScriptMemberExtDimensionNode)scriptMember).getCompareCondition(number, ">");
            }
            throw new WrappedException((Throwable)new ScriptAnalyzeException(ResManager.loadKDString((String)"\u5f53\u524d\u62d3\u5c55\u7ef4\u5ea6\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScriptDimension_7", (String)"fi-bcm-computing", (Object[])new Object[0])));
        }
        throw new WrappedException((Throwable)new ScriptAnalyzeException(ResManager.loadKDString((String)"\u975e\u62d3\u5c55\u7ef4\u5ea6\u4e0d\u5b58\u5728greaterThan\u65b9\u6cd5\u3002", (String)"ScriptDimension_4", (String)"fi-bcm-computing", (Object[])new Object[0])));
    }

    @KSMethod
    public XDMScopeInfo lessThan(String number) {
        if (this.outline.getComputingContext().getExtendNumbers().contains(this.number)) {
            ScriptMember scriptMember = this.getScriptExtMember();
            if (scriptMember != null) {
                return ((ScriptMemberExtDimensionNode)scriptMember).getCompareCondition(number, "<");
            }
            throw new WrappedException((Throwable)new ScriptAnalyzeException(ResManager.loadKDString((String)"\u5f53\u524d\u62d3\u5c55\u7ef4\u5ea6\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScriptDimension_7", (String)"fi-bcm-computing", (Object[])new Object[0])));
        }
        throw new WrappedException((Throwable)new ScriptAnalyzeException(ResManager.loadKDString((String)"\u975e\u62d3\u5c55\u7ef4\u5ea6\u4e0d\u5b58\u5728lessThan\u65b9\u6cd5\u3002", (String)"ScriptDimension_5", (String)"fi-bcm-computing", (Object[])new Object[0])));
    }

    @KSMethod
    public XDMScopeInfo isEmpty() {
        if (this.outline.getComputingContext().getExtendNumbers().contains(this.number)) {
            ScriptMember scriptMember = this.getScriptExtMember();
            if (scriptMember != null) {
                return ((ScriptMemberExtDimensionNode)scriptMember).getEmptyOrNotEmptyCondition("is null");
            }
            throw new BizRuleException(ResManager.loadKDString((String)"\u5f53\u524d\u62d3\u5c55\u7ef4\u5ea6\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScriptDimension_7", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        throw new BizRuleException(ResManager.loadKDString((String)"\u975e\u62d3\u5c55\u7ef4\u5ea6\u4e0d\u5b58\u5728isEmpty\u65b9\u6cd5\u3002", (String)"ScriptDimension_10", (String)"fi-bcm-computing", (Object[])new Object[0]));
    }

    @KSMethod
    public XDMScopeInfo isNotEmpty() {
        if (this.outline.getComputingContext().getExtendNumbers().contains(this.number)) {
            ScriptMember scriptMember = this.getScriptExtMember();
            if (scriptMember != null) {
                return ((ScriptMemberExtDimensionNode)scriptMember).getEmptyOrNotEmptyCondition("is not null");
            }
            throw new BizRuleException(ResManager.loadKDString((String)"\u5f53\u524d\u62d3\u5c55\u7ef4\u5ea6\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScriptDimension_7", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        throw new BizRuleException(ResManager.loadKDString((String)"\u975e\u62d3\u5c55\u7ef4\u5ea6\u4e0d\u5b58\u5728isNotEmpty\u65b9\u6cd5\u3002", (String)"ScriptDimension_11", (String)"fi-bcm-computing", (Object[])new Object[0]));
    }

    @KSMethod
    public ScopeInfo in(Object[] memberNames) {
        String[] strs = new String[memberNames.length];
        int count = 0;
        for (Object obj : memberNames) {
            strs[count] = obj instanceof BigDecimal ? ((BigDecimal)obj).stripTrailingZeros().toPlainString() : obj.toString();
            ++count;
        }
        return this.In(strs);
    }

    @KSMethod
    public ScopeInfo like(String ... memberName) {
        if (this.outline.getComputingContext().getExtendNumbers().contains(this.number)) {
            ScriptMember scriptMember = this.getScriptExtMember();
            if (scriptMember != null) {
                return ((ScriptMemberExtDimensionNode)scriptMember).like(memberName);
            }
            throw new WrappedException((Throwable)new ScriptAnalyzeException(ResManager.loadKDString((String)"\u5f53\u524d\u62d3\u5c55\u7ef4\u5ea6\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScriptDimension_7", (String)"fi-bcm-computing", (Object[])new Object[0])));
        }
        throw new WrappedException((Throwable)new ScriptAnalyzeException(String.format("Cannot find function like in object %s.", this.number)));
    }

    @KSMethod
    public ScriptMember member(String memberName, String cslNum) {
        if (DimEntityNumEnum.ENTITY.getNumber().equals(this.number)) {
            IDNumberTreeNode entityNode = MemberReader.findEntityMemberByNum((String)this.outline.getModelNum(), (String)memberName);
            if (entityNode != IDNumberTreeNode.NotFoundTreeNode) {
                if (entityNode.getProperty("cslscheme").equals(cslNum) || entityNode.getShareNodes().isEmpty()) {
                    return ScriptMember.create(memberName, this, entityNode.getId());
                }
                List shareNodes = entityNode.getShareNodes();
                ArrayList<IDNumberTreeNode> nodes = new ArrayList<IDNumberTreeNode>(10);
                for (IDNumberTreeNode shareNode : shareNodes) {
                    if (!shareNode.getProperty("cslscheme").equals(cslNum)) continue;
                    nodes.add(shareNode);
                }
                if (nodes.isEmpty()) {
                    return ScriptMember.create(memberName, this, entityNode.getId());
                }
                if (nodes.size() == 1) {
                    return ScriptMember.create(memberName, this, ((IDNumberTreeNode)nodes.get(0)).getId());
                }
                nodes.sort(Comparator.comparingInt(IDNumberTreeNode::getLevel));
                return ScriptMember.create(memberName, this, ((IDNumberTreeNode)nodes.get(0)).getId());
            }
            return null;
        }
        return null;
    }

    @KSMethod
    public void agg(ScopeInfo scopeInfo, String ... memberNames) {
        ScriptAgg scriptAgg = new ScriptAgg(this.olapConnection);
        scriptAgg.agg(scopeInfo, memberNames);
    }

    @KSMethod
    public boolean hasMember(String number) {
        return MemberReader.isExistMember((String)this.outline.getModelNum(), (String)this.getNumber(), (String)number);
    }

    @KSMethod
    public boolean isBase(String child, String parent) {
        boolean isBase = MemberReader.isBase((String)this.outline.getModelNum(), (String)this.getNumber(), (String)child, (String)parent);
        if (isBase && this.isOpenVersion()) {
            Object[] params = new Object[]{this.getOutline().getModelNum(), this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1, child, parent};
            isBase = (Boolean)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"isValidBase", (Object[])params);
        }
        return isBase;
    }

    @KSMethod
    public boolean isBase(String child, String parent, String dimStr) {
        boolean isBase = MemberReader.isBase((String)this.outline.getModelNum(), (String)this.getNumber(), (String)child, (String)parent);
        if (isBase && this.isOpenVersion()) {
            Map<String, String> map = BizRuleUtil.parseICDimStr(this.getOutline().getModelNum(), dimStr);
            String scenarioNum = map.getOrDefault(PresetConstant.SCENE_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p2);
            String yearNum = map.getOrDefault(PresetConstant.FY_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p2);
            String periodNum = map.getOrDefault(PresetConstant.PERIOD_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p2);
            long scenario = MemberReader.findScenaMemberByNum((String)this.getOutline().getModelNum(), (String)scenarioNum).getId();
            long year = MemberReader.findFyMemberByNum((String)this.getOutline().getModelNum(), (String)yearNum).getId();
            long period = MemberReader.findPeriodMemberByNum((String)this.getOutline().getModelNum(), (String)periodNum).getId();
            Object[] params = new Object[]{this.getOutline().getModelNum(), scenario, year, period, child, parent};
            isBase = (Boolean)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"isValidBase", (Object[])params);
        }
        return isBase;
    }

    @KSMethod
    public boolean isChild(String child, String parent) {
        IDNumberTreeNode node = this.findMemberByNumber(parent);
        boolean isChild = node.getChildren().stream().anyMatch(c -> c.getNumber().equals(child));
        if (isChild && this.isOpenVersion()) {
            Object[] params = new Object[]{this.getOutline().getModelNum(), this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1, child, parent};
            isChild = (Boolean)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"isValidChild", (Object[])params);
        }
        return isChild;
    }

    @KSMethod
    public boolean isChild(String child, String parent, String dimStr) {
        IDNumberTreeNode node = this.findMemberByNumber(parent);
        boolean isChild = node.getChildren().stream().anyMatch(c -> c.getNumber().equals(child));
        if (isChild && this.isOpenVersion()) {
            Map<String, String> map = BizRuleUtil.parseICDimStr(this.getOutline().getModelNum(), dimStr);
            String scenarioNum = map.getOrDefault(PresetConstant.SCENE_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p2);
            String yearNum = map.getOrDefault(PresetConstant.FY_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p2);
            String periodNum = map.getOrDefault(PresetConstant.PERIOD_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p2);
            long scenario = MemberReader.findScenaMemberByNum((String)this.getOutline().getModelNum(), (String)scenarioNum).getId();
            long year = MemberReader.findFyMemberByNum((String)this.getOutline().getModelNum(), (String)yearNum).getId();
            long period = MemberReader.findPeriodMemberByNum((String)this.getOutline().getModelNum(), (String)periodNum).getId();
            Object[] params = new Object[]{this.getOutline().getModelNum(), scenario, year, period, child, parent};
            isChild = (Boolean)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"isValidChild", (Object[])params);
        }
        return isChild;
    }

    @KSMethod
    public boolean isDescendant(String child, String parent) {
        IDNumberTreeNode node = this.findMemberByNumber(parent);
        boolean isDescendant = node.getAllChildren(4).stream().anyMatch(c -> c.getNumber().equals(child));
        if (isDescendant && this.isOpenVersion()) {
            Object[] params = new Object[]{this.getOutline().getModelNum(), this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1, child, parent};
            isDescendant = (Boolean)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"isValidDescendant", (Object[])params);
        }
        return isDescendant;
    }

    @KSMethod
    public boolean isDescendant(String child, String parent, String dimStr) {
        IDNumberTreeNode node = this.findMemberByNumber(parent);
        boolean isDescendant = node.getAllChildren(4).stream().anyMatch(c -> c.getNumber().equals(child));
        if (isDescendant && this.isOpenVersion()) {
            Map<String, String> map = BizRuleUtil.parseICDimStr(this.getOutline().getModelNum(), dimStr);
            String scenarioNum = map.getOrDefault(PresetConstant.SCENE_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p2);
            String yearNum = map.getOrDefault(PresetConstant.FY_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p2);
            String periodNum = map.getOrDefault(PresetConstant.PERIOD_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p2);
            long scenario = MemberReader.findScenaMemberByNum((String)this.getOutline().getModelNum(), (String)scenarioNum).getId();
            long year = MemberReader.findFyMemberByNum((String)this.getOutline().getModelNum(), (String)yearNum).getId();
            long period = MemberReader.findPeriodMemberByNum((String)this.getOutline().getModelNum(), (String)periodNum).getId();
            Object[] params = new Object[]{this.getOutline().getModelNum(), scenario, year, period, child, parent};
            isDescendant = (Boolean)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"isValidDescendant", (Object[])params);
        }
        return isDescendant;
    }

    @KSMethod
    public ScriptMember[] within(String key, String ... values) {
        List<IDNumberTreeNode> numbers = ScriptBuiltinHelper.getRefPropertyMembers(this.outline.getModelNum(), this.number, key, values);
        ScriptMember[] scriptMembers = new ScriptMember[numbers.size()];
        IntStream.range(0, numbers.size()).forEach(index -> {
            IDNumberTreeNode node = (IDNumberTreeNode)numbers.get(index);
            scriptMembers[index] = ScriptMember.create(node.getNumber(), this, node.getId());
        });
        return scriptMembers;
    }

    @KSMethod
    public String[] properties() {
        Long dimensionId = MemberReader.getDimensionIdByNum((long)MemberReader.findModelIdByNum((String)this.getOutline().getModelNum()), (String)this.number);
        DimPropList dimPropList = DimPropList.getDimPropList((long)dimensionId);
        Map fieldNameMap = dimPropList.getFieldNameMap();
        if (fieldNameMap.size() == 0) {
            return null;
        }
        String[] res = new String[fieldNameMap.size()];
        int index = 0;
        for (Map.Entry entry : fieldNameMap.entrySet()) {
            res[index] = (String)entry.getKey() + ":" + (String)entry.getValue();
            ++index;
        }
        return res;
    }

    @KSMethod
    public boolean isHierarchy(String child, String parent) {
        boolean isHierarchy;
        boolean bl = isHierarchy = child.equals(parent) || this.isDescendant(child, parent);
        if (isHierarchy && this.getNumber().equals(PresetConstant.INTERNALCOMPANY_DIM) && this.getOutline().getComputingContext().getScopeItems() != null) {
            Object[] params = new Object[]{this.getOutline().getModelNum(), this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1, child, parent};
            isHierarchy = (Boolean)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"isValidHierarchy", (Object[])params);
        }
        return isHierarchy;
    }

    @KSMethod
    public boolean isHierarchy(String child, String parent, String dimStr) {
        boolean isHierarchy;
        boolean bl = isHierarchy = child.equals(parent) || this.isDescendant(child, parent);
        if (isHierarchy && this.getNumber().equals(PresetConstant.INTERNALCOMPANY_DIM) && this.getOutline().getComputingContext().getScopeItems() != null) {
            Map<String, String> map = BizRuleUtil.parseICDimStr(this.getOutline().getModelNum(), dimStr);
            String scenarioNum = map.getOrDefault(PresetConstant.SCENE_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p2);
            String yearNum = map.getOrDefault(PresetConstant.FY_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p2);
            String periodNum = map.getOrDefault(PresetConstant.PERIOD_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p2);
            long scenario = MemberReader.findScenaMemberByNum((String)this.getOutline().getModelNum(), (String)scenarioNum).getId();
            long year = MemberReader.findFyMemberByNum((String)this.getOutline().getModelNum(), (String)yearNum).getId();
            long period = MemberReader.findPeriodMemberByNum((String)this.getOutline().getModelNum(), (String)periodNum).getId();
            Object[] params = new Object[]{this.getOutline().getModelNum(), scenario, year, period, child, parent};
            isHierarchy = (Boolean)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"isValidHierarchy", (Object[])params);
        }
        return isHierarchy;
    }

    public boolean isValidBase(String child, String parent) {
        return this.checkValid("base", child, parent);
    }

    public boolean isValidChild(String child, String parent) {
        return this.checkValid("child", child, parent);
    }

    public boolean isValidDescendant(String child, String parent) {
        return this.checkValid("descent", child, parent);
    }

    private boolean checkNumberInMembers(String child, ScriptMember[] scriptMembers) {
        for (ScriptMember scriptMember : scriptMembers) {
            if (!child.equals(scriptMember.getNumber())) continue;
            return true;
        }
        return false;
    }

    private boolean checkValid(String method, String child, String parent) {
        this.checkSupportDim();
        IDNumberTreeNode node = this.findMemberByNumber(parent);
        ScriptMemberEntityNode scriptMemberEntityNode = new ScriptMemberEntityNode(node.getNumber(), this, node.getId());
        switch (method) {
            case "child": {
                return this.checkNumberInMembers(child, scriptMemberEntityNode.validChildren());
            }
            case "base": {
                return this.checkNumberInMembers(child, scriptMemberEntityNode.validBase());
            }
            case "descent": {
                return this.checkNumberInMembers(child, scriptMemberEntityNode.validDescendant());
            }
        }
        return false;
    }

    private void checkSupportDim() {
        if (!this.getNumber().equals(PresetConstant.ENTITY_DIM)) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u6b64\u51fd\u6570\u4e0d\u652f\u6301\u201c%s\u7ef4\u5ea6\u201d\uff0c\u53ea\u652f\u6301\u201c\u7ec4\u7ec7\u7ef4\u5ea6\u201d\u3002", (String)"ScriptDimension_8", (String)"fi-bcm-computing", (Object[])new Object[0]), this.getNumber()));
        }
    }

    private IDNumberTreeNode findMemberByNumber(String number) {
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)this.outline.getModelNum(), (String)this.getNumber(), (String)number);
        if (IDNumberTreeNode.NotFoundTreeNode == node) {
            throw new WrappedException((Throwable)new ScriptAnalyzeException(String.format(ResManager.loadKDString((String)"\u5728%1$s\u7ef4\u5ea6\u4e2d\u672a\u627e\u5230\u7f16\u7801\u4e3a%2$s\u7684\u6210\u5458\u3002", (String)"ScriptDimension_6", (String)"fi-bcm-computing", (Object[])new Object[0]), this.getNumber(), number)));
        }
        return node;
    }

    private Boolean checkMemberInDemision(String number) {
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)this.outline.getModelNum(), (String)this.getNumber(), (String)number);
        if (IDNumberTreeNode.NotFoundTreeNode == node) {
            throw new WrappedException((Throwable)new ScriptAnalyzeException(String.format(ResManager.loadKDString((String)"\u5728%1$s\u7ef4\u5ea6\u4e2d\u672a\u627e\u5230\u7f16\u7801\u4e3a%2$s\u7684\u6210\u5458\u3002", (String)"ScriptDimension_6", (String)"fi-bcm-computing", (Object[])new Object[0]), this.getNumber(), number)));
        }
        return Boolean.TRUE;
    }

    private boolean isOpenVersion() {
        boolean openVersion = false;
        if (this.getNumber().equals(PresetConstant.INTERNALCOMPANY_DIM) && this.getOutline().getComputingContext().getScopeItems() != null && this.getOutline().getComputingContext().getScopeItems().get(PresetConstant.SCENE_DIM) != null && this.getOutline().getComputingContext().getScopeItems().get(PresetConstant.FY_DIM) != null && this.getOutline().getComputingContext().getScopeItems().get(PresetConstant.PERIOD_DIM) != null) {
            Object[] params = new Object[]{this.getOutline().getModelNum(), this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1};
            openVersion = (Boolean)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"isOpenVersion", (Object[])params);
        }
        return openVersion;
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable1, Object[] objects) {
        if (objects != null && objects.length == 1) {
            return this.__getUndefinedElement(objects[0]);
        }
        return null;
    }
}

