/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing;

import java.util.ArrayList;
import kd.bos.script.ScriptObject;
import kd.bos.script.annotations.KSObject;
import kd.fi.bcm.computing.ScriptMember;

@KSObject
public class ScriptFactorList
implements ScriptObject {
    private static final String vFunctionStr = "v('%s')";
    private ArrayList<String> factors = new ArrayList();

    public void add(Object ... objects) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object factor : objects) {
            if (factor instanceof String) {
                result.add(factor.toString());
                continue;
            }
            if (factor instanceof ScriptMember) {
                ScriptMember scriptMember = (ScriptMember)factor;
                result.add(scriptMember.getDimension().getNumber() + "@" + scriptMember.number);
                continue;
            }
            throw new UnsupportedOperationException(String.format("Object type (%s) is not supported", factor.getClass()));
        }
        this.factors.add(String.format(vFunctionStr, String.join((CharSequence)",", result)));
    }

    public void addAll(Object[] objArray) {
        for (Object factor : objArray) {
            String result;
            if (factor instanceof String) {
                result = (String)factor;
            } else if (factor instanceof ScriptMember) {
                ScriptMember scriptMember = (ScriptMember)factor;
                result = scriptMember.getDimension().getNumber() + "@" + scriptMember.number;
            } else {
                throw new UnsupportedOperationException(String.format("Object type (%s) is not supported", factor.getClass()));
            }
            this.factors.add(String.format(vFunctionStr, result));
        }
    }

    public Object __getUndefinedProperty(String propertyName) {
        if (propertyName != null && !propertyName.isEmpty() && propertyName.equals("size")) {
            return this.factors.size();
        }
        return null;
    }

    public String toString() {
        return this.toString("+");
    }

    public String toString(String operator) {
        return String.join((CharSequence)operator, this.factors);
    }
}

