/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.script.ScriptObject;
import kd.bos.script.annotations.KSMethod;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.prop.DimPropList;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.exception.ScriptAnalyzeException;
import kd.fi.bcm.computing.ScriptDimension;
import kd.fi.bcm.computing.ScriptNode;
import kd.fi.bcm.computing.ScriptProperty;
import kd.fi.bcm.computing.ScriptPropertyValue;
import kd.fi.bcm.computing.bizabout.cach.ScriptCache;
import kd.fi.bcm.computing.bizrule.log.AuditLogHelper;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.member.ScriptMemberAccountNode;
import kd.fi.bcm.computing.member.ScriptMemberCurrencyNode;
import kd.fi.bcm.computing.member.ScriptMemberEntityNode;
import kd.fi.bcm.computing.member.ScriptMemberExtDimensionNode;
import kd.fi.bcm.computing.member.ScriptMemberICNode;
import kd.fi.bcm.computing.member.ScriptMemberPeriodNode;
import kd.fi.bcm.computing.member.ScriptMemberProcessNode;
import kd.fi.bcm.computing.member.ScriptMemberScenarioNode;
import kd.fi.bcm.computing.member.ScriptMemberYearNode;
import kd.fi.bcm.computing.model.BcmMap;
import org.apache.commons.collections.CollectionUtils;
import org.mozilla.javascript.WrappedException;

public class ScriptMember
extends ScriptNode
implements ScriptObject {
    private ScriptDimension dimension;
    private long id;
    private IDNumberTreeNode _currentNode = null;
    private Set<String> _dimensionPropSet = null;

    public ScriptMember(String datamodelNum) {
        super(datamodelNum);
    }

    public ScriptDimension getDimension() {
        return this.dimension;
    }

    public ScriptMember(String number, ScriptDimension dimension, long id) {
        super(number);
        this.dimension = dimension;
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public static ScriptMember create(String number, ScriptDimension dimension, long id) {
        ScriptMember member = null;
        member = DimTypesEnum.CURRENCY.getNumber().equals(dimension.number) ? new ScriptMemberCurrencyNode(number, dimension, id) : (DimTypesEnum.ENTITY.getNumber().equals(dimension.number) ? new ScriptMemberEntityNode(number, dimension, id) : (DimTypesEnum.YEAR.getNumber().equals(dimension.number) ? new ScriptMemberYearNode(number, dimension, id) : (DimTypesEnum.PERIOD.getNumber().equals(dimension.number) ? new ScriptMemberPeriodNode(number, dimension, id) : (DimTypesEnum.PROCESS.getNumber().equals(dimension.number) ? new ScriptMemberProcessNode(number, dimension, id) : (DimTypesEnum.SCENARIO.getNumber().equals(dimension.number) ? new ScriptMemberScenarioNode(number, dimension, id) : (DimTypesEnum.ACCOUNT.getNumber().equals(dimension.number) ? new ScriptMemberAccountNode(number, dimension, id) : (DimTypesEnum.INTERCOMPANY.getNumber().equals(dimension.number) ? new ScriptMemberICNode(number, dimension, id) : new ScriptMember(number, dimension, id))))))));
        return (ScriptMember)AuditLogHelper.proxyWithAuditEvent(member, new Class[]{String.class, ScriptDimension.class, Long.TYPE}, new Object[]{number, dimension, id});
    }

    public static ScriptMember extCreate(String number, ScriptDimension scriptDimension, Long id, String extendsmodelNumber) {
        return new ScriptMemberExtDimensionNode(number, scriptDimension, id, extendsmodelNumber);
    }

    public static ScriptMember extCreate(String number, ScriptDimension scriptDimension, Long id) {
        return new ScriptMemberExtDimensionNode(number, scriptDimension, id);
    }

    @Override
    public IOutline getOutline() {
        return this.dimension.getOutline();
    }

    protected IDNumberTreeNode getIDNumberTreeNode() {
        if (this._currentNode == null) {
            IOutline outline = this.getOutline();
            String modelNum = outline.getModelNum();
            this._currentNode = this.getIDNumberTreeNode(modelNum, DimEntityNumEnum.getEntieyNumByNumber((String)this.dimension.number), this.id);
        }
        return this._currentNode;
    }

    protected IDNumberTreeNode getIDNumberTreeNode(String modelNum, String entityNum, Long id) {
        return MemberReader.findMemberById((String)modelNum, (String)DimEntityNumEnum.getEntieyNumByNumber((String)this.dimension.number), (Long)id);
    }

    private Set<String> getDimensionPropSet() {
        if (this._dimensionPropSet == null) {
            IOutline outline = this.getOutline();
            String modelNum = outline.getModelNum();
            this._dimensionPropSet = MemberReader.getDimensionProp((String)modelNum, (String)this.dimension.number);
        }
        return this._dimensionPropSet;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ScriptMember) {
            ScriptMember other = (ScriptMember)obj;
            if (!this.dimension.getNumber().equals(other.dimension.getNumber())) {
                return false;
            }
        }
        return super.equals(obj);
    }

    @Override
    public int scriptCompareTo(Object o) {
        if (o instanceof ScriptMember) {
            ScriptMember other = (ScriptMember)o;
            if (!this.dimension.getNumber().equals(other.dimension.getNumber())) {
                return -1;
            }
        }
        return super.scriptCompareTo(o);
    }

    public Object __getUndefinedElement(Object element) {
        if (element instanceof String) {
            return this.__getUndefinedProperty((String)element);
        }
        throw new WrappedException((Throwable)new UnsupportedOperationException(String.format("%s not supported property [%s] operate", this.number, element)));
    }

    @Override
    public Object __getUndefinedProperty(String propertyName) {
        if (propertyName != null && !propertyName.trim().isEmpty()) {
            if ("longNumber".equals(propertyName)) {
                return this.getIDNumberTreeNode().getLongNumber();
            }
            if ("aggOprt".equals(propertyName)) {
                return this.getIDNumberTreeNode().getAggOprt();
            }
            if ("name".equals(propertyName)) {
                return this.getIDNumberTreeNode().getName();
            }
            if ("storageType".equals(propertyName)) {
                return this.getIDNumberTreeNode().getStorageType().toString();
            }
            if ("dataType".equalsIgnoreCase(propertyName)) {
                return this.getIDNumberTreeNode().loadAndConsumerProp("datatype", dyna -> dyna.getInt("datatype"));
            }
            if (this.getDimensionPropSet().contains(propertyName)) {
                return this.getIDNumberTreeNode().getCustomPropVal(propertyName);
            }
            return super.__getUndefinedProperty(propertyName);
        }
        return super.__getUndefinedProperty(propertyName);
    }

    @KSMethod
    public ScriptPropertyValue property(String propertyName) {
        String propVal = this.getIDNumberTreeNode().getCustomPropVal(propertyName);
        if (propVal != null) {
            DimPropList plist = DimPropList.getDimPropList((long)this.getIDNumberTreeNode().getDimId());
            ScriptProperty property = new ScriptProperty(plist.getFieldId(propertyName), propertyName, plist.getFieldName(propertyName), this.dimension);
            Collection treeNodes = MemberReader.getAllNodeFromCache((String)"bcm_definedpropertyvalue", (String)this.dimension.getOutline().getModelNum()).values();
            for (IDNumberTreeNode treeNode : treeNodes) {
                if (!treeNode.getDimNumber().equals(this.dimension.getNumber()) || !treeNode.getNumber().equals(propVal)) continue;
                return new ScriptPropertyValue(treeNode.getId(), treeNode, property);
            }
        }
        return null;
    }

    @KSMethod
    public BcmMap<String, String> properties() {
        Set<String> dimensionPropSet = this.getDimensionPropSet();
        Collection treeNodes = MemberReader.getAllNodeFromCache((String)"bcm_definedpropertyvalue", (String)this.dimension.getOutline().getModelNum()).values();
        Map<String, IDNumberTreeNode> map = treeNodes.stream().filter(node -> node.getDimNumber().equals(this.dimension.getNumber())).collect(Collectors.toMap(IDNumberTreeNode::getNumber, v -> v));
        BcmMap<String, String> res = new BcmMap<String, String>();
        for (String prop : dimensionPropSet) {
            String propVal = this.getIDNumberTreeNode().getCustomPropVal(prop);
            if (propVal == null || map.get(propVal) == null) continue;
            res.put(prop, propVal + ":" + map.get(propVal).getName());
        }
        if (res.size() == 0) {
            return null;
        }
        return res;
    }

    @KSMethod
    public boolean isChild(String memberNumber) {
        this.checkNumberIsNotNull(memberNumber);
        IDNumberTreeNode parent = this.getIDNumberTreeNode().getParent();
        return parent != null && memberNumber.equalsIgnoreCase(parent.getNumber());
    }

    @KSMethod
    public boolean isChild(ScriptMember scriptMember) {
        return this.isChild(scriptMember.getNumber());
    }

    @KSMethod
    public boolean isDescendant(String memberNumber) {
        this.checkNumberIsNotNull(memberNumber);
        IDNumberTreeNode node = this.getIDNumberTreeNode();
        return this.isDescendantByNumber(node, memberNumber);
    }

    @KSMethod
    public boolean isDescendant(ScriptMember scriptMember) {
        return this.isDescendant(scriptMember.getNumber());
    }

    private boolean isDescendantByNumber(IDNumberTreeNode node, String memberNumber) {
        for (IDNumberTreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!memberNumber.equalsIgnoreCase(parent.getNumber())) continue;
            return true;
        }
        return false;
    }

    @KSMethod
    public boolean isBase(String memberNumber) {
        return this.getDimension().isBase(this.getNumber(), memberNumber);
    }

    @KSMethod
    public boolean isBase(ScriptMember scriptMember) {
        return this.isBase(scriptMember.getNumber());
    }

    @KSMethod
    public boolean isBase() {
        return this.getIDNumberTreeNode().isLeaf();
    }

    @KSMethod
    public ScriptMember[] children() {
        return (ScriptMember[])ScriptCache.getCacheOf("children_" + this.getDimension().number + this.id, () -> {
            List children = this.getIDNumberTreeNode().getChildren();
            ScriptMember[] self = this.returnSelfIfLeafNode(children);
            if (self != null) {
                return self;
            }
            ScriptMember[] scriptMembers = new ScriptMember[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                IDNumberTreeNode node = (IDNumberTreeNode)children.get(i);
                scriptMembers[i] = this instanceof ScriptMemberExtDimensionNode ? ScriptMember.extCreate(node.getNumber(), this.dimension, node.getId()) : ScriptMember.create(node.getNumber(), this.dimension, node.getId());
            }
            return scriptMembers;
        });
    }

    @KSMethod
    public ScriptMember parent() {
        IDNumberTreeNode parent = this.getIDNumberTreeNode().getParent();
        if (parent != null) {
            if (this instanceof ScriptMemberExtDimensionNode) {
                return ScriptMember.extCreate(parent.getNumber(), this.dimension, parent.getId());
            }
            return ScriptMember.create(parent.getNumber(), this.dimension, parent.getId());
        }
        return null;
    }

    @KSMethod
    public ScriptMember[] base() {
        return (ScriptMember[])ScriptCache.getCacheOf("base_" + this.getDimension().number + this.id, () -> {
            List leafChildren = this.getIDNumberTreeNode().getAllChildren(3);
            ScriptMember[] self = this.returnSelfIfLeafNode(leafChildren);
            if (self != null) {
                return self;
            }
            ScriptMember[] scriptMembers = new ScriptMember[leafChildren.size()];
            for (int i = 0; i < leafChildren.size(); ++i) {
                IDNumberTreeNode node = (IDNumberTreeNode)leafChildren.get(i);
                scriptMembers[i] = this instanceof ScriptMemberExtDimensionNode ? ScriptMember.extCreate(node.getNumber(), this.dimension, node.getId()) : ScriptMember.create(node.getNumber(), this.dimension, node.getId());
            }
            return scriptMembers;
        });
    }

    private ScriptMember[] returnSelfIfLeafNode(List<IDNumberTreeNode> leafChildren) {
        if (CollectionUtils.isEmpty(leafChildren) && this.getIDNumberTreeNode().isLeaf()) {
            return new ScriptMember[]{this};
        }
        return null;
    }

    @KSMethod
    public ScriptMember[] hierarchy() {
        return (ScriptMember[])ScriptCache.getCacheOf("hierarchy_" + this.getDimension().number + this.id, () -> {
            List leafChildren = this.getIDNumberTreeNode().getAllChildren();
            ScriptMember[] scriptMembers = new ScriptMember[leafChildren.size() + 1];
            scriptMembers[0] = this;
            for (int i = 0; i < leafChildren.size(); ++i) {
                IDNumberTreeNode node = (IDNumberTreeNode)leafChildren.get(i);
                scriptMembers[i + 1] = this instanceof ScriptMemberExtDimensionNode ? ScriptMember.extCreate(node.getNumber(), this.dimension, node.getId()) : ScriptMember.create(node.getNumber(), this.dimension, node.getId());
            }
            return scriptMembers;
        });
    }

    @KSMethod
    public boolean isHierarchy(String memberNumber) {
        int firstExclamationMark = memberNumber.indexOf(33);
        if (firstExclamationMark >= 0) {
            Object memberObj = this.getDimension().__getUndefinedElement(memberNumber);
            if (memberObj instanceof ScriptMember) {
                ScriptMember member = (ScriptMember)memberObj;
                if (this.id == member.id) {
                    return true;
                }
                return this.isDescendant(member);
            }
            throw new ScriptAnalyzeException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u4e2d\u627e\u4e0d\u5230\u6210\u5458:%2$s\uff0c\u8bf7\u786e\u8ba4\u8be5\u7ef4\u5ea6\u6210\u5458\u662f\u5426\u5b58\u5728\u3002", (String)"ScriptMember_0", (String)"fi-bcm-computing", (Object[])new Object[0]), this.getDimension().getNumber(), memberNumber));
        }
        if (this.getNumber().equalsIgnoreCase(memberNumber)) {
            return true;
        }
        return this.isDescendant(memberNumber);
    }

    @KSMethod
    public boolean isHierarchy(ScriptMember scriptMember) {
        if (this.id == scriptMember.id) {
            return true;
        }
        return this.isDescendant(scriptMember);
    }

    @KSMethod
    public ScriptMember[] descendant() {
        return (ScriptMember[])ScriptCache.getCacheOf("descendant_" + this.getDimension().number + this.id, () -> {
            List leafChildren = this.getIDNumberTreeNode().getAllChildren();
            ScriptMember[] self = this.returnSelfIfLeafNode(leafChildren);
            if (self != null) {
                return self;
            }
            ScriptMember[] scriptMembers = new ScriptMember[leafChildren.size()];
            for (int i = 0; i < leafChildren.size(); ++i) {
                IDNumberTreeNode node = (IDNumberTreeNode)leafChildren.get(i);
                scriptMembers[i] = this instanceof ScriptMemberExtDimensionNode ? ScriptMember.extCreate(node.getNumber(), this.dimension, node.getId()) : ScriptMember.create(node.getNumber(), this.dimension, node.getId());
            }
            return scriptMembers;
        });
    }

    protected void checkNumberIsNotNull(String number) {
        if (number == null || number.trim().isEmpty()) {
            throw new RuntimeException(String.format("number [%s] can't be null or empty", number));
        }
    }
}

