/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing;

import java.util.Map;
import javax.script.SimpleBindings;
import kd.bos.olap.dataSources.AggPair;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.metadata.MetadataTypes;
import kd.fi.bcm.computing.BindingsCache;
import kd.fi.bcm.computing.ScriptDimension;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.datasource.OutlineNode;

public class ScriptObjectBindings
extends SimpleBindings {
    private final OlapConnection olapConn;
    private final Map<String, Object> args;
    private final IOutline outline;
    private final BindingsCache<String, Object> mapperCache = new BindingsCache(200);

    public ScriptObjectBindings(OlapConnection olapConn, Map<String, Object> args, IOutline outline) {
        this.olapConn = olapConn;
        this.args = args;
        this.outline = outline;
    }

    public OlapConnection getOlapConn() {
        return this.olapConn;
    }

    public Map<String, Object> getArgs() {
        return this.args;
    }

    public IOutline getOutline() {
        return this.outline;
    }

    @Override
    public boolean containsKey(Object key) {
        return (key == null || key instanceof String) && this.contains((String)key);
    }

    private boolean contains(String key) {
        if (key != null) {
            if (this.args != null && this.args.containsKey(key)) {
                return true;
            }
            if (this.mapperCache.containsKey(key)) {
                return true;
            }
            Object node = this.tryGetNode(key);
            if (node != null) {
                this.mapperCache.put(key, node);
                return true;
            }
        }
        return super.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            return this.getByString((String)key);
        }
        return null;
    }

    private Object getByString(String name) {
        if (this.args != null && this.args.containsKey(name)) {
            Object argValue = this.args.get(name);
            if (argValue instanceof String) {
                if (((String)argValue).length() > 1 && ((String)argValue).startsWith("\"") && ((String)argValue).endsWith("\"")) {
                    return ((String)argValue).substring(1, ((String)argValue).length() - 1);
                }
                return this.tryGetNode((String)argValue) != null ? this.tryGetNode((String)argValue) : argValue;
            }
            if (argValue != null) {
                this.mapperCache.put(name, argValue);
            }
            return argValue;
        }
        Object node = this.tryGetNode(name);
        if (node != null) {
            this.mapperCache.put(name, node);
            return node;
        }
        return super.get(name);
    }

    private Object tryGetNode(String name) {
        OutlineNode node = this.outline.tryGetNode(name);
        if (node != null) {
            if (MetadataTypes.Dimension == node.getNodeType()) {
                return ScriptDimension.create(name, this.olapConn, this.outline);
            }
            if (MetadataTypes.Member == node.getNodeType()) {
                return new AggPair(name, null);
            }
            return null;
        }
        return null;
    }
}

