/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.dataSources.AggPair;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.metadata.MetadataTypes;
import kd.bos.script.VarProvider;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.exception.ScriptAnalyzeException;
import kd.fi.bcm.computing.ScriptBuiltin;
import kd.fi.bcm.computing.ScriptDimension;
import kd.fi.bcm.computing.bizrule.log.AuditLogHelper;
import kd.fi.bcm.computing.datasource.ExtOutlineNode;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.datasource.OutlineNode;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.WrappedException;

public class VarProviderImpl
implements VarProvider {
    private final OlapConnection olapConn;
    private final Map<String, Object> args;
    private final IOutline outline;
    private final ScriptBuiltin builtin;
    private static final String XDM = "XDM";
    private Map<String, String> shortNumber2NumberMap = null;

    public VarProviderImpl(OlapConnection olapConn, Map<String, Object> args, IOutline outline) {
        this.olapConn = olapConn;
        this.args = args;
        this.outline = outline;
        this.builtin = (ScriptBuiltin)AuditLogHelper.proxyWithAuditEvent(new ScriptBuiltin(olapConn, args, outline), new Class[]{OlapConnection.class, Map.class, IOutline.class}, new Object[]{olapConn, args, outline});
        outline.setBuiltin(this.builtin);
    }

    public Object get(String name, Object p1) {
        if (name != null) {
            if ("__builtin__".equals(name)) {
                return this.builtin;
            }
            Object argValue = this.args.get(name);
            if (argValue != null) {
                if (argValue instanceof String) {
                    if (((String)argValue).length() > 1 && ((String)argValue).startsWith("\"") && ((String)argValue).endsWith("\"")) {
                        return ((String)argValue).substring(1, ((String)argValue).length() - 1);
                    }
                    return this.tryGetNode((String)argValue) != null ? this.tryGetNode((String)argValue) : argValue;
                }
                return argValue;
            }
            Object node = this.tryGetNode(name);
            if (node != null) {
                return node;
            }
        }
        throw new WrappedException((Throwable)new ScriptAnalyzeException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a %s \u7684\u7ef4\u5ea6\u6216\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"VarProviderImpl_0", (String)"fi-bcm-computing", (Object[])new Object[0]), name)));
    }

    private Object tryGetNode(String name) {
        String number;
        Boolean isExtendFlag = Boolean.FALSE;
        if (this.shortNumber2NumberMap == null) {
            this.shortNumber2NumberMap = MemberReader.getDimensionShortNumber2NumberMap((String)this.outline.getModelNum());
        }
        if ((number = this.shortNumber2NumberMap.get(name)) == null) {
            DynamicObject extendDyo = this.getExtendByModelNum();
            if (extendDyo != null && (name.equals(extendDyo.getString("shortnumber")) || XDM.equals(name))) {
                number = extendDyo.getString("number");
                isExtendFlag = Boolean.TRUE;
            } else if (this.outline.getComputingContext().getExtendNumbers().contains(name)) {
                number = name;
                isExtendFlag = Boolean.TRUE;
            } else {
                number = name;
            }
        }
        OutlineNode node = null;
        ExtOutlineNode extNode = null;
        try {
            if (isExtendFlag.booleanValue()) {
                extNode = this.outline.tryGetExtendNode(number);
            } else if (number.split("[.@]").length > 1 || this.shortNumber2NumberMap.containsValue(number)) {
                node = this.outline.tryGetNode(number);
            }
        }
        catch (RhinoException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new WrappedException((Throwable)e1);
        }
        if (node != null) {
            if (MetadataTypes.Dimension == node.getNodeType()) {
                return ScriptDimension.create(number, this.olapConn, this.outline);
            }
            if (MetadataTypes.Member == node.getNodeType()) {
                return new AggPair(number, null);
            }
            return null;
        }
        if (extNode != null) {
            return ScriptDimension.create(number, this.olapConn, this.outline, true, XDM.equals(name));
        }
        return null;
    }

    private DynamicObject getExtendByModelNum() {
        Long modelId = MemberReader.findModelIdByNum((String)this.outline.getModelNum());
        Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)DimEntityNumEnum.EXTENDS.getNumber());
        return dimId == null ? null : MemberReader.getDimensionDynById((long)dimId);
    }
}

