/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.computing.ScopeInfo;
import kd.fi.bcm.computing.ScriptMember;
import kd.fi.bcm.computing.XDMDimensionFilterItem;
import org.apache.commons.collections.CollectionUtils;

public class XDMScopeInfo
extends ScopeInfo {
    private static final String IN = "in";
    private static final String LIKE = "like";
    private static final String NOTLIKE = "not like";
    private static final String NOTIN = "not in";
    private Collection<XDMDimensionFilterItem> filters;
    private String modelNum;
    private Long extendsmodelId;
    private String extendsmodelNumber;
    private Set<String> extendNumbers;

    public XDMScopeInfo(Collection<XDMDimensionFilterItem> filters) {
        this.filters = filters;
    }

    public Collection<XDMDimensionFilterItem> getXdmFilters() {
        return this.filters;
    }

    @Override
    public void setModelNum(String modelNum) {
        this.modelNum = modelNum;
    }

    public String getModelNum() {
        return this.modelNum;
    }

    public Long getExtendsmodelId() {
        return this.extendsmodelId;
    }

    public void setExtendsmodelId(Long extendsmodelId) {
        this.extendsmodelId = extendsmodelId;
    }

    public void setExtendsmodelNumber(String extendsmodelNumber) {
        this.extendsmodelNumber = extendsmodelNumber;
    }

    public String getExtendsmodelNumber() {
        return this.extendsmodelNumber;
    }

    public void setExtendNumbers(Set<String> extendNumbers) {
        this.extendNumbers = extendNumbers;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("XDMScopeInfo{");
        StringJoiner sj = new StringJoiner(",");
        if (this.filters != null) {
            this.filters.forEach(f -> sj.add(String.format("%s.%s:%s", f.getName(), f.getCondition(), String.join((CharSequence)",", f.getValues().toString()))));
        }
        sb.append(sj).append('}');
        return sb.toString();
    }

    public XDMScopeInfo() {
        this.filters = new ArrayList<XDMDimensionFilterItem>();
    }

    public static XDMScopeInfo create(Long datamodelId, String datamodelNum, Set<String> extendNumbers, Object ... XDMScopeInfo2) {
        XDMScopeInfo newXDMScopeInfo = new XDMScopeInfo();
        newXDMScopeInfo.setExtendsmodelId(datamodelId);
        newXDMScopeInfo.setExtendsmodelNumber(datamodelNum);
        newXDMScopeInfo.XDMScope(datamodelNum, extendNumbers, XDMScopeInfo2);
        return newXDMScopeInfo;
    }

    public static XDMScopeInfo create(Object[] scopeInfo) {
        XDMScopeInfo xdmScopeInfo = new XDMScopeInfo();
        xdmScopeInfo.XDMScope(null, Collections.emptySet(), scopeInfo);
        return xdmScopeInfo;
    }

    public void XDMScope(String datamodelNum, Set<String> extendNumbers, Object ... anys) {
        HashMap<String, Set<Object>> tempInMap = new HashMap<String, Set<Object>>(16);
        HashMap<String, Set<Object>> tempLikeMap = new HashMap<String, Set<Object>>(16);
        HashMap<String, Set<Object>> tempDimMap = new HashMap<String, Set<Object>>(16);
        ArrayList<XDMDimensionFilterItem> tempFilter = new ArrayList<XDMDimensionFilterItem>(10);
        Boolean isExceptFlag = Boolean.FALSE;
        if (datamodelNum != null) {
            this.setExtendsmodelNumber(datamodelNum);
        }
        this.setExtendNumbers(extendNumbers);
        if (anys == null) {
            this.filters = tempFilter;
            return;
        }
        if (CollectionUtils.isNotEmpty(this.filters)) {
            tempFilter.addAll(this.filters);
        }
        if (anys.length == 1 && anys[0] instanceof Object[]) {
            Object items = anys[0];
            this.merge(new Object[]{items}, tempInMap, tempLikeMap, tempDimMap, tempFilter, isExceptFlag, datamodelNum, extendNumbers);
        } else {
            this.merge(anys, tempInMap, tempLikeMap, tempDimMap, tempFilter, isExceptFlag, datamodelNum, extendNumbers);
        }
        this.creatXDMFilter(IN, tempInMap, tempFilter);
        this.creatXDMFilter(IN, tempDimMap, tempFilter);
        this.creatXDMFilter(LIKE, tempLikeMap, tempFilter);
        this.filters = tempFilter;
    }

    private void creatXDMFilter(String condition, Map<String, Set<Object>> tempMap, List<XDMDimensionFilterItem> tempFilter) {
        for (Map.Entry<String, Set<Object>> entry : tempMap.entrySet()) {
            String key = entry.getKey();
            tempFilter.add(new XDMDimensionFilterItem(key, condition, entry.getValue() == null ? null : new ArrayList(entry.getValue())));
        }
    }

    private void merge(Object[] anys, Map<String, Set<Object>> tempInMap, Map<String, Set<Object>> tempLikeMap, Map<String, Set<Object>> tempDimMap, List<XDMDimensionFilterItem> tempFilter, Boolean isExceptFlag, String datamodelNum, Set<String> extendNumbers) {
        for (Object any : anys) {
            if (any instanceof XDMScopeInfo) {
                if (datamodelNum != null && ((XDMScopeInfo)any).extendsmodelNumber != null && !datamodelNum.equals(((XDMScopeInfo)any).extendsmodelNumber)) {
                    throw new BizRuleException(ResManager.loadKDString((String)"XDMScope\u7684\u6240\u6709\u5b57\u6bb5\u6761\u4ef6\u53ea\u80fd\u6765\u81ea\u540c\u4e00\u4e2a\u62d3\u5c55\u6570\u636e\u6a21\u578b\u3002", (String)"ScriptMemberExtDimensionNode_8", (String)"fi-bcm-computing", (Object[])new Object[0]));
                }
                this.mergeWithXDMScopeInfo(tempInMap, tempLikeMap, any, tempFilter, isExceptFlag, datamodelNum, extendNumbers);
                continue;
            }
            if (any instanceof ScopeInfo) {
                this.mergeWithScopeInfo(tempDimMap, any);
                continue;
            }
            if (any instanceof ScriptMember) {
                this.mergeWithScriptMember(tempDimMap, any);
                continue;
            }
            if (any instanceof Object[]) {
                this.merge((Object[])any, tempInMap, tempLikeMap, tempDimMap, tempFilter, isExceptFlag, datamodelNum, extendNumbers);
                continue;
            }
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u6784\u9020\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u65f6\uff0c\u4f7f\u7528\u4e86\u65e0\u6cd5\u8bc6\u522b\u7684\u7c7b\u578b\uff1a%s\u3002", (String)"ScopeInfo_0", (String)"fi-bcm-computing", (Object[])new Object[0]), any == null ? null : any.getClass()));
        }
    }

    private void mergeWithScopeInfo(Map<String, Set<Object>> tempMap, Object any) {
        for (DimensionFilterItem filter : ((ScopeInfo)any).getFilters()) {
            String dimName = filter.getName();
            List values = filter.getValues();
            Set<Object> members = tempMap.get(dimName);
            if (members == null) {
                tempMap.put(dimName, new LinkedHashSet(values));
                continue;
            }
            members.addAll(values);
        }
    }

    private void mergeWithScriptMember(Map<String, Set<Object>> tempMap, Object any) {
        Set members = tempMap.computeIfAbsent(((ScriptMember)any).getDimension().getNumber(), k -> new LinkedHashSet(16));
        members.add(((ScriptMember)any).getNumber());
    }

    private void mergeWithXDMScopeInfo(Map<String, Set<Object>> tempInMap, Map<String, Set<Object>> tempLikeMap, Object any, List<XDMDimensionFilterItem> tempFilter, Boolean isExceptFlag, String datamodelNum, Set<String> extendNumbers) {
        for (XDMDimensionFilterItem filter : ((XDMScopeInfo)any).getXdmFilters()) {
            Set<Object> members;
            String dimName = filter.getName();
            List<Object> values = filter.getValues();
            if (IN.equals(filter.getCondition())) {
                members = tempInMap.get(dimName);
                if (members == null) {
                    tempInMap.put(dimName, new LinkedHashSet<Object>(values));
                    continue;
                }
                members.addAll(values);
                continue;
            }
            if (LIKE.equals(filter.getCondition())) {
                members = tempLikeMap.get(dimName);
                if (members == null) {
                    tempLikeMap.put(dimName, new LinkedHashSet<Object>(values));
                    continue;
                }
                members.addAll(values);
                continue;
            }
            String condition = filter.getCondition();
            if (isExceptFlag.booleanValue()) {
                if (">".equals(condition)) {
                    condition = "<=";
                } else if ("<".equals(condition)) {
                    condition = ">=";
                } else if ("is null".equals(condition)) {
                    condition = "is not null";
                } else if ("is not null".equals(condition)) {
                    condition = "is null";
                }
            }
            tempFilter.add(new XDMDimensionFilterItem(dimName, condition, values == null ? null : new ArrayList<Object>(values)));
        }
    }

    @Override
    public ScopeInfo except(Object ... anys) {
        HashMap<String, Set<Object>> tempInMap = new HashMap<String, Set<Object>>(16);
        HashMap<String, Set<Object>> tempLikeMap = new HashMap<String, Set<Object>>(16);
        HashMap<String, Set<Object>> tempDimMap = new HashMap<String, Set<Object>>(16);
        ArrayList<XDMDimensionFilterItem> tempFilter = new ArrayList<XDMDimensionFilterItem>(10);
        Boolean isExceptFlag = Boolean.TRUE;
        if (anys.length == 1 && anys[0] instanceof Object[]) {
            Object items = anys[0];
            this.merge(new Object[]{items}, tempInMap, tempLikeMap, tempDimMap, tempFilter, isExceptFlag, this.extendsmodelNumber, this.extendNumbers);
        } else {
            this.merge(anys, tempInMap, tempLikeMap, tempDimMap, tempFilter, isExceptFlag, this.extendsmodelNumber, this.extendNumbers);
        }
        this.creatExceptFilter(NOTIN, tempInMap);
        this.creatExceptFilter(NOTIN, tempDimMap);
        this.creatExceptFilter(NOTLIKE, tempLikeMap);
        this.filters.addAll(tempFilter);
        XDMScopeInfo xdmScopeInfo = new XDMScopeInfo(this.filters);
        xdmScopeInfo.setExtendsmodelNumber(this.extendsmodelNumber);
        xdmScopeInfo.setExtendNumbers(this.extendNumbers);
        return xdmScopeInfo;
    }

    private void creatExceptFilter(String condition, Map<String, Set<Object>> tempMap) {
        for (Map.Entry<String, Set<Object>> filter : tempMap.entrySet()) {
            XDMDimensionFilterItem inFilter = null;
            if (filter.getValue() == null) {
                XDMDimensionFilterItem item = new XDMDimensionFilterItem(filter.getKey(), condition, null);
                this.filters.add(item);
                continue;
            }
            LinkedHashSet src = new LinkedHashSet(filter.getValue());
            for (XDMDimensionFilterItem in : this.getXdmFilters()) {
                if (!in.getName().equals(filter.getKey()) || !NOTIN.equals(condition) || !IN.equals(in.getCondition())) continue;
                inFilter = in;
                LinkedHashSet<Object> tar = new LinkedHashSet<Object>(in.getValues());
                tar.removeAll(src);
                inFilter.setValues(new ArrayList<Object>(tar));
                in.setValues(new ArrayList<Object>(tar));
                break;
            }
            if (inFilter != null) continue;
            String key = filter.getKey();
            XDMDimensionFilterItem item = new XDMDimensionFilterItem(key, condition, new ArrayList<Object>(src));
            this.filters.add(item);
        }
    }
}

