/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.bizabout;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.common.msservice.MsServiceHelper;
import kd.fi.bcm.common.util.InvokeUtils;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.ScopeInfo;
import kd.fi.bcm.computing.ScriptMember;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.spread.common.util.StringUtil;

public class AboutFormulaServer {
    private final IOutline outline;
    private static final String NUMBER = "number";
    private static final String ENTITY = "entity";
    private static final String MODEL_NUMBER = "model.number";
    private static final String MODEL = "model";
    private static final String PERIOD = "period";
    private static final String SCENE = "scene";
    private static final Map<String, String> SPECIAL_PROPERTY_MAP = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("BOYRate", "beginyear");
            this.put("ClosingRate", "periodend");
            this.put("AverageRate", "average");
            this.put("UserdefinedRate", "userdefine");
        }
    });

    public AboutFormulaServer(IOutline outline) {
        this.outline = outline;
    }

    public BigDecimal esp(Object[] args) {
        this.checkParamSize("esp", args, 4);
        String relaType = args[0].toString();
        String valType = args[1].toString();
        if (args[2] == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u76f8\u5e94\u7684\u63a7\u80a1\u7ec4\u7ec7\u3002", (String)"AboutFormulaServer_3", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        String investCmp = args[2].toString();
        String investeeCmp = args[3].toString();
        String scenario = this.getDefaultParamVal(args, 4, PresetConstant.SCENE_DIM);
        String fy = this.getDefaultParamVal(args, 5, PresetConstant.FY_DIM);
        String period = this.getDefaultParamVal(args, 6, PresetConstant.PERIOD_DIM);
        String formula = this.constructFormula("esp", relaType, valType, scenario, fy, period, investCmp, investeeCmp);
        Map formulas = MapInitHelper.ofMap((Object)"1", (Object)formula);
        String key = formulas.toString() + this.getCommonConditionKey();
        return (BigDecimal)GlobalCacheServiceHelper.getOrLoadNode((String)key, () -> {
            Map<String, String> args2 = this.getCommonParams();
            return this.invokeFormulaService("esp", formulas, args2, v -> this.limitScale(new BigDecimal(v.toString())), BigDecimal.ZERO);
        });
    }

    public BigDecimal getRate(Object[] args) {
        this.checkParamSize("getRate", args, 3);
        String srcCurrency = args[0].toString();
        String targCurrency = args[1].toString();
        String rateType = args[2].toString();
        String scenario = this.getDefaultParamVal(args, 4, PresetConstant.SCENE_DIM);
        String fy = this.getDefaultParamVal(args, 5, PresetConstant.FY_DIM);
        String period = this.getDefaultParamVal(args, 6, PresetConstant.PERIOD_DIM);
        if (srcCurrency.equals(targCurrency)) {
            return BigDecimal.ONE;
        }
        this.checkRateType(rateType);
        String scheme = this.getCurSchema(args.length > 3 ? args[3] : "", scenario, fy, period);
        ArrayList<String> scope = new ArrayList<String>(12);
        scope.add(this.packDimAndMember(PresetConstant.PROCESS_DIM, srcCurrency));
        scope.add(this.packDimAndMember(PresetConstant.CURRENCY_DIM, targCurrency));
        scope.add(this.packDimAndMember(PresetConstant.ACCOUNT_DIM, rateType));
        scope.add(this.packDimAndMember(PresetConstant.ENTITY_DIM, scheme));
        scope.add(this.packDimAndMember(PresetConstant.FY_DIM, fy));
        scope.add(this.packDimAndMember(PresetConstant.PERIOD_DIM, period));
        scope.add(this.packDimAndMember(PresetConstant.SCENE_DIM, scenario));
        for (Pair p : this.getDefaultDimensionMember()) {
            scope.add(this.packDimAndMember((String)p.p1, (String)p.p2));
        }
        String expression = Joiner.on((char)',').join(scope);
        ScopeInfo scopeInfo = this.outline.getComputingContext().getRuntimeScope(null);
        String key = expression + scopeInfo.toString();
        Object v = GlobalCacheServiceHelper.getOrLoadNode((String)key, () -> this.outline.getBuiltin().evalOld(scopeInfo, expression, BigDecimal.ZERO));
        if (v instanceof BigDecimal) {
            return this.limitScale((BigDecimal)v);
        }
        throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6c47\u7387\u503c\u201c%1$s\u201d,\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u201c%2$s\u201d\u3002", (String)"AboutFormulaServer_0", (String)"fi-bcm-computing", (Object[])new Object[0]), "" + v, ((Object)scope).toString()));
    }

    public void setRate(Object[] args) {
        if (args.length < 5 || args.length > 6) {
            throw new BizRuleException(ResManager.loadKDString((String)"setRate()\u51fd\u6570\u53c2\u6570\u6709\u8bef\uff0c\u6216\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\u3002", (String)"AboutFormulaServer_4", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        String rateEnt = args[0] == null ? "" : args[0].toString();
        String srcCurr = args[1] == null ? "" : args[1].toString();
        String tarCurr = args[2] == null ? "" : args[2].toString();
        String rateType = args[3] == null ? "" : args[3].toString();
        Object rateData = args[4];
        this.checkRateEntNum(rateEnt);
        this.checkCurr(srcCurr, tarCurr);
        this.checkRateType(rateType);
        BigDecimal newRateData = this.checkRateData(rateData);
        int precision = 15;
        int scale = newRateData.scale();
        if (args.length == 6) {
            if (!(args[5] instanceof Number) || args[5].toString().contains(".")) {
                throw new BizRuleException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u7cbe\u5ea6\u53c2\u6570\u6216\u7cbe\u5ea6\u53c2\u6570\u5927\u4e8e15\u3002", (String)"AboutFormulaServer_16", (String)"fi-bcm-computing", (Object[])new Object[0]));
            }
            precision = Integer.parseInt(args[5].toString());
        }
        if (precision > 15 || precision < 0) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u7cbe\u5ea6\u53c2\u6570\u6216\u7cbe\u5ea6\u53c2\u6570\u5927\u4e8e15\u3002", (String)"AboutFormulaServer_16", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        if (scale > precision) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u6307\u5b9a\u7684\u7cbe\u5ea6\u53c2\u6570\u5c0f\u4e8e\u6c47\u7387\u6570\u503c\u7684\u7cbe\u5ea6\u3002", (String)"AboutFormulaServer_12", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        this.updateRate(rateEnt, srcCurr, tarCurr, rateType, newRateData, precision);
    }

    private void saveOlapRate(List<DynamicObject> rows, String rateEnt, String rateType) {
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        Map<String, Pair<Long, String>> scopeItems = this.outline.getComputingContext().getScopeItems();
        String scenarioNumber = (String)scopeItems.get((Object)DimTypesEnum.SCENARIO.getNumber()).p2;
        Pair fyPair = Pair.onePair((Object)DimTypesEnum.YEAR.getNumber(), (Object)scopeItems.get((Object)DimTypesEnum.YEAR.getNumber()).p2);
        Pair periodPair = Pair.onePair((Object)DimTypesEnum.PERIOD.getNumber(), (Object)scopeItems.get((Object)DimTypesEnum.PERIOD.getNumber()).p2);
        Pair entityPair = Pair.onePair((Object)DimTypesEnum.ENTITY.getNumber(), (Object)rateEnt);
        pairs.add(fyPair);
        pairs.add(periodPair);
        pairs.add(entityPair);
        this.getDefaultDimensionMember().forEach(pairs::add);
        Object[] params = new Object[]{pairs, rows, rateType, this.outline.getModelNum(), false, Collections.singleton(scenarioNumber), OlapSourceEnum.S1};
        InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.exchangeRate.ExchageRateServiceHelper", (String)"saveExchangeRate4Rows", (Object[])params);
    }

    private void updateRate(String rateEnt, String srcCurr, String tarCurr, String rateType, BigDecimal rateData, int precision) {
        DynamicObject rate = QueryServiceHelper.queryOne((String)"bcm_exchagerate", (String)"id,fromid,triangle", (QFilter[])this.getUniqueFilters(rateEnt, srcCurr, tarCurr));
        if (rate != null && !StringUtil.isEmptyString((String)rate.getString("triangle"))) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u5b58\u5728\u4e09\u89d2\u6c47\u7387\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"AboutFormulaServer_13", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        if (rate != null && rate.getLong("fromid") != 0L) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u5b58\u5728\u6c47\u7387\u4e92\u7b97\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"AboutFormulaServer_14", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        Long modelId = MemberReader.findModelIdByNum((String)this.outline.getModelNum());
        Object[] params = new Object[]{modelId, "CM009"};
        boolean isUpdateRate = (Boolean)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.serviceHelper.ConfigServiceHelper", (String)"getBoolParam", (Object[])params);
        if (!isUpdateRate && (Arrays.asList("BOYRate", "BOYAverageRate", "BOYUserdefinedRate").contains(rateType) || rateType.startsWith("BOYUserdefinedRate"))) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7684\u5e74\u521d\u6c47\u7387\u3001\u5e74\u521d\u81ea\u5b9a\u4e49\u6c47\u7387\u548c\u5e74\u521d\u5e73\u5747\u6c47\u7387\u5747\u4e3a\u53ea\u8bfb\uff0c\u4e0d\u53ef\u624b\u52a8\u4fee\u6539\u3002", (String)"AboutFormulaServer_15", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        DynamicObject updateRate = null;
        if (rate != null) {
            updateRate = BusinessDataServiceHelper.loadSingle((Object)rate.getLong("id"), (String)"bcm_exchagerate");
        } else {
            IDNumberTreeNode entityMem = MemberReader.findMemberByNumber((String)this.outline.getModelNum(), (String)DimTypesEnum.ENTITY.getNumber(), (String)rateEnt);
            DynamicObjectCollection exists = QueryServiceHelper.query((String)"bcm_exchagerate", (String)"id", (QFilter[])this.getEntityFilters(modelId, entityMem));
            updateRate = BusinessDataServiceHelper.newDynamicObject((String)"bcm_exchagerate");
            int seq = CollectionUtils.isEmpty((Collection)exists) ? 0 : exists.size();
            updateRate.set(MODEL, (Object)modelId);
            updateRate.set(SCENE, this.outline.getComputingContext().getScopeItems().get((Object)SysDimensionEnum.Scenario.getNumber()).p1);
            updateRate.set("fy", this.outline.getComputingContext().getScopeItems().get((Object)SysDimensionEnum.Year.getNumber()).p1);
            updateRate.set(PERIOD, this.outline.getComputingContext().getScopeItems().get((Object)SysDimensionEnum.Period.getNumber()).p1);
            updateRate.set(ENTITY, (Object)entityMem.getId());
            updateRate.set("eseq", (Object)seq);
            updateRate.set("source", (Object)BusinessDataServiceHelper.loadSingle((Object)MemberReader.findProcessMemberByNum((String)this.outline.getModelNum(), (String)srcCurr).getId(), (String)"bcm_processmembertree"));
            updateRate.set("target", (Object)BusinessDataServiceHelper.loadSingle((Object)MemberReader.findCurrencyMemberByNum((String)this.outline.getModelNum(), (String)tarCurr).getId(), (String)"bcm_currencymembertree"));
        }
        String type = SPECIAL_PROPERTY_MAP.get(rateType) != null ? SPECIAL_PROPERTY_MAP.get(rateType) : rateType;
        updateRate.set(type, (Object)rateData);
        updateRate.set("precision", (Object)precision);
        updateRate.set("modifier", (Object)RequestContext.get().getCurrUserId());
        updateRate.set("modifytime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{updateRate});
        this.saveOlapRate(Collections.singletonList(updateRate), rateEnt, type);
    }

    private QFilter[] getEntityFilters(Long modelId, IDNumberTreeNode entityMem) {
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)modelId);
        qfBuilder.and(SCENE, "=", this.outline.getComputingContext().getScopeItems().get((Object)SysDimensionEnum.Scenario.getNumber()).p1);
        qfBuilder.and("fy", "=", this.outline.getComputingContext().getScopeItems().get((Object)SysDimensionEnum.Year.getNumber()).p1);
        qfBuilder.and(PERIOD, "=", this.outline.getComputingContext().getScopeItems().get((Object)SysDimensionEnum.Period.getNumber()).p1);
        qfBuilder.and(ENTITY, "=", (Object)entityMem.getId());
        return qfBuilder.toArray();
    }

    private QFilter[] getUniqueFilters(String rateEnt, String srcCurr, String tarCurr) {
        IDNumberTreeNode entityMem = MemberReader.findMemberByNumber((String)this.outline.getModelNum(), (String)DimTypesEnum.ENTITY.getNumber(), (String)rateEnt);
        IDNumberTreeNode src = MemberReader.findMemberByNumber((String)this.outline.getModelNum(), (String)DimTypesEnum.PROCESS.getNumber(), (String)srcCurr);
        IDNumberTreeNode tar = MemberReader.findMemberByNumber((String)this.outline.getModelNum(), (String)DimTypesEnum.CURRENCY.getNumber(), (String)tarCurr);
        return new QFilter[]{new QFilter(MODEL_NUMBER, "=", (Object)this.outline.getModelNum()), new QFilter(SCENE, "=", this.outline.getComputingContext().getScopeItems().get((Object)SysDimensionEnum.Scenario.getNumber()).p1), new QFilter("fy", "=", this.outline.getComputingContext().getScopeItems().get((Object)SysDimensionEnum.Year.getNumber()).p1), new QFilter(PERIOD, "=", this.outline.getComputingContext().getScopeItems().get((Object)SysDimensionEnum.Period.getNumber()).p1), new QFilter(ENTITY, "=", (Object)entityMem.getId()), new QFilter("source", "=", (Object)src.getId()), new QFilter("target", "=", (Object)tar.getId())};
    }

    private BigDecimal checkRateData(Object rateData) {
        int scale;
        if (!(rateData instanceof Number)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6c47\u7387\u503c\u6216\u5c0f\u6570\u7cbe\u5ea6\u8d85\u8fc7\u4e8615\u4f4d\u3002", (String)"AboutFormulaServer_11", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        if (rateData instanceof BigDecimal && (scale = ((BigDecimal)rateData).scale()) > 15) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6c47\u7387\u503c\u6216\u5c0f\u6570\u7cbe\u5ea6\u8d85\u8fc7\u4e8615\u4f4d\u3002", (String)"AboutFormulaServer_11", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        return new BigDecimal(String.valueOf(rateData));
    }

    private void checkRateType(String rateType) {
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)this.outline.getModelNum(), (String)DimEntityNumEnum.ACCOUNT.getNumber(), (String)rateType);
        if (node == IDNumberTreeNode.NotFoundTreeNode || node.getParent() == IDNumberTreeNode.NotFoundTreeNode || !"ExchangeRate".equals(node.getParent().getNumber())) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6c47\u7387\u7c7b\u578b\u3002", (String)"AboutFormulaServer_9", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
    }

    private void checkCurr(String srcCurr, String tarCurr) {
        QFBuilder qfBuilder = new QFBuilder(MODEL_NUMBER, "=", (Object)this.outline.getModelNum());
        qfBuilder.and("isleaf", "=", (Object)"1").and(NUMBER, "not in", (Object)new String[]{"CNone", "EC", "PC", "DC"});
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_currencymembertree", (String)NUMBER, (QFilter[])qfBuilder.toArray());
        Set numbers = dyns.stream().map(dyn -> dyn.getString(NUMBER)).collect(Collectors.toSet());
        if (!numbers.contains(srcCurr)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u539f\u5e01\u7f16\u7801\u3002", (String)"AboutFormulaServer_6", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        if (!numbers.contains(tarCurr)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u76ee\u6807\u5e01\u7f16\u7801\u3002", (String)"AboutFormulaServer_7", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        if (srcCurr.equals(tarCurr)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u539f\u5e01\u548c\u76ee\u6807\u5e01\u4e0d\u53ef\u76f8\u540c\u3002", (String)"AboutFormulaServer_8", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
    }

    private void checkRateEntNum(String rateEnt) {
        Object[] params2;
        boolean checkPeriodStatus;
        IDNumberTreeNode node = MemberReader.findEntityMemberByNum((String)this.outline.getModelNum(), (String)rateEnt);
        if (node == IDNumberTreeNode.NotFoundTreeNode || node.getParent() == IDNumberTreeNode.NotFoundTreeNode || !"RateEntity".equals(node.getParent().getNumber())) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6c47\u7387\u7ec4\u7ec7\u7f16\u7801\u3002", (String)"AboutFormulaServer_5", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        if (!node.isLeaf()) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u660e\u7ec6\u7684\u6c47\u7387\u7ec4\u7ec7\u624d\u80fd\u4fee\u6539\u6c47\u7387\u3002", (String)"AboutFormulaServer_17", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        Long modelId = MemberReader.findModelIdByNum((String)this.outline.getModelNum());
        Object[] params1 = new Object[]{modelId, "CM012"};
        boolean isopen = (Boolean)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.serviceHelper.ConfigServiceHelper", (String)"getBoolParam", (Object[])params1);
        if (isopen && !(checkPeriodStatus = ((Boolean)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.period.PeriodSettingHelper", (String)"checkPeriodStatus", (Object[])(params2 = new Object[]{modelId, rateEnt, this.outline.getComputingContext().getScopeItems().get((Object)SysDimensionEnum.Scenario.getNumber()).p1, this.outline.getComputingContext().getScopeItems().get((Object)SysDimensionEnum.Year.getNumber()).p1, this.outline.getComputingContext().getScopeItems().get((Object)SysDimensionEnum.Period.getNumber()).p1, "datastatus"}))).booleanValue())) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6c47\u7387\u7ec4\u7ec7[%s]\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AboutFormulaServer_10", (String)"fi-bcm-computing", (Object[])new Object[0]), rateEnt));
        }
    }

    private BigDecimal limitScale(BigDecimal v) {
        if (v.scale() > 15) {
            return v.setScale(15, RoundingMode.HALF_UP);
        }
        return v;
    }

    private String packDimAndMember(String dim, String member) {
        return dim + "@" + member;
    }

    private ApplicationTypeEnum getModelApp(long modelId) {
        QFilter fmodelid = new QFilter("id", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObject dcs = QueryServiceHelper.queryOne((String)"bcm_model", (String)"reporttype", (QFilter[])filters);
        ApplicationTypeEnum app = ApplicationTypeEnum.CM;
        if (dcs != null) {
            String reporttype = dcs.getString("reporttype");
            app = ApplicationTypeEnum.getEnumByIndex((String)reporttype);
        }
        return app;
    }

    private PairList<String, String> getDefaultDimensionMember() {
        return (PairList)ThreadCache.get((Object)("getDefaultDimensionMember" + this.outline.getModelNum()), () -> {
            ApplicationTypeEnum app;
            PairList pairs = new PairList();
            if (MemberReader.isExistAuditTrailDimension((String)this.outline.getModelNum())) {
                Pair at = Pair.onePair((Object)DimTypesEnum.AUDITTRIAL.getNumber(), (Object)"ATNone");
                pairs.add(at);
            }
            if (MemberReader.isExistChangeTypeDimension((String)this.outline.getModelNum())) {
                Pair ct = Pair.onePair((Object)DimTypesEnum.CHANGETYPE.getNumber(), PresetConstant.CHANGETYPE_MEMS.get(1));
                pairs.add(ct);
            }
            pairs.add(Pair.onePair((Object)DimTypesEnum.INTERCOMPANY.getNumber(), PresetConstant.INTERNALCOMPANY_MEMS.get(2)));
            Collection dimNums = MemberReader.getDimensionShortNumber2NumberMap((String)this.outline.getModelNum()).values();
            QFilter modelFilter = new QFilter(NUMBER, "=", (Object)this.outline.getModelNum());
            DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"isspptmultrule, isspptdatasort, defineddim", (QFilter[])new QFilter[]{modelFilter});
            if (dimNums.contains(DimTypesEnum.MULTIGAAP.getNumber())) {
                pairs.add(Pair.onePair((Object)DimTypesEnum.MULTIGAAP.getNumber(), PresetConstant.RULE_MEMS.get(1)));
            }
            if (dimNums.contains(DimTypesEnum.DATASORT.getNumber())) {
                pairs.add(Pair.onePair((Object)DimTypesEnum.DATASORT.getNumber(), (Object)"Actual"));
            }
            if (dimNums.contains("MyCompany")) {
                pairs.add(Pair.onePair((Object)DimTypesEnum.MYCOMPANY.getNumber(), (Object)"MCNone"));
            }
            if ((app = this.getModelApp(MemberReader.findModelIdByNum((String)this.outline.getModelNum()))) == ApplicationTypeEnum.RPT || app == ApplicationTypeEnum.UNRPT || app == ApplicationTypeEnum.PUB) {
                String defineddim = model.getString("defineddim");
                if (defineddim.contains("1")) {
                    pairs.add(Pair.onePair((Object)SysDimensionEnum.Project.getNumber(), (Object)(SysDimensionEnum.Project.getShortnumber() + "None")));
                } else if (defineddim.contains("2")) {
                    pairs.add(Pair.onePair((Object)SysDimensionEnum.BusinessPartner.getNumber(), (Object)(SysDimensionEnum.BusinessPartner.getShortnumber() + "None")));
                } else if (defineddim.contains("3")) {
                    pairs.add(Pair.onePair((Object)SysDimensionEnum.MultiBook.getNumber(), (Object)(SysDimensionEnum.MultiBook.getShortnumber() + "None")));
                }
            }
            QFBuilder filters = new QFBuilder();
            filters.add(new QFilter(MODEL, "=", (Object)MemberReader.findModelIdByNum((String)this.outline.getModelNum())));
            filters.add(new QFilter("level", "=", (Object)2));
            filters.add(new QFilter("ISSYSMEMBER", "=", (Object)1));
            filters.add(new QFilter(NUMBER, "like", (Object)"%None"));
            filters.add(new QFilter("dimension.ISSYSDIMENSION", "=", (Object)"0"));
            Collection dimMembers = BusinessDataServiceHelper.loadFromCache((String)"bcm_userdefinedmembertree", (String)"dimension.id,number,dimension.number", (QFilter[])filters.toArray()).values();
            dimMembers.stream().map(dyn -> Pair.onePair((Object)dyn.getString("dimension.number"), (Object)dyn.getString(NUMBER))).forEach(arg_0 -> ((PairList)pairs).add(arg_0));
            return pairs;
        });
    }

    private void checkParamSize(String formula, Object[] args, int checkSize) {
        if (args == null || args.length < checkSize) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%S\u51fd\u6570\u63d0\u4f9b\u7684\u53c2\u6570\u4e0d\u5bf9\uff0c\u6216\u5fc5\u8981\u53c2\u6570\u7f3a\u5931\u3002", (String)"AboutFormulaServer_1", (String)"fi-bcm-computing", (Object[])new Object[0]), formula, Arrays.toString(args)));
        }
    }

    private <T> T invokeFormulaService(String fomulaName, Map<String, String> formulas, Map<String, String> args, Function<Object, T> valHandle, T defVal) {
        Object v = MsServiceHelper.invokeService((String)"fi", (String)"bcm", (String)"CalculateMsService", (String)"calculateFormulas", (Object[])new Object[]{ObjectSerialUtil.toJson(formulas), ObjectSerialUtil.toJson(args)});
        Map argsMap = new HashMap();
        if (v != null) {
            argsMap = (Map)ObjectSerialUtil.parseObject((String)v.toString(), Map.class);
        }
        v = ((Map)argsMap.get("1")).get("v");
        Object failed = ((Map)argsMap.get("1")).get("failed");
        if (failed instanceof Boolean && ((Boolean)failed).booleanValue()) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f%1$s\u53d6\u6570\u62a5\u9519\uff1a%2$s\u3002", (String)"AboutFormulaServer_2", (String)"fi-bcm-computing", (Object[])new Object[0]), fomulaName, v));
        }
        if (v != null) {
            return valHandle.apply(v);
        }
        return defVal;
    }

    private String constructFormula(String formulaName, String ... args) {
        StringBuilder formula = new StringBuilder(formulaName);
        formula.append("(\"").append(Joiner.on((String)"\",\"").join((Object[])args)).append("\")");
        return formula.toString();
    }

    private Map<String, String> getCommonParams() {
        HashMap<String, String> args = new HashMap<String, String>(16);
        args.put(MODEL, BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"shownumber", (QFilter[])QFilter.of((String)"number=?", (Object[])new Object[]{this.outline.getModelNum()}).toArray()).getString("shownumber"));
        args.put("fy", this.getCurrentFy());
        args.put(PERIOD, this.getCurrentPeriod());
        args.put("scenariod", this.getCurrentScenario());
        return args;
    }

    private String getCommonConditionKey() {
        return Joiner.on((char)'|').join((Object)this.outline.getModelNum(), (Object)this.getCurrentFy(), new Object[]{this.getCurrentPeriod(), this.getCurrentScenario()});
    }

    private String getDefaultParamVal(Object[] args, int index, String dimNum) {
        String paramV = null;
        if (args.length > index) {
            paramV = args[index] instanceof ScriptMember ? ((ScriptMember)args[index]).getNumber() : args[index].toString();
        }
        if (StringUtils.isEmpty(paramV)) {
            return (String)this.outline.getComputingContext().getScopeItems().get((Object)dimNum).p2;
        }
        return paramV;
    }

    private String getCurrentFy() {
        return (String)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p2;
    }

    private String getCurrentPeriod() {
        return (String)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p2;
    }

    private String getCurrentScenario() {
        return (String)this.outline.getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p2;
    }

    private String getCurSchema(Object scheme, String scene, String fy, String period) {
        if (scheme == null || StringUtils.isEmpty((String)scheme.toString()) || StringUtils.isBlank((String)scheme.toString())) {
            String orgNum = (String)this.outline.getComputingContext().getScopeItems().get((Object)SysDimensionEnum.Entity.getNumber()).p2;
            Object[] params = new Object[]{this.outline.getModelNum(), scene, fy, period, orgNum};
            String rateNum = (String)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.convert.query.ExchangeQueryHelper", (String)"getRateSchemaByOrg", (Object[])params);
            return rateNum;
        }
        this.checkRateEntNum(scheme.toString());
        return scheme.toString();
    }
}

